/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.model.xml;

import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.cnd.asm.model.xml.ModelXMLReaderException;
import org.netbeans.modules.cnd.asm.model.xml.XMLReaderContext;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ModelXMLReader {
    private static final String START_ELEMENT_SUFFIX = "Start";
    private static final String END_ELEMENT_SUFFIX = "End";

    public void readModelXml(Reader src, XMLReaderContext ctx) {
        XMLReader xmlReader = null;
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setValidating(false);
            SAXParser parser = saxFactory.newSAXParser();
            xmlReader = parser.getXMLReader();
            xmlReader.setContentHandler(new ModelXMLContentHandler(ctx));
            xmlReader.parse(new InputSource(src));
        }
        catch (ModelXMLReaderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ModelXMLReaderException(ex);
        }
    }

    private static class ModelXMLContentHandler
    extends DefaultHandler {
        private List<XMLReaderContext> ctxStack;
        private XMLReaderContext ctxCur;

        public ModelXMLContentHandler(XMLReaderContext startCtx) {
            this.ctxCur = startCtx;
            this.ctxStack = new LinkedList<XMLReaderContext>();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.ctxStack.add(this.ctxCur);
            Object result = this.invokeCtxMethod(qName + ModelXMLReader.START_ELEMENT_SUFFIX, attributes, Attributes.class);
            if (result instanceof XMLReaderContext) {
                this.ctxCur = (XMLReaderContext)result;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XMLReaderContext backCtx = this.ctxCur;
            this.ctxCur = this.ctxStack.remove(this.ctxStack.size() - 1);
            this.invokeCtxMethod(qName + ModelXMLReader.END_ELEMENT_SUFFIX, backCtx, backCtx.getClass());
        }

        private Object invokeCtxMethod(String name, Object arg, Class argClass) {
            Object result = null;
            Method method = null;
            if (this.ctxCur == null || arg == null) {
                return result;
            }
            try {
                method = this.ctxCur.getClass().getMethod(name, argClass);
            }
            catch (Exception ex) {
                return null;
            }
            try {
                result = method.invoke((Object)this.ctxCur, arg);
            }
            catch (InvocationTargetException ex) {
                throw new ModelXMLReaderException(ex.getTargetException().toString());
            }
            catch (Exception ex) {
                throw new ModelXMLReaderException(ex);
            }
            return result;
        }
    }
}

