/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php;

import java.util.Collection;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.php.RefactoringTask;
import org.netbeans.modules.refactoring.php.delete.PhpDeleteRefactoringUI;
import org.netbeans.modules.refactoring.php.delete.SafeDeleteSupport;
import org.netbeans.modules.refactoring.php.findusages.RefactoringUtils;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.php.rename.PhpRenameRefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    public boolean canFindUsages(Lookup lookup) {
        FileObject fo;
        FileObject fileObject = fo = this.isFromEditor(lookup) ? this.getFileObject(lookup) : null;
        return fo != null && RefactoringUtils.isRefactorable(fo) ? !RefactoringUtils.isOutsidePhp(lookup, fo) : false;
    }

    private FileObject getFileObject(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        Node n = nodes.size() == 1 ? (Node)nodes.iterator().next() : null;
        DataObject dob = n != null ? (DataObject)n.getCookie(DataObject.class) : null;
        return dob != null ? dob.getPrimaryFile() : null;
    }

    private boolean isFromEditor(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        return ec != null && ec.getOpenedPanes() != null;
    }

    public void doFindUsages(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (RefactoringUtils.isFromEditor(ec)) {
            new RefactoringTask.TextComponentTask(ec){

                @Override
                protected RefactoringUI createRefactoringUI(PHPParseResult info, int offset) {
                    WhereUsedSupport ctx = WhereUsedSupport.getInstance(info, offset);
                    if (ctx != null && ctx.getName() != null) {
                        return new WhereUsedQueryUI(ctx);
                    }
                    return null;
                }
            }.run();
        }
    }

    public boolean canRename(Lookup lookup) {
        return this.canFindUsages(lookup);
    }

    public void doRename(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (RefactoringUtils.isFromEditor(ec)) {
            new RefactoringTask.TextComponentTask(ec){

                @Override
                protected RefactoringUI createRefactoringUI(PHPParseResult info, int offset) {
                    FileObject fileObject;
                    PhpSourcePath.FileType fileType;
                    WhereUsedSupport ctx = WhereUsedSupport.getInstance(info, offset);
                    if (ctx != null && ctx.getName() != null && !(fileType = PhpSourcePath.getFileType((FileObject)(fileObject = ctx.getModelElement().getFileObject()))).equals((Object)PhpSourcePath.FileType.INTERNAL)) {
                        return new PhpRenameRefactoringUI(ctx);
                    }
                    return null;
                }
            }.run();
        }
    }

    public boolean canDelete(Lookup lookup) {
        FileObject fo = this.getFileObject(lookup);
        return fo != null && RefactoringUtils.isRefactorable(fo);
    }

    public void doDelete(Lookup lookup) {
        final boolean regularDelete = lookup.lookup(ExplorerContext.class) != null;
        Collection nodes = lookup.lookupAll(Node.class);
        assert (nodes.size() == 1);
        Node currentNode = (Node)nodes.iterator().next();
        new RefactoringTask.NodeToFileTask(currentNode){

            @Override
            protected RefactoringUI createRefactoringUI(PHPParseResult info) {
                FileObject fileObject;
                PhpSourcePath.FileType fileType;
                SafeDeleteSupport ctx = SafeDeleteSupport.getInstance(info);
                if (ctx != null && !(fileType = PhpSourcePath.getFileType((FileObject)(fileObject = ctx.getModel().getFileScope().getFileObject()))).equals((Object)PhpSourcePath.FileType.INTERNAL)) {
                    return new PhpDeleteRefactoringUI(ctx, regularDelete);
                }
                return null;
            }
        }.run();
    }
}

