/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.groovy.editor.actions.FixImportsHelper;
import org.netbeans.modules.groovy.editor.actions.ImportChooserInnerPanel;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FixImportsAction
extends BaseAction
implements Runnable {
    private final Logger LOG = Logger.getLogger(FixImportsAction.class.getName());
    Document doc = null;
    private FixImportsHelper helper = new FixImportsHelper();

    public FixImportsAction() {
        super(NbBundle.getMessage(FixImportsAction.class, (String)"fix-groovy-imports"), 0);
    }

    public boolean isEnabled() {
        return true;
    }

    public void actionPerformed(ActionEvent evt, JTextComponent comp) {
        this.LOG.log(Level.FINEST, "actionPerformed(final JTextComponent comp)");
        assert (comp != null);
        this.doc = comp.getDocument();
        if (this.doc != null) {
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    @Override
    public void run() {
        DataObject dob = NbEditorUtilities.getDataObject((Document)this.doc);
        if (dob == null) {
            this.LOG.log(Level.FINEST, "Could not get DataObject for document");
            return;
        }
        final ArrayList missingNames = new ArrayList();
        FileObject fo = dob.getPrimaryFile();
        try {
            Source source = Source.create((FileObject)fo);
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    GroovyParserResult result = AstUtilities.getParseResult(resultIterator.getParserResult());
                    if (result != null) {
                        ErrorCollector errorCollector = result.getErrorCollector();
                        if (errorCollector == null) {
                            FixImportsAction.this.LOG.log(Level.FINEST, "Could not get error collector");
                            return;
                        }
                        List errList = errorCollector.getErrors();
                        if (errList == null) {
                            FixImportsAction.this.LOG.log(Level.FINEST, "Could not get list of errors");
                            return;
                        }
                        for (Object error : errList) {
                            SyntaxException se;
                            if (!(error instanceof SyntaxErrorMessage) || (se = ((SyntaxErrorMessage)error).getCause()) == null) continue;
                            FixImportsAction.this.helper;
                            String missingClassName = FixImportsHelper.getMissingClassName(se.getMessage());
                            if (missingClassName == null || missingNames.contains(missingClassName)) continue;
                            missingNames.add(missingClassName);
                        }
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        HashMap<String, List<FixImportsHelper.ImportCandidate>> multipleCandidates = new HashMap<String, List<FixImportsHelper.ImportCandidate>>();
        for (String name : missingNames) {
            List<FixImportsHelper.ImportCandidate> importCandidates = this.helper.getImportCandidate(fo, name);
            if (importCandidates.isEmpty()) {
                return;
            }
            int size = importCandidates.size();
            if (size == 1) {
                this.helper.doImport(fo, importCandidates.get(0).getFqnName());
                continue;
            }
            this.LOG.log(Level.FINEST, "Adding to multipleCandidates: " + name);
            multipleCandidates.put(name, importCandidates);
        }
        List<String> listToFix = null;
        if (!multipleCandidates.isEmpty()) {
            this.LOG.log(Level.FINEST, "multipleCandidates.size(): " + multipleCandidates.size());
            listToFix = this.presentChooser(multipleCandidates);
        }
        if (listToFix != null && !listToFix.isEmpty()) {
            this.LOG.log(Level.FINEST, "listToFix.size(): " + listToFix.size());
            for (String fqn : listToFix) {
                this.helper.doImport(fo, fqn);
            }
        }
    }

    private List<String> presentChooser(Map<String, List<FixImportsHelper.ImportCandidate>> multipleCandidates) {
        this.LOG.log(Level.FINEST, "presentChooser()");
        List<String> result = new ArrayList<String>();
        ImportChooserInnerPanel panel = new ImportChooserInnerPanel();
        panel.initPanel(multipleCandidates);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(FixImportsAction.class, (String)"FixImportsDialogTitle"));
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        d.setVisible(false);
        d.dispose();
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            result = panel.getSelections();
        }
        return result;
    }
}

