/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc.oracle;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCCatalog;
import org.netbeans.modules.db.metadata.model.jdbc.oracle.OracleMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.oracle.OracleSchema;

public class OracleCatalog
extends JDBCCatalog {
    private static final Logger LOGGER = Logger.getLogger(OracleCatalog.class.getName());

    public OracleCatalog(OracleMetadata metadata, String name, boolean _default, String defaultSchemaName) {
        super(metadata, name, _default, defaultSchemaName);
    }

    @Override
    public String toString() {
        return "OracleCatalog[name='" + this.getName() + "']";
    }

    @Override
    protected OracleSchema createJDBCSchema(String name, boolean _default, boolean synthetic) {
        return new OracleSchema(this, name, _default, synthetic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createSchemas() {
        LinkedHashMap<String, Schema> newSchemas = new LinkedHashMap<String, Schema>();
        try {
            ResultSet rs = this.getJDBCMetadata().getDmd().getSchemas();
            try {
                while (rs.next()) {
                    String schemaName = rs.getString("TABLE_SCHEM");
                    LOGGER.log(Level.FINE, "Read schema ''{0}''", schemaName);
                    if (this.defaultSchemaName != null && MetadataUtilities.equals(schemaName, this.defaultSchemaName)) {
                        this.defaultSchema = this.createJDBCSchema(this.defaultSchemaName, true, false).getSchema();
                        newSchemas.put(this.defaultSchema.getName(), this.defaultSchema);
                        LOGGER.log(Level.FINE, "Created default schema {0}", this.defaultSchema);
                        continue;
                    }
                    Schema schema = this.createJDBCSchema(schemaName, false, false).getSchema();
                    newSchemas.put(schemaName, schema);
                    LOGGER.log(Level.FINE, "Created schema {0}", schema);
                }
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new MetadataException(e);
        }
        this.schemas = Collections.unmodifiableMap(newSchemas);
    }
}

