/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.view.source;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteFactory;
import org.netbeans.modules.mobility.svgcore.view.svg.SelectionCookie;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewElement;
import org.netbeans.spi.palette.PaletteController;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class SVGSourceMultiViewElement
extends XmlMultiViewElement {
    private static final long serialVersionUID = 7525761714575627761L;
    private static final Logger LOG = Logger.getLogger(SVGSourceMultiViewElement.class.getName());

    public SVGSourceMultiViewElement(SVGDataObject dObj) {
        super((XmlMultiViewDataObject)dObj);
    }

    public Lookup getLookup() {
        try {
            PaletteController pc = SVGPaletteFactory.getPalette();
            return new ProxyLookup(new Lookup[]{this.dObj.getNodeDelegate().getLookup(), Lookups.singleton((Object)pc), Lookups.singleton((Object)new SelectionCookie(){

                @Override
                public void updateSelection(SVGDataObject doj, String id, int startOff, boolean doubleClick) {
                    SVGSourceMultiViewElement.selectElement(doj, startOff, doubleClick);
                }
            })});
        }
        catch (IOException e) {
            SceneManager.error("Lookup creation failed", e);
            return super.getLookup();
        }
    }

    public void componentHidden() {
        ((SVGDataObject)this.dObj).setMultiViewElement(null);
        super.componentHidden();
    }

    public void componentOpened() {
        super.componentOpened();
        SVGFileModel svgModel = ((SVGDataObject)this.dObj).getModel();
        if (svgModel.getModel() != null) {
            svgModel.attachToOpenedDocument();
        } else {
            LOG.log(Level.WARNING, "Can not attachToOpenedDocument. document model is not loaded.");
        }
    }

    public void componentShowing() {
        super.componentShowing();
        this.dObj.setLastOpenView(0);
        ((SVGDataObject)this.dObj).setMultiViewElement((MultiViewElement)this);
    }

    public static void selectElement(SVGDataObject svgDoj, int startOffset, boolean requestFocus) {
        if (startOffset != -1) {
            SVGSourceMultiViewElement.selectPosition(svgDoj, startOffset, requestFocus);
        }
    }

    public static void selectPosition(final SVGDataObject svgDoj, final int position, final boolean requestFocus) {
        SVGSourceMultiViewElement.openFileInEditor(svgDoj);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorCookie ed = (EditorCookie)svgDoj.getCookie(EditorCookie.class);
                try {
                    if (ed != null) {
                        ed.openDocument();
                        JEditorPane[] opened = ed.getOpenedPanes();
                        if (opened != null && opened.length > 0) {
                            TopComponent tc;
                            JEditorPane pane = opened[0];
                            pane.setSelectionStart(position);
                            pane.setSelectionEnd(position);
                            if (requestFocus && (tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, pane)) != null) {
                                tc.requestActive();
                                tc.requestFocus();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    SceneManager.error("Select in editor failed.", e);
                }
            }
        });
    }

    private static boolean openFileInEditor(SVGDataObject svgDoj) {
        EditCookie ck = (EditCookie)svgDoj.getCookie(EditCookie.class);
        if (ck != null) {
            ck.edit();
            return true;
        }
        OpenCookie oc = (OpenCookie)svgDoj.getCookie(OpenCookie.class);
        if (oc != null) {
            oc.open();
            return true;
        }
        return false;
    }
}

