/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.ISVNMergeStrategy;
import org.tmatesoft.svn.core.internal.wc.ISVNReusableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeCallback;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteDiffEditor;
import org.tmatesoft.svn.core.internal.wc.SVNRevisionStatus;
import org.tmatesoft.svn.core.internal.wc.SVNStatusUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNMergeDriver
extends SVNBasicClient
implements ISVNMergeStrategy {
    protected boolean myAreSourcesAncestral;
    protected boolean myIsSameRepository;
    protected boolean myIsDryRun;
    protected boolean myIsRecordOnly;
    protected boolean myIsForce;
    protected boolean myIsTargetMissingChild;
    protected boolean myHasExistingMergeInfo;
    protected boolean myIsTargetHasDummyMergeRange;
    protected boolean myIsIgnoreAncestry;
    protected boolean myIsSingleFileMerge;
    protected boolean myIsMergeInfoCapable;
    protected boolean myIsReIntegrateMerge;
    protected boolean myIsAddNecessitatedMerge;
    protected int myOperativeNotificationsNumber;
    protected int myNotificationsNumber;
    protected int myCurrentAncestorIndex;
    protected Map myConflictedPaths;
    protected Map myDryRunDeletions;
    protected SVNURL myURL;
    protected File myTarget;
    private List myMergedPaths;
    private List mySkippedPaths;
    private List myChildrenWithMergeInfo;
    private List myAddedPaths;
    protected SVNWCAccess myWCAccess;
    protected SVNRepository myRepository1;
    protected SVNRepository myRepository2;
    private SVNLogClient myLogClient;
    private List myPathsWithNewMergeInfo;
    private LinkedList myPathsWithDeletedMergeInfo;
    private MergeSource myCurrentMergeSource;
    private SVNMergeRangeList myImplicitSrcGap;
    static /* synthetic */ Class class$org$tmatesoft$svn$core$internal$wc$SVNMergeDriver$MergePath;

    public SVNMergeDriver(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    protected SVNMergeDriver(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public abstract SVNDiffOptions getMergeOptions();

    public void getLogMergedMergeInfo(File path, SVNRevision pegRevision, SVNURL mergeSrcURL, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        if (this instanceof SVNDiffClient) {
            SVNDiffClient diffClient = (SVNDiffClient)this;
            diffClient.doGetLogMergedMergeInfo(path, pegRevision, mergeSrcURL, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
        }
    }

    public void getLogMergedMergeInfo(SVNURL url, SVNRevision pegRevision, SVNURL mergeSrcURL, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        if (this instanceof SVNDiffClient) {
            SVNDiffClient diffClient = (SVNDiffClient)this;
            diffClient.doGetLogMergedMergeInfo(url, pegRevision, mergeSrcURL, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
        }
    }

    public void getLogMergedMergeInfo(File path, SVNRevision pegRevision, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        if (this instanceof SVNDiffClient) {
            SVNDiffClient diffClient = (SVNDiffClient)this;
            diffClient.doGetLogMergedMergeInfo(path, pegRevision, mergeSrcPath, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
        }
    }

    public void getLogMergedMergeInfo(SVNURL url, SVNRevision pegRevision, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        if (this instanceof SVNDiffClient) {
            SVNDiffClient diffClient = (SVNDiffClient)this;
            diffClient.doGetLogMergedMergeInfo(url, pegRevision, mergeSrcPath, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
        }
    }

    public void getLogEligibleMergeInfo(File path, SVNRevision pegRevision, SVNURL mergeSrcURL, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        if (this instanceof SVNDiffClient) {
            SVNDiffClient diffClient = (SVNDiffClient)this;
            diffClient.doGetLogEligibleMergeInfo(path, pegRevision, mergeSrcURL, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
        }
    }

    public void getLogEligibleMergeInfo(SVNURL url, SVNRevision pegRevision, SVNURL mergeSrcURL, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        if (this instanceof SVNDiffClient) {
            SVNDiffClient diffClient = (SVNDiffClient)this;
            diffClient.doGetLogEligibleMergeInfo(url, pegRevision, mergeSrcURL, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
        }
    }

    public void getLogEligibleMergeInfo(File path, SVNRevision pegRevision, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        if (this instanceof SVNDiffClient) {
            SVNDiffClient diffClient = (SVNDiffClient)this;
            diffClient.doGetLogEligibleMergeInfo(path, pegRevision, mergeSrcPath, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
        }
    }

    public void getLogEligibleMergeInfo(SVNURL url, SVNRevision pegRevision, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        if (this instanceof SVNDiffClient) {
            SVNDiffClient diffClient = (SVNDiffClient)this;
            diffClient.doGetLogEligibleMergeInfo(url, pegRevision, mergeSrcPath, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
        }
    }

    public Map getMergedMergeInfo(File path, SVNRevision pegRevision) throws SVNException {
        if (this instanceof SVNDiffClient) {
            SVNDiffClient diffClient = (SVNDiffClient)this;
            return diffClient.doGetMergedMergeInfo(path, pegRevision);
        }
        return null;
    }

    public Map getMergedMergeInfo(SVNURL url, SVNRevision pegRevision) throws SVNException {
        if (this instanceof SVNDiffClient) {
            SVNDiffClient diffClient = (SVNDiffClient)this;
            return diffClient.doGetMergedMergeInfo(url, pegRevision);
        }
        return null;
    }

    public Collection suggestMergeSources(File path, SVNRevision pegRevision) throws SVNException {
        if (this instanceof SVNDiffClient) {
            SVNDiffClient diffClient = (SVNDiffClient)this;
            return diffClient.doSuggestMergeSources(path, pegRevision);
        }
        return null;
    }

    public Collection suggestMergeSources(SVNURL url, SVNRevision pegRevision) throws SVNException {
        if (this instanceof SVNDiffClient) {
            SVNDiffClient diffClient = (SVNDiffClient)this;
            return diffClient.doSuggestMergeSources(url, pegRevision);
        }
        return null;
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        boolean isOperativeNotification = false;
        if (this.isOperativeNotification(event)) {
            ++this.myOperativeNotificationsNumber;
            isOperativeNotification = true;
        }
        if (this.myAreSourcesAncestral) {
            ++this.myNotificationsNumber;
            if (!this.myIsSingleFileMerge && isOperativeNotification) {
                int newNearestAncestorIndex;
                Object[] childrenWithMergeInfoArray = null;
                if (this.myChildrenWithMergeInfo != null) {
                    childrenWithMergeInfoArray = this.myChildrenWithMergeInfo.toArray();
                }
                if ((newNearestAncestorIndex = this.findNearestAncestor(childrenWithMergeInfoArray, event.getAction() != SVNEventAction.UPDATE_DELETE, event.getFile())) != this.myCurrentAncestorIndex) {
                    MergePath child = (MergePath)childrenWithMergeInfoArray[newNearestAncestorIndex];
                    this.myCurrentAncestorIndex = newNearestAncestorIndex;
                    if (!(child.myIsAbsent || child.myRemainingRanges.isEmpty() || newNearestAncestorIndex == 0 && this.myIsTargetHasDummyMergeRange)) {
                        SVNMergeRange[] ranges = child.myRemainingRanges.getRanges();
                        SVNEvent mergeBeginEvent = SVNEventFactory.createSVNEvent(child.myPath, SVNNodeKind.UNKNOWN, null, -1L, this.myIsSameRepository ? SVNEventAction.MERGE_BEGIN : SVNEventAction.FOREIGN_MERGE_BEGIN, null, null, ranges[0]);
                        super.handleEvent(mergeBeginEvent, -1.0);
                    }
                }
            }
            if (event.getContentsStatus() == SVNStatusType.MERGED || event.getContentsStatus() == SVNStatusType.CHANGED || event.getPropertiesStatus() == SVNStatusType.MERGED || event.getPropertiesStatus() == SVNStatusType.CHANGED || event.getAction() == SVNEventAction.UPDATE_ADD) {
                File mergedPath = event.getFile();
                if (this.myMergedPaths == null) {
                    this.myMergedPaths = new LinkedList();
                }
                this.myMergedPaths.add(mergedPath);
            }
            if (event.getAction() == SVNEventAction.SKIP) {
                File skippedPath = event.getFile();
                if (this.mySkippedPaths == null) {
                    this.mySkippedPaths = new LinkedList();
                }
                this.mySkippedPaths.add(skippedPath);
            } else if (event.getAction() == SVNEventAction.UPDATE_ADD) {
                boolean isRootOfAddedSubTree = false;
                File addedPath = event.getFile();
                if (this.myAddedPaths == null) {
                    isRootOfAddedSubTree = true;
                    this.myAddedPaths = new LinkedList();
                } else {
                    File addedPathParent = addedPath.getParentFile();
                    boolean bl = isRootOfAddedSubTree = !this.myAddedPaths.contains(addedPathParent);
                }
                if (isRootOfAddedSubTree) {
                    this.myAddedPaths.add(addedPath);
                }
            }
        } else if (!this.myIsSingleFileMerge && this.myOperativeNotificationsNumber == 1 && isOperativeNotification) {
            SVNEvent mergeBeginEvent = SVNEventFactory.createSVNEvent(this.myTarget, SVNNodeKind.UNKNOWN, null, -1L, this.myIsSameRepository ? SVNEventAction.MERGE_BEGIN : SVNEventAction.FOREIGN_MERGE_BEGIN, null, null, null);
            super.handleEvent(mergeBeginEvent, -1.0);
        }
        super.handleEvent(event, progress);
    }

    public void checkCancelled() throws SVNCancelException {
        super.checkCancelled();
    }

    protected SVNLocationEntry getCopySource(File path, SVNURL url, SVNRevision revision) throws SVNException {
        long[] pegRev = new long[]{-1L};
        SVNRepository repos = this.createRepository(url, path, null, revision, revision, pegRev);
        SVNLocationEntry copyFromEntry = null;
        String targetPath = this.getPathRelativeToRoot(path, url, null, null, repos);
        CopyFromReceiver receiver = new CopyFromReceiver(targetPath);
        try {
            repos.log(new String[]{""}, pegRev[0], 1L, true, true, 0L, false, new String[0], receiver);
            copyFromEntry = receiver.getCopyFromLocation();
        }
        catch (SVNException e) {
            SVNErrorCode errCode = e.getErrorMessage().getErrorCode();
            if (errCode == SVNErrorCode.FS_NOT_FOUND || errCode == SVNErrorCode.RA_DAV_REQUEST_FAILED) {
                return new SVNLocationEntry(-1L, null);
            }
            throw e;
        }
        return copyFromEntry == null ? new SVNLocationEntry(-1L, null) : copyFromEntry;
    }

    protected void getLogsForMergeInfoRangeList(SVNURL reposRootURL, String[] paths, SVNMergeRangeList rangeList, boolean discoverChangedPaths, String[] revProps, ISVNLogEntryHandler handler) throws SVNException {
        if (rangeList.isEmpty()) {
            return;
        }
        Object[] listRanges = rangeList.getRanges();
        Arrays.sort(listRanges);
        Object youngestRange = listRanges[listRanges.length - 1];
        SVNRevision youngestRev = SVNRevision.create(((SVNMergeRange)youngestRange).getEndRevision());
        Object oldestRange = listRanges[0];
        SVNRevision oldestRev = SVNRevision.create(((SVNMergeRange)oldestRange).getStartRevision());
        LogHandlerFilter filterHandler = new LogHandlerFilter(handler, rangeList);
        SVNLogClient logClient = this.getLogClient();
        logClient.doLog(reposRootURL, paths, youngestRev, oldestRev, youngestRev, false, discoverChangedPaths, false, 0L, revProps, filterHandler);
        this.checkCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getMergeInfo(File path, SVNRevision pegRevision, SVNURL[] repositoryRoot) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            SVNAdminArea adminArea = wcAccess.probeOpen(path, false, 0);
            SVNEntry entry = wcAccess.getVersionedEntry(path, false);
            long[] revNum = new long[]{-1L};
            SVNURL url = this.getEntryLocation(path, entry, revNum, SVNRevision.WORKING);
            SVNRepository repository = null;
            try {
                repository = this.createRepository(url, null, null, false);
                repository.assertServerIsMergeInfoCapable(path.toString());
            }
            finally {
                repository.closeSession();
            }
            SVNURL reposRoot = this.getReposRoot(path, null, pegRevision, adminArea, wcAccess);
            if (repositoryRoot != null && repositoryRoot.length > 0) {
                repositoryRoot[0] = reposRoot;
            }
            boolean[] indirect = new boolean[]{false};
            Map map = this.getWCOrRepositoryMergeInfo(path, entry, SVNMergeInfoInheritance.INHERITED, indirect, false, null);
            return map;
        }
        finally {
            wcAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getMergeInfo(SVNURL url, SVNRevision pegRevision, SVNURL[] repositoryRoot) throws SVNException {
        SVNRepository repository = null;
        try {
            String relPath;
            repository = this.createRepository(url, null, null, true);
            long revisionNum = this.getRevisionNumber(pegRevision, repository, null);
            SVNURL reposRoot = repository.getRepositoryRoot(true);
            if (repositoryRoot != null && repositoryRoot.length > 0) {
                repositoryRoot[0] = reposRoot;
            }
            if ((relPath = this.getPathRelativeToSession(url, null, repository)) == null) {
                repository.setLocation(url, false);
                relPath = "";
            }
            Map map = this.getReposMergeInfo(repository, relPath, revisionNum, SVNMergeInfoInheritance.INHERITED, false);
            return map;
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPeggedMerge(SVNURL srcURL, File srcPath, Collection rangesToMerge, SVNRevision pegRevision, File targetWCPath, SVNDepth depth, boolean dryRun, boolean force, boolean ignoreAncestry, boolean recordOnly) throws SVNException {
        if (rangesToMerge == null || rangesToMerge.isEmpty()) {
            return;
        }
        this.myWCAccess = this.createWCAccess();
        targetWCPath = targetWCPath.getAbsoluteFile();
        try {
            SVNURL url;
            SVNAdminArea adminArea = this.myWCAccess.probeOpen(targetWCPath, !dryRun, -1);
            SVNEntry targetEntry = this.myWCAccess.getVersionedEntry(targetWCPath, false);
            SVNURL sVNURL = url = srcURL == null ? this.getURL(srcPath) : srcURL;
            if (url == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", srcPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SVNURL wcReposRoot = this.getReposRoot(targetWCPath, null, SVNRevision.WORKING, adminArea, this.myWCAccess);
            List mergeSources = null;
            SVNRepository repository = null;
            SVNURL sourceReposRoot = null;
            try {
                repository = this.createRepository(url, null, null, true);
                sourceReposRoot = repository.getRepositoryRoot(true);
                mergeSources = this.normalizeMergeSources(srcPath, url, sourceReposRoot, pegRevision, rangesToMerge, repository);
            }
            finally {
                repository.closeSession();
            }
            this.doMerge(mergeSources, targetWCPath, targetEntry, adminArea, true, true, wcReposRoot.equals(sourceReposRoot), ignoreAncestry, force, dryRun, recordOnly, false, depth);
        }
        finally {
            this.myWCAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void runMerge(SVNURL url1, SVNRevision revision1, SVNURL url2, SVNRevision revision2, File targetWCPath, SVNDepth depth, boolean dryRun, boolean force, boolean ignoreAncestry, boolean recordOnly) throws SVNException {
        block18: {
            List<MergeSource> mergeSources;
            boolean ancestral;
            boolean related;
            boolean sameRepos;
            long rev2;
            long rev1;
            SVNEntry entry;
            SVNAdminArea adminArea;
            SVNRepository repository2;
            SVNRepository repository1;
            block13: {
                long youngestCommonRevision;
                SVNURL sourceReposRoot;
                SVNURL wcReposRoot;
                block17: {
                    SVNURL youngestCommonURL;
                    LinkedList<SVNRevisionRange> ranges;
                    SVNRevisionRange range;
                    block15: {
                        if (!revision1.isValid() || !revision2.isValid()) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
                            SVNErrorManager.error(err, SVNLogType.DEFAULT);
                        }
                        repository1 = null;
                        repository2 = null;
                        this.myWCAccess = this.createWCAccess();
                        targetWCPath = targetWCPath.getAbsoluteFile();
                        adminArea = this.myWCAccess.probeOpen(targetWCPath, !dryRun, -1);
                        entry = this.myWCAccess.getVersionedEntry(targetWCPath, false);
                        wcReposRoot = this.getReposRoot(targetWCPath, null, SVNRevision.WORKING, adminArea, this.myWCAccess);
                        long[] latestRev = new long[]{-1L};
                        repository1 = this.createRepository(url1, null, null, false);
                        sourceReposRoot = repository1.getRepositoryRoot(true);
                        rev1 = this.getRevisionNumber(revision1, latestRev, repository1, null);
                        repository2 = this.createRepository(url2, null, null, false);
                        rev2 = this.getRevisionNumber(revision2, latestRev, repository2, null);
                        sameRepos = sourceReposRoot.equals(wcReposRoot);
                        String youngestCommonPath = null;
                        youngestCommonRevision = -1L;
                        if (!ignoreAncestry) {
                            SVNLocationEntry youngestLocation = this.getYoungestCommonAncestor(null, url1, rev1, null, url2, rev2);
                            youngestCommonPath = youngestLocation.getPath();
                            youngestCommonRevision = youngestLocation.getRevision();
                        }
                        related = false;
                        ancestral = false;
                        mergeSources = null;
                        if (youngestCommonPath == null || !SVNRevision.isValidRevisionNumber(youngestCommonRevision)) break block14;
                        range = null;
                        ranges = new LinkedList<SVNRevisionRange>();
                        related = true;
                        youngestCommonURL = sourceReposRoot.appendPath(youngestCommonPath, false);
                        if (!youngestCommonURL.equals(url2) || youngestCommonRevision != rev2) break block15;
                        ancestral = true;
                        SVNRevision sRev = SVNRevision.create(rev1);
                        SVNRevision eRev = SVNRevision.create(youngestCommonRevision);
                        range = new SVNRevisionRange(sRev, eRev);
                        ranges.add(range);
                        mergeSources = this.normalizeMergeSources(null, url1, sourceReposRoot, sRev, ranges, repository1);
                        break block16;
                    }
                    if (!youngestCommonURL.equals(url1) || youngestCommonRevision != rev1) break block17;
                    ancestral = true;
                    SVNRevision sRev = SVNRevision.create(youngestCommonRevision);
                    SVNRevision eRev = SVNRevision.create(rev2);
                    range = new SVNRevisionRange(sRev, eRev);
                    ranges.add(range);
                    mergeSources = this.normalizeMergeSources(null, url2, sourceReposRoot, eRev, ranges, repository2);
                    break block16;
                }
                this.mergeCousinsAndSupplementMergeInfo(targetWCPath, entry, adminArea, repository1, url1, rev1, url2, rev2, youngestCommonRevision, sourceReposRoot, wcReposRoot, depth, ignoreAncestry, force, recordOnly, dryRun);
                Object var35_35 = null;
                if (repository1 != null) {
                    repository1.closeSession();
                }
                if (repository2 == null) break block13;
                repository2.closeSession();
            }
            try {
                this.myWCAccess.close();
            }
            catch (SVNException svne) {
                // empty catch block
            }
            {
                block16: {
                    block14: {
                        return;
                    }
                    MergeSource mergeSrc = new MergeSource();
                    mergeSrc.myURL1 = url1;
                    mergeSrc.myURL2 = url2;
                    mergeSrc.myRevision1 = rev1;
                    mergeSrc.myRevision2 = rev2;
                    mergeSources = new LinkedList<MergeSource>();
                    mergeSources.add(mergeSrc);
                }
                repository1.closeSession();
                repository2.closeSession();
                this.doMerge(mergeSources, targetWCPath, entry, adminArea, ancestral, related, sameRepos, ignoreAncestry, force, dryRun, recordOnly, false, depth);
            }
            Object var35_36 = null;
            if (repository1 != null) {
                repository1.closeSession();
            }
            if (repository2 != null) {
                repository2.closeSession();
            }
            try {
                this.myWCAccess.close();
            }
            catch (SVNException svne) {}
            break block18;
            catch (Throwable throwable) {
                Object var35_37 = null;
                if (repository1 != null) {
                    repository1.closeSession();
                }
                if (repository2 != null) {
                    repository2.closeSession();
                }
                try {
                    this.myWCAccess.close();
                }
                catch (SVNException svne) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runMergeReintegrate(SVNURL srcURL, File srcPath, SVNRevision pegRevision, File targetWCPath, boolean dryRun) throws SVNException {
        this.myWCAccess = this.createWCAccess();
        targetWCPath = targetWCPath.getAbsoluteFile();
        try {
            SVNURL url2;
            SVNAdminArea adminArea = this.myWCAccess.probeOpen(targetWCPath, !dryRun, -1);
            SVNEntry targetEntry = this.myWCAccess.getVersionedEntry(targetWCPath, false);
            SVNURL sVNURL = url2 = srcURL == null ? this.getURL(srcPath) : srcURL;
            if (url2 == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", srcPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SVNURL wcReposRoot = this.getReposRoot(targetWCPath, null, SVNRevision.WORKING, adminArea, this.myWCAccess);
            SVNRepository repository = null;
            SVNURL sourceReposRoot = null;
            try {
                repository = this.createRepository(wcReposRoot, null, null, true);
                sourceReposRoot = repository.getRepositoryRoot(true);
                if (!wcReposRoot.equals(sourceReposRoot)) {
                    Object source = srcPath;
                    if (source == null) {
                        source = srcURL;
                    }
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "''{0}'' must be from the same repository as ''{1}''", new Object[]{source, targetWCPath});
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                this.ensureWCReflectsRepositorySubTree(targetWCPath);
                long[] rev1 = new long[]{targetEntry.getRevision()};
                String sourceReposRelPath = this.getPathRelativeToRoot(null, url2, null, null, repository);
                String targetReposRelPath = this.getPathRelativeToRoot(targetWCPath, null, wcReposRoot, null, repository);
                SubTreeMergeInfoHandler handler = new SubTreeMergeInfoHandler(targetWCPath, wcReposRoot);
                this.myWCAccess.walkEntries(targetWCPath, handler, true, SVNDepth.INFINITY);
                long rev2 = this.getRevisionNumber(pegRevision, repository, srcPath);
                SVNURL[] url1 = new SVNURL[]{null};
                Map unmergedToSourceMergeInfoCatalog = this.calculateLeftHandSide(url1, rev1, targetReposRelPath, handler.getSubTreesWithMergeInfoPaths(), rev1[0], sourceReposRelPath, sourceReposRoot, rev2, repository);
                SVNLocationEntry youngestCommonAncestor = this.getYoungestCommonAncestor(null, url2, rev2, null, url1[0], rev1[0]);
                String youngestAncestorPath = youngestCommonAncestor.getPath();
                long youngestAncestorRevision = youngestCommonAncestor.getRevision();
                if (youngestAncestorPath == null || !SVNRevision.isValidRevisionNumber(youngestAncestorRevision)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "''{0}@{1}'' must be ancestrally related to ''{2}@{3}''", new Object[]{url1[0], new Long(rev1[0]), url2, new Long(rev2)});
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if (rev1[0] > youngestAncestorRevision) {
                    try {
                        this.ensureAllMissingRangesArePhantoms(repository, unmergedToSourceMergeInfoCatalog);
                    }
                    catch (SVNException svne) {
                        if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_NOT_READY_TO_MERGE) {
                            String srcMergeInfoCatalogString = SVNMergeInfoUtil.formatMergeInfoCatalogToString(unmergedToSourceMergeInfoCatalog, "  ", "    Missing ranges: ");
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Reintegrate can only be used if revisions {0} through {1} were previously merged from {2} to the reintegrate source, but this is not the case:\n{3}", new Object[]{String.valueOf(youngestAncestorRevision + 1L), String.valueOf(rev2), targetEntry.getURL(), srcMergeInfoCatalogString});
                            SVNErrorManager.error(err, SVNLogType.WC);
                        }
                        throw svne;
                    }
                }
                this.mergeCousinsAndSupplementMergeInfo(targetWCPath, targetEntry, adminArea, repository, url1[0], rev1[0], url2, rev2, youngestAncestorRevision, sourceReposRoot, wcReposRoot, SVNDepth.INFINITY, false, false, false, dryRun);
            }
            finally {
                repository.closeSession();
            }
        }
        finally {
            this.myWCAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMerge(List mergeSources, File target, SVNEntry targetEntry, SVNAdminArea adminArea, boolean sourcesAncestral, boolean sourcesRelated, boolean sameRepository, boolean ignoreAncestry, boolean force, boolean dryRun, boolean recordOnly, boolean reintegrateMerge, SVNDepth depth) throws SVNException {
        if (recordOnly) {
            SVNErrorMessage err;
            if (!sourcesAncestral) {
                err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Use of two URLs is not compatible with mergeinfo modification");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            if (!sameRepository) {
                err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Merge from foreign repository is not compatible with mergeinfo modification");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (dryRun) {
                return;
            }
        }
        if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        this.myIsForce = force;
        this.myIsDryRun = dryRun;
        this.myIsRecordOnly = recordOnly;
        this.myIsIgnoreAncestry = ignoreAncestry;
        this.myIsSameRepository = sameRepository;
        this.myIsMergeInfoCapable = false;
        this.myAreSourcesAncestral = sourcesAncestral;
        this.myIsTargetMissingChild = false;
        this.myIsSingleFileMerge = false;
        this.myTarget = target;
        this.myNotificationsNumber = 0;
        this.myOperativeNotificationsNumber = 0;
        this.myCurrentAncestorIndex = -1;
        this.myMergedPaths = null;
        this.mySkippedPaths = null;
        this.myAddedPaths = null;
        this.myChildrenWithMergeInfo = null;
        this.myPathsWithNewMergeInfo = null;
        this.myHasExistingMergeInfo = false;
        this.myIsReIntegrateMerge = reintegrateMerge;
        this.myImplicitSrcGap = null;
        boolean checkedMergeInfoCapability = false;
        for (int i = 0; i < mergeSources.size(); ++i) {
            Object var25_23;
            long revision2;
            MergeSource mergeSource = (MergeSource)mergeSources.get(i);
            SVNURL url1 = mergeSource.myURL1;
            SVNURL url2 = mergeSource.myURL2;
            long revision1 = mergeSource.myRevision1;
            if (revision1 == (revision2 = mergeSource.myRevision2) && mergeSource.myURL1.equals(mergeSource.myURL2)) continue;
            try {
                this.myRepository1 = this.ensureRepository(this.myRepository1, url1);
                this.myRepository2 = this.ensureRepository(this.myRepository2, url2);
                this.myIsTargetHasDummyMergeRange = false;
                this.myURL = url2;
                this.myConflictedPaths = null;
                this.myDryRunDeletions = dryRun ? new SVNHashMap() : null;
                this.myIsAddNecessitatedMerge = false;
                this.myCurrentMergeSource = mergeSource;
                if (!checkedMergeInfoCapability) {
                    this.myIsMergeInfoCapable = this.myRepository1.hasCapability(SVNCapability.MERGE_INFO);
                    checkedMergeInfoCapability = true;
                }
                if (targetEntry.isFile()) {
                    this.doFileMerge(url1, revision1, url2, revision2, target, adminArea, sourcesRelated);
                } else if (targetEntry.isDirectory()) {
                    this.doDirectoryMerge(url1, revision1, url2, revision2, targetEntry, adminArea, depth);
                }
                if (!dryRun) {
                    this.elideMergeInfo(this.myWCAccess, target, targetEntry, null);
                }
                SVNEvent mergeCompletedEvent = SVNEventFactory.createSVNEvent(target, SVNNodeKind.NONE, null, -1L, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.MERGE_COMPLETE, null, null, null);
                super.handleEvent(mergeCompletedEvent, -1.0);
                var25_23 = null;
                if (this.myRepository1 != null) {
                    this.myRepository1.closeSession();
                }
                if (this.myRepository2 == null) continue;
                this.myRepository2.closeSession();
                continue;
            }
            catch (Throwable throwable) {
                var25_23 = null;
                if (this.myRepository1 != null) {
                    this.myRepository1.closeSession();
                }
                if (this.myRepository2 != null) {
                    this.myRepository2.closeSession();
                }
                throw throwable;
            }
        }
    }

    protected void addPathWithNewMergeInfo(File path) {
        if (this.myPathsWithNewMergeInfo == null) {
            this.myPathsWithNewMergeInfo = new LinkedList();
        }
        this.myPathsWithNewMergeInfo.add(path);
    }

    protected void addPathWithDeletedMergeInfo(File path) {
        if (this.myPathsWithDeletedMergeInfo == null) {
            this.myPathsWithDeletedMergeInfo = new LinkedList();
        }
        this.myPathsWithDeletedMergeInfo.add(path);
    }

    protected SVNRepository ensureRepository(SVNRepository repository, SVNURL url) throws SVNException {
        if (repository != null) {
            try {
                this.ensureSessionURL(repository, url);
                return repository;
            }
            catch (SVNException sVNException) {
                repository = null;
            }
        }
        if (repository == null) {
            repository = this.createRepository(url, null, null, false);
        }
        return repository;
    }

    public Object[] calculateRemainingRangeList(File targetFile, SVNEntry entry, SVNURL sourceRoot, boolean[] indirect, SVNURL url1, long revision1, SVNURL url2, long revision2, SVNMergeRange range) throws SVNException {
        SVNMergeRangeList remainingRangeList = null;
        Map targetMergeInfo = null;
        Map implicitMergeInfo = null;
        boolean honorMergeInfo = this.isHonorMergeInfo();
        if (honorMergeInfo) {
            MergePath mergeTarget = new MergePath();
            this.myRepository1.setLocation(entry.getSVNURL(), false);
            Map[] fullMergeInfo = this.getFullMergeInfo(entry, indirect, SVNMergeInfoInheritance.INHERITED, this.myRepository1, targetFile, Math.max(revision1, revision2), Math.min(revision1, revision2));
            targetMergeInfo = fullMergeInfo[0];
            implicitMergeInfo = fullMergeInfo[1];
            this.myRepository1.setLocation(url1, false);
            if (!this.myIsRecordOnly) {
                this.calculateRemainingRanges(null, mergeTarget, sourceRoot, url1, revision1, url2, revision2, targetMergeInfo, implicitMergeInfo, this.myImplicitSrcGap, false, entry, this.myRepository1);
                remainingRangeList = mergeTarget.myRemainingRanges;
            }
        }
        if (!honorMergeInfo || this.myIsRecordOnly) {
            remainingRangeList = new SVNMergeRangeList(range);
        }
        return new Object[]{remainingRangeList, targetMergeInfo, implicitMergeInfo};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void findGapsInMergeSourceHistory(long[] gap, String mergeSrcCanonPath, SVNURL url1, long rev1, SVNURL url2, long rev2, SVNRepository repos) throws SVNException {
        Map implicitSrcMergeInfo;
        block6: {
            long youngRev = Math.max(rev1, rev2);
            long oldRev = Math.min(rev1, rev2);
            SVNURL url = rev2 < rev1 ? url1 : url2;
            gap[1] = -1L;
            gap[0] = -1L;
            SVNRevision pegRevision = SVNRevision.create(youngRev);
            SVNURL oldURL = null;
            if (repos != null) {
                oldURL = this.ensureSessionURL(repos, url);
            }
            implicitSrcMergeInfo = null;
            try {
                implicitSrcMergeInfo = this.getHistoryAsMergeInfo(url, null, pegRevision, youngRev, oldRev, repos, null);
                Object var19_14 = null;
                if (repos == null || oldURL == null) break block6;
            }
            catch (Throwable throwable) {
                Object var19_15 = null;
                if (repos == null) throw throwable;
                if (oldURL == null) throw throwable;
                repos.setLocation(oldURL, false);
                throw throwable;
            }
            repos.setLocation(oldURL, false);
        }
        SVNMergeRangeList rangelist = (SVNMergeRangeList)implicitSrcMergeInfo.get(mergeSrcCanonPath);
        if (rangelist == null) return;
        if (rangelist.getSize() > 1) {
            gap[0] = Math.min(rev1, rev2);
            gap[1] = rangelist.getRanges()[rangelist.getSize() - 1].getStartRevision();
            return;
        }
        if (implicitSrcMergeInfo.size() <= 1) return;
        SVNMergeRangeList implicitMergeRangeList = new SVNMergeRangeList(new SVNMergeRange[0]);
        SVNMergeRangeList requestedMergeRangeList = new SVNMergeRangeList(Math.min(rev1, rev2), Math.max(rev1, rev2), true);
        Iterator paths = implicitSrcMergeInfo.keySet().iterator();
        while (true) {
            if (!paths.hasNext()) {
                SVNMergeRangeList gapRangeList = requestedMergeRangeList.diff(implicitMergeRangeList, false);
                if (gapRangeList.getSize() <= 0) return;
                gap[0] = gapRangeList.getRanges()[0].getStartRevision();
                gap[1] = gapRangeList.getRanges()[0].getEndRevision();
                return;
            }
            String path = (String)paths.next();
            rangelist = (SVNMergeRangeList)implicitSrcMergeInfo.get(path);
            implicitMergeRangeList = implicitMergeRangeList != null ? implicitMergeRangeList.merge(rangelist) : rangelist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFileMerge(SVNURL url1, long revision1, SVNURL url2, long revision2, File targetWCPath, SVNAdminArea adminArea, boolean sourcesRelated) throws SVNException {
        SVNMergeRangeList filteredRangeList;
        SVNMergeRange[] remainingRanges;
        Map implicitMergeInfo;
        Map targetMergeInfo;
        SVNMergeRange range;
        SVNEntry entry;
        SVNMergeRange conflictedRange;
        String mergeInfoPath;
        boolean[] indirect;
        boolean recordMergeInfo;
        boolean isRollBack;
        block15: {
            isRollBack = revision1 > revision2;
            SVNURL primaryURL = isRollBack ? url1 : url2;
            boolean honorMergeInfo = this.isHonorMergeInfo();
            recordMergeInfo = this.isRecordMergeInfo();
            this.myIsSingleFileMerge = true;
            indirect = new boolean[]{false};
            boolean[] isTreeConflict = new boolean[]{false};
            SVNURL sourceRootURL = null;
            mergeInfoPath = null;
            conflictedRange = null;
            this.myWCAccess.probeTry(targetWCPath, true, -1);
            entry = this.myWCAccess.getVersionedEntry(targetWCPath, false);
            if (honorMergeInfo) {
                sourceRootURL = this.myRepository1.getRepositoryRoot(true);
                mergeInfoPath = this.getPathRelativeToRoot(null, primaryURL, sourceRootURL, null, null);
            }
            range = new SVNMergeRange(revision1, revision2, true);
            Object[] mergeInfoBundle = this.calculateRemainingRangeList(targetWCPath, entry, sourceRootURL, indirect, url1, revision1, url2, revision2, range);
            SVNMergeRangeList remainingRangeList = (SVNMergeRangeList)mergeInfoBundle[0];
            targetMergeInfo = (Map)mergeInfoBundle[1];
            implicitMergeInfo = (Map)mergeInfoBundle[1];
            remainingRanges = remainingRangeList.getRanges();
            SVNMergeCallback callback = this.getMergeCallback(adminArea);
            String targetName = targetWCPath.getName();
            if (this.myIsRecordOnly) break block15;
            SVNMergeRangeList rangeListToMerge = remainingRangeList;
            if (this.myAreSourcesAncestral && remainingRangeList.getSize() > 1) {
                SVNURL oldSessionURL = this.ensureSessionURL(this.myRepository1, primaryURL);
                rangeListToMerge = this.removeNoOpMergeRanges(this.myRepository1, remainingRangeList);
                if (oldSessionURL != null) {
                    this.myRepository1.setLocation(oldSessionURL, false);
                }
            }
            SVNMergeRange[] rangesToMerge = rangeListToMerge.getRanges();
            for (int i = 0; i < rangesToMerge.length; ++i) {
                File f2;
                File f1;
                SVNMergeRange nextRange;
                block14: {
                    nextRange = rangesToMerge[i];
                    boolean headerSent = false;
                    SVNEvent event = SVNEventFactory.createSVNEvent(targetWCPath, SVNNodeKind.UNKNOWN, null, -1L, this.myIsSameRepository ? SVNEventAction.MERGE_BEGIN : SVNEventAction.FOREIGN_MERGE_BEGIN, null, null, this.myAreSourcesAncestral ? nextRange : null);
                    SVNProperties props1 = new SVNProperties();
                    SVNProperties props2 = new SVNProperties();
                    f1 = null;
                    f2 = null;
                    SVNRepository repos1 = this.myRepository1;
                    SVNRepository repos2 = this.myRepository2;
                    if (honorMergeInfo && !url1.equals(url2)) {
                        if (!isRollBack && nextRange.getStartRevision() != revision1) {
                            repos1 = repos2;
                        } else if (isRollBack && nextRange.getEndRevision() != revision2) {
                            repos2 = repos1;
                        }
                    }
                    try {
                        SVNStatusType[] mergeResult;
                        f1 = this.loadFile(repos1, nextRange.getStartRevision(), props1, adminArea);
                        f2 = this.loadFile(repos2, nextRange.getEndRevision(), props2, adminArea);
                        String mimeType1 = props1.getStringValue("svn:mime-type");
                        String mimeType2 = props2.getStringValue("svn:mime-type");
                        props1 = SVNMergeDriver.filterProperties(props1, true, false, false);
                        props2 = SVNMergeDriver.filterProperties(props2, true, false, false);
                        SVNProperties propsDiff = SVNMergeDriver.computePropsDiff(props1, props2);
                        if (!this.myIsIgnoreAncestry && !sourcesRelated) {
                            SVNStatusType cstatus = ((AbstractDiffCallback)callback).fileDeleted(targetName, f1, f2, mimeType1, mimeType2, props1, isTreeConflict);
                            headerSent = this.notifySingleFileMerge(targetWCPath, isTreeConflict[0] ? SVNEventAction.TREE_CONFLICT : SVNEventAction.UPDATE_DELETE, cstatus, SVNStatusType.UNKNOWN, event, headerSent);
                            mergeResult = ((AbstractDiffCallback)callback).fileAdded(targetName, f1, f2, nextRange.getStartRevision(), nextRange.getEndRevision(), mimeType1, mimeType2, props1, propsDiff, isTreeConflict);
                            headerSent = this.notifySingleFileMerge(targetWCPath, isTreeConflict[0] ? SVNEventAction.TREE_CONFLICT : SVNEventAction.UPDATE_ADD, mergeResult[0], mergeResult[1], event, headerSent);
                            break block14;
                        }
                        mergeResult = ((AbstractDiffCallback)callback).fileChanged(targetName, f1, f2, nextRange.getStartRevision(), nextRange.getEndRevision(), mimeType1, mimeType2, props1, propsDiff, isTreeConflict);
                        headerSent = this.notifySingleFileMerge(targetWCPath, isTreeConflict[0] ? SVNEventAction.TREE_CONFLICT : SVNEventAction.UPDATE_UPDATE, mergeResult[0], mergeResult[1], event, headerSent);
                    }
                    catch (Throwable throwable) {
                        SVNFileUtil.deleteAll(f1, null);
                        SVNFileUtil.deleteAll(f2, null);
                        throw throwable;
                    }
                }
                SVNFileUtil.deleteAll(f1, null);
                SVNFileUtil.deleteAll(f2, null);
                if (i >= rangesToMerge.length - 1 || this.myConflictedPaths == null || this.myConflictedPaths.isEmpty()) continue;
                conflictedRange = nextRange;
                break;
            }
        }
        if (recordMergeInfo && remainingRanges.length > 0 && !(filteredRangeList = this.filterNaturalHistoryFromMergeInfo(mergeInfoPath, implicitMergeInfo, range)).isEmpty() && (this.mySkippedPaths == null || this.mySkippedPaths.isEmpty())) {
            if (indirect[0]) {
                SVNPropertiesManager.recordWCMergeInfo(targetWCPath, targetMergeInfo, this.myWCAccess);
            }
            TreeMap<File, SVNMergeRangeList> merges = new TreeMap<File, SVNMergeRangeList>();
            merges.put(targetWCPath, filteredRangeList);
            this.updateWCMergeInfo(targetWCPath, mergeInfoPath, entry, merges, isRollBack);
        }
        this.sleepForTimeStamp();
        if (conflictedRange != null) {
            SVNErrorMessage error = this.makeMergeConflictError(targetWCPath, conflictedRange);
            SVNErrorManager.error(error, SVNLogType.WC);
        }
    }

    protected void doMergeInfoUnawareDirectoryMerge(SVNURL url1, long revision1, SVNURL url2, long revision2, SVNAdminArea adminArea, SVNDepth depth) throws SVNException {
        File targetWCPath = adminArea.getRoot();
        boolean isRollBack = revision1 > revision2;
        MergePath item = new MergePath(targetWCPath);
        SVNMergeRange itemRange = new SVNMergeRange(revision1, revision2, true);
        item.myRemainingRanges = new SVNMergeRangeList(itemRange);
        this.myChildrenWithMergeInfo.add(item);
        this.driveMergeReportEditor(targetWCPath, url1, revision1, url2, revision2, null, isRollBack, depth, adminArea, this.getMergeCallback(adminArea), null);
    }

    protected void recordMergeInfoForDirectoryMerge(SVNEntry targetEntry, SVNMergeRange range, String mergeInfoPath, SVNDepth depth) throws SVNException {
        boolean isRollBack = range.getStartRevision() > range.getEndRevision();
        this.removeAbsentChildren(this.myTarget, this.myChildrenWithMergeInfo);
        for (int i = 0; i < this.myChildrenWithMergeInfo.size(); ++i) {
            MergePath child = (MergePath)this.myChildrenWithMergeInfo.get(i);
            if (child == null || child.myIsAbsent) continue;
            String childReposPath = null;
            childReposPath = child.myPath.equals(this.myTarget) ? "" : SVNPathUtil.getRelativePath(this.myTarget.getAbsolutePath(), child.myPath.getAbsolutePath());
            SVNEntry childEntry = this.myWCAccess.getVersionedEntry(child.myPath, false);
            String childMergeSourcePath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(mergeInfoPath, childReposPath));
            SVNMergeRangeList childMergeRangeList = this.filterNaturalHistoryFromMergeInfo(childMergeSourcePath, child.myImplicitMergeInfo, range);
            if (childMergeRangeList.isEmpty()) continue;
            if (i == 0) {
                this.recordSkips(mergeInfoPath, targetEntry, isRollBack);
            }
            this.calculateMergeInheritance(childMergeRangeList, childEntry, i == 0, child.myHasMissingChildren, depth);
            if (child.myIsIndirectMergeInfo) {
                SVNPropertiesManager.recordWCMergeInfo(child.myPath, child.myPreMergeMergeInfo, this.myWCAccess);
            }
            if (this.myImplicitSrcGap != null) {
                if (isRollBack) {
                    childMergeRangeList.reverse();
                }
                childMergeRangeList = childMergeRangeList.diff(this.myImplicitSrcGap, false);
                if (isRollBack) {
                    childMergeRangeList.reverse();
                }
            }
            TreeMap<File, SVNMergeRangeList> childMerges = new TreeMap<File, SVNMergeRangeList>();
            childMerges.put(child.myPath, childMergeRangeList);
            this.updateWCMergeInfo(child.myPath, childMergeSourcePath, childEntry, childMerges, isRollBack);
            if (i <= 0) continue;
            boolean isInSwitchedSubTree = false;
            if (child.myIsSwitched) {
                isInSwitchedSubTree = true;
            } else if (i > 1) {
                for (int j = i - 1; j > 0; --j) {
                    MergePath parent = (MergePath)this.myChildrenWithMergeInfo.get(j);
                    if (parent == null || !parent.myIsSwitched || !SVNPathUtil.isAncestor(parent.myPath.getAbsolutePath().replace(File.separatorChar, '/'), child.myPath.getAbsolutePath().replace(File.separatorChar, '/'))) continue;
                    isInSwitchedSubTree = true;
                    break;
                }
            }
            this.elideMergeInfo(this.myWCAccess, child.myPath, childEntry, isInSwitchedSubTree ? null : this.myTarget);
        }
    }

    protected void recordMergeInfoForAddedSubtrees(SVNMergeRange range, String mergeInfoPath, SVNDepth depth) throws SVNException {
        if (this.myAddedPaths != null) {
            Iterator addedPathsIter = this.myAddedPaths.iterator();
            while (addedPathsIter.hasNext()) {
                File addedPath = (File)addedPathsIter.next();
                SVNPropertyValue addedPathParentPropValue = SVNPropertiesManager.getProperty(this.myWCAccess, addedPath.getParentFile(), "svn:mergeinfo");
                String addedPathParentPropValueStr = addedPathParentPropValue != null ? addedPathParentPropValue.getString() : null;
                if (addedPathParentPropValueStr == null || addedPathParentPropValueStr.indexOf(SVNMergeRangeList.MERGE_INFO_NONINHERITABLE_STRING) == -1) continue;
                SVNEntry entry = this.myWCAccess.getVersionedEntry(addedPath, false);
                Map<String, SVNMergeRangeList> mergeMergeInfo = new TreeMap<String, SVNMergeRangeList>();
                MergePath targetMergePath = (MergePath)this.myChildrenWithMergeInfo.get(0);
                SVNMergeRange rng = range.dup();
                if (entry.isFile()) {
                    rng.setInheritable(true);
                } else {
                    rng.setInheritable(depth != SVNDepth.INFINITY && depth != SVNDepth.IMMEDIATES);
                }
                String addedPathStr = SVNPathUtil.validateFilePath(addedPath.getAbsolutePath());
                String targetMergePathStr = SVNPathUtil.validateFilePath(targetMergePath.myPath.getAbsolutePath());
                String commonAncestorPath = SVNPathUtil.getCommonPathAncestor(addedPathStr, targetMergePathStr);
                String relativeAddedPath = SVNPathUtil.getRelativePath(commonAncestorPath, addedPathStr);
                if (relativeAddedPath.startsWith("/")) {
                    relativeAddedPath = relativeAddedPath.substring(1);
                }
                SVNMergeRangeList rangeList = new SVNMergeRangeList(rng);
                mergeMergeInfo.put(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(mergeInfoPath, relativeAddedPath)), rangeList);
                boolean[] inherited = new boolean[]{false};
                Map addedPathMergeInfo = this.getWCMergeInfo(addedPath, entry, null, SVNMergeInfoInheritance.EXPLICIT, false, inherited);
                if (addedPathMergeInfo != null) {
                    mergeMergeInfo = SVNMergeInfoUtil.mergeMergeInfos(mergeMergeInfo, addedPathMergeInfo);
                }
                SVNPropertiesManager.recordWCMergeInfo(addedPath, mergeMergeInfo, this.myWCAccess);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDirectoryMerge(SVNURL url1, long revision1, SVNURL url2, long revision2, SVNEntry parentEntry, SVNAdminArea adminArea, SVNDepth depth) throws SVNException {
        SVNErrorMessage err;
        SVNMergeRange range;
        String mergeInfoPath;
        boolean recordMergeInfo;
        block15: {
            ISVNReusableEditor editor;
            SVNMergeCallback mergeCallback;
            boolean isRollBack;
            block16: {
                isRollBack = revision1 > revision2;
                SVNURL primaryURL = isRollBack ? url1 : url2;
                boolean honorMergeInfo = this.isHonorMergeInfo();
                recordMergeInfo = this.isRecordMergeInfo();
                boolean sameURLs = url1.equals(url2);
                mergeCallback = this.getMergeCallback(adminArea);
                this.myChildrenWithMergeInfo = new LinkedList();
                if (!honorMergeInfo) {
                    this.doMergeInfoUnawareDirectoryMerge(url1, revision1, url2, revision2, adminArea, depth);
                    return;
                }
                SVNRepository repository = isRollBack ? this.myRepository1 : this.myRepository2;
                SVNURL sourceRootURL = repository.getRepositoryRoot(true);
                mergeInfoPath = this.getPathRelativeToRoot(null, primaryURL, sourceRootURL, null, null);
                this.myChildrenWithMergeInfo = this.getMergeInfoPaths(this.myChildrenWithMergeInfo, mergeInfoPath, parentEntry, sourceRootURL, revision1, revision2, honorMergeInfo, repository, depth);
                MergePath targetMergePath = (MergePath)this.myChildrenWithMergeInfo.get(0);
                this.myIsTargetMissingChild = targetMergePath.myHasMissingChildren;
                this.populateRemainingRanges(this.myChildrenWithMergeInfo, sourceRootURL, url1, revision1, url2, revision2, honorMergeInfo, repository, mergeInfoPath);
                range = new SVNMergeRange(revision1, revision2, true);
                editor = null;
                err = null;
                if (!honorMergeInfo || this.myIsRecordOnly) break block16;
                long startRev = this.getMostInclusiveStartRevision(this.myChildrenWithMergeInfo, isRollBack);
                if (!SVNRevision.isValidRevisionNumber(startRev)) break block15;
                range.setStartRevision(startRev);
                long endRev = this.getMostInclusiveEndRevision(this.myChildrenWithMergeInfo, isRollBack);
                while (SVNRevision.isValidRevisionNumber(endRev)) {
                    long nextEndRev;
                    SVNURL oldURL2;
                    block14: {
                        Object var34_28;
                        SVNURL realURL1 = url1;
                        SVNURL realURL2 = url2;
                        SVNURL oldURL1 = null;
                        oldURL2 = null;
                        nextEndRev = -1L;
                        this.sliceRemainingRanges(this.myChildrenWithMergeInfo, isRollBack, endRev);
                        this.myCurrentAncestorIndex = -1;
                        if (!sameURLs) {
                            if (isRollBack && endRev != revision2) {
                                realURL2 = url1;
                                oldURL2 = this.ensureSessionURL(this.myRepository2, realURL2);
                            }
                            if (!isRollBack && startRev != revision1) {
                                realURL1 = url2;
                                oldURL1 = this.ensureSessionURL(this.myRepository1, realURL1);
                            }
                        }
                        try {
                            editor = this.driveMergeReportEditor(this.myTarget, realURL1, startRev, realURL2, endRev, this.myChildrenWithMergeInfo, isRollBack, depth, adminArea, mergeCallback, editor);
                            var34_28 = null;
                            if (oldURL1 == null) break block14;
                        }
                        catch (Throwable throwable) {
                            var34_28 = null;
                            if (oldURL1 != null) {
                                this.myRepository1.setLocation(oldURL1, false);
                            }
                            if (oldURL2 != null) {
                                this.myRepository2.setLocation(oldURL2, false);
                            }
                            throw throwable;
                        }
                        this.myRepository1.setLocation(oldURL1, false);
                    }
                    if (oldURL2 != null) {
                        this.myRepository2.setLocation(oldURL2, false);
                    }
                    this.processChildrenWithNewMergeInfo();
                    this.processChildrenWithDeletedMergeInfo();
                    this.removeFirstRangeFromRemainingRanges(endRev, this.myChildrenWithMergeInfo);
                    nextEndRev = this.getMostInclusiveEndRevision(this.myChildrenWithMergeInfo, isRollBack);
                    if (SVNRevision.isValidRevisionNumber(nextEndRev) && this.myConflictedPaths != null && !this.myConflictedPaths.isEmpty() && !this.myIsDryRun) {
                        SVNMergeRange conflictedRange = new SVNMergeRange(startRev, endRev, false);
                        err = this.makeMergeConflictError(this.myTarget, conflictedRange);
                        range.setEndRevision(endRev);
                        break block15;
                    }
                    startRev = this.getMostInclusiveStartRevision(this.myChildrenWithMergeInfo, isRollBack);
                    endRev = nextEndRev;
                }
                break block15;
            }
            if (!this.myIsRecordOnly) {
                this.myCurrentAncestorIndex = -1;
                editor = this.driveMergeReportEditor(this.myTarget, url1, revision1, url2, revision2, null, isRollBack, depth, adminArea, mergeCallback, editor);
            }
        }
        if (recordMergeInfo) {
            this.recordMergeInfoForDirectoryMerge(parentEntry, range, mergeInfoPath, depth);
            this.recordMergeInfoForAddedSubtrees(range, mergeInfoPath, depth);
        }
        if (err != null) {
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    protected SVNProperties filterSelfReferentialMergeInfo(SVNProperties props, File path) throws SVNException {
        boolean honorMergeInfo = this.isHonorMergeInfo();
        if (!honorMergeInfo && this.myIsSameRepository && !this.myIsReIntegrateMerge) {
            return null;
        }
        SVNEntry targetEntry = this.myWCAccess.getVersionedEntry(path, false);
        if (this.myIsSameRepository && (targetEntry.isScheduledForAddition() || targetEntry.isScheduledForReplacement())) {
            return null;
        }
        SVNProperties adjustedProperties = new SVNProperties();
        Iterator propNamesIter = props.nameSet().iterator();
        while (propNamesIter.hasNext()) {
            String propName = (String)propNamesIter.next();
            SVNPropertyValue propValue = props.getSVNPropertyValue(propName);
            if ("svn:mergeinfo".equals(propName) && !this.myIsSameRepository) continue;
            if (!"svn:mergeinfo".equals(propName) || propValue == null || "".equals(propValue.getString())) {
                adjustedProperties.put(propName, propValue);
                continue;
            }
            SVNURL mergeSourceRootURL = this.myRepository2.getRepositoryRoot(true);
            SVNURL targetURL = this.getURL(path);
            SVNURL oldURL = this.ensureSessionURL(this.myRepository2, targetURL);
            TreeMap<String, SVNMergeRangeList> filteredYoungerMergeInfo = null;
            Map mergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(propValue.getString()), null);
            Map[] mergeInfoArr = new Map[]{mergeInfo};
            Map youngerMergeInfo = this.splitMergeInfoOnRevision(mergeInfoArr, targetEntry.getRevision());
            mergeInfo = mergeInfoArr[0];
            if (youngerMergeInfo != null) {
                Iterator youngerMergeInfoIter = youngerMergeInfo.keySet().iterator();
                while (youngerMergeInfoIter.hasNext()) {
                    String sourcePath = (String)youngerMergeInfoIter.next();
                    SVNMergeRangeList rangeList = (SVNMergeRangeList)youngerMergeInfo.get(sourcePath);
                    SVNMergeRange[] ranges = rangeList.getRanges();
                    LinkedList<SVNMergeRange> adjustedRanges = new LinkedList<SVNMergeRange>();
                    SVNURL mergeSourceURL = mergeSourceRootURL.appendPath(sourcePath, false);
                    for (int i = 0; i < ranges.length; ++i) {
                        SVNMergeRange range = ranges[i];
                        SVNBasicClient.SVNRepositoryLocation[] locations = null;
                        try {
                            locations = this.getLocations(targetURL, null, this.myRepository2, SVNRevision.create(targetEntry.getRevision()), SVNRevision.create(range.getStartRevision() + 1L), SVNRevision.UNDEFINED);
                            SVNURL startURL = locations[0].getURL();
                            if (mergeSourceURL.equals(startURL)) continue;
                            adjustedRanges.add(range);
                            continue;
                        }
                        catch (SVNException svne) {
                            SVNErrorCode code = svne.getErrorMessage().getErrorCode();
                            if (code == SVNErrorCode.CLIENT_UNRELATED_RESOURCES || code == SVNErrorCode.RA_DAV_PATH_NOT_FOUND || code == SVNErrorCode.FS_NOT_FOUND || code == SVNErrorCode.FS_NO_SUCH_REVISION) {
                                adjustedRanges.add(range);
                                continue;
                            }
                            throw svne;
                        }
                    }
                    if (adjustedRanges.isEmpty()) continue;
                    if (filteredYoungerMergeInfo == null) {
                        filteredYoungerMergeInfo = new TreeMap<String, SVNMergeRangeList>();
                    }
                    SVNMergeRangeList adjustedRangeList = SVNMergeRangeList.fromCollection(adjustedRanges);
                    filteredYoungerMergeInfo.put(sourcePath, adjustedRangeList);
                }
            }
            TreeMap<String, SVNMergeRangeList> filteredMergeInfo = null;
            if (mergeInfo != null && !mergeInfo.isEmpty()) {
                Map implicitMergeInfo = this.getHistoryAsMergeInfo(null, path, SVNRevision.create(targetEntry.getRevision()), targetEntry.getRevision(), -1L, this.myRepository2, this.myWCAccess);
                filteredMergeInfo = SVNMergeInfoUtil.removeMergeInfo(implicitMergeInfo, mergeInfo);
            }
            if (oldURL != null) {
                this.myRepository2.setLocation(oldURL, false);
            }
            if (filteredMergeInfo != null && filteredYoungerMergeInfo != null) {
                filteredMergeInfo = SVNMergeInfoUtil.mergeMergeInfos(filteredMergeInfo, filteredYoungerMergeInfo);
            } else if (filteredYoungerMergeInfo != null) {
                filteredMergeInfo = filteredYoungerMergeInfo;
            }
            if (filteredMergeInfo == null || filteredMergeInfo.isEmpty()) continue;
            String filteredMergeInfoStr = SVNMergeInfoUtil.formatMergeInfoToString(filteredMergeInfo, null);
            adjustedProperties.put("svn:mergeinfo", filteredMergeInfoStr);
        }
        return adjustedProperties;
    }

    protected SVNLogClient getLogClient() {
        if (this.myLogClient == null) {
            this.myLogClient = new SVNLogClient(this.getRepositoryPool(), this.getOptions());
        }
        return this.myLogClient;
    }

    protected void recordTreeConflict(File victim, SVNAdminArea adminArea, SVNNodeKind kind, SVNConflictAction action, SVNConflictReason reason) throws SVNException {
        if (this.myIsRecordOnly || this.myIsDryRun) {
            return;
        }
        SVNTreeConflictDescription conflict = this.makeTreeConflict(victim, kind, action, reason);
        adminArea.addTreeConflict(conflict);
    }

    protected void recordTreeConflictOnAdd(File victim, SVNAdminArea adminArea, SVNNodeKind kind, SVNConflictAction action, SVNConflictReason reason) throws SVNException {
        if (this.myIsRecordOnly || this.myIsDryRun) {
            return;
        }
        SVNTreeConflictDescription conflict = this.makeTreeConflict(victim, kind, action, reason);
        SVNTreeConflictDescription existingConflict = this.myWCAccess.getTreeConflict(conflict.getPath());
        if (existingConflict != null && existingConflict.getConflictAction() == SVNConflictAction.DELETE && conflict.getConflictAction() == SVNConflictAction.ADD) {
            adminArea.deleteTreeConflict(conflict.getPath().getName());
            conflict = new SVNTreeConflictDescription(conflict.getPath(), conflict.getNodeKind(), SVNConflictAction.DELETE, existingConflict.getConflictReason(), conflict.getOperation(), existingConflict.getSourceLeftVersion(), conflict.getSourceRightVersion());
        }
        adminArea.addTreeConflict(conflict);
    }

    protected SVNTreeConflictDescription makeTreeConflict(File victim, SVNNodeKind kind, SVNConflictAction action, SVNConflictReason reason) throws SVNException {
        SVNURL srcReposRoot = this.myRepository1.getRepositoryRoot(true);
        String child = SVNPathUtil.getRelativePath(this.myTarget.getAbsolutePath(), victim.getAbsolutePath());
        SVNURL leftURL = null;
        SVNURL rightURL = null;
        if (child != null) {
            leftURL = this.myCurrentMergeSource.myURL1.appendPath(child, false);
            rightURL = this.myCurrentMergeSource.myURL2.appendPath(child, false);
        } else {
            leftURL = this.myCurrentMergeSource.myURL1;
            rightURL = this.myCurrentMergeSource.myURL2;
        }
        SVNConflictVersion leftConflictVersion = new SVNConflictVersion(srcReposRoot, SVNURLUtil.getRelativeURL(srcReposRoot, leftURL), this.myCurrentMergeSource.myRevision1, kind);
        SVNConflictVersion rightConflictVersion = new SVNConflictVersion(srcReposRoot, SVNURLUtil.getRelativeURL(srcReposRoot, rightURL), this.myCurrentMergeSource.myRevision2, kind);
        SVNTreeConflictDescription conflictDescription = new SVNTreeConflictDescription(victim, kind, action, reason, SVNOperation.MERGE, leftConflictVersion, rightConflictVersion);
        return conflictDescription;
    }

    private SVNMergeCallback getMergeCallback(SVNAdminArea adminArea) {
        return this.myWCAccess.createMergeCallback(this, adminArea, this.myURL, this.getMergeOptions(), this.myConflictedPaths, this.myIsForce, this.myIsDryRun);
    }

    private void processChildrenWithNewMergeInfo() throws SVNException {
        if (this.myPathsWithNewMergeInfo != null && !this.myIsDryRun) {
            Iterator pathsIter = this.myPathsWithNewMergeInfo.iterator();
            while (pathsIter.hasNext()) {
                File pathWithNewMergeInfo = (File)pathsIter.next();
                SVNEntry pathEntry = this.myWCAccess.getVersionedEntry(pathWithNewMergeInfo, false);
                boolean[] indirect = new boolean[]{false};
                Map pathExplicitMergeInfo = this.getWCMergeInfo(pathWithNewMergeInfo, pathEntry, null, SVNMergeInfoInheritance.EXPLICIT, false, indirect);
                SVNURL oldURL = null;
                if (pathExplicitMergeInfo != null) {
                    MergePath newChild;
                    oldURL = this.ensureSessionURL(this.myRepository2, pathEntry.getSVNURL());
                    Map pathInheritedMergeInfo = this.getWCOrRepositoryMergeInfo(pathWithNewMergeInfo, pathEntry, SVNMergeInfoInheritance.NEAREST_ANCESTOR, indirect, false, this.myRepository2);
                    if (pathInheritedMergeInfo != null) {
                        pathExplicitMergeInfo = SVNMergeInfoUtil.mergeMergeInfos(pathExplicitMergeInfo, pathInheritedMergeInfo);
                        SVNPropertiesManager.recordWCMergeInfo(pathWithNewMergeInfo, pathExplicitMergeInfo, this.myWCAccess);
                    }
                    if (!this.myChildrenWithMergeInfo.contains(newChild = new MergePath(pathWithNewMergeInfo))) {
                        int parentIndex = this.findNearestAncestor(this.myChildrenWithMergeInfo.toArray(), false, pathWithNewMergeInfo);
                        MergePath parent = (MergePath)this.myChildrenWithMergeInfo.get(parentIndex);
                        newChild.myRemainingRanges = parent.myRemainingRanges.dup();
                        this.myChildrenWithMergeInfo.add(newChild);
                        Collections.sort(this.myChildrenWithMergeInfo);
                    }
                }
                if (oldURL == null) continue;
                this.myRepository2.setLocation(oldURL, false);
            }
        }
    }

    private void processChildrenWithDeletedMergeInfo() {
        if (this.myPathsWithDeletedMergeInfo != null && !this.myIsDryRun) {
            Iterator children = this.myChildrenWithMergeInfo.iterator();
            children.next();
            while (children.hasNext()) {
                MergePath path = (MergePath)children.next();
                if (path == null || !this.myPathsWithDeletedMergeInfo.contains(path.myPath)) continue;
                children.remove();
            }
        }
    }

    private Map splitMergeInfoOnRevision(Map[] mergeInfo, long revision) {
        TreeMap<String, SVNMergeRangeList> youngerMergeInfo = null;
        Iterator mergeInfoIter = mergeInfo[0].keySet().iterator();
        block0: while (mergeInfoIter.hasNext()) {
            String mergeSourcePath = (String)mergeInfoIter.next();
            SVNMergeRangeList rangeList = (SVNMergeRangeList)mergeInfo[0].get(mergeSourcePath);
            SVNMergeRange[] ranges = rangeList.getRanges();
            for (int i = 0; i < ranges.length; ++i) {
                SVNMergeRange range = ranges[i];
                if (range.getEndRevision() < revision) continue;
                LinkedList<SVNMergeRange> youngerRanges = new LinkedList<SVNMergeRange>();
                for (int j = i; j < ranges.length; ++j) {
                    SVNMergeRange youngerRange = ranges[j].dup();
                    if (j == i && youngerRange.getStartRevision() < revision) {
                        youngerRange.setStartRevision(revision);
                        range.setEndRevision(revision);
                    }
                    youngerRanges.add(youngerRange);
                }
                if (youngerMergeInfo == null) {
                    youngerMergeInfo = new TreeMap<String, SVNMergeRangeList>();
                }
                youngerMergeInfo.put(mergeSourcePath, SVNMergeRangeList.fromCollection(youngerRanges));
                mergeInfo[0] = SVNMergeInfoUtil.removeMergeInfo(youngerMergeInfo, mergeInfo[0]);
                continue block0;
            }
        }
        return youngerMergeInfo;
    }

    private void ensureWCReflectsRepositorySubTree(File targetWCPath) throws SVNException {
        SVNErrorMessage err;
        SVNRevisionStatus wcStatus = SVNStatusUtil.getRevisionStatus(targetWCPath, null, false, this.getEventDispatcher());
        if (wcStatus.isSwitched()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot reintegrate into a working copy with a switched subtree");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (wcStatus.isSparseCheckout()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot reintegrate into a working copy not entirely at infinite depth");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (wcStatus.isModified()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot reintegrate into a working copy that has local modifications");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!SVNRevision.isValidRevisionNumber(wcStatus.getMinRevision()) || !SVNRevision.isValidRevisionNumber(wcStatus.getMaxRevision())) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot determine revision of working copy");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (wcStatus.getMinRevision() != wcStatus.getMaxRevision()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot reintegrate into mixed-revision working copy; try updating first");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
    }

    private void ensureAllMissingRangesArePhantoms(SVNRepository repository, Map unmergedHistory) throws SVNException {
        Iterator unmergedHistoryIter = unmergedHistory.keySet().iterator();
        while (unmergedHistoryIter.hasNext()) {
            String catalogPath = (String)unmergedHistoryIter.next();
            Map historyAsMergeInfo = (Map)unmergedHistory.get(catalogPath);
            Iterator pathsIter = historyAsMergeInfo.keySet().iterator();
            while (pathsIter.hasNext()) {
                String path = (String)pathsIter.next();
                SVNMergeRangeList rangeList = (SVNMergeRangeList)historyAsMergeInfo.get(path);
                SVNMergeRange[] ranges = rangeList.getRanges();
                for (int i = 0; i < ranges.length; ++i) {
                    SVNDirEntry dirEntry;
                    SVNMergeRange mergeRange = ranges[i];
                    if (mergeRange.getStartRevision() >= mergeRange.getEndRevision()) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "range start >= end");
                        SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    }
                    if (!this.mergeRangeContainsRevision(mergeRange, (dirEntry = repository.info(path, mergeRange.getEndRevision())).getRevision())) continue;
                    SVNURL fullURL = repository.getLocation();
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    fullURL = fullURL.appendPath(path, false);
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "At least one revision (r{0}) not yet merged from ''{1}''", new Object[]{new Long(dirEntry.getRevision()), fullURL});
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                }
            }
        }
    }

    private Map findUnmergedMergeInfo(boolean[] neverSynched, long[] youngestMergedRev, long[] ycAncestorRev, Map srcCatalog, Map targetSegments, String sourceReposPath, String targetReposPath, long targetRev, long srcRev, SVNRepository repos) throws SVNException {
        neverSynched[0] = true;
        youngestMergedRev[0] = -1L;
        Map<String, Map> newCatalog = new TreeMap();
        Iterator targetSegmentsIter = targetSegments.keySet().iterator();
        while (targetSegmentsIter.hasNext()) {
            Map srcMergeInfo;
            String path = (String)targetSegmentsIter.next();
            Collection segments = (Collection)targetSegments.get(path);
            String srcPath = path.substring(targetReposPath.length());
            if (srcPath.startsWith("/")) {
                srcPath = srcPath.substring(1);
            }
            if (!(srcPath = SVNPathUtil.append(sourceReposPath, srcPath)).startsWith("/")) {
                srcPath = "/" + srcPath;
            }
            Map targetHistoryAsMergeInfo = this.getMergeInfoFromSegments(segments);
            targetHistoryAsMergeInfo = SVNMergeInfoUtil.filterMergeInfoByRanges(targetHistoryAsMergeInfo, srcRev, ycAncestorRev[0]);
            SVNMergeInfo sourceMergeInfoObject = (SVNMergeInfo)srcCatalog.get(srcPath);
            TreeMap treeMap = srcMergeInfo = sourceMergeInfoObject != null ? sourceMergeInfoObject.getMergeSourcesToMergeLists() : null;
            if (srcMergeInfo != null) {
                srcCatalog.remove(srcPath);
                Map explicitSrcTgtHistoryIntersection = SVNMergeInfoUtil.intersectMergeInfo(srcMergeInfo, targetHistoryAsMergeInfo);
                if (!explicitSrcTgtHistoryIntersection.isEmpty()) {
                    neverSynched[0] = false;
                    long[] endPoints = SVNMergeInfoUtil.getRangeEndPoints(explicitSrcTgtHistoryIntersection);
                    long youngRev = endPoints[0];
                    if (!SVNRevision.isValidRevisionNumber(youngestMergedRev[0]) || youngRev > youngestMergedRev[0]) {
                        youngestMergedRev[0] = youngRev;
                    }
                }
            } else {
                SVNNodeKind kind = repos.checkPath(srcPath, srcRev);
                if (kind == SVNNodeKind.NONE) continue;
                Map subTreeCatalog = repos.getMergeInfo(new String[]{srcPath}, srcRev, SVNMergeInfoInheritance.INHERITED, false);
                if (subTreeCatalog != null) {
                    SVNMergeInfo sourceMergeInfo = (SVNMergeInfo)subTreeCatalog.get(srcPath);
                    Map map = srcMergeInfo = sourceMergeInfo != null ? sourceMergeInfo.getMergeSourcesToMergeLists() : null;
                }
                if (srcMergeInfo == null) {
                    srcMergeInfo = new TreeMap();
                }
            }
            segments = repos.getLocationSegments(srcPath, srcRev, srcRev, -1L);
            Map srcHistoryAsMergeInfo = this.getMergeInfoFromSegments(segments);
            srcMergeInfo = SVNMergeInfoUtil.mergeMergeInfos(srcMergeInfo, srcHistoryAsMergeInfo);
            Map commonMergeInfo = SVNMergeInfoUtil.intersectMergeInfo(srcMergeInfo, targetHistoryAsMergeInfo);
            Map filteredMergeInfo = SVNMergeInfoUtil.removeMergeInfo(commonMergeInfo, targetHistoryAsMergeInfo);
            newCatalog.put(srcPath, filteredMergeInfo);
        }
        if (!srcCatalog.isEmpty()) {
            Iterator srcCatalogIter = srcCatalog.keySet().iterator();
            while (srcCatalogIter.hasNext()) {
                Map srcHistoryAsMergeInfo;
                Map commonMergeInfo;
                Map filteredMergeInfo;
                String srcPath = (String)srcCatalogIter.next();
                SVNMergeInfo sourceMergeInfoObject = (SVNMergeInfo)srcCatalog.get(srcPath);
                Map srcMergeInfo = sourceMergeInfoObject.getMergeSourcesToMergeLists();
                String targetPath = srcPath.substring(sourceReposPath.length());
                if (targetPath.startsWith("/")) {
                    targetPath = targetPath.substring(1);
                }
                targetPath = SVNPathUtil.append(targetReposPath, targetPath);
                List segments = null;
                boolean tgtPathExists = true;
                try {
                    segments = repos.getLocationSegments(targetPath, targetRev, targetRev, -1L);
                }
                catch (SVNException svne) {
                    SVNErrorMessage err = svne.getErrorMessage();
                    SVNErrorCode errCode = err.getErrorCode();
                    if (errCode != SVNErrorCode.FS_NOT_FOUND && errCode != SVNErrorCode.RA_DAV_REQUEST_FAILED) {
                        throw svne;
                    }
                    tgtPathExists = false;
                }
                if (!tgtPathExists) continue;
                Map targetHistoryAsMergeInfo = this.getMergeInfoFromSegments(segments);
                Map explicitSrcTgtHistoryIntersection = SVNMergeInfoUtil.intersectMergeInfo(srcMergeInfo, targetHistoryAsMergeInfo);
                if (!explicitSrcTgtHistoryIntersection.isEmpty()) {
                    neverSynched[0] = false;
                    long[] endPoints = SVNMergeInfoUtil.getRangeEndPoints(explicitSrcTgtHistoryIntersection);
                    long youngRev = endPoints[0];
                    if (!SVNRevision.isValidRevisionNumber(youngestMergedRev[0]) || youngRev > youngestMergedRev[0]) {
                        youngestMergedRev[0] = youngRev;
                    }
                }
                if ((filteredMergeInfo = SVNMergeInfoUtil.removeMergeInfo(commonMergeInfo = SVNMergeInfoUtil.intersectMergeInfo(srcMergeInfo = SVNMergeInfoUtil.mergeMergeInfos(srcMergeInfo, srcHistoryAsMergeInfo = this.getMergeInfoFromSegments(segments = repos.getLocationSegments(srcPath, targetRev, targetRev, -1L))), targetHistoryAsMergeInfo), targetHistoryAsMergeInfo)).isEmpty()) continue;
                newCatalog.put(srcPath, filteredMergeInfo);
            }
        }
        if (SVNRevision.isValidRevisionNumber(youngestMergedRev[0])) {
            newCatalog = SVNMergeInfoUtil.filterCatalogByRanges(newCatalog, youngestMergedRev[0], 0L);
        }
        return newCatalog;
    }

    private Map calculateLeftHandSide(SVNURL[] leftURL, long[] leftRev, String targetReposRelPath, Collection subTreesWithMergeInfo, long targetRev, String sourceReposRelPath, SVNURL sourceReposRoot, long sourceRev, SVNRepository repository) throws SVNException {
        TreeMap<String, List> segmentsMap = new TreeMap<String, List>();
        Iterator subTreesPathIter = subTreesWithMergeInfo.iterator();
        while (subTreesPathIter.hasNext()) {
            String path = (String)subTreesPathIter.next();
            List segments = repository.getLocationSegments(path, targetRev, targetRev, -1L);
            segmentsMap.put(path, segments);
        }
        Map mergeInfoCatalog = repository.getMergeInfo(new String[]{sourceReposRelPath}, sourceRev, SVNMergeInfoInheritance.INHERITED, true);
        if (mergeInfoCatalog == null) {
            mergeInfoCatalog = Collections.EMPTY_MAP;
        }
        boolean[] neverSynched = new boolean[1];
        long[] youngestMergedRev = new long[1];
        SVNURL sourceURL = sourceReposRoot.appendPath(sourceReposRelPath.startsWith("/") ? sourceReposRelPath.substring(1) : sourceReposRelPath, false);
        SVNURL targetURL = sourceReposRoot.appendPath(targetReposRelPath.startsWith("/") ? targetReposRelPath.substring(1) : targetReposRelPath, false);
        SVNLocationEntry youngestLocation = this.getYoungestCommonAncestor(null, sourceURL, sourceRev, null, targetURL, targetRev);
        String youngestCommonAncestorPath = youngestLocation.getPath();
        leftRev[0] = youngestLocation.getRevision();
        if (youngestCommonAncestorPath == null || !SVNRevision.isValidRevisionNumber(leftRev[0])) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "''{0}@{1}'' must be ancestrally related to ''{2}@{3}''", new Object[]{sourceURL, new Long(sourceRev), targetURL, new Long(targetRev)});
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        Map unmergedCatalog = this.findUnmergedMergeInfo(neverSynched, youngestMergedRev, leftRev, mergeInfoCatalog, segmentsMap, sourceReposRelPath, targetReposRelPath, targetRev, sourceRev, repository);
        unmergedCatalog = SVNMergeInfoUtil.elideMergeInfoCatalog(unmergedCatalog);
        if (neverSynched[0]) {
            leftURL[0] = sourceReposRoot.appendPath(youngestCommonAncestorPath.startsWith("/") ? youngestCommonAncestorPath.substring(1) : youngestCommonAncestorPath, false);
        } else {
            leftRev[0] = youngestMergedRev[0];
            leftURL[0] = this.deriveLocation(null, sourceReposRoot.appendPath(targetReposRelPath, false), null, SVNRevision.create(youngestMergedRev[0]), repository, null);
        }
        return unmergedCatalog;
    }

    private boolean mergeRangeContainsRevision(SVNMergeRange range, long rev) throws SVNException {
        SVNErrorMessage err;
        if (!SVNRevision.isValidRevisionNumber(range.getStartRevision())) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "invalid start range revision");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (!SVNRevision.isValidRevisionNumber(range.getEndRevision())) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "invalid end range revision");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (range.getStartRevision() == range.getEndRevision()) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "start range revision is equal to end range revision");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (range.getStartRevision() < range.getEndRevision()) {
            return rev > range.getStartRevision() && rev <= range.getEndRevision();
        }
        return rev > range.getEndRevision() && rev <= range.getStartRevision();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeCousinsAndSupplementMergeInfo(File targetWCPath, SVNEntry entry, SVNAdminArea adminArea, SVNRepository repository, SVNURL url1, long rev1, SVNURL url2, long rev2, long youngestCommonRev, SVNURL sourceReposRoot, SVNURL wcReposRoot, SVNDepth depth, boolean ignoreAncestry, boolean force, boolean recordOnly, boolean dryRun) throws SVNException {
        SVNURL oldURL = repository.getLocation();
        List addSources = null;
        List removeSources = null;
        try {
            SVNRevision sRev = SVNRevision.create(rev1);
            SVNRevision eRev = SVNRevision.create(youngestCommonRev);
            SVNRevisionRange range = new SVNRevisionRange(sRev, eRev);
            LinkedList<SVNRevisionRange> ranges = new LinkedList<SVNRevisionRange>();
            ranges.add(range);
            repository.setLocation(url1, false);
            removeSources = this.normalizeMergeSources(null, url1, sourceReposRoot, sRev, ranges, repository);
            sRev = eRev;
            eRev = SVNRevision.create(rev2);
            range = new SVNRevisionRange(sRev, eRev);
            ranges.clear();
            ranges.add(range);
            repository.setLocation(url2, false);
            addSources = this.normalizeMergeSources(null, url2, sourceReposRoot, eRev, ranges, repository);
        }
        finally {
            repository.setLocation(oldURL, false);
        }
        boolean sameRepos = sourceReposRoot.equals(wcReposRoot);
        if (!recordOnly) {
            MergeSource fauxSource = new MergeSource();
            fauxSource.myURL1 = url1;
            fauxSource.myURL2 = url2;
            fauxSource.myRevision1 = rev1;
            fauxSource.myRevision2 = rev2;
            LinkedList<MergeSource> fauxSources = new LinkedList<MergeSource>();
            fauxSources.add(fauxSource);
            this.doMerge(fauxSources, targetWCPath, entry, adminArea, false, true, sourceReposRoot.equals(wcReposRoot), ignoreAncestry, force, dryRun, false, true, depth);
        } else if (!sameRepos) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Merge from foreign repository is not compatible with mergeinfo modification");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (sameRepos) {
            this.doMerge(addSources, targetWCPath, entry, adminArea, true, true, sameRepos, ignoreAncestry, force, dryRun, true, true, depth);
            this.doMerge(removeSources, targetWCPath, entry, adminArea, true, true, sameRepos, ignoreAncestry, force, dryRun, true, true, depth);
        }
    }

    public boolean isSameRepository() {
        return this.myIsSameRepository;
    }

    protected boolean isHonorMergeInfo() {
        return this.myIsMergeInfoCapable && this.myAreSourcesAncestral && this.myIsSameRepository && !this.myIsIgnoreAncestry;
    }

    public boolean isRecordMergeInfo() {
        return this.myIsMergeInfoCapable && this.myAreSourcesAncestral && this.myIsSameRepository && !this.myIsIgnoreAncestry && !this.myIsDryRun;
    }

    protected MergeSource getCurrentMergeSource() {
        return this.myCurrentMergeSource;
    }

    private List normalizeMergeSources(File source, SVNURL sourceURL, SVNURL sourceRootURL, SVNRevision pegRevision, Collection rangesToMerge, SVNRepository repository) throws SVNException {
        long[] youngestRevision = new long[]{-1L};
        long pegRevNum = this.getRevisionNumber(pegRevision, youngestRevision, repository, source);
        if (!SVNRevision.isValidRevisionNumber(pegRevNum)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        List<SVNMergeRange> mergeRanges = new ArrayList(rangesToMerge.size());
        Iterator rangesIter = rangesToMerge.iterator();
        while (rangesIter.hasNext()) {
            long rangeEndRev;
            long rangeStartRev;
            SVNRevisionRange revRange = (SVNRevisionRange)rangesIter.next();
            SVNRevision rangeStart = revRange.getStartRevision();
            SVNRevision rangeEnd = revRange.getEndRevision();
            if (!rangeStart.isValid() || !rangeEnd.isValid()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            if ((rangeStartRev = this.getRevisionNumber(rangeStart, youngestRevision, repository, source)) == (rangeEndRev = this.getRevisionNumber(rangeEnd, youngestRevision, repository, source))) continue;
            SVNMergeRange range = new SVNMergeRange(rangeStartRev, rangeEndRev, true);
            mergeRanges.add(range);
        }
        SVNMergeRangeList mergeRangesList = SVNMergeRangeList.fromCollection(mergeRanges);
        if ((mergeRanges = mergeRangesList.getRangesAsList()).isEmpty()) {
            return mergeRanges;
        }
        long oldestRequestedRev = -1L;
        long youngestRequestedRev = -1L;
        Iterator rangesIter2 = mergeRanges.iterator();
        while (rangesIter2.hasNext()) {
            SVNMergeRange range = (SVNMergeRange)rangesIter2.next();
            long minRev = Math.min(range.getStartRevision(), range.getEndRevision());
            long maxRev = Math.max(range.getStartRevision(), range.getEndRevision());
            if (!SVNRevision.isValidRevisionNumber(oldestRequestedRev) || minRev < oldestRequestedRev) {
                oldestRequestedRev = minRev;
            }
            if (SVNRevision.isValidRevisionNumber(youngestRequestedRev) && maxRev <= youngestRequestedRev) continue;
            youngestRequestedRev = maxRev;
        }
        if (pegRevNum < youngestRequestedRev) {
            this.getLocations(sourceURL, null, repository, SVNRevision.create(pegRevNum), SVNRevision.create(youngestRequestedRev), SVNRevision.UNDEFINED);
            pegRevNum = youngestRequestedRev;
        }
        LinkedList segments = (LinkedList)repository.getLocationSegments("", pegRevNum, youngestRequestedRev, oldestRequestedRev);
        long trimRevision = -1L;
        if (!segments.isEmpty()) {
            SVNLocationSegment segment = (SVNLocationSegment)segments.get(0);
            if (segment.getStartRevision() != oldestRequestedRev) {
                trimRevision = segment.getStartRevision();
            } else if (segment.getPath() == null && segments.size() > 1) {
                SVNLocationSegment segment2 = (SVNLocationSegment)segments.get(1);
                SVNURL segmentURL = sourceRootURL.appendPath(segment2.getPath(), false);
                SVNLocationEntry copyFromLocation = this.getCopySource(null, segmentURL, SVNRevision.create(segment2.getStartRevision()));
                String copyFromPath = copyFromLocation.getPath();
                long copyFromRevision = copyFromLocation.getRevision();
                if (copyFromPath != null && SVNRevision.isValidRevisionNumber(copyFromRevision)) {
                    SVNLocationSegment newSegment = new SVNLocationSegment(copyFromRevision, copyFromRevision, copyFromPath);
                    segment.setStartRevision(copyFromRevision + 1L);
                    segments.addFirst(newSegment);
                }
            }
        }
        SVNLocationSegment[] segmentsArray = segments.toArray(new SVNLocationSegment[segments.size()]);
        LinkedList resultMergeSources = new LinkedList();
        Iterator rangesIter3 = mergeRanges.iterator();
        while (rangesIter3.hasNext()) {
            SVNMergeRange range = (SVNMergeRange)rangesIter3.next();
            if (SVNRevision.isValidRevisionNumber(trimRevision)) {
                if (Math.max(range.getStartRevision(), range.getEndRevision()) < trimRevision) continue;
                if (range.getStartRevision() < trimRevision) {
                    range.setStartRevision(trimRevision);
                }
                if (range.getEndRevision() < trimRevision) {
                    range.setEndRevision(trimRevision);
                }
            }
            List mergeSources = this.combineRangeWithSegments(range, segmentsArray, sourceRootURL);
            resultMergeSources.addAll(mergeSources);
        }
        return resultMergeSources;
    }

    private List combineRangeWithSegments(SVNMergeRange range, SVNLocationSegment[] segments, SVNURL sourceRootURL) throws SVNException {
        long minRev = Math.min(range.getStartRevision(), range.getEndRevision()) + 1L;
        long maxRev = Math.max(range.getStartRevision(), range.getEndRevision());
        boolean subtractive = range.getStartRevision() > range.getEndRevision();
        LinkedList<MergeSource> mergeSources = new LinkedList<MergeSource>();
        for (int i = 0; i < segments.length; ++i) {
            SVNLocationSegment segment = segments[i];
            if (segment.getEndRevision() < minRev || segment.getStartRevision() > maxRev || segment.getPath() == null) continue;
            String path1 = null;
            long rev1 = Math.max(segment.getStartRevision(), minRev) - 1L;
            if (minRev <= segment.getStartRevision()) {
                if (i > 0) {
                    path1 = segments[i - 1].getPath();
                }
                if (path1 == null && i > 1) {
                    path1 = segments[i - 2].getPath();
                    rev1 = segments[i - 2].getEndRevision();
                }
            } else {
                path1 = segment.getPath();
            }
            if (path1 == null || segment.getPath() == null) continue;
            MergeSource mergeSource = new MergeSource();
            mergeSource.myURL1 = sourceRootURL.appendPath(path1, false);
            mergeSource.myURL2 = sourceRootURL.appendPath(segment.getPath(), false);
            mergeSource.myRevision1 = rev1;
            mergeSource.myRevision2 = Math.min(segment.getEndRevision(), maxRev);
            if (subtractive) {
                long tmpRev = mergeSource.myRevision1;
                SVNURL tmpURL = mergeSource.myURL1;
                mergeSource.myRevision1 = mergeSource.myRevision2;
                mergeSource.myURL1 = mergeSource.myURL2;
                mergeSource.myRevision2 = tmpRev;
                mergeSource.myURL2 = tmpURL;
            }
            mergeSources.add(mergeSource);
        }
        if (subtractive && !mergeSources.isEmpty()) {
            Collections.sort(mergeSources, new Comparator(){

                public int compare(Object o1, Object o2) {
                    long src2Rev1;
                    MergeSource source1 = (MergeSource)o1;
                    MergeSource source2 = (MergeSource)o2;
                    long src1Rev1 = source1.myRevision1;
                    if (src1Rev1 == (src2Rev1 = source2.myRevision1)) {
                        return 0;
                    }
                    return src1Rev1 < src2Rev1 ? 1 : -1;
                }
            });
        }
        return mergeSources;
    }

    private SVNLocationEntry getYoungestCommonAncestor(File path1, SVNURL url1, long revision1, File path2, SVNURL url2, long revision2) throws SVNException {
        Map history1 = this.getHistoryAsMergeInfo(url1, path1, SVNRevision.create(revision1), -1L, -1L, null, null);
        Map history2 = this.getHistoryAsMergeInfo(url2, path2, SVNRevision.create(revision2), -1L, -1L, null, null);
        long youngestCommonRevision = -1L;
        String youngestCommonPath = null;
        Iterator historyIter = history1.entrySet().iterator();
        while (historyIter.hasNext()) {
            SVNMergeRangeList commonList;
            Map.Entry historyEntry = historyIter.next();
            String path = (String)historyEntry.getKey();
            SVNMergeRangeList ranges1 = (SVNMergeRangeList)historyEntry.getValue();
            SVNMergeRangeList ranges2 = (SVNMergeRangeList)history2.get(path);
            if (ranges2 == null || (commonList = ranges2.intersect(ranges1, true)).isEmpty()) continue;
            SVNMergeRange[] commonRanges = commonList.getRanges();
            SVNMergeRange youngestCommonRange = commonRanges[commonRanges.length - 1];
            if (SVNRevision.isValidRevisionNumber(youngestCommonRevision) && youngestCommonRange.getEndRevision() <= youngestCommonRevision) continue;
            youngestCommonRevision = youngestCommonRange.getEndRevision();
            youngestCommonPath = path;
        }
        return new SVNLocationEntry(youngestCommonRevision, youngestCommonPath);
    }

    protected Map[] getFullMergeInfo(SVNEntry entry, boolean[] indirect, SVNMergeInfoInheritance inherit, SVNRepository repos, File target, long start, long end) throws SVNException {
        Map[] result = new Map[2];
        if (!SVNRevision.isValidRevisionNumber(start) || !SVNRevision.isValidRevisionNumber(end) || start <= end) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "ASSERTION FAILED in SVNMergeDriver.getFullMergeInfo()");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        result[0] = this.getWCOrRepositoryMergeInfo(target, entry, inherit, indirect, false, repos);
        long[] targetRev = new long[]{-1L};
        SVNURL url = this.deriveLocation(target, null, targetRev, SVNRevision.WORKING, repos, this.myWCAccess);
        if (targetRev[0] <= end) {
            result[1] = new TreeMap();
            return result;
        }
        Map implicitMergeInfo = this.calculateImplicitMergeInfo(repos, url, targetRev, start, end);
        if (implicitMergeInfo != null) {
            result[1] = implicitMergeInfo;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map calculateImplicitMergeInfo(SVNRepository repos, SVNURL url, long[] targetRev, long start, long end) throws SVNException {
        Map implicitMergeInfo = null;
        boolean closeSession = false;
        SVNURL sessionURL = null;
        try {
            if (repos != null) {
                sessionURL = this.ensureSessionURL(repos, url);
            } else {
                repos = this.createRepository(url, null, null, false);
                closeSession = true;
            }
            if (targetRev[0] < start) {
                this.getLocations(url, null, repos, SVNRevision.create(targetRev[0]), SVNRevision.create(start), SVNRevision.UNDEFINED);
                targetRev[0] = start;
            }
            implicitMergeInfo = this.getHistoryAsMergeInfo(url, null, SVNRevision.create(targetRev[0]), start, end, repos, null);
            if (sessionURL != null) {
                repos.setLocation(sessionURL, false);
            }
        }
        finally {
            if (closeSession) {
                repos.closeSession();
            }
        }
        return implicitMergeInfo;
    }

    private int findNearestAncestor(Object[] childrenWithMergeInfoArray, boolean pathIsOwnAncestor, File path) {
        if (childrenWithMergeInfoArray == null) {
            return 0;
        }
        int ancestorIndex = 0;
        for (int i = 0; i < childrenWithMergeInfoArray.length; ++i) {
            String pathStr;
            MergePath child = (MergePath)childrenWithMergeInfoArray[i];
            String childPath = child.myPath.getAbsolutePath().replace(File.separatorChar, '/');
            if (!SVNPathUtil.isAncestor(childPath, pathStr = path.getAbsolutePath().replace(File.separatorChar, '/')) || childPath.equals(pathStr) && !pathIsOwnAncestor) continue;
            ancestorIndex = i;
        }
        return ancestorIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getHistoryAsMergeInfo(SVNURL url, File path, SVNRevision pegRevision, long rangeYoungest, long rangeOldest, SVNRepository repos, SVNWCAccess access) throws SVNException {
        long[] pegRevNum = new long[]{-1L};
        url = this.deriveLocation(path, url, pegRevNum, pegRevision, repos, access);
        boolean closeSession = false;
        try {
            if (repos == null) {
                repos = this.createRepository(url, null, null, false);
                closeSession = true;
            }
            if (!SVNRevision.isValidRevisionNumber(rangeYoungest)) {
                rangeYoungest = pegRevNum[0];
            }
            if (!SVNRevision.isValidRevisionNumber(rangeOldest)) {
                rangeOldest = 0L;
            }
            List segments = repos.getLocationSegments("", pegRevNum[0], rangeYoungest, rangeOldest);
            Map map = this.getMergeInfoFromSegments(segments);
            return map;
        }
        finally {
            if (closeSession) {
                repos.closeSession();
            }
        }
    }

    private Map getMergeInfoFromSegments(Collection segments) {
        LinkedList<SVNMergeRange> pathRanges;
        TreeMap mergeInfo = new TreeMap();
        Iterator segmentsIter = segments.iterator();
        while (segmentsIter.hasNext()) {
            SVNLocationSegment segment = (SVNLocationSegment)segmentsIter.next();
            if (segment.getPath() == null) continue;
            String sourcePath = segment.getPath();
            pathRanges = (LinkedList<SVNMergeRange>)mergeInfo.get(sourcePath);
            if (pathRanges == null) {
                pathRanges = new LinkedList<SVNMergeRange>();
                mergeInfo.put(sourcePath, pathRanges);
            }
            SVNMergeRange range = new SVNMergeRange(Math.max(segment.getStartRevision() - 1L, 0L), segment.getEndRevision(), true);
            pathRanges.add(range);
        }
        TreeMap<String, SVNMergeRangeList> result = new TreeMap<String, SVNMergeRangeList>();
        Iterator paths = mergeInfo.keySet().iterator();
        while (paths.hasNext()) {
            String path = (String)paths.next();
            pathRanges = (Collection)mergeInfo.get(path);
            result.put(path, SVNMergeRangeList.fromCollection(pathRanges));
        }
        return result;
    }

    private void removeAbsentChildren(File targetWCPath, List childrenWithMergeInfo) {
        Iterator children = childrenWithMergeInfo.iterator();
        while (children.hasNext()) {
            MergePath child = (MergePath)children.next();
            String topDir = targetWCPath.getAbsolutePath().replace(File.separatorChar, '/');
            String childPath = child.myPath.getAbsolutePath().replace(File.separatorChar, '/');
            if (child == null || !child.myIsAbsent && !child.myIsScheduledForDeletion || !SVNPathUtil.isAncestor(topDir, childPath)) continue;
            if (this.mySkippedPaths != null) {
                this.mySkippedPaths.remove(child.myPath);
            }
            children.remove();
        }
    }

    private void removeFirstRangeFromRemainingRanges(long endRevision, List childrenWithMergeInfo) {
        Iterator children = childrenWithMergeInfo.iterator();
        while (children.hasNext()) {
            SVNMergeRange[] originalRemainingRanges;
            SVNMergeRange firstRange;
            MergePath child = (MergePath)children.next();
            if (child == null || child.myIsAbsent || child.myRemainingRanges.isEmpty() || (firstRange = (originalRemainingRanges = child.myRemainingRanges.getRanges())[0]).getEndRevision() != endRevision) continue;
            SVNMergeRange[] remainingRanges = new SVNMergeRange[originalRemainingRanges.length - 1];
            System.arraycopy(originalRemainingRanges, 1, remainingRanges, 0, originalRemainingRanges.length - 1);
            child.myRemainingRanges = new SVNMergeRangeList(remainingRanges);
        }
    }

    private SVNMergeRangeList removeNoOpMergeRanges(SVNRepository repository, SVNMergeRangeList ranges) throws SVNException {
        long oldestRev = -1L;
        long youngestRev = -1L;
        SVNMergeRange[] mergeRanges = ranges.getRanges();
        for (int i = 0; i < ranges.getSize(); ++i) {
            SVNMergeRange range = mergeRanges[i];
            long maxRev = Math.max(range.getStartRevision(), range.getEndRevision());
            long minRev = Math.min(range.getStartRevision(), range.getEndRevision());
            if (!SVNRevision.isValidRevisionNumber(youngestRev) || maxRev > youngestRev) {
                youngestRev = maxRev;
            }
            if (SVNRevision.isValidRevisionNumber(oldestRev) && minRev >= oldestRev) continue;
            oldestRev = minRev;
        }
        final LinkedList changedRevs = new LinkedList();
        repository.log(new String[]{""}, youngestRev, oldestRev, false, false, 0L, false, new String[0], new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                changedRevs.add(new Long(logEntry.getRevision()));
            }
        });
        long youngestChangedRevision = -1L;
        long oldestChangedRevision = -1L;
        if (changedRevs.size() > 0) {
            youngestChangedRevision = (Long)changedRevs.get(0);
            oldestChangedRevision = (Long)changedRevs.get(changedRevs.size() - 1);
        }
        LinkedList<SVNMergeRange> operativeRanges = new LinkedList<SVNMergeRange>();
        block1: for (int i = 0; i < ranges.getSize(); ++i) {
            SVNMergeRange range = mergeRanges[i];
            long rangeMinRev = Math.min(range.getStartRevision(), range.getEndRevision()) + 1L;
            long rangeMaxRev = Math.max(range.getStartRevision(), range.getEndRevision());
            if (rangeMinRev > youngestChangedRevision || rangeMaxRev < oldestChangedRevision) continue;
            Iterator changedRevsIter = changedRevs.iterator();
            while (changedRevsIter.hasNext()) {
                long changedRev = (Long)changedRevsIter.next();
                if (changedRev < rangeMinRev || changedRev > rangeMaxRev) continue;
                operativeRanges.add(range);
                continue block1;
            }
        }
        return SVNMergeRangeList.fromCollection(operativeRanges);
    }

    private SVNMergeRangeList filterNaturalHistoryFromMergeInfo(String srcPath, Map implicitMergeInfo, SVNMergeRange requestedRange) {
        SVNMergeRangeList impliedRangeList;
        SVNMergeRangeList requestedRangeList = new SVNMergeRangeList(requestedRange.dup());
        SVNMergeRangeList filteredRangeList = null;
        if (implicitMergeInfo != null && requestedRange.getStartRevision() < requestedRange.getEndRevision() && (impliedRangeList = (SVNMergeRangeList)implicitMergeInfo.get(srcPath)) != null) {
            filteredRangeList = requestedRangeList.diff(impliedRangeList, false);
        }
        if (filteredRangeList == null) {
            filteredRangeList = requestedRangeList;
        }
        return filteredRangeList;
    }

    private void sliceRemainingRanges(List childrenWithMergeInfo, boolean isRollBack, long endRevision) {
        Iterator children = childrenWithMergeInfo.iterator();
        while (children.hasNext()) {
            MergePath child = (MergePath)children.next();
            if (child == null || child.myIsAbsent || child.myRemainingRanges.isEmpty()) continue;
            SVNMergeRange[] originalRemainingRanges = child.myRemainingRanges.getRanges();
            SVNMergeRange range = originalRemainingRanges[0];
            if ((!isRollBack || range.getStartRevision() <= endRevision || range.getEndRevision() >= endRevision) && (isRollBack || range.getStartRevision() >= endRevision || range.getEndRevision() <= endRevision)) continue;
            SVNMergeRange splitRange1 = new SVNMergeRange(range.getStartRevision(), endRevision, range.isInheritable());
            SVNMergeRange splitRange2 = new SVNMergeRange(endRevision, range.getEndRevision(), range.isInheritable());
            SVNMergeRange[] remainingRanges = new SVNMergeRange[originalRemainingRanges.length + 1];
            remainingRanges[0] = splitRange1;
            remainingRanges[1] = splitRange2;
            System.arraycopy(originalRemainingRanges, 1, remainingRanges, 2, originalRemainingRanges.length - 1);
            child.myRemainingRanges = new SVNMergeRangeList(remainingRanges);
        }
    }

    private long getMostInclusiveEndRevision(List childrenWithMergeInfo, boolean isRollBack) {
        long endRev = -1L;
        for (int i = 0; i < childrenWithMergeInfo.size(); ++i) {
            MergePath child = (MergePath)childrenWithMergeInfo.get(i);
            if (child == null || child.myIsAbsent || child.myRemainingRanges.getSize() <= 0) continue;
            SVNMergeRange[] ranges = child.myRemainingRanges.getRanges();
            SVNMergeRange range = ranges[0];
            if (SVNRevision.isValidRevisionNumber(endRev) && (!isRollBack || range.getEndRevision() <= endRev) && (isRollBack || range.getEndRevision() >= endRev)) continue;
            endRev = range.getEndRevision();
        }
        return endRev;
    }

    private long getMostInclusiveStartRevision(List childrenWithMergeInfo, boolean isRollBack) {
        long startRev = -1L;
        for (int i = 0; i < childrenWithMergeInfo.size(); ++i) {
            MergePath child = (MergePath)childrenWithMergeInfo.get(i);
            if (child == null || child.myIsAbsent || child.myRemainingRanges.isEmpty()) continue;
            SVNMergeRange[] ranges = child.myRemainingRanges.getRanges();
            SVNMergeRange range = ranges[0];
            if (i == 0 && range.getStartRevision() == range.getEndRevision() || SVNRevision.isValidRevisionNumber(startRev) && (!isRollBack || range.getStartRevision() <= startRev) && (isRollBack || range.getStartRevision() >= startRev)) continue;
            startRev = range.getStartRevision();
        }
        return startRev;
    }

    private void populateRemainingRanges(List childrenWithMergeInfo, SVNURL sourceRootURL, SVNURL url1, long revision1, SVNURL url2, long revision2, boolean honorMergeInfo, SVNRepository repository, String parentMergeSrcCanonPath) throws SVNException {
        if (!honorMergeInfo || this.myIsRecordOnly) {
            ListIterator childrenIter = childrenWithMergeInfo.listIterator();
            while (childrenIter.hasNext()) {
                MergePath child = (MergePath)childrenIter.next();
                SVNMergeRange range = new SVNMergeRange(revision1, revision2, true);
                child.myRemainingRanges = new SVNMergeRangeList(range);
            }
            return;
        }
        long[] gap = new long[2];
        this.findGapsInMergeSourceHistory(gap, parentMergeSrcCanonPath, url1, revision1, url2, revision2, repository);
        if (gap[0] >= 0L && gap[1] >= 0L) {
            this.myImplicitSrcGap = new SVNMergeRangeList(gap[0], gap[1], true);
        }
        int index = 0;
        ListIterator childrenIter = childrenWithMergeInfo.listIterator();
        while (childrenIter.hasNext()) {
            Object[] childrenWithMergeInfoArray;
            int parentIndex;
            MergePath child = (MergePath)childrenIter.next();
            if (child == null || child.myIsAbsent) {
                ++index;
                continue;
            }
            String childRelativePath = null;
            childRelativePath = this.myTarget.equals(child.myPath) ? "" : SVNPathUtil.getRelativePath(this.myTarget.getAbsolutePath(), child.myPath.getAbsolutePath());
            MergePath parent = null;
            SVNURL childURL1 = url1.appendPath(childRelativePath, false);
            SVNURL childURL2 = url2.appendPath(childRelativePath, false);
            SVNEntry childEntry = this.myWCAccess.getVersionedEntry(child.myPath, false);
            boolean[] indirect = new boolean[]{false};
            Map[] mergeInfo = this.getFullMergeInfo(childEntry, indirect, SVNMergeInfoInheritance.INHERITED, repository, child.myPath, Math.max(revision1, revision2), Math.min(revision1, revision2));
            child.myPreMergeMergeInfo = mergeInfo[0];
            child.myImplicitMergeInfo = mergeInfo[1];
            child.myIsIndirectMergeInfo = indirect[0];
            if (index > 0 && (parentIndex = this.findNearestAncestor(childrenWithMergeInfoArray = childrenWithMergeInfo.toArray(), false, child.myPath)) >= 0 && parentIndex < childrenWithMergeInfoArray.length) {
                parent = (MergePath)childrenWithMergeInfoArray[parentIndex];
            }
            this.calculateRemainingRanges(parent, child, sourceRootURL, childURL1, revision1, childURL2, revision2, child.myPreMergeMergeInfo, child.myImplicitMergeInfo, this.myImplicitSrcGap, index > 0, childEntry, repository);
            if (child.myRemainingRanges.getSize() > 0 && this.myImplicitSrcGap != null) {
                boolean properSubset = false;
                boolean equals = false;
                boolean overlapsOrAdjoins = false;
                if (revision1 > revision2) {
                    child.myRemainingRanges.reverse();
                }
                for (int j = 0; j < child.myRemainingRanges.getSize(); ++j) {
                    long start = child.myRemainingRanges.getRanges()[j].getStartRevision();
                    long end = child.myRemainingRanges.getRanges()[j].getEndRevision();
                    if (start <= gap[0] && gap[1] < end || start < gap[0] && gap[1] <= end) {
                        properSubset = true;
                        break;
                    }
                    if (gap[0] == start && gap[1] == end) {
                        equals = true;
                        break;
                    }
                    if (gap[0] > end || start > gap[1]) continue;
                    overlapsOrAdjoins = true;
                    break;
                }
                if (!properSubset) {
                    if (overlapsOrAdjoins) {
                        child.myRemainingRanges = child.myRemainingRanges.merge(this.myImplicitSrcGap);
                    } else if (equals) {
                        child.myRemainingRanges = child.myRemainingRanges.diff(this.myImplicitSrcGap, false);
                    }
                }
                if (revision1 > revision2) {
                    child.myRemainingRanges.reverse();
                }
            }
            ++index;
        }
        if (childrenWithMergeInfo.size() > 1) {
            MergePath child = (MergePath)childrenWithMergeInfo.get(0);
            if (child.myRemainingRanges.isEmpty()) {
                SVNMergeRange dummyRange = new SVNMergeRange(revision2, revision2, true);
                child.myRemainingRanges = new SVNMergeRangeList(dummyRange);
                this.myIsTargetHasDummyMergeRange = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISVNReusableEditor driveMergeReportEditor(File targetWCPath, SVNURL url1, long revision1, SVNURL url2, final long revision2, final List childrenWithMergeInfo, final boolean isRollBack, SVNDepth depth, SVNAdminArea adminArea, SVNMergeCallback mergeCallback, ISVNReusableEditor editor) throws SVNException {
        block9: {
            final boolean honorMergeInfo = this.isHonorMergeInfo();
            long defaultStart = revision1;
            long targetStart = revision1;
            if (honorMergeInfo) {
                if (this.myIsTargetHasDummyMergeRange) {
                    targetStart = revision2;
                } else if (childrenWithMergeInfo != null && !childrenWithMergeInfo.isEmpty()) {
                    MergePath targetMergePath = (MergePath)childrenWithMergeInfo.get(0);
                    SVNMergeRangeList remainingRanges = targetMergePath.myRemainingRanges;
                    if (remainingRanges != null && !remainingRanges.isEmpty()) {
                        SVNMergeRange[] ranges = remainingRanges.getRanges();
                        SVNMergeRange range = ranges[0];
                        targetStart = !isRollBack && range.getStartRevision() > revision2 || isRollBack && range.getStartRevision() < revision2 ? revision2 : range.getStartRevision();
                    }
                }
            }
            editor = this.getMergeReportEditor(defaultStart, revision2, adminArea, depth, mergeCallback, editor);
            SVNURL oldURL = this.ensureSessionURL(this.myRepository2, url1);
            try {
                final SVNDepth reportDepth = depth;
                final long reportStart = targetStart;
                final String targetPath = targetWCPath.getAbsolutePath().replace(File.separatorChar, '/');
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "repository1 location: " + this.myRepository1.getLocation());
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "repository2 location: " + this.myRepository2.getLocation());
                this.myRepository1.diff(url2, revision2, revision2, null, this.myIsIgnoreAncestry, depth, true, new ISVNReporterBaton(){

                    public void report(ISVNReporter reporter) throws SVNException {
                        reporter.setPath("", null, reportStart, reportDepth, false);
                        if (honorMergeInfo && childrenWithMergeInfo != null) {
                            for (int i = 1; i < childrenWithMergeInfo.size(); ++i) {
                                MergePath childMergePath = (MergePath)childrenWithMergeInfo.get(i);
                                MergePath parent = null;
                                if (childMergePath == null || childMergePath.myIsAbsent) continue;
                                Object[] childrenWithMergeInfoArray = childrenWithMergeInfo.toArray();
                                int parentIndex = SVNMergeDriver.this.findNearestAncestor(childrenWithMergeInfoArray, false, childMergePath.myPath);
                                if (parentIndex >= 0 && parentIndex < childrenWithMergeInfoArray.length) {
                                    parent = (MergePath)childrenWithMergeInfoArray[parentIndex];
                                }
                                String parentPath = parent.myPath.getAbsolutePath().replace(File.separatorChar, '/');
                                boolean nearestParentIsTarget = parentPath.equals(targetPath);
                                SVNMergeRange range = null;
                                if (childMergePath.myRemainingRanges != null && !childMergePath.myRemainingRanges.isEmpty()) {
                                    SVNMergeRangeList remainingRangesList = childMergePath.myRemainingRanges;
                                    SVNMergeRange[] remainingRanges = remainingRangesList.getRanges();
                                    range = remainingRanges[0];
                                    if (!isRollBack && range.getStartRevision() > revision2 || isRollBack && range.getStartRevision() < revision2) continue;
                                    if (parent.myRemainingRanges != null && !parent.myRemainingRanges.isEmpty()) {
                                        SVNMergeRange parentRange = parent.myRemainingRanges.getRanges()[0];
                                        SVNMergeRange childRange = childMergePath.myRemainingRanges.getRanges()[0];
                                        if (parentRange.getStartRevision() == childRange.getStartRevision()) {
                                            continue;
                                        }
                                    }
                                } else if (parent.myRemainingRanges == null || parent.myRemainingRanges.isEmpty() || nearestParentIsTarget && SVNMergeDriver.this.myIsTargetHasDummyMergeRange) continue;
                                String childPath = childMergePath.myPath.getAbsolutePath();
                                String relChildPath = (childPath = childPath.replace(File.separatorChar, '/')).substring(targetPath.length());
                                if (relChildPath.startsWith("/")) {
                                    relChildPath = relChildPath.substring(1);
                                }
                                if (childMergePath.myRemainingRanges == null || childMergePath.myRemainingRanges.isEmpty() || isRollBack && range.getStartRevision() < revision2 || !isRollBack && range.getStartRevision() > revision2) {
                                    reporter.setPath(relChildPath, null, revision2, reportDepth, false);
                                    continue;
                                }
                                reporter.setPath(relChildPath, null, range.getStartRevision(), reportDepth, false);
                            }
                        }
                        reporter.finishReport();
                    }
                }, SVNCancellableEditor.newInstance(editor, this, this.getDebugLog()));
                Object var25_21 = null;
                if (oldURL == null) break block9;
            }
            catch (Throwable throwable) {
                Object var25_22 = null;
                if (oldURL != null) {
                    this.myRepository2.setLocation(oldURL, false);
                }
                editor.cleanup();
                throw throwable;
            }
            this.myRepository2.setLocation(oldURL, false);
        }
        editor.cleanup();
        this.sleepForTimeStamp();
        if (this.myConflictedPaths == null) {
            this.myConflictedPaths = mergeCallback.getConflictedPaths();
        }
        return editor;
    }

    public ISVNReusableEditor getMergeReportEditor(long defaultStart, long revision, SVNAdminArea adminArea, SVNDepth depth, AbstractDiffCallback mergeCallback, ISVNReusableEditor editor) throws SVNException {
        if (editor == null) {
            editor = new SVNRemoteDiffEditor(adminArea, adminArea.getRoot(), mergeCallback, this.myRepository2, defaultStart, revision, this.myIsDryRun, this, this);
        } else {
            editor.reset(defaultStart, revision);
        }
        return editor;
    }

    private SVNErrorMessage makeMergeConflictError(File targetPath, SVNMergeRange range) {
        SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "One or more conflicts were produced while merging r{0}:{1} into\n''{2}'' --\nresolve all conflicts and rerun the merge to apply the remaining\nunmerged revisions", new Object[]{Long.toString(range.getStartRevision()), Long.toString(range.getEndRevision()), targetPath});
        return error;
    }

    private List getMergeInfoPaths(List children, String mergeSrcPath, SVNEntry entry, SVNURL sourceRootURL, long revision1, long revision2, boolean honorMergeInfo, SVNRepository repository, SVNDepth depth) throws SVNException {
        List childrenWithMergeInfo = children == null ? new LinkedList() : children;
        ISVNEntryHandler handler = this.getMergeInfoEntryHandler(mergeSrcPath, sourceRootURL, revision1, revision2, repository, depth, childrenWithMergeInfo);
        if (entry.isFile()) {
            handler.handleEntry(this.myTarget, entry);
        } else {
            this.myWCAccess.walkEntries(this.myTarget, handler, true, honorMergeInfo ? depth : SVNDepth.EMPTY);
        }
        if (honorMergeInfo && SVNDepth.EMPTY.compareTo(depth) < 0) {
            Collections.sort(childrenWithMergeInfo);
            for (int i = 0; i < childrenWithMergeInfo.size(); ++i) {
                MergePath parent;
                MergePath child = (MergePath)childrenWithMergeInfo.get(i);
                if (child.myHasNonInheritableMergeInfo) {
                    SVNAdminArea childArea = this.myWCAccess.probeTry(child.myPath, true, -1);
                    Iterator entries = childArea.entries(false);
                    while (entries.hasNext()) {
                        SVNEntry childEntry2;
                        File childPath;
                        MergePath childOfNonInheritable;
                        SVNEntry childEntry = (SVNEntry)entries.next();
                        if (childArea.getThisDirName().equals(childEntry.getName()) || childrenWithMergeInfo.contains(childOfNonInheritable = new MergePath(childPath = childArea.getFile(childEntry.getName()))) || depth == SVNDepth.FILES && ((childEntry2 = this.myWCAccess.getEntry(childPath, false)) == null || !childEntry2.isFile())) continue;
                        childrenWithMergeInfo.add(childOfNonInheritable);
                        Collections.sort(childrenWithMergeInfo);
                        if (this.myIsDryRun || !this.myIsSameRepository) continue;
                        SVNEntry childOfNonInheritableEntry = this.myWCAccess.getVersionedEntry(childOfNonInheritable.myPath, false);
                        Map mergeInfo = this.getWCMergeInfo(childOfNonInheritable.myPath, childOfNonInheritableEntry, this.myTarget, SVNMergeInfoInheritance.NEAREST_ANCESTOR, false, new boolean[1]);
                        SVNPropertiesManager.recordWCMergeInfo(childPath, mergeInfo, this.myWCAccess);
                    }
                }
                if (!child.myIsAbsent && (!child.myIsSwitched || this.myTarget.equals(child.myPath))) continue;
                File parentPath = child.myPath.getParentFile();
                int parentInd = childrenWithMergeInfo.indexOf(new MergePath(parentPath));
                MergePath mergePath = parent = parentInd != -1 ? (MergePath)childrenWithMergeInfo.get(parentInd) : null;
                if (parent != null) {
                    parent.myHasMissingChildren = true;
                } else {
                    parent = new MergePath(parentPath);
                    parent.myHasMissingChildren = true;
                    childrenWithMergeInfo.add(parent);
                    Collections.sort(childrenWithMergeInfo);
                    ++i;
                }
                SVNAdminArea parentArea = this.myWCAccess.probeTry(parentPath, true, -1);
                Iterator siblings = parentArea.entries(false);
                while (siblings.hasNext()) {
                    SVNEntry childEntry;
                    File siblingPath;
                    MergePath siblingOfMissing;
                    SVNEntry siblingEntry = (SVNEntry)siblings.next();
                    if (parentArea.getThisDirName().equals(siblingEntry.getName()) || childrenWithMergeInfo.contains(siblingOfMissing = new MergePath(siblingPath = parentArea.getFile(siblingEntry.getName()))) || depth == SVNDepth.FILES && ((childEntry = this.myWCAccess.getEntry(siblingPath, false)) == null || !childEntry.isFile())) continue;
                    childrenWithMergeInfo.add(siblingOfMissing);
                    Collections.sort(childrenWithMergeInfo);
                }
            }
        }
        return childrenWithMergeInfo;
    }

    public ISVNEntryHandler getMergeInfoEntryHandler(String mergeSrcPath, SVNURL sourceRootURL, long revision1, long revision2, SVNRepository repository, SVNDepth depth, List childrenWithMergeInfo) {
        return new MergeInfoFetcher(depth, childrenWithMergeInfo);
    }

    private boolean notifySingleFileMerge(File targetWCPath, SVNEventAction action, SVNStatusType cstate, SVNStatusType pstate, SVNEvent headerEvent, boolean isHeaderSent) throws SVNException {
        action = cstate == SVNStatusType.MISSING ? SVNEventAction.SKIP : action;
        SVNEvent event = SVNEventFactory.createSVNEvent(targetWCPath, SVNNodeKind.FILE, null, -1L, cstate, pstate, SVNStatusType.LOCK_INAPPLICABLE, action, null, null, null);
        if (this.isOperativeNotification(event) && headerEvent != null && !isHeaderSent) {
            this.handleEvent(headerEvent, -1.0);
            isHeaderSent = true;
        }
        this.handleEvent(event, -1.0);
        return isHeaderSent;
    }

    private boolean isOperativeNotification(SVNEvent event) {
        return event.getContentsStatus() == SVNStatusType.CONFLICTED || event.getContentsStatus() == SVNStatusType.MERGED || event.getContentsStatus() == SVNStatusType.CHANGED || event.getPropertiesStatus() == SVNStatusType.CONFLICTED || event.getPropertiesStatus() == SVNStatusType.MERGED || event.getPropertiesStatus() == SVNStatusType.CHANGED || event.getAction() == SVNEventAction.UPDATE_ADD || event.getAction() == SVNEventAction.TREE_CONFLICT;
    }

    private void calculateMergeInheritance(SVNMergeRangeList rangeList, SVNEntry entry, boolean wcPathIsMergeTarget, boolean wcPathHasMissingChild, SVNDepth depth) {
        if (entry.isFile()) {
            rangeList.setInheritable(true);
        } else if (entry.isDirectory()) {
            if (wcPathIsMergeTarget) {
                if (wcPathHasMissingChild || depth == SVNDepth.FILES || depth == SVNDepth.EMPTY) {
                    rangeList.setInheritable(false);
                } else {
                    rangeList.setInheritable(true);
                }
            } else if (wcPathHasMissingChild || depth == SVNDepth.IMMEDIATES) {
                rangeList.setInheritable(false);
            } else {
                rangeList.setInheritable(true);
            }
        }
    }

    private void recordSkips(String mergeInfoPath, SVNEntry targetEntry, boolean isRollback) throws SVNException {
        int numberOfSkippedPaths;
        int n = numberOfSkippedPaths = this.mySkippedPaths != null ? this.mySkippedPaths.size() : 0;
        if (numberOfSkippedPaths > 0) {
            TreeMap<File, SVNMergeRangeList> merges = new TreeMap<File, SVNMergeRangeList>();
            Iterator skippedPaths = this.mySkippedPaths.iterator();
            while (skippedPaths.hasNext()) {
                File skippedPath = (File)skippedPaths.next();
                SVNStatus status = SVNStatusUtil.getStatus(skippedPath, this.myWCAccess);
                if (status.getContentsStatus() == SVNStatusType.STATUS_NONE || status.getContentsStatus() == SVNStatusType.STATUS_UNVERSIONED) continue;
                merges.put(skippedPath, new SVNMergeRangeList(new SVNMergeRange[0]));
            }
            this.updateWCMergeInfo(this.myTarget, mergeInfoPath, targetEntry, merges, isRollback);
        }
    }

    private void updateWCMergeInfo(File targetPath, String parentReposPath, SVNEntry entry, Map merges, boolean isRollBack) throws SVNException {
        Iterator mergesEntries = merges.entrySet().iterator();
        while (mergesEntries.hasNext()) {
            Map.Entry pathToRangeList = mergesEntries.next();
            File path = (File)pathToRangeList.getKey();
            SVNMergeRangeList ranges = (SVNMergeRangeList)pathToRangeList.getValue();
            Map<String, SVNMergeRangeList> mergeInfo = null;
            try {
                SVNEntry pathEntry = entry.getAdminArea().getWCAccess().getEntry(path, false);
                if (pathEntry != null && pathEntry.isDirectory()) {
                    pathEntry.getAdminArea().getWCAccess().retrieve(path);
                }
                mergeInfo = SVNPropertiesManager.parseMergeInfo(path, entry, false);
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) continue;
                throw svne;
            }
            if (mergeInfo == null && ranges.isEmpty()) {
                mergeInfo = this.getWCMergeInfo(path, entry, null, SVNMergeInfoInheritance.NEAREST_ANCESTOR, true, new boolean[1]);
            }
            if (mergeInfo == null) {
                mergeInfo = new TreeMap();
            }
            String parent = targetPath.getAbsolutePath();
            parent = parent.replace(File.separatorChar, '/');
            String child = path.getAbsolutePath();
            child = child.replace(File.separatorChar, '/');
            String reposPath = null;
            if (parent.length() < child.length()) {
                String childRelPath = child.substring(parent.length());
                if (childRelPath.startsWith("/")) {
                    childRelPath = childRelPath.substring(1);
                }
                reposPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(parentReposPath, childRelPath));
            } else {
                reposPath = parentReposPath;
            }
            SVNMergeRangeList rangeList = (SVNMergeRangeList)mergeInfo.get(reposPath);
            if (rangeList == null) {
                rangeList = new SVNMergeRangeList(new SVNMergeRange[0]);
            }
            if (isRollBack) {
                ranges = ranges.dup();
                ranges = ranges.reverse();
                rangeList = rangeList.diff(ranges, false);
            } else {
                rangeList = rangeList.merge(ranges);
            }
            mergeInfo.put(reposPath, rangeList);
            if (isRollBack && mergeInfo.isEmpty()) {
                mergeInfo = null;
            }
            SVNMergeInfoUtil.removeEmptyRangeLists(mergeInfo);
            try {
                SVNPropertiesManager.recordWCMergeInfo(path, mergeInfo, this.myWCAccess);
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() != SVNErrorCode.ENTRY_NOT_FOUND) {
                    throw svne;
                }
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, svne);
            }
        }
    }

    public void calculateRemainingRanges(MergePath parent, MergePath child, SVNURL sourceRootURL, SVNURL url1, long revision1, SVNURL url2, long revision2, Map targetMergeInfo, Map implicitMergeInfo, SVNMergeRangeList implicitSrcGap, boolean isSubtree, SVNEntry entry, SVNRepository repository) throws SVNException {
        block9: {
            SVNURL primaryURL = revision1 < revision2 ? url2 : url1;
            Map adjustedTargetMergeInfo = null;
            String mergeInfoPath = this.getPathRelativeToRoot(null, primaryURL, sourceRootURL, null, repository);
            if (implicitSrcGap != null && child.myPreMergeMergeInfo != null) {
                SVNMergeRangeList explicitMergeInfoGapRanges = (SVNMergeRangeList)child.myPreMergeMergeInfo.get(mergeInfoPath);
                if (explicitMergeInfoGapRanges != null) {
                    TreeMap<String, SVNMergeRangeList> gapMergeInfo = new TreeMap<String, SVNMergeRangeList>();
                    gapMergeInfo.put(mergeInfoPath, implicitSrcGap);
                    adjustedTargetMergeInfo = SVNMergeInfoUtil.removeMergeInfo(gapMergeInfo, targetMergeInfo, false);
                }
            } else {
                adjustedTargetMergeInfo = targetMergeInfo;
            }
            this.filterMergedRevisions(child, mergeInfoPath, adjustedTargetMergeInfo, implicitMergeInfo, revision1, revision2);
            if (isSubtree) {
                SVNMergeRangeList[] rangeListDiff = SVNMergeInfoUtil.diffMergeRangeLists(child.myRemainingRanges, parent.myRemainingRanges, true);
                SVNMergeRangeList deletedRangeList = rangeListDiff[0];
                SVNMergeRangeList addedRangeList = rangeListDiff[1];
                if (!deletedRangeList.isEmpty() || !addedRangeList.isEmpty()) {
                    this.adjustDeletedSubTreeRanges(child, parent, revision1, revision2, primaryURL, repository);
                }
            }
            if ((child.myRemainingRanges == null || child.myRemainingRanges.isEmpty()) && revision2 < revision1 && entry.getRevision() <= revision2) {
                SVNBasicClient.SVNRepositoryLocation[] locations = null;
                try {
                    locations = this.getLocations(url1, null, repository, SVNRevision.create(revision1), SVNRevision.create(entry.getRevision()), SVNRevision.UNDEFINED);
                    SVNURL startURL = locations[0].getURL();
                    if (startURL.equals(entry.getSVNURL())) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot reverse-merge a range from a path's own future history; try updating first");
                        SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    }
                }
                catch (SVNException svne) {
                    SVNErrorCode code = svne.getErrorMessage().getErrorCode();
                    if (code == SVNErrorCode.FS_NOT_FOUND || code == SVNErrorCode.RA_DAV_PATH_NOT_FOUND || code == SVNErrorCode.CLIENT_UNRELATED_RESOURCES) break block9;
                    throw svne;
                }
            }
        }
    }

    private void adjustDeletedSubTreeRanges(MergePath child, MergePath parent, long revision1, long revision2, SVNURL primaryURL, SVNRepository repository) throws SVNException {
        long pegRev;
        String relativePath;
        if (parent.myRemainingRanges == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Assertions failed: parent must already have non-null remaining ranges set");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((relativePath = this.getPathRelativeToRoot(null, primaryURL, repository.getLocation(), null, repository)).startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        boolean isRollback = revision2 < revision1;
        long youngerRev = pegRev = isRollback ? revision1 : revision2;
        long olderRev = isRollback ? revision2 : revision1;
        List locationSegments = null;
        try {
            locationSegments = repository.getLocationSegments(relativePath, pegRev, youngerRev, olderRev);
        }
        catch (SVNException e) {
            SVNErrorCode errCode = e.getErrorMessage().getErrorCode();
            if (errCode == SVNErrorCode.FS_NOT_FOUND || errCode == SVNErrorCode.RA_DAV_REQUEST_FAILED) {
                SVNNodeKind kind = repository.checkPath(relativePath, olderRev);
                if (kind == SVNNodeKind.NONE) {
                    child.myRemainingRanges = parent.myRemainingRanges.dup();
                } else {
                    long primaryURLDeletedRevision = repository.getDeletedRevision(relativePath, olderRev, youngerRev);
                    if (!SVNRevision.isValidRevisionNumber(primaryURLDeletedRevision)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Assertion failed: deleted revision must exist");
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    if (isRollback) {
                        child.myRemainingRanges = child.myRemainingRanges.reverse();
                        parent.myRemainingRanges = parent.myRemainingRanges.reverse();
                    }
                    SVNMergeRangeList existingRangeList = new SVNMergeRangeList(new SVNMergeRange(olderRev, primaryURLDeletedRevision - 1L, true));
                    child.myRemainingRanges = child.myRemainingRanges.intersect(existingRangeList, false);
                    SVNMergeRangeList deletedRangeList = new SVNMergeRangeList(new SVNMergeRange(primaryURLDeletedRevision - 1L, pegRev, true));
                    deletedRangeList = parent.myRemainingRanges.intersect(deletedRangeList, false);
                    child.myRemainingRanges = child.myRemainingRanges.merge(deletedRangeList);
                    if (isRollback) {
                        child.myRemainingRanges = child.myRemainingRanges.reverse();
                        parent.myRemainingRanges = parent.myRemainingRanges.reverse();
                    }
                }
            }
            throw e;
        }
        if (locationSegments != null && !locationSegments.isEmpty()) {
            SVNLocationSegment segment = (SVNLocationSegment)locationSegments.get(locationSegments.size() - 1);
            if (segment.getStartRevision() == olderRev) {
                return;
            }
            if (isRollback) {
                child.myRemainingRanges = child.myRemainingRanges.reverse();
                parent.myRemainingRanges = parent.myRemainingRanges.reverse();
            }
            SVNMergeRangeList existingRangeList = new SVNMergeRangeList(new SVNMergeRange(segment.getStartRevision(), pegRev, true));
            child.myRemainingRanges = child.myRemainingRanges.intersect(existingRangeList, false);
            SVNMergeRangeList nonExistentRangeList = new SVNMergeRangeList(new SVNMergeRange(olderRev, segment.getStartRevision(), true));
            nonExistentRangeList = parent.myRemainingRanges.intersect(nonExistentRangeList, false);
            child.myRemainingRanges = child.myRemainingRanges.merge(nonExistentRangeList);
            if (isRollback) {
                child.myRemainingRanges = child.myRemainingRanges.reverse();
                parent.myRemainingRanges = parent.myRemainingRanges.reverse();
            }
        }
    }

    private void filterMergedRevisions(MergePath child, String mergeInfoPath, Map targetMergeInfo, Map implicitMergeInfo, long rev1, long rev2) throws SVNException {
        Map mergeInfo = implicitMergeInfo;
        SVNMergeRangeList targetRangeList = null;
        if (rev1 > rev2) {
            if (targetMergeInfo != null) {
                mergeInfo = SVNMergeInfoUtil.dupMergeInfo(implicitMergeInfo, null);
                SVNMergeInfoUtil.mergeMergeInfos(mergeInfo, targetMergeInfo);
            }
            if ((targetRangeList = (SVNMergeRangeList)mergeInfo.get(mergeInfoPath)) != null) {
                SVNMergeRangeList requestedMergeRangeList = new SVNMergeRangeList(new SVNMergeRange(rev1, rev2, true));
                requestedMergeRangeList = requestedMergeRangeList.reverse();
                child.myRemainingRanges = targetRangeList.intersect(requestedMergeRangeList, false);
                child.myRemainingRanges = child.myRemainingRanges.reverse();
            } else {
                child.myRemainingRanges = new SVNMergeRangeList(new SVNMergeRange[0]);
            }
        } else {
            if (this.getOptions().isAllowAllForwardMergesFromSelf()) {
                if (targetMergeInfo != null) {
                    targetRangeList = (SVNMergeRangeList)targetMergeInfo.get(mergeInfoPath);
                }
            } else {
                if (targetMergeInfo != null) {
                    mergeInfo = SVNMergeInfoUtil.dupMergeInfo(implicitMergeInfo, null);
                    mergeInfo = SVNMergeInfoUtil.mergeMergeInfos(mergeInfo, targetMergeInfo);
                }
                targetRangeList = (SVNMergeRangeList)mergeInfo.get(mergeInfoPath);
            }
            if (targetRangeList != null) {
                SVNMergeRangeList requestedRangeList = new SVNMergeRangeList(new SVNMergeRange(rev1, rev2, true));
                child.myRemainingRanges = requestedRangeList.diff(targetRangeList, false);
            } else {
                child.myRemainingRanges = new SVNMergeRangeList(new SVNMergeRange(rev1, rev2, true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File loadFile(SVNRepository repository, long revision, SVNProperties properties, SVNAdminArea adminArea) throws SVNException {
        File tmpDir = adminArea.getAdminTempDirectory();
        File result = SVNFileUtil.createUniqueFile(tmpDir, ".merge", ".tmp", false);
        OutputStream os = null;
        try {
            os = SVNFileUtil.openFileForWriting(result);
            repository.getFile("", revision, properties, new SVNCancellableOutputStream(os, this));
        }
        finally {
            SVNFileUtil.closeFile(os);
        }
        return result;
    }

    private static SVNProperties computePropsDiff(SVNProperties props1, SVNProperties props2) {
        SVNProperties propsDiff = new SVNProperties();
        Iterator names = props2.nameSet().iterator();
        while (names.hasNext()) {
            String newPropName = (String)names.next();
            if (props1.containsName(newPropName)) {
                SVNPropertyValue oldValue = props2.getSVNPropertyValue(newPropName);
                if (oldValue.equals(props1.getSVNPropertyValue(newPropName))) continue;
                propsDiff.put(newPropName, props2.getSVNPropertyValue(newPropName));
                continue;
            }
            propsDiff.put(newPropName, props2.getSVNPropertyValue(newPropName));
        }
        names = props1.nameSet().iterator();
        while (names.hasNext()) {
            String oldPropName = (String)names.next();
            if (props2.containsName(oldPropName)) continue;
            propsDiff.put(oldPropName, (SVNPropertyValue)null);
        }
        return propsDiff;
    }

    private static SVNProperties filterProperties(SVNProperties props1, boolean leftRegular, boolean leftEntry, boolean leftWC) {
        SVNProperties result = new SVNProperties();
        Iterator names = props1.nameSet().iterator();
        while (names.hasNext()) {
            String propName = (String)names.next();
            if (!leftEntry && propName.startsWith("svn:entry:") || !leftWC && propName.startsWith("svn:wc:") || !leftRegular && !propName.startsWith("svn:entry:") && !propName.startsWith("svn:wc:")) continue;
            result.put(propName, props1.getSVNPropertyValue(propName));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class MergeInfoFetcher
    implements ISVNEntryHandler {
        private SVNDepth myDepth;
        private List myChildrenWithMergeInfo;

        protected MergeInfoFetcher(SVNDepth depth, List childrenWithMergeInfo) {
            this.myDepth = depth;
            this.myChildrenWithMergeInfo = childrenWithMergeInfo;
        }

        public MergeInfoFetcher() {
        }

        public void handleEntry(File path, SVNEntry entry) throws SVNException {
            File target = SVNMergeDriver.this.myTarget;
            SVNAdminArea adminArea = entry.getAdminArea();
            if (entry.isDirectory() && !adminArea.getThisDirName().equals(entry.getName()) && !entry.isAbsent()) {
                return;
            }
            if (entry.isDeleted()) {
                return;
            }
            boolean isSwitched = false;
            boolean hasMergeInfo = false;
            boolean pathIsMergeTarget = target.equals(path);
            String mergeInfoProp = null;
            if (entry.isAbsent() || entry.isScheduledForDeletion()) {
                mergeInfoProp = null;
                isSwitched = false;
            } else {
                SVNVersionedProperties props = adminArea.getProperties(entry.getName());
                mergeInfoProp = props.getStringPropertyValue("svn:mergeinfo");
                if (mergeInfoProp != null) {
                    hasMergeInfo = true;
                }
                isSwitched = SVNWCManager.isEntrySwitched(path, entry);
            }
            File parent = path.getParentFile();
            if (pathIsMergeTarget || hasMergeInfo || entry.isScheduledForDeletion() || isSwitched || entry.getDepth() == SVNDepth.EMPTY || entry.getDepth() == SVNDepth.FILES || entry.isAbsent() || this.myDepth == SVNDepth.IMMEDIATES && entry.isDirectory() && parent != null && !parent.equals(path) && parent.equals(target) || this.myDepth == SVNDepth.FILES && entry.isFile() && parent != null && parent.equals(target)) {
                boolean hasMissingChild = entry.getDepth() == SVNDepth.EMPTY || entry.getDepth() == SVNDepth.FILES || this.myDepth == SVNDepth.IMMEDIATES && entry.isDirectory() && parent != null && parent.equals(target);
                boolean hasNonInheritable = false;
                if (mergeInfoProp != null && mergeInfoProp.indexOf(SVNMergeRangeList.MERGE_INFO_NONINHERITABLE_STRING) != -1) {
                    hasNonInheritable = true;
                }
                if (!(hasNonInheritable || entry.getDepth() != SVNDepth.EMPTY && entry.getDepth() != SVNDepth.FILES)) {
                    hasNonInheritable = true;
                }
                MergePath child = new MergePath();
                child.myPath = path;
                child.myHasMissingChildren = hasMissingChild;
                child.myIsSwitched = isSwitched;
                child.myIsAbsent = entry.isAbsent();
                child.myIsScheduledForDeletion = entry.isScheduledForDeletion();
                child.myHasNonInheritableMergeInfo = hasNonInheritable;
                this.myChildrenWithMergeInfo.add(child);
            }
        }

        public void handleError(File path, SVNErrorMessage error) throws SVNException {
            while (error.hasChildErrorMessage()) {
                error = error.getChildErrorMessage();
            }
            if (error.getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND || error.getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                return;
            }
            SVNErrorManager.error(error, SVNLogType.DEFAULT);
        }
    }

    protected class SubTreeMergeInfoHandler
    implements ISVNEntryHandler {
        private File myTargetPath;
        private SVNURL myTargetReposRoot;
        private Collection mySubTreesWithMergeInfoPaths = new LinkedList();

        public SubTreeMergeInfoHandler(File targetPath, SVNURL targetReposRoot) {
            this.myTargetPath = targetPath;
            this.myTargetReposRoot = targetReposRoot;
        }

        public void handleEntry(File path, SVNEntry entry) throws SVNException {
            SVNAdminArea adminArea = entry.getAdminArea();
            if (entry.getKind() == SVNNodeKind.DIR && !adminArea.getThisDirName().equals(entry.getName()) && !entry.isAbsent()) {
                return;
            }
            SVNVersionedProperties props = adminArea.getProperties(entry.getName());
            String mergeInfoProp = props.getStringPropertyValue("svn:mergeinfo");
            if (mergeInfoProp != null || path.equals(this.myTargetPath)) {
                String storedPath = SVNMergeDriver.this.getPathRelativeToRoot(path, null, this.myTargetReposRoot, adminArea.getWCAccess(), null);
                this.mySubTreesWithMergeInfoPaths.add(storedPath);
            }
        }

        public void handleError(File path, SVNErrorMessage error) throws SVNException {
            while (error.hasChildErrorMessage()) {
                error = error.getChildErrorMessage();
            }
            if (error.getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND || error.getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                return;
            }
            SVNErrorManager.error(error, SVNLogType.DEFAULT);
        }

        public Collection getSubTreesWithMergeInfoPaths() {
            return this.mySubTreesWithMergeInfoPaths;
        }
    }

    private static class CopyFromReceiver
    implements ISVNLogEntryHandler {
        private String myTargetPath;
        private SVNLocationEntry myCopyFromLocation;

        public CopyFromReceiver(String targetPath) {
            this.myTargetPath = targetPath;
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            if (this.myCopyFromLocation != null) {
                return;
            }
            Map changedPaths = logEntry.getChangedPaths();
            if (changedPaths != null && !changedPaths.isEmpty()) {
                TreeMap sortedChangedPaths = new TreeMap(Collections.reverseOrder());
                sortedChangedPaths.putAll(changedPaths);
                Iterator changedPathsIter = sortedChangedPaths.keySet().iterator();
                while (changedPathsIter.hasNext()) {
                    String changedPath = (String)changedPathsIter.next();
                    SVNLogEntryPath logEntryPath = (SVNLogEntryPath)sortedChangedPaths.get(changedPath);
                    if (logEntryPath.getCopyPath() == null || !SVNRevision.isValidRevisionNumber(logEntryPath.getCopyRevision()) || !SVNPathUtil.isAncestor(changedPath, this.myTargetPath)) continue;
                    String copyFromPath = null;
                    if (changedPath.equals(this.myTargetPath)) {
                        copyFromPath = logEntryPath.getCopyPath();
                    } else {
                        String relPath = this.myTargetPath.substring(changedPath.length());
                        if (relPath.startsWith("/")) {
                            relPath = relPath.substring(1);
                        }
                        copyFromPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(logEntryPath.getCopyPath(), relPath));
                    }
                    this.myCopyFromLocation = new SVNLocationEntry(logEntryPath.getCopyRevision(), copyFromPath);
                    break;
                }
            }
        }

        public SVNLocationEntry getCopyFromLocation() {
            return this.myCopyFromLocation;
        }
    }

    private class LogHandlerFilter
    implements ISVNLogEntryHandler {
        ISVNLogEntryHandler myRealHandler;
        SVNMergeRangeList myRangeList;

        public LogHandlerFilter(ISVNLogEntryHandler handler, SVNMergeRangeList rangeList) {
            this.myRealHandler = handler;
            this.myRangeList = rangeList;
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            SVNMergeDriver.this.checkCancelled();
            SVNMergeRange range = new SVNMergeRange(logEntry.getRevision() - 1L, logEntry.getRevision(), true);
            SVNMergeRangeList thisRangeList = new SVNMergeRangeList(range);
            SVNMergeRangeList intersection = thisRangeList.intersect(this.myRangeList, true);
            if (intersection == null || intersection.isEmpty()) {
                return;
            }
            if (intersection.getSize() != 1) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "assertion failure in SVNMergeDriver.LogHandlerFilter.handleLogEntry: intersection list size is {0}", new Integer(intersection.getSize()));
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            if (this.myRealHandler != null) {
                this.myRealHandler.handleLogEntry(logEntry);
            }
        }
    }

    protected class MergePath
    implements Comparable {
        protected File myPath;
        protected boolean myHasMissingChildren;
        protected boolean myIsSwitched;
        protected boolean myHasNonInheritableMergeInfo;
        protected boolean myIsAbsent;
        protected boolean myIsIndirectMergeInfo;
        protected boolean myIsScheduledForDeletion;
        public SVNMergeRangeList myRemainingRanges;
        protected Map myPreMergeMergeInfo;
        protected Map myImplicitMergeInfo;

        public MergePath() {
        }

        public MergePath(File path) {
            this.myPath = path;
        }

        public int compareTo(Object obj) {
            if (obj == null || obj.getClass() != (class$org$tmatesoft$svn$core$internal$wc$SVNMergeDriver$MergePath == null ? (class$org$tmatesoft$svn$core$internal$wc$SVNMergeDriver$MergePath = SVNMergeDriver.class$("org.tmatesoft.svn.core.internal.wc.SVNMergeDriver$MergePath")) : class$org$tmatesoft$svn$core$internal$wc$SVNMergeDriver$MergePath)) {
                return -1;
            }
            MergePath mergePath = (MergePath)obj;
            if (this == mergePath) {
                return 0;
            }
            return this.myPath.compareTo(mergePath.myPath);
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public String toString() {
            return this.myPath.toString();
        }
    }

    protected static class MergeAction {
        public static final MergeAction MERGE = new MergeAction();
        public static final MergeAction ROLL_BACK = new MergeAction();
        public static final MergeAction NO_OP = new MergeAction();

        protected MergeAction() {
        }
    }

    protected class MergeSource {
        private SVNURL myURL1;
        private long myRevision1;
        private SVNURL myURL2;
        private long myRevision2;

        protected MergeSource() {
        }

        public SVNURL getURL1() {
            return this.myURL1;
        }

        public SVNURL getURL2() {
            return this.myURL2;
        }

        public long getRevision1() {
            return this.myRevision1;
        }

        public long getRevision2() {
            return this.myRevision2;
        }
    }
}

