/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxrs.glassfish.v3;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxrs.JaxRs;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

public class GlassFishV3EE6JaxRsStack
implements WSStackImplementation<JaxRs> {
    private static final String[] JAXRS_LIBRARIES = new String[]{"jackson", "jersey-gf-bundle", "jettison", "jsr311-api"};
    private static final String GFV3_MODULES_DIR_NAME = "modules";
    private String gfRootStr;
    private JaxRs jaxRs;

    public GlassFishV3EE6JaxRsStack(String gfRootStr) {
        this.gfRootStr = gfRootStr;
        this.jaxRs = new JaxRs();
    }

    public JaxRs get() {
        return this.jaxRs;
    }

    public WSStackVersion getVersion() {
        return WSStackVersion.valueOf((int)1, (int)1, (int)0, (int)0);
    }

    public WSTool getWSTool(WSStack.Tool toolId) {
        if (toolId == JaxRs.Tool.JAXRS) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxRsTool(JaxRs.Tool.JAXRS, JAXRS_LIBRARIES));
        }
        return null;
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        URL[] libs;
        WSTool wsTool;
        boolean isFeatureSupported = false;
        if (feature == JaxRs.Feature.JAXRS && (wsTool = this.getWSTool(JaxRs.Tool.JAXRS)) != null && (libs = wsTool.getLibraries()) != null && libs.length == JAXRS_LIBRARIES.length) {
            isFeatureSupported = true;
        }
        return isFeatureSupported;
    }

    private File getJarName(String glassfishInstallRoot, String jarNamePrefix) {
        File modulesDir = new File(glassfishInstallRoot + File.separatorChar + GFV3_MODULES_DIR_NAME);
        File[] candidates = modulesDir.listFiles(new VersionFilter(jarNamePrefix));
        if (candidates != null && candidates.length > 0) {
            return candidates[0];
        }
        return null;
    }

    protected class JaxRsTool
    implements WSToolImplementation {
        JaxRs.Tool tool;
        String[] libraries;

        JaxRsTool(JaxRs.Tool tool, String[] libraries) {
            this.tool = tool;
            this.libraries = libraries;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            ArrayList<URL> cPath = new ArrayList<URL>();
            for (String entry : this.libraries) {
                File f = GlassFishV3EE6JaxRsStack.this.getJarName(GlassFishV3EE6JaxRsStack.this.gfRootStr, entry);
                if (f == null || !f.exists()) continue;
                try {
                    cPath.add(f.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
            return cPath.toArray(new URL[cPath.size()]);
        }
    }

    private static class VersionFilter
    implements FileFilter {
        private String nameprefix;

        public VersionFilter(String nameprefix) {
            this.nameprefix = nameprefix;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().startsWith(this.nameprefix);
        }
    }
}

