/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.model.impl;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.modules.websvc.rest.model.api.SubResourceLocator;
import org.netbeans.modules.websvc.rest.model.impl.RestMethodDescriptionImpl;
import org.netbeans.modules.websvc.rest.model.impl.RestServicesImpl;
import org.netbeans.modules.websvc.rest.model.impl.Utils;

public class SubResourceLocatorImpl
extends RestMethodDescriptionImpl
implements SubResourceLocator {
    private String uriTemplate;
    private String resourceType;

    public SubResourceLocatorImpl(ExecutableElement methodElement) {
        super(methodElement);
        this.uriTemplate = Utils.getUriTemplate(methodElement);
    }

    @Override
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public RestServicesImpl.Status refresh(Element element) {
        boolean isModified = false;
        if (super.refresh(element) == RestServicesImpl.Status.MODIFIED) {
            isModified = true;
        }
        if (!Utils.hasUriTemplate(element)) {
            return RestServicesImpl.Status.REMOVED;
        }
        String newValue = Utils.getUriTemplate(element);
        if (!this.uriTemplate.equals(newValue)) {
            this.uriTemplate = newValue;
            isModified = true;
        }
        if (isModified) {
            return RestServicesImpl.Status.MODIFIED;
        }
        return RestServicesImpl.Status.UNMODIFIED;
    }
}

