/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;

public class MainProjectManager
implements ProjectActionPerformer,
PropertyChangeListener {
    public static final String PROP_MAIN_PROJECT = "mainProject";
    public static final String PROP_SELECTED_PROJECT = "selectedProject";
    private static MainProjectManager mainProjectManager = new MainProjectManager();
    private Action a;
    private Project currentProject;
    private Reference<Project> lastSelectedProjectRef = new WeakReference<Object>(null);
    private boolean isMainProject;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static MainProjectManager getDefault() {
        return mainProjectManager;
    }

    private MainProjectManager() {
        this.a = ProjectSensitiveActions.projectSensitiveAction((ProjectActionPerformer)this, (String)"x", null);
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.currentProject = OpenProjects.getDefault().getMainProject();
        this.isMainProject = this.currentProject != null;
        this.a.addPropertyChangeListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainProjectManager.this.a.isEnabled();
            }
        });
    }

    public synchronized Project getMainProject() {
        Project lastSelectedProject = this.lastSelectedProjectRef.get();
        if (this.isMainProject && lastSelectedProject != null && !MainProjectManager.isDependent(lastSelectedProject, this.currentProject)) {
            return lastSelectedProject;
        }
        return this.currentProject;
    }

    public void perform(Project p) {
        assert (false) : "Fake action should never really be called";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enable(Project p) {
        Project old = p;
        Project oldSelected = p;
        MainProjectManager mainProjectManager = this;
        synchronized (mainProjectManager) {
            if (this.isMainProject) {
                oldSelected = this.lastSelectedProjectRef.get();
            }
            this.lastSelectedProjectRef = new WeakReference<Project>(p);
            if (!this.isMainProject && this.currentProject != p) {
                old = this.currentProject;
                this.currentProject = p;
            }
        }
        if (old != p) {
            this.pcs.firePropertyChange(PROP_MAIN_PROJECT, old, p);
        }
        if (oldSelected != p) {
            this.pcs.firePropertyChange(PROP_SELECTED_PROJECT, oldSelected, p);
        }
        return true;
    }

    private static boolean isDependent(Project p1, Project p2) {
        Set<URL> p1Roots = MainProjectManager.getProjectRoots(p1);
        Set<URL> p2Roots = MainProjectManager.getProjectRoots(p2);
        for (URL root : p2Roots) {
            Set dependentRoots = SourceUtils.getDependentRoots((URL)root);
            for (URL sr : p1Roots) {
                if (!dependentRoots.contains(sr)) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<URL> getProjectRoots(Project p) {
        SourceGroup[] sgs;
        HashSet<URL> projectRoots = new HashSet<URL>();
        Sources sources = ProjectUtils.getSources((Project)p);
        for (SourceGroup sg : sgs = sources.getSourceGroups("java")) {
            try {
                URL root = sg.getRootFolder().getURL();
                projectRoots.add(root);
            }
            catch (FileStateInvalidException fsiex) {
            }
            catch (NullPointerException npe) {
                if (sg == null) {
                    npe = (NullPointerException)Exceptions.attachMessage((Throwable)npe, (String)("Null source group returned from " + sources + " of class " + sources.getClass()));
                } else if (sg.getRootFolder() == null) {
                    npe = (NullPointerException)Exceptions.attachMessage((Throwable)npe, (String)("Null root folder returned from " + sg + " of class " + sg.getClass()));
                }
                Exceptions.printStackTrace((Throwable)npe);
            }
        }
        return projectRoots;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("MainProject".equals(evt.getPropertyName())) {
            Project theMainProject;
            Project old = theMainProject = OpenProjects.getDefault().getMainProject();
            MainProjectManager mainProjectManager = this;
            synchronized (mainProjectManager) {
                this.isMainProject = theMainProject != null;
                old = this.currentProject;
                this.currentProject = this.isMainProject ? theMainProject : this.lastSelectedProjectRef.get();
            }
            if (old != theMainProject) {
                this.pcs.firePropertyChange(PROP_MAIN_PROJECT, old, theMainProject);
            }
        }
    }
}

