/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.marking;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.MethodMarker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation;
import org.netbeans.modules.profiler.categories.CustomMarker;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.filesystems.FileObject;

public abstract class BaseEJBMarkingProvider
extends CustomMarker {
    private MethodMarker delegate = new MethodMarker();
    private static Logger LOGGER = Logger.getLogger(BaseEJBMarkingProvider.class.getName());

    public BaseEJBMarkingProvider(Project project, Mark assignedMark) {
        super(project, assignedMark);
        this.addEjbMethods();
    }

    public MarkMapping[] getMappings() {
        return this.delegate.getMappings();
    }

    public Mark[] getMarks() {
        return this.delegate.getMarks();
    }

    protected abstract boolean isValid(ExecutableElement var1);

    private void addEjbMethods() {
        ClasspathInfo cpInfo = ProjectUtilities.getClasspathInfo((Project)this.getProject());
        final JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
        for (MetadataModel<EjbJarMetadata> mdModel : this.listAllMetadata()) {
            try {
                mdModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                    public Void run(EjbJarMetadata metadata) throws Exception {
                        Ejb[] ejbs;
                        StringBuilder stringBuilder = new StringBuilder().append(metadata.getRoot().getVersion().toString()).append(" = ");
                        metadata.getRoot();
                        System.out.println(stringBuilder.append("3.0").toString());
                        for (final Ejb ejb : ejbs = metadata.getRoot().getEnterpriseBeans().getEjbs()) {
                            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                                public void cancel() {
                                }

                                public void run(CompilationController controller) throws Exception {
                                    TypeElement type = controller.getElements().getTypeElement(ejb.getEjbClass());
                                    BaseEJBMarkingProvider.this.addTypeMethods(BaseEJBMarkingProvider.this.delegate, type, controller);
                                }
                            }, true);
                        }
                        return null;
                    }
                });
            }
            catch (MetadataModelException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private Set<MetadataModel<EjbJarMetadata>> listAllMetadata() {
        HashSet<MetadataModel<EjbJarMetadata>> metadata = new HashSet<MetadataModel<EjbJarMetadata>>();
        HashSet<Project> projects = new HashSet<Project>();
        projects.add(this.getProject());
        ProjectUtilities.fetchSubprojects((Project)this.getProject(), projects);
        for (Project testProject : projects) {
            EjbJarImplementation jar = (EjbJarImplementation)testProject.getLookup().lookup(EjbJarImplementation.class);
            if (jar == null) continue;
            metadata.add((MetadataModel<EjbJarMetadata>)jar.getMetadataModel());
        }
        return metadata;
    }

    private void addTypeMethods(MethodMarker marker, TypeElement type, CompilationController controller) {
        if (marker == null || type == null || this.getMark() == null || controller == null) {
            return;
        }
        try {
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            for (ExecutableElement method : ElementFilter.methodsIn(controller.getElements().getAllMembers(type))) {
                if (method.getKind() != ElementKind.METHOD || method.getModifiers().contains((Object)Modifier.ABSTRACT) || !this.isValid(method)) continue;
                try {
                    marker.addMethodMark(ElementUtilities.getBinaryName((TypeElement)type), method.getSimpleName().toString(), SourceUtils.getVMMethodSignature((ExecutableElement)method, (CompilationInfo)controller), this.getMark());
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            LOGGER.throwing(BaseEJBMarkingProvider.class.getName(), "addTypeMethods", e);
        }
    }
}

