/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util.usagetracking;

import java.io.IOException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.util.RequestProcessor;

public final class SunStudioUserCounter {
    private static final boolean SUNW_NO_UPDATE_NOTIFY;
    private static final RequestProcessor SS_USER_COUNT;
    private static IDEType appType;

    private SunStudioUserCounter() {
    }

    public static IDEType getIDEType() {
        if (appType == null) {
            String ide = System.getProperty("spro.ide.name");
            appType = "sside".equals(ide) ? IDEType.SUN_STUDIO_IDE : ("dlighttool".equals(ide) ? IDEType.DLIGHTTOOL : ("dbxtool".equals(ide) ? IDEType.DBX_TOOL : IDEType.CND));
        }
        return appType;
    }

    private static String getSunStudioBinDir(ExecutionEnvironment env) {
        if (env != null && env.isRemote()) {
            return null;
        }
        String ssBin = System.getProperty("spro.bin");
        if (ssBin == null) {
            ssBin = System.getProperty("spro.home");
            if (ssBin != null) {
                if (!ssBin.endsWith("/") && !ssBin.endsWith("\\")) {
                    ssBin = ssBin + "/";
                }
                ssBin = ssBin + "bin/";
            }
        } else {
            ssBin = ssBin + "/";
        }
        return ssBin;
    }

    private static String getCheckUpdatePath(String ssBinPath, ExecutionEnvironment env) {
        String checkUpdatePath = System.getProperty("spro.check_update");
        if (checkUpdatePath == null || ssBinPath != null && env.isRemote()) {
            String string = ssBinPath = ssBinPath == null ? SunStudioUserCounter.getSunStudioBinDir(env) : ssBinPath;
            if (ssBinPath != null) {
                if (!ssBinPath.endsWith("/") && !ssBinPath.endsWith("\\")) {
                    ssBinPath = ssBinPath + "/";
                }
                checkUpdatePath = ssBinPath + "../prod/bin/check_update";
            }
        }
        return checkUpdatePath;
    }

    public static void countIDE(String ssBaseDir, ExecutionEnvironment execEnv) {
        SunStudioUserCounter.countTool(SunStudioUserCounter.getCheckUpdatePath(ssBaseDir, execEnv), execEnv, SunStudioUserCounter.getIDEType().getTag());
    }

    public static void countDLight(ExecutionEnvironment execEnv) {
        ExecutionEnvironment localEnv;
        String localCheckUpdatePath;
        if (SUNW_NO_UPDATE_NOTIFY) {
            return;
        }
        String tool = SunStudioUserCounter.getIDEType() == IDEType.DLIGHTTOOL ? "dlight" : "dlightss";
        if (!execEnv.isLocal() && (localCheckUpdatePath = SunStudioUserCounter.getCheckUpdatePath(null, localEnv = ExecutionEnvironmentFactory.getLocal())) != null) {
            SunStudioUserCounter.countTool(localCheckUpdatePath, localEnv, tool);
            return;
        }
        SunStudioUserCounter.countTool(SunStudioUserCounter.getCheckUpdatePath(null, execEnv), execEnv, tool);
    }

    public static void countGizmo(String sprohome, ExecutionEnvironment execEnv) {
        String ssBin = null;
        if (sprohome != null) {
            ssBin = !sprohome.endsWith("/") && !sprohome.endsWith("\\") ? sprohome + "/bin/" : sprohome + "bin/";
        }
        SunStudioUserCounter.countTool(SunStudioUserCounter.getCheckUpdatePath(ssBin, execEnv), execEnv, "gizmo");
    }

    private static void countTool(final String checkUpdatePath, final ExecutionEnvironment execEnv, final String toolTag) {
        if (SUNW_NO_UPDATE_NOTIFY) {
            return;
        }
        if (checkUpdatePath == null || execEnv == null || toolTag == null) {
            return;
        }
        if (ConnectionManager.getInstance().isConnectedTo(execEnv)) {
            SS_USER_COUNT.post(new Runnable(){

                @Override
                public void run() {
                    NativeProcessBuilder nb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv).setExecutable(checkUpdatePath).setArguments(new String[]{toolTag});
                    try {
                        nb.call();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    static {
        SS_USER_COUNT = new RequestProcessor("SunStudio check_update");
        SUNW_NO_UPDATE_NOTIFY = System.getProperty("SUNW_NO_UPDATE_NOTIFY") != null;
        appType = null;
    }

    public static enum IDEType {
        CND("cnd"),
        SUN_STUDIO_IDE("ide"),
        DBX_TOOL("dbxtool"),
        DLIGHTTOOL("dlighttool");

        private final String tag;

        private IDEType(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

