/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jdesktop.application.ResourceConverter;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.swingapp.ActionManager;
import org.netbeans.modules.swingapp.ActionPropertyEditorPanel;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.DesignResourceMap;
import org.netbeans.modules.swingapp.DisabledEditorPanel;
import org.netbeans.modules.swingapp.JumpToOrCreateNewAction;
import org.netbeans.modules.swingapp.ProxyAction;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.netbeans.modules.swingapp.ResourceValueImpl;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ActionEditor
extends PropertyEditorSupport
implements FormAwareEditor,
XMLPropertyEditor,
ExPropertyEditor,
VetoableChangeListener {
    private List<String> actionNames = new ArrayList<String>();
    private FormModel formModel;
    private RADProperty formProperty;
    private RADComponent radComponent;
    private Map<ProxyAction.Scope, List<ProxyAction>> actionMap = new EnumMap<ProxyAction.Scope, List<ProxyAction>>(ProxyAction.Scope.class);
    private ActionPropertyEditorPanel panel;
    private ProxyAction action;
    private boolean scannedOnce = false;
    private FileObject sourceFile;
    private String GLOBAL_SUFFIX = "(global)";
    private static Action jumpToSourceAction;
    private static final String CODE_MARK_END = "*/\n\\0";
    private static final String CODE_MARK_LINE_COMMENT = "*/\n\\1";
    private static final String CODE_MARK_VARIABLE_SUBST = "*/\n\\2";
    private PropertyEnv env;

    public ActionEditor(FileObject sourceFile) {
        this();
        this.sourceFile = sourceFile;
    }

    public ActionEditor() {
    }

    @Override
    public String getJavaInitializationString() {
        if (!this.isAppFramework()) {
            return super.getJavaInitializationString();
        }
        return CODE_MARK_VARIABLE_SUBST + AppFrameworkSupport.getActionMapCode(this.getSourceFile()) + CODE_MARK_VARIABLE_SUBST + ActionMap.class.getName() + CODE_MARK_VARIABLE_SUBST + "actionMap" + CODE_MARK_LINE_COMMENT + "NOI18N" + CODE_MARK_END + ".get(\"" + this.action.getId() + "\")";
    }

    public void setContext(FormModel formModel, FormProperty property) {
        this.formModel = formModel;
        ActionManager.registerFormModel(formModel, this.getSourceFile());
        this.formProperty = (RADProperty)property;
        this.radComponent = this.formProperty.getRADComponent();
        FormEditor formEditor = FormEditor.getFormEditor((FormModel)formModel);
        if (formEditor != null) {
            if (jumpToSourceAction == null) {
                jumpToSourceAction = new JumpToOrCreateNewAction();
            }
            formEditor.registerDefaultComponentAction(jumpToSourceAction);
        }
    }

    public void updateFormVersionLevel() {
        this.formModel.raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
    }

    private String getComponentName() {
        if (this.radComponent == null) {
            return null;
        }
        return this.radComponent.getName();
    }

    @Override
    public Component getCustomEditor() {
        if (!this.isAppFramework()) {
            return new DisabledEditorPanel();
        }
        if (this.panel == null) {
            this.panel = new ActionPropertyEditorPanel((FormProperty)this.formProperty, this.getSourceFile());
            this.panel.addPropertyChangeListener("action", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ActionEditor.this.setValue(ActionEditor.this.panel.getSelectedAction());
                }
            });
        }
        FileObject srcFile = this.getSourceFile();
        EnumMap<ProxyAction.Scope, String> scopeMap = new EnumMap<ProxyAction.Scope, String>(ProxyAction.Scope.class);
        this.scanForActions();
        String appCls = AppFrameworkSupport.getApplicationClassName(srcFile);
        if (appCls != null) {
            scopeMap.put(ProxyAction.Scope.Application, AppFrameworkSupport.getApplicationClassName(srcFile));
        }
        scopeMap.put(ProxyAction.Scope.Form, AppFrameworkSupport.getClassNameForFile(srcFile));
        this.panel.resetFields();
        if (this.action != null) {
            ActionManager.initActionFromSource(this.action, this.sourceFile);
        }
        this.panel.updatePanel(this.actionMap, this.action, scopeMap, this.getComponentName(), srcFile);
        this.panel.setMode(ActionPropertyEditorPanel.Mode.Form);
        this.panel.attachEnv(this.env);
        return this.panel;
    }

    @Override
    public boolean supportsCustomEditor() {
        if (!this.isAppFramework()) {
            return super.supportsCustomEditor();
        }
        return true;
    }

    @Override
    public String getAsText() {
        if (!this.isAppFramework()) {
            return null;
        }
        if (this.action == null) {
            return "null";
        }
        return this.action.getId();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (!this.isAppFramework()) {
            return;
        }
        if ("null".equals(string)) {
            this.setValue(null);
            return;
        }
        for (List<ProxyAction> acts : this.actionMap.values()) {
            for (ProxyAction act : acts) {
                if (act == null) continue;
                if (act.getId().equals(string)) {
                    this.setValue(act);
                    return;
                }
                if (string == null || !string.endsWith(this.GLOBAL_SUFFIX) || !act.isAppWide()) continue;
                String shortname = string.substring(0, string.length() - this.GLOBAL_SUFFIX.length());
                if (!act.getId().equals(shortname)) continue;
                this.setValue(act);
                return;
            }
        }
        this.setValue(null);
    }

    @Override
    public Object getValue() {
        if (!this.isAppFramework()) {
            return super.getValue();
        }
        return this.action;
    }

    @Override
    public void setValue(Object object) {
        if (!this.isAppFramework()) {
            super.setValue(object);
            return;
        }
        if (object instanceof ProxyAction) {
            ProxyAction oldAction = this.action;
            this.action = (ProxyAction)object;
            ActionManager am = ActionManager.getActionManager(this.getSourceFile());
            this.action.setResourceMap(this.getResourceMapForAction(this.action));
            if (!ActionManager.actionsMatch(oldAction, this.action)) {
                if (oldAction != null) {
                    am.removeRADComponent(oldAction, this.radComponent);
                }
                am.addRADComponent(this.action, this.radComponent);
            }
        } else {
            ProxyAction oldAction = this.action;
            this.action = null;
            ActionManager.getActionManager(this.getSourceFile()).removeRADComponent(oldAction, this.radComponent);
        }
    }

    @Override
    public String[] getTags() {
        if (!this.isAppFramework()) {
            return null;
        }
        this.scanForActions();
        return this.actionNames.toArray(new String[0]);
    }

    private void scanForActions() {
        this.actionMap.clear();
        ArrayList<ProxyAction> appActions = new ArrayList<ProxyAction>();
        ArrayList<ProxyAction> formActions = new ArrayList<ProxyAction>();
        this.actionMap.put(ProxyAction.Scope.Application, appActions);
        this.actionMap.put(ProxyAction.Scope.Form, formActions);
        appActions.add(null);
        this.actionNames.clear();
        this.actionNames.add("null");
        List<ProxyAction> actions = this.getClassActions();
        for (ProxyAction act : actions) {
            act.setAppWide(false);
            formActions.add(act);
            this.actionNames.add(act.getId());
        }
        actions = this.getApplicationActions();
        for (ProxyAction act : actions) {
            act.setAppWide(true);
            appActions.add(act);
            this.actionNames.add(act.getId() + this.GLOBAL_SUFFIX);
        }
        this.scannedOnce = true;
    }

    private List<ProxyAction> getClassActions() {
        return ActionManager.getActions(this.getSourceFile(), !this.scannedOnce);
    }

    private List<ProxyAction> getApplicationActions() {
        String appClassName = AppFrameworkSupport.getApplicationClassName(this.getSourceFile());
        if (appClassName == null) {
            return Collections.emptyList();
        }
        FileObject appSourceFile = AppFrameworkSupport.getFileForClass(this.getSourceFile(), appClassName);
        return ActionManager.getActions(appSourceFile, !this.scannedOnce);
    }

    private FileObject getSourceFile() {
        if (this.sourceFile == null && this.formModel != null) {
            this.sourceFile = FormEditor.getFormDataObject((FormModel)this.formModel).getPrimaryFile();
        }
        return this.sourceFile;
    }

    private DesignResourceMap getResourceMapForAction(ProxyAction act) {
        FileObject actFile = AppFrameworkSupport.getFileForClass(this.getSourceFile(), act.getClassname());
        return ResourceUtils.getDesignResourceMap(actFile != null ? actFile : this.getSourceFile(), true);
    }

    public void readFromXML(Node element) throws IOException {
        if (element != null) {
            Element elem = (Element)element;
            if (elem.hasAttribute("id")) {
                FileObject srcFile = this.getSourceFile();
                String className = elem.getAttribute("class");
                String id = elem.getAttribute("id");
                String methodName = elem.getAttribute("methodName");
                if (methodName == null) {
                    methodName = id;
                }
                ProxyAction action = new ProxyAction(className, id, methodName);
                boolean appWide = !className.endsWith(srcFile.getName()) || className.length() != srcFile.getName().length() && className.charAt(className.length() - srcFile.getName().length() - 1) != '.';
                action.setAppWide(appWide);
                action.setResourceMap(this.getResourceMapForAction(action));
                action.loadFromResourceMap();
                this.setValue(action);
            } else {
                this.setValue(null);
            }
        }
    }

    public Node storeToXML(Document doc) {
        Element elem = doc.createElement("action");
        if (this.action != null) {
            elem.setAttribute("id", this.action.getId());
            elem.setAttribute("class", this.action.getClassname());
            elem.setAttribute("methodName", this.action.getMethodName());
        }
        return elem;
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
        env.removeVetoableChangeListener((VetoableChangeListener)this);
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addVetoableChangeListener((VetoableChangeListener)this);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (!this.isAppFramework()) {
            return;
        }
        if ("state".equals(evt.getPropertyName())) {
            try {
                this.confirmChanges(evt);
            }
            catch (IllegalArgumentException ex) {
                throw new PropertyVetoException(ex.getMessage(), evt);
            }
        }
    }

    void confirmChanges(PropertyChangeEvent evt) throws PropertyVetoException {
        ProxyAction act;
        if ("state".equals(evt.getPropertyName()) && !PropertyEnv.STATE_VALID.equals(evt.getNewValue())) {
            return;
        }
        if (this.panel.isNewActionCreated()) {
            if (!this.panel.canCreateNewAction()) {
                if (!this.panel.isMethodNonEmpty()) {
                    throw new PropertyVetoException(NbBundle.getMessage(ActionEditor.class, (String)"ActionEditor.createMethodError.emptyMethod"), evt);
                }
                if (this.panel.doesMethodContainBadChars()) {
                    throw new PropertyVetoException(NbBundle.getMessage(ActionEditor.class, (String)"ActionEditor.createMethodError.invalidName", (Object)this.panel.getNewMethodName()), evt);
                }
                if (!this.panel.isValidClassname()) {
                    throw new PropertyVetoException(NbBundle.getMessage(ActionEditor.class, (String)"ActionEditor.createMethodError.invalidClassname"), evt);
                }
                if (this.panel.isDuplicateMethod()) {
                    throw new PropertyVetoException(NbBundle.getMessage(ActionEditor.class, (String)"ActionEditor.createMethodError.duplicateMethod", (Object)this.panel.getNewMethodName()), evt);
                }
            }
            ProxyAction act2 = this.createNewAction();
            this.panel.setMode(ActionPropertyEditorPanel.Mode.Form);
            this.setValue(act2);
            this.scanForActions();
            ActionManager.getActionManager(this.getSourceFile()).jumpToActionSource(act2);
            return;
        }
        if (this.panel.getSelectedAction() == null) {
            this.setValue(null);
            return;
        }
        if (this.panel.isViewSource()) {
            act = this.panel.getSelectedAction();
            ActionManager.getActionManager(this.getSourceFile()).jumpToActionSource(act);
            this.panel.resetFields();
        }
        if (this.panel.isActionPropertiesUpdated()) {
            act = this.panel.getUpdatedAction();
            this.saveChangedActionProperties(act);
            this.panel.resetFields();
            FileObject actFile = AppFrameworkSupport.getFileForClass(this.getSourceFile(), act.getClassname());
            ActionManager.getActionManager(actFile != null ? actFile : this.getSourceFile()).updateAction(act);
            this.setValue(act);
        }
    }

    private void saveChangedActionProperties(ProxyAction action) {
        FileObject fileInProject = AppFrameworkSupport.getFileForClass(this.getSourceFile(), action.getClassname());
        if (fileInProject == null) {
            fileInProject = this.getSourceFile();
        }
        DesignResourceMap map = ResourceUtils.getDesignResourceMap(fileInProject, true);
        String actionKey = action.getId() + ".Action";
        this.updateOrDeleteResource(action, actionKey + ".text", "Name", fileInProject, map, String.class);
        this.updateOrDeleteResource(action, actionKey + ".shortDescription", "ShortDescription", fileInProject, map, String.class);
        if (action.getValue("SmallIcon") != null) {
            this.updateOrDeleteResource(action, actionKey + ".icon", "SmallIcon.IconName", fileInProject, map, Icon.class);
        } else {
            this.updateOrDeleteResource(action, actionKey + ".icon", "SwingLargeIconKey.IconName", fileInProject, map, Icon.class);
        }
        this.updateOrDeleteResource(action, actionKey + ".smallIcon", "SmallIcon.IconName", fileInProject, map, Icon.class);
        this.updateOrDeleteResource(action, actionKey + ".largeIcon", "SwingLargeIconKey.IconName", fileInProject, map, Icon.class);
        this.updateOrDeleteResource(action, actionKey + ".accelerator", "AcceleratorKey", fileInProject, map, KeyStroke.class);
        String blockPrefix = action.getId() + ".BlockingDialog.";
        this.updateOrDeleteResource(action, blockPrefix + "optionPane.message", "BlockingDialog.message", fileInProject, map, String.class);
        this.updateOrDeleteResource(action, blockPrefix + "title", "BlockingDialog.title", fileInProject, map, String.class);
        map.save();
    }

    private void updateOrDeleteResource(ProxyAction act, String key, String actionKey, FileObject fileInProject, DesignResourceMap map, Class type) {
        int level = 2;
        if (act.isAppWide()) {
            level = 0;
        }
        Object newVal = act.getValue(actionKey);
        if (act.getValue(actionKey) == null) {
            ResourceValueImpl val = map.getResourceValue(key, type);
            if (val != null) {
                map.removeResourceValue(val);
            }
            return;
        }
        String stringVal = null;
        if (newVal instanceof String) {
            if (Icon.class.equals((Object)type)) {
                String iconCPName = (String)newVal;
                String pkgResName = map.getResourcesDir();
                stringVal = iconCPName.startsWith(pkgResName) ? iconCPName.substring(pkgResName.length()) : iconCPName;
                newVal = null;
            } else {
                stringVal = (String)newVal;
            }
        } else {
            stringVal = String.class.equals((Object)type) ? "" + newVal : ResourceConverter.forType(type).toString(newVal);
        }
        ResourceValueImpl val = new ResourceValueImpl(key, type, newVal, null, stringVal, true, level, fileInProject);
        map.addResourceValue(val);
    }

    public ProxyAction createNewAction() {
        ProxyAction newAction = this.panel.getNewAction();
        boolean appWide = newAction.getClassname().equals(AppFrameworkSupport.getApplicationClassName(this.getSourceFile()));
        newAction.setAppWide(appWide);
        if (ActionManager.getActionManager(this.getSourceFile()).createActionMethod(newAction)) {
            ActionManager.getActionManager(this.getSourceFile()).addNewAction(newAction);
            this.saveChangedActionProperties(newAction);
        }
        return newAction;
    }

    private boolean isAppFramework() {
        return ActionManager.canHaveActions(this.getSourceFile());
    }
}

