/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.StandardColumns;
import org.netbeans.modules.dlight.dtrace.collector.DTraceEventData;
import org.netbeans.modules.dlight.dtrace.collector.DTraceOutputParser;
import org.netbeans.modules.dlight.dtrace.collector.support.LineParser;
import org.netbeans.modules.dlight.util.DLightLogger;

final class DataAndStacksParser
implements DTraceOutputParser {
    private static final Logger log = DLightLogger.getLogger(DataAndStacksParser.class);
    private final boolean isProfiling;
    private final LineParser lineParser;
    private final List<String> colNames;
    private List<Object> currData;
    private List<CharSequence> currStack;

    public DataAndStacksParser(DataTableMetadata tableMetadata) {
        assert (tableMetadata != null);
        this.isProfiling = tableMetadata.getName().equals("CallStack");
        ArrayList<DataTableMetadata.Column> columns = new ArrayList<DataTableMetadata.Column>(tableMetadata.getColumns());
        this.colNames = new ArrayList<String>(tableMetadata.getColumnNames());
        if (this.colNames.contains(StandardColumns.STACK_COLUMN.getColumnName())) {
            for (DataTableMetadata.Column column : columns) {
                if (!column.getColumnName().equals(StandardColumns.STACK_COLUMN.getColumnName())) continue;
                columns.remove(column);
                break;
            }
            this.colNames.remove(StandardColumns.STACK_COLUMN.getColumnName());
        }
        assert (columns.size() > 1);
        this.lineParser = new LineParser(columns);
    }

    @Override
    public DTraceEventData parse(String line) {
        String l = line.trim();
        if (l.isEmpty() || l.indexOf(32) > 0) {
            DTraceEventData result = null;
            if (this.currData != null) {
                if (this.currStack != null && this.currStack.size() > 0) {
                    result = new DTraceEventData(new DataRow(this.colNames, this.currData), this.currStack);
                    this.currStack = null;
                } else {
                    result = new DTraceEventData(new DataRow(this.colNames, this.currData));
                }
            }
            this.currData = l.isEmpty() ? null : this.lineParser.parse(l, log);
            return result;
        }
        if (this.currData == null) {
            return null;
        }
        if (this.currStack == null) {
            this.currStack = new ArrayList<CharSequence>(10);
        }
        if (this.isProfiling || !l.startsWith("libc.so.")) {
            this.currStack.add(l);
        }
        return null;
    }
}

