/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;

public class JavaUtils {
    public static String extractClassNameFromType(TypeMirror type) {
        Element elem;
        if (type instanceof DeclaredType && ((elem = ((DeclaredType)type).asElement()).getKind() == ElementKind.CLASS || elem.getKind() == ElementKind.INTERFACE)) {
            return ((TypeElement)elem).getQualifiedName().toString();
        }
        return null;
    }

    public static boolean hasAnnotation(Element element, String annClass) {
        AnnotationMirror annEntity = JavaUtils.findAnnotation(element, annClass);
        return annEntity != null;
    }

    public static AnnotationMirror findAnnotation(Element element, String annotationClass) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationClass.equals(annotationMirror.getAnnotationType().toString())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static AnnotationValue getAnnotationAttrValue(AnnotationMirror ann, String attrName) {
        if (ann != null) {
            for (ExecutableElement executableElement : ann.getElementValues().keySet()) {
                if (!attrName.equals(executableElement.getSimpleName().toString())) continue;
                return ann.getElementValues().get(executableElement);
            }
        }
        return null;
    }

    public static String getShortClassName(String qualifiedClassName) {
        return qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1);
    }

    public static boolean isMethodSignatureSame(CompilationInfo cinfo, ExecutableElement method1, ExecutableElement method2) {
        int paramCount = method1.getParameters().size();
        if (paramCount != method2.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < paramCount; ++i) {
            TypeMirror param1 = method1.getParameters().get(i).asType();
            TypeMirror param2 = method2.getParameters().get(i).asType();
            if (cinfo.getTypes().isSameType(param1, param2)) continue;
            return JavaUtils.isSameDeclaredType(param1, param2);
        }
        return true;
    }

    public static boolean isSameDeclaredType(TypeMirror param1, TypeMirror param2) {
        return JavaUtils.extractClassNameFromType(param1).equals(JavaUtils.extractClassNameFromType(param2));
    }
}

