/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.tests.SelectFilePanel;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GoToTest
implements TestLocator {
    private static final Logger LOGGER = Logger.getLogger(GoToTest.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(GoToTest.class.getName(), 2);

    public boolean appliesTo(FileObject fo) {
        return FileUtils.isPhpFile((FileObject)fo);
    }

    public boolean asynchronous() {
        return true;
    }

    public void findOpposite(final FileObject fo, int caretOffset, final TestLocator.LocationListener callback) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                callback.foundLocation(fo, GoToTest.this.findOpposite0(fo));
            }
        });
    }

    public TestLocator.LocationResult findOpposite(FileObject fo, int caretOffset) {
        throw new UnsupportedOperationException("Go To Test is asynchronous");
    }

    private TestLocator.LocationResult findOpposite0(FileObject fo) {
        PhpProject project = PhpProjectUtils.getPhpProject(fo);
        if (project == null) {
            LOGGER.log(Level.INFO, "PHP project was not found for file {0}", fo);
            return null;
        }
        if (CommandUtils.isUnderTests(project, fo, false)) {
            return this.findSource(project, fo);
        }
        if (CommandUtils.isUnderSources(project, fo)) {
            return GoToTest.findTest(project, fo);
        }
        return null;
    }

    public TestLocator.FileType getFileType(FileObject fo) {
        PhpProject project = PhpProjectUtils.getPhpProject(fo);
        if (project == null) {
            LOGGER.log(Level.INFO, "PHP project was not found for file {0}", fo);
            return TestLocator.FileType.NEITHER;
        }
        if (CommandUtils.isUnderTests(project, fo, false)) {
            if (PhpUnit.isTestOrSuiteFile(fo.getNameExt())) {
                return TestLocator.FileType.TEST;
            }
        } else if (CommandUtils.isUnderSources(project, fo)) {
            return TestLocator.FileType.TESTED;
        }
        return TestLocator.FileType.NEITHER;
    }

    private TestLocator.LocationResult findSource(PhpProject project, FileObject testFo) {
        return GoToTest.findFile(project, testFo, false);
    }

    public static TestLocator.LocationResult findTest(PhpProject project, FileObject srcFo) {
        return GoToTest.findFile(project, srcFo, true);
    }

    private static TestLocator.LocationResult findFile(PhpProject project, FileObject file, boolean searchTest) {
        FileObject sourceRoot;
        FileObject fileObject = sourceRoot = searchTest ? GoToTest.getTests(project) : GoToTest.getSources(project);
        if (sourceRoot == null) {
            return null;
        }
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        assert (editorSupport != null) : "Editor support must exist";
        TreeSet<Pair<FileObject, Integer>> phpFiles = new TreeSet<Pair<FileObject, Integer>>(new Comparator<Pair<FileObject, Integer>>(){

            @Override
            public int compare(Pair<FileObject, Integer> o1, Pair<FileObject, Integer> o2) {
                return ((FileObject)o1.first).getPath().compareTo(((FileObject)o2.first).getPath());
            }
        });
        for (PhpClass phpClass : editorSupport.getClasses(file)) {
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            if (searchTest) {
                arrayList.add(Pair.of((Object)PhpUnit.makeTestClass(phpClass.getName()), (Object)PhpUnit.makeTestClass(phpClass.getFullyQualifiedName())));
                arrayList.add(Pair.of((Object)PhpUnit.makeSuiteClass(phpClass.getName()), (Object)PhpUnit.makeSuiteClass(phpClass.getFullyQualifiedName())));
            } else {
                if (!PhpUnit.isTestOrSuiteClass(phpClass.getName())) continue;
                arrayList.add(Pair.of((Object)PhpUnit.getTestedClass(phpClass.getName()), (Object)PhpUnit.getTestedClass(phpClass.getFullyQualifiedName())));
            }
            for (Pair pair : arrayList) {
                Collection files = editorSupport.filesForClass(sourceRoot, new PhpClass((String)pair.first, (String)pair.second, -1));
                for (Pair pair2 : files) {
                    FileObject fileObject2 = (FileObject)pair2.first;
                    if (!FileUtils.isPhpFile((FileObject)fileObject2) || !FileUtil.isParentOf((FileObject)sourceRoot, (FileObject)fileObject2)) continue;
                    phpFiles.add((Pair<FileObject, Integer>)pair2);
                }
            }
        }
        if (phpFiles.isEmpty()) {
            return new TestLocator.LocationResult(NbBundle.getMessage(GoToTest.class, (String)(searchTest ? "MSG_TestNotFound" : "MSG_SrcNotFound"), (Object)file.getNameExt()));
        }
        if (phpFiles.size() == 1) {
            Pair source = (Pair)phpFiles.iterator().next();
            return new TestLocator.LocationResult((FileObject)source.first, ((Integer)source.second).intValue());
        }
        ArrayList<FileObject> files = new ArrayList<FileObject>(phpFiles.size());
        for (Pair pair : phpFiles) {
            files.add((FileObject)pair.first);
        }
        FileObject selected = SelectFilePanel.open(sourceRoot, files);
        if (selected != null) {
            int n;
            int n2 = -1;
            for (Pair pair : phpFiles) {
                if (!selected.equals(pair.first)) continue;
                n = (Integer)pair.second;
                break;
            }
            return new TestLocator.LocationResult(selected, n);
        }
        return null;
    }

    private static FileObject getSources(PhpProject project) {
        FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(project);
        assert (sources != null) : "Project sources must be found for " + project;
        return sources;
    }

    private static FileObject getTests(PhpProject project) {
        return ProjectPropertiesSupport.getTestDirectory(project, false);
    }
}

