/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.DebugScript;
import org.netbeans.modules.php.project.ui.actions.support.DefaultScriptProvider;
import org.netbeans.modules.php.project.ui.actions.support.RunScript;
import org.netbeans.modules.php.project.ui.actions.support.XDebugStarterFactory;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

class ConfigActionScript
extends ConfigAction {
    private final FileObject sourceRoot;

    protected ConfigActionScript(PhpProject project) {
        super(project);
        this.sourceRoot = ProjectPropertiesSupport.getSourcesDirectory(project);
        assert (this.sourceRoot != null);
    }

    @Override
    public boolean isValid(boolean indexFileNeeded) {
        boolean valid = true;
        if (indexFileNeeded && !this.isIndexFileValid(this.sourceRoot)) {
            valid = false;
        } else {
            try {
                if (RunAsValidator.validateScriptFields(ProjectPropertiesSupport.getPhpInterpreter(this.project).getProgram(), FileUtil.toFile((FileObject)this.sourceRoot), null, ProjectPropertiesSupport.getArguments(this.project), ProjectPropertiesSupport.getWorkDir(this.project), ProjectPropertiesSupport.getPhpArguments(this.project)) != null) {
                    valid = false;
                }
            }
            catch (PhpProgram.InvalidPhpProgramException ex) {
                valid = false;
            }
        }
        if (!valid) {
            this.showCustomizer();
        }
        return valid;
    }

    @Override
    public boolean isRunFileEnabled(Lookup context) {
        FileObject file = CommandUtils.fileForContextOrSelectedNodes(context, this.sourceRoot);
        return file != null && FileUtils.isPhpFile((FileObject)file);
    }

    @Override
    public boolean isDebugFileEnabled(Lookup context) {
        if (XDebugStarterFactory.getInstance() == null) {
            return false;
        }
        return this.isRunFileEnabled(context);
    }

    @Override
    public void runProject() {
        new RunScript(new ScriptProvider(this.getStartFile(null))).run();
    }

    @Override
    public void debugProject() {
        new DebugScript(new ScriptProvider(this.getStartFile(null))).run();
    }

    @Override
    public void runFile(Lookup context) {
        new RunScript(new ScriptProvider(this.getStartFile(context))).run();
    }

    @Override
    public void debugFile(Lookup context) {
        new DebugScript(new ScriptProvider(this.getStartFile(context))).run();
    }

    private File getStartFile(Lookup context) {
        FileObject file = null;
        file = context == null ? CommandUtils.fileForProject(this.project, this.sourceRoot) : CommandUtils.fileForContextOrSelectedNodes(context, this.sourceRoot);
        assert (file != null) : "Start file must be found";
        return FileUtil.toFile((FileObject)file);
    }

    private final class ScriptProvider
    extends DefaultScriptProvider
    implements DebugScript.Provider {
        public ScriptProvider(File file) {
            super(file);
        }

        @Override
        public PhpProject getProject() {
            return ConfigActionScript.this.project;
        }

        @Override
        public FileObject getStartFile() {
            assert (this.file != null);
            return FileUtil.toFileObject((File)this.file);
        }

        @Override
        public ExecutionDescriptor getDescriptor() throws IOException {
            assert (this.file != null);
            return super.getDescriptor().charset(Charset.forName(ProjectPropertiesSupport.getEncoding(ConfigActionScript.this.project)));
        }

        @Override
        public ExternalProcessBuilder getProcessBuilder() {
            String workDir;
            assert (this.file != null);
            ExternalProcessBuilder builder = this.program.getProcessBuilder();
            String phpArgs = ProjectPropertiesSupport.getPhpArguments(ConfigActionScript.this.project);
            if (StringUtils.hasText((String)phpArgs)) {
                for (String phpArg : Utilities.parseParameters((String)phpArgs)) {
                    builder = builder.addArgument(phpArg);
                }
            }
            builder = builder.addArgument(this.file.getAbsolutePath());
            String args = ProjectPropertiesSupport.getArguments(ConfigActionScript.this.project);
            if (StringUtils.hasText((String)args)) {
                for (String arg : Utilities.parseParameters((String)args)) {
                    builder = builder.addArgument(arg);
                }
            }
            builder = RunAsValidator.validateWorkDir(workDir = ProjectPropertiesSupport.getWorkDir(ConfigActionScript.this.project), false) == null ? builder.workingDirectory(new File(workDir)) : builder.workingDirectory(this.file.getParentFile());
            return builder;
        }

        @Override
        public boolean isValid() {
            return super.isValid() && this.file != null;
        }

        @Override
        protected PhpProgram getPhpProgram() throws PhpProgram.InvalidPhpProgramException {
            return ProjectPropertiesSupport.getPhpInterpreter(ConfigActionScript.this.project);
        }

        @Override
        public List<Pair<String, String>> getDebugPathMapping() {
            return ProjectPropertiesSupport.getDebugPathMapping(ConfigActionScript.this.project);
        }

        @Override
        public Pair<String, Integer> getDebugProxy() {
            return ProjectPropertiesSupport.getDebugProxy(ConfigActionScript.this.project);
        }
    }
}

