/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.environment;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.openide.util.NbBundle;

final class WindowsPhpEnvironment
extends PhpEnvironment {
    private static final String PHP = "php.exe";
    private static final String XAMPP = "xampp";
    private static final FilenameFilter XAMPP_FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().startsWith(WindowsPhpEnvironment.XAMPP);
        }
    };

    WindowsPhpEnvironment() {
    }

    @Override
    protected List<PhpEnvironment.DocumentRoot> getDocumentRoots(String projectName) {
        File[] fsRoots = File.listRoots();
        if (fsRoots == null) {
            return Collections.emptyList();
        }
        File htDocs = null;
        for (File root : fsRoots) {
            LOGGER.log(Level.FINE, "FS root: {0}", root);
            if (WindowsPhpEnvironment.isFloppy(root)) {
                LOGGER.log(Level.FINE, "Skipping floppy: {0}", root);
                continue;
            }
            File programFiles = new File(root, "Program Files");
            htDocs = WindowsPhpEnvironment.findHtDocsDirectory(programFiles, APACHE_FILENAME_FILTER);
            if (htDocs != null || (htDocs = new File(new File(root, XAMPP), "htdocs")).isDirectory() || (htDocs = WindowsPhpEnvironment.findHtDocsDirectory(programFiles, XAMPP_FILENAME_FILTER)) != null) break;
        }
        if (htDocs != null) {
            String documentRoot = WindowsPhpEnvironment.getFolderName(htDocs, projectName);
            String url = WindowsPhpEnvironment.getDefaultUrl(projectName);
            String hint = NbBundle.getMessage(WindowsPhpEnvironment.class, (String)"TXT_HtDocs");
            return Arrays.asList(new PhpEnvironment.DocumentRoot(documentRoot, url, hint, FileUtils.isDirectoryWritable((File)htDocs)));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAllPhpInterpreters() {
        return WindowsPhpEnvironment.getAllPhpInterpreters(PHP);
    }

    @Override
    public List<String> getAllPhpUnits() {
        return FileUtils.findFileOnUsersPath((String)"phpunit.bat");
    }

    private static boolean isFloppy(File root) {
        String absolutePath = root.getAbsolutePath();
        LOGGER.log(Level.FINE, "Testing floppy on {0}", absolutePath);
        return absolutePath.toLowerCase().startsWith("a:") || absolutePath.toLowerCase().startsWith("b:");
    }
}

