/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementEvent;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementListener;
import org.netbeans.modules.vmd.midpnb.propertyeditors.table.TableModelEditorElement;
import org.openide.util.NbBundle;

public class PropertyEditorTableModel
extends DesignPropertyEditor
implements PropertyEditorResourceElementListener {
    private WeakReference<DesignComponent> component;
    private JPanel customEditorPanel;
    private TableModelEditorElement perElement;
    private PropertyValue values;
    private PropertyValue headers;

    public static PropertyEditorTableModel createInstance() {
        return new PropertyEditorTableModel();
    }

    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.perElement != null) {
            this.perElement.clean(component);
            this.perElement = null;
        }
        this.values = null;
        this.headers = null;
        if (this.customEditorPanel != null) {
            this.customEditorPanel.removeAll();
        }
        this.component = null;
    }

    private void initComponents() {
        this.perElement = new TableModelEditorElement();
        this.perElement.addPropertyEditorResourceElementListener(this);
        this.customEditorPanel = new JPanel(new BorderLayout());
        this.customEditorPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.customEditorPanel.add((Component)((Object)this.perElement), "Center");
    }

    public void init(DesignComponent component) {
        if (component != null) {
            this.component = new WeakReference<DesignComponent>(component);
        }
    }

    public Component getCustomEditor() {
        if (this.customEditorPanel == null) {
            this.initComponents();
        }
        if (this.component != null && this.component.get() != null) {
            this.perElement.setDesignComponentWrapper(new PropertyEditorResourceElement.DesignComponentWrapper((DesignComponent)this.component.get()));
        }
        this.perElement.setAllEnabled(true);
        return this.customEditorPanel;
    }

    public Boolean canEditAsText() {
        return Boolean.FALSE;
    }

    public String getAsText() {
        return NbBundle.getMessage(PropertyEditorTableModel.class, (String)"DISP_PE_TableModel_GetAsText");
    }

    public boolean executeInsideWriteTransaction() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        DesignComponent _component = (DesignComponent)this.component.get();
        if (this.headers != null) {
            _component.writeProperty("columnNames", this.headers);
        }
        if (this.values != null) {
            _component.writeProperty("values", this.values);
        }
        return false;
    }

    public boolean isExecuteInsideWriteTransactionUsed() {
        return true;
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public void elementChanged(PropertyEditorResourceElementEvent event) {
        PropertyValue propertyValue = event.getPropertyValue();
        String propertyName = event.getPropertyName();
        if ("columnNames".equals(propertyName)) {
            this.headers = propertyValue;
        } else if ("values".equals(propertyName)) {
            this.values = propertyValue;
        } else {
            throw Debug.illegalArgument((Object[])new Object[]{"Illegal property value has been passed"});
        }
    }

    public boolean isDefaultValue() {
        if (this.component == null || this.component.get() == null) {
            return true;
        }
        final boolean[] isDefaultValue = new boolean[]{true};
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent _component = (DesignComponent)PropertyEditorTableModel.this.component.get();
                boolean names = PropertyValue.createNull().equals(_component.readProperty("columnNames"));
                boolean values = PropertyValue.createNull().equals(_component.readProperty("values"));
                isDefaultValue[0] = names && values;
            }
        });
        return isDefaultValue[0];
    }

    public boolean isResetToDefaultAutomatically() {
        return false;
    }

    public void customEditorResetToDefaultButtonPressed() {
        if (this.component != null && this.component.get() != null) {
            DesignComponent _component = (DesignComponent)this.component.get();
            _component.writeProperty("columnNames", PropertyValue.createNull());
            _component.writeProperty("values", PropertyValue.createNull());
        }
    }
}

