/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components.svg.form;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeleteSupport;
import org.netbeans.modules.vmd.api.model.support.ArraySupport;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.midp.components.MidpArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.sources.EventSourceCD;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGButtonCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGButtonGroupCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGCheckBoxCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComboBoxCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComponentCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGLabelCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGListCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGRadioButtonCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGSliderCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGSpinnerCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGTextFieldCD;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGFormImageParser;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class SVGFormFileObjectListener
implements FileChangeListener,
ActiveViewSupport.Listener {
    private WeakReference<DesignComponent> component;
    private DataEditorView.Kind activatedView;

    public SVGFormFileObjectListener(DesignComponent component, DesignComponent imageComponent, String propertyName) {
        assert (component != null);
        assert (imageComponent != null);
        this.component = new WeakReference<DesignComponent>(component);
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
        this.regenerateComponents(fe.getFile());
    }

    public void fileDeleted(FileEvent fe) {
        if (this.component == null || this.component.get() == null || fe == null) {
            return;
        }
        Project project = MidpProjectSupport.getProjectForDocument((DesignDocument)((DesignComponent)this.component.get()).getDocument());
        if (project == null) {
            return;
        }
        if (fe.getFile() == null) {
            return;
        }
        this.regenerateComponents(fe.getFile());
        fe.getFile().removeFileChangeListener((FileChangeListener)this);
        ActiveViewSupport.getDefault().removeActiveViewListener((ActiveViewSupport.Listener)this);
        this.activatedView = null;
    }

    public void fileRenamed(FileRenameEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private void regenerateComponents(FileObject fe) {
        if (this.component == null || this.component.get() == null || ((DesignComponent)this.component.get()).getDocument() == null || fe == null) {
            return;
        }
        DesignComponent svgForm = (DesignComponent)this.component.get();
        SVGFormFileObjectListener.regenerateSVGComponentsStructure(fe, svgForm, this.activatedView);
    }

    public static synchronized void regenerateSVGComponentsStructure(FileObject fo, final DesignComponent svgForm, DataEditorView.Kind activatedView) {
        Project project = MidpProjectSupport.getProjectForDocument((DesignDocument)svgForm.getDocument());
        if (project == null) {
            return;
        }
        InputStream is = null;
        try {
            if (fo.isValid()) {
                is = fo.getInputStream();
            }
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (fo == null && is == null) {
            return;
        }
        SVGFormFileObjectListener.updateScreenDesigner(svgForm);
        Object[][] idsArray = SVGFormImageParser.getComponentsInformation(is);
        final HashMap exisitngIDs = new HashMap();
        svgForm.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DescriptorRegistry registry = svgForm.getDocument().getDescriptorRegistry();
                for (DesignComponent component : svgForm.getComponents()) {
                    if (!registry.isInHierarchy(SVGComponentCD.TYPEID, component.getType())) continue;
                    String id = (String)component.readProperty("id").getPrimitiveValue();
                    exisitngIDs.put(id, component.getType().toString());
                }
            }
        });
        LinkedHashMap<String, String> changedIDs = new LinkedHashMap<String, String>();
        final LinkedHashMap<String, SVGFormImageParser.SVGFormComponent> producers = new LinkedHashMap<String, SVGFormImageParser.SVGFormComponent>();
        for (int i = 0; i < idsArray.length; ++i) {
            changedIDs.put(idsArray[i][1].toString(), idsArray[i][0].toString());
            producers.put(idsArray[i][1].toString(), (SVGFormImageParser.SVGFormComponent)idsArray[i][2]);
        }
        final HashSet<String> toDelete = new HashSet<String>();
        for (String id : exisitngIDs.keySet()) {
            if (changedIDs.containsKey(id)) continue;
            toDelete.add(id);
        }
        final LinkedHashMap toAdd = new LinkedHashMap();
        for (String id : changedIDs.keySet()) {
            if (exisitngIDs.containsKey(id)) continue;
            toAdd.put(id, changedIDs.get(id));
        }
        if (!toAdd.isEmpty() || !toDelete.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    svgForm.getDocument().getTransactionManager().writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            DescriptorRegistry registry = svgForm.getDocument().getDescriptorRegistry();
                            HashSet components = new HashSet(svgForm.getComponents());
                            for (DesignComponent component : components) {
                                String id;
                                if (!registry.isInHierarchy(SVGComponentCD.TYPEID, component.getType()) || !toDelete.contains(id = (String)component.readProperty("id").getPrimitiveValue())) continue;
                                ArraySupport.remove((DesignComponent)svgForm, (String)"components", (DesignComponent)component);
                                SVGFormFileObjectListener.removeSVGComponentEventSource(component, svgForm);
                                SVGFormFileObjectListener.refreshButtonGroup(component, svgForm);
                                DeleteSupport.invokeDirectUserDeletion((DesignDocument)svgForm.getDocument(), Collections.singleton(component), (boolean)false);
                            }
                            SVGFormFileObjectListener.addComponents(toAdd, svgForm, producers);
                        }
                    });
                }
            });
            final DataObjectContext context = ProjectUtils.getDataObjectContextForDocument((DesignDocument)svgForm.getDocument());
            if (context != null && context.getDataObject() != null && DataEditorView.Kind.CODE == activatedView) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IOSupport.forceUpdateCode((DataObject)context.getDataObject());
                    }
                });
            }
        }
    }

    private static void updateScreenDesigner(final DesignComponent svgForm) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                svgForm.getDocument().getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        Project project = MidpProjectSupport.getProjectForDocument((DesignDocument)svgForm.getDocument());
                        if (project == null) {
                            return;
                        }
                        ScreenDisplayPresenter sdp = (ScreenDisplayPresenter)svgForm.getPresenter(ScreenDisplayPresenter.class);
                        ScreenDeviceInfo di = ScreenSupport.getDeviceInfo((DesignDocument)svgForm.getDocument());
                        sdp.reload(di);
                    }
                });
            }
        });
    }

    private static void addComponents(Map<String, String> ids, DesignComponent svgForm, Map<String, SVGFormImageParser.SVGFormComponent> producers) {
        HashMap<SVGFormImageParser.SVGFormComponent, DesignComponent> producer2Component = new HashMap<SVGFormImageParser.SVGFormComponent, DesignComponent>();
        for (String id : ids.keySet()) {
            String type = ids.get(id);
            SVGFormImageParser.SVGFormComponent producer = producers.get(id);
            if (MidpTypes.getSimpleClassName((TypeID)SVGButtonCD.TYPEID).equals(type)) {
                SVGFormFileObjectListener.createComponent(id, SVGButtonCD.TYPEID, svgForm, producer, producer2Component);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGCheckBoxCD.TYPEID).equals(type)) {
                SVGFormFileObjectListener.createComponent(id, SVGCheckBoxCD.TYPEID, svgForm, producer, producer2Component);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGComboBoxCD.TYPEID).equals(type)) {
                SVGFormFileObjectListener.createComponent(id, SVGComboBoxCD.TYPEID, svgForm, producer, producer2Component);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGLabelCD.TYPEID).equals(type)) {
                SVGFormFileObjectListener.createComponent(id, SVGLabelCD.TYPEID, svgForm, producer, producer2Component);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGListCD.TYPEID).equals(type)) {
                SVGFormFileObjectListener.createComponent(id, SVGListCD.TYPEID, svgForm, producer, producer2Component);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGRadioButtonCD.TYPEID).equals(type)) {
                SVGFormFileObjectListener.createComponent(id, SVGRadioButtonCD.TYPEID, svgForm, producer, producer2Component);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGSliderCD.TYPEID).equals(type)) {
                SVGFormFileObjectListener.createComponent(id, SVGSliderCD.TYPEID, svgForm, producer, producer2Component);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGSpinnerCD.TYPEID).equals(type)) {
                SVGFormFileObjectListener.createComponent(id, SVGSpinnerCD.TYPEID, svgForm, producer, producer2Component);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGTextFieldCD.TYPEID).equals(type)) {
                SVGFormFileObjectListener.createComponent(id, SVGTextFieldCD.TYPEID, svgForm, producer, producer2Component);
                continue;
            }
            if (!MidpTypes.getSimpleClassName((TypeID)SVGButtonGroupCD.TYPEID).equals(type)) continue;
            SVGFormFileObjectListener.createComponent(id, SVGButtonGroupCD.TYPEID, svgForm, producer, producer2Component);
        }
        SVGFormImageParser.initButtonGroup(producer2Component);
    }

    private static void createComponent(String id, TypeID type, DesignComponent svgForm, SVGFormImageParser.SVGFormComponent producer, Map<SVGFormImageParser.SVGFormComponent, DesignComponent> producerMap) {
        SVGFormImageParser.SVGFormComponent srcSvgComponent = SVGFormImageParser.SVGFormComponent.createComponent(producer, new Float(10000.0f));
        DesignComponent svgComponent = srcSvgComponent.createComponent(svgForm);
        svgForm.addComponent(svgComponent);
        producerMap.put(srcSvgComponent, svgComponent);
        MidpArraySupport.append((DesignComponent)svgForm, (String)"components", (DesignComponent)svgComponent);
    }

    private static void removeSVGComponentEventSource(DesignComponent svgComponent, DesignComponent svgForm) {
        HashSet components = new HashSet(svgForm.getComponents());
        for (DesignComponent potentialButtonEventSource : components) {
            PropertyValue value;
            if (!svgComponent.getDocument().getDescriptorRegistry().isInHierarchy(EventSourceCD.TYPEID, potentialButtonEventSource.getType()) || (value = potentialButtonEventSource.readProperty("svgButton")) == null || value.getComponent() == null || value.getComponent() != svgComponent) continue;
            potentialButtonEventSource.getDocument().deleteComponent(potentialButtonEventSource);
        }
    }

    private static void refreshButtonGroup(DesignComponent component, DesignComponent form) {
        TypeID type = component.getType();
        if (type.equals((Object)SVGButtonGroupCD.TYPEID)) {
            List list = form.readProperty("components").getArray();
            for (PropertyValue propertyValue : list) {
                DesignComponent buttonGroup;
                DesignComponent desComponent = propertyValue.getComponent();
                if (!desComponent.getType().equals((Object)SVGRadioButtonCD.TYPEID) || !component.equals(buttonGroup = desComponent.readProperty("buttonGroup").getComponent())) continue;
                desComponent.writeProperty("buttonGroup", PropertyValue.createNull());
            }
        }
    }

    public void activeViewChanged(DataEditorView deactivatedView, DataEditorView activatedView) {
        if (activatedView != null) {
            this.activatedView = activatedView.getKind();
        }
    }
}

