/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.ThreadInfo;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshotQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.threadmap.api.ThreadData;
import org.netbeans.modules.dlight.threadmap.api.ThreadMapSummaryData;
import org.netbeans.modules.dlight.threadmap.api.ThreadSummaryData;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.visualizers.threadmap.DataManagerListener;
import org.netbeans.modules.dlight.visualizers.threadmap.MonitoredData;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadSummaryColumnImpl;

public final class ThreadsDataManager {
    private final List<ThreadStateColumnImpl> threadData = new ArrayList<ThreadStateColumnImpl>();
    private final CopyOnWriteArrayList<DataManagerListener> listeners = new CopyOnWriteArrayList();
    private final Object lock = new Lock();
    private boolean threadsMonitoringEnabled = true;
    private long endTime;
    private long startTime;
    private ThreadMapSummaryData summary;
    private ThreadMapDataProvider provider;
    private int threadNameFormat = 0;
    private ThreadNameUpdateTask updater = new ThreadNameUpdateTask();
    private DLightExecutorService.DLightScheduledTask updateNameTask;
    private boolean fillThreadNames = false;

    public ThreadsDataManager() {
        this.reset();
    }

    public void addDataListener(DataManagerListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeDataListener(DataManagerListener listener) {
        this.listeners.remove(listener);
    }

    private void fireDataChanged() {
        for (DataManagerListener l : this.listeners) {
            l.dataChanged();
        }
    }

    private void fireDataReset() {
        for (DataManagerListener l : this.listeners) {
            l.dataReset();
        }
    }

    public synchronized long getEndTimeStump() {
        return this.endTime;
    }

    public synchronized long getEndTime() {
        return ThreadStateColumnImpl.timeStampToMilliSeconds(this.endTime);
    }

    public synchronized long getStartTime() {
        return ThreadStateColumnImpl.timeStampToMilliSeconds(this.startTime);
    }

    public synchronized ThreadStateColumnImpl getThreadData(int index) {
        return this.threadData.get(index);
    }

    public synchronized String getThreadName(int index) {
        return this.threadData.get(index).getName();
    }

    public synchronized String findThreadName(int threadID) {
        for (int i = 0; i < this.threadData.size(); ++i) {
            if (this.threadData.get(i).getThreadID() != threadID) continue;
            return this.threadData.get(i).getName();
        }
        return "" + threadID;
    }

    public synchronized int getThreadsCount() {
        return this.threadData.size();
    }

    public synchronized void setThreadsMonitoringEnabled(boolean enabled) {
        if (this.threadsMonitoringEnabled == enabled) {
            return;
        }
        this.threadsMonitoringEnabled = enabled;
        if (!this.threadsMonitoringEnabled) {
            for (int i = 0; i < this.threadData.size(); ++i) {
                this.threadData.get(i).clearStates();
            }
        }
    }

    public synchronized boolean hasData() {
        return this.getThreadsCount() != 0;
    }

    public synchronized void processData(ThreadMapSummaryData summaryData) {
        this.summary = summaryData;
    }

    public synchronized ThreadSummaryColumnImpl getThreadSummary(int i) {
        i = this.getThreadData(i).getThreadID();
        ThreadMapSummaryData summaryData = this.summary;
        List state = null;
        if (summaryData != null) {
            for (ThreadSummaryData data : summaryData.getThreadsData()) {
                if (data.getThreadInfo().getThreadId() != i) continue;
                state = data.getThreadSummary();
            }
        }
        if (state == null) {
            state = Collections.emptyList();
        }
        return new ThreadSummaryColumnImpl(state);
    }

    public synchronized void processData(MonitoredData monitoredData, DLightSession session, ThreadMapDataProvider provider, long requestFrom) {
        int threadSize = monitoredData.getThreadsSize();
        if (threadSize == 0) {
            return;
        }
        this.mergeData(monitoredData, requestFrom);
        threadSize = this.threadData.size();
        if (threadSize == 0) {
            return;
        }
        if (this.provider == null) {
            this.provider = provider;
        }
        this.startTime = session.getStartTime();
        this.endTime = 0L;
        if (this.threadsMonitoringEnabled) {
            for (int i = 0; i < threadSize; ++i) {
                ThreadStateColumnImpl col = this.threadData.get(i);
                this.endTime = Math.max(this.endTime, col.getThreadStateAt(col.size() - 1).getTimeStamp());
            }
            this.fireDataChanged();
        }
        if (this.fillThreadNames) {
            this.fillThreadNames = false;
            this.setThreadNameFormat();
        }
    }

    private void mergeData(MonitoredData monitoredData, long requestFrom) {
        int updateThreadSize = monitoredData.getThreadsSize();
        if (updateThreadSize == 0) {
            return;
        }
        LinkedHashMap<Integer, Integer> IdToNumber = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < updateThreadSize; ++i) {
            ThreadInfo info = monitoredData.getThreadInfo(i);
            IdToNumber.put(info.getThreadId(), i);
        }
        int oldThreadSize = this.threadData.size();
        for (int i = 0; i < oldThreadSize; ++i) {
            ThreadStateColumnImpl col = this.threadData.get(i);
            Integer number = (Integer)IdToNumber.get(col.getThreadID());
            if (number == null) continue;
            long lastState = col.getThreadStateAt(col.size() - 1).getTimeStamp();
            if (requestFrom == 0L) {
                col.clearStates();
                lastState = -1L;
            }
            int newData = number;
            List<ThreadState> states = monitoredData.getThreadStates(newData);
            for (int j = 0; j < states.size(); ++j) {
                ThreadState newState = states.get(j);
                if (newState.getTimeStamp() > lastState) {
                    col.add(newState);
                }
                col.updateStackProvider(monitoredData.getStackProvider(newData));
            }
            IdToNumber.remove(col.getThreadID());
        }
        for (Integer number : IdToNumber.values()) {
            int i = number;
            List<ThreadState> states = monitoredData.getThreadStates(i);
            int size = states.size();
            if (size <= 0) continue;
            MergedThreadInfo info = new MergedThreadInfo(monitoredData.getThreadInfo(i), monitoredData.getStartTimestamp(i));
            ThreadData stackProvider = monitoredData.getStackProvider(i);
            ThreadStateColumnImpl col = new ThreadStateColumnImpl(info, stackProvider);
            this.threadData.add(col);
            for (int j = 0; j < size; ++j) {
                col.add(states.get(j));
            }
        }
    }

    public synchronized void startup(DLightSession.SessionState sessionState) {
        if (sessionState == DLightSession.SessionState.ANALYZE) {
            if (this.updateNameTask != null) {
                this.updateNameTask.cancel();
                this.updateNameTask = null;
            }
            this.fillThreadNames = true;
        } else if (this.updateNameTask == null) {
            this.updateNameTask = DLightExecutorService.scheduleAtFixedRate((Runnable)this.updater, (long)5L, (TimeUnit)TimeUnit.SECONDS, (String)"updateNameTask");
        }
    }

    public synchronized void shutdown(DLightSession.SessionState sessionState) {
        if (this.updateNameTask != null) {
            this.updateNameTask.cancel();
        }
        if (sessionState == DLightSession.SessionState.ANALYZE) {
            this.fillThreadNames = true;
        }
    }

    public synchronized void reset() {
        this.startTime = 0L;
        this.endTime = 0L;
        this.provider = null;
        this.threadData.clear();
        this.fireDataReset();
    }

    public ThreadsDataManager(long endTime, long startTime, ThreadMapSummaryData summary, ThreadMapDataProvider provider) {
        this.endTime = endTime;
        this.startTime = startTime;
        this.summary = summary;
        this.provider = provider;
    }

    void setThreadNameFormat(int format, boolean init) {
        if (this.threadNameFormat != format) {
            this.threadNameFormat = format;
            if (init) {
                return;
            }
            this.setThreadNameFormat();
        }
    }

    private void setThreadNameFormat() {
        switch (this.threadNameFormat) {
            case 1: 
            case 2: {
                DLightExecutorService.submit((Runnable)this.updater, (String)"urgentUpdateNameTask");
                break;
            }
            default: {
                for (ThreadStateColumnImpl col : this.threadData) {
                    col.resetName();
                }
                this.fireDataChanged();
            }
        }
    }

    int getThreadNameFormat() {
        return this.threadNameFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateThreadNames() {
        ThreadMapDataProvider aProvider = this.provider;
        if (this.threadNameFormat == 0 || aProvider == null) {
            this.fireDataChanged();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Collection dumps;
            ThreadSnapshotQuery query;
            ThreadSnapshotQuery.TimeFilter time;
            block16: {
                time = new ThreadSnapshotQuery.TimeFilter(0L, Long.MAX_VALUE, ThreadSnapshotQuery.TimeFilter.Mode.FIRST);
                query = new ThreadSnapshotQuery(true, new ThreadSnapshotQuery.Filter[]{time});
                dumps = aProvider.getThreadSnapshots(query);
                if (dumps == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 7, 14] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.fireDataChanged();
                    return;
                }
                if (this.threadNameFormat != 0) break block16;
                // MONITOREXIT @DISABLED, blocks:[0, 2, 7] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
                this.fireDataChanged();
                return;
            }
            try {
                int level = this.threadNameFormat + 1;
                if (level <= 0) return;
                Iterator i$ = dumps.iterator();
                while (i$.hasNext()) {
                    int lookAt;
                    ThreadSnapshot dump = (ThreadSnapshot)i$.next();
                    int i = dump.getThreadInfo().getThreadId();
                    int n = lookAt = i == 1 ? 1 : level;
                    if (!this.isValidDump(dump, lookAt)) {
                        time = new ThreadSnapshotQuery.TimeFilter(dump.getTimestamp(), dump.getTimestamp() + 50000000L, ThreadSnapshotQuery.TimeFilter.Mode.ALL);
                        ThreadSnapshotQuery.ThreadFilter thread = new ThreadSnapshotQuery.ThreadFilter(Collections.singletonList(i));
                        query = new ThreadSnapshotQuery(true, new ThreadSnapshotQuery.Filter[]{time, thread});
                        dump = null;
                        for (ThreadSnapshot d : aProvider.getThreadSnapshots(query)) {
                            if (!this.isValidDump(d, lookAt)) continue;
                            dump = d;
                        }
                    }
                    if (dump == null) continue;
                    this.updateName(((FunctionCall)dump.getStack().get(lookAt)).getFunction().getQuilifiedName(), i);
                }
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
    }

    private boolean isValidDump(ThreadSnapshot dump, int lookAt) {
        String s;
        return dump.getStack().size() > lookAt && ("_start".equals(s = ((FunctionCall)dump.getStack().get(0)).getFunction().getQuilifiedName()) || "_lwp_start".equals(s));
    }

    private void updateName(String newName, int id) {
        for (ThreadStateColumnImpl col : this.threadData) {
            if (col.getThreadID() != id) continue;
            col.updateName(newName + " (" + id + ")");
            break;
        }
    }

    private final class ThreadNameUpdateTask
    implements Runnable {
        private ThreadNameUpdateTask() {
        }

        @Override
        public void run() {
            ThreadsDataManager.this.updateThreadNames();
        }
    }

    private static final class ProcessID {
        private final ThreadInfo info;
        private final long startTimeStamp;

        private ProcessID(ThreadInfo info, long startTimeStamp) {
            this.info = info;
            this.startTimeStamp = startTimeStamp;
        }

        private int getId() {
            return this.info.getThreadId();
        }

        private ThreadInfo getThreadInfo() {
            return this.info;
        }

        private long getStartTimeStamp() {
            return this.startTimeStamp;
        }
    }

    static class MergedThreadInfo {
        private String name;
        private final LinkedList<ProcessID> processes = new LinkedList();

        private MergedThreadInfo(ThreadInfo info, long startTime) {
            this.name = info.getThreadName();
            this.processes.add(new ProcessID(info, startTime));
        }

        String getThreadName() {
            return this.name;
        }

        void setThreadName(String newName) {
            this.name = newName;
        }

        int getThreadId() {
            return this.processes.getFirst().getId();
        }

        void resetName() {
            this.name = this.processes.getFirst().getThreadInfo().getThreadName();
        }

        long getStartTimeStamp() {
            return this.processes.getFirst().getStartTimeStamp();
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

