/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

public abstract class BaseRegistrationProcessor<P, R extends Annotation>
extends LayerGeneratingProcessor {
    protected abstract String getPath();

    protected abstract int getPosition(R var1);

    public final Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(this.registrationClass().getCanonicalName());
    }

    protected final boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        if (roundEnv.processingOver()) {
            return false;
        }
        Class<P> providerClass = this.providerClass();
        Class<R> registrationClass = this.registrationClass();
        TypeMirror provider = this.processingEnv.getElementUtils().getTypeElement(providerClass.getName()).asType();
        for (Element element : roundEnv.getElementsAnnotatedWith(registrationClass)) {
            String classname = null;
            String methodname = null;
            switch (element.getKind()) {
                case CLASS: {
                    classname = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                    if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                        throw new LayerGenerationException("Class needs to be public");
                    }
                    if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                        throw new LayerGenerationException("Class cannot be abstract");
                    }
                    if (!this.processingEnv.getTypeUtils().isAssignable(element.asType(), provider)) {
                        throw new LayerGenerationException("Class needs to extend " + providerClass.getSimpleName());
                    }
                    boolean found = false;
                    for (Element element2 : this.processingEnv.getElementUtils().getAllMembers((TypeElement)element)) {
                        ExecutableElement exec;
                        if (element2.getKind() != ElementKind.CONSTRUCTOR || !(exec = (ExecutableElement)element2).getModifiers().contains((Object)Modifier.PUBLIC) || !exec.getParameters().isEmpty()) continue;
                        found = true;
                        break;
                    }
                    if (found) break;
                    throw new LayerGenerationException("There needs to be public default constructor");
                }
                case METHOD: {
                    classname = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element.getEnclosingElement()).toString();
                    methodname = ((ExecutableElement)element).getSimpleName().toString();
                    if (!element.getEnclosingElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
                        throw new LayerGenerationException("Class needs to be public");
                    }
                    ExecutableElement exec = (ExecutableElement)element;
                    if (!(exec.getModifiers().contains((Object)Modifier.PUBLIC) && exec.getModifiers().contains((Object)Modifier.STATIC) && exec.getParameters().isEmpty())) {
                        throw new LayerGenerationException("The method needs to be public, static and without arguments");
                    }
                    if (this.processingEnv.getTypeUtils().isAssignable(exec.getReturnType(), provider)) break;
                    throw new LayerGenerationException("Method needs to return " + providerClass.getSimpleName());
                }
                default: {
                    throw new IllegalArgumentException(element.toString());
                }
            }
            LayerBuilder.File f = this.layer(new Element[]{element}).file(this.getPath() + "/" + classname.replace('.', '-') + ".instance").intvalue("position", this.getPosition(element.getAnnotation(registrationClass)));
            if (methodname != null) {
                f = f.methodvalue("instanceCreate", classname, methodname);
            }
            f.write();
        }
        return true;
    }

    private Class<P> providerClass() {
        return (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    private Class<R> registrationClass() {
        return (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[1];
    }
}

