/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.LocalHistoryStore;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryRootNode;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class LocalHistoryFileView
implements VersioningListener {
    private FileTablePanel tablePanel;
    private File[] files;
    private RequestProcessor rp = new RequestProcessor("LocalHistoryView", 1, true);
    private static final Icon NO_ICON = new NoIcon();

    public LocalHistoryFileView() {
        this.tablePanel = new FileTablePanel();
        this.files = new File[0];
        LocalHistory.getInstance().getLocalHistoryStore().addVersioningListener(this);
    }

    public void refresh(File[] files) {
        this.refresh(files, -1L);
    }

    public void refresh(File[] files, long toSelect) {
        this.files = files;
        this.refreshTablePanel(toSelect);
    }

    public void versioningEvent(VersioningEvent evt) {
        if (LocalHistoryStore.EVENT_HISTORY_CHANGED == evt.getId() || LocalHistoryStore.EVENT_ENTRY_DELETED == evt.getId()) {
            this.storeChanged(evt);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.tablePanel.getExplorerManager();
    }

    public JPanel getPanel() {
        return this.tablePanel;
    }

    public void close() {
        LocalHistory.getInstance().getLocalHistoryStore().removeVersioningListener(this);
    }

    private Node getNode(long ts) {
        if (ts == -1L) {
            return null;
        }
        Node root = this.tablePanel.getExplorerManager().getRootContext();
        Node[] dayNodes = root.getChildren().getNodes();
        if (dayNodes != null && dayNodes.length > 0) {
            for (Node dayNode : dayNodes) {
                Node[] entryNodes = dayNode.getChildren().getNodes();
                if (entryNodes == null || entryNodes.length <= 0) continue;
                for (Node entryNode : entryNodes) {
                    StoreEntry se = (StoreEntry)entryNode.getLookup().lookup(StoreEntry.class);
                    if (se == null || se.getTimestamp() != ts) continue;
                    return entryNode;
                }
            }
        }
        return null;
    }

    private void storeChanged(VersioningEvent evt) {
        Object value = evt.getParams()[0];
        if (value != null && this.contains((File)value)) {
            this.refreshTablePanel(-1L);
        }
    }

    private boolean contains(File file) {
        for (File f : this.files) {
            if (!f.equals(file)) continue;
            return true;
        }
        return false;
    }

    private void refreshTablePanel(long toSelect) {
        RequestProcessor.Task refreshTask = this.rp.create((Runnable)new RefreshTable(toSelect));
        refreshTask.schedule(100);
    }

    private static class NoIcon
    implements Icon {
        private NoIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    }

    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }

    private class FileTablePanel
    extends JPanel
    implements ExplorerManager.Provider {
        private final BrowserTreeTableView treeView;
        private final ExplorerManager manager = new ExplorerManager();

        public FileTablePanel() {
            this.setLayout(new GridBagLayout());
            this.treeView = new BrowserTreeTableView();
            this.setLayout(new BorderLayout());
            this.add((Component)((Object)this.treeView), "Center");
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        private class BrowserTreeTableView
        extends OutlineView {
            BrowserTreeTableView() {
                super(NbBundle.getMessage(LocalHistoryFileView.class, (String)"LBL_LocalHistory_Column_Version"));
                this.setupColumns();
                this.getOutline().setRootVisible(false);
                this.setBorder(BorderFactory.createEtchedBorder());
                this.getOutline().setSelectionMode(1);
                this.setPopupAllowed(true);
                this.setDragSource(false);
                this.setDropTarget(false);
                this.getOutline().setColumnHidingAllowed(false);
                this.getOutline().setRenderDataProvider((RenderDataProvider)new NoLeafIconRenderDataProvider(this.getOutline().getRenderDataProvider()));
            }

            public void addNotify() {
                super.addNotify();
                this.setDefaultColumnSizes();
            }

            private void setupColumns() {
                ResourceBundle loc = NbBundle.getBundle(FileTablePanel.class);
                Node.Property[] columns = new Node.Property[1];
                columns = new Node.Property[]{new ColumnDescriptor<String>("label", String.class, loc.getString("LBL_LocalHistory_Column_Label"), loc.getString("LBL_LocalHistory_Column_Label_Desc"))};
                this.setProperties(columns);
            }

            private void setDefaultColumnSizes() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int width = BrowserTreeTableView.this.getWidth();
                        BrowserTreeTableView.this.getOutline().getColumnModel().getColumn(0).setPreferredWidth(width * 35 / 100);
                        BrowserTreeTableView.this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(width * 65 / 100);
                    }
                });
            }

            private class NoLeafIconRenderDataProvider
            implements RenderDataProvider {
                private RenderDataProvider delegate;

                public NoLeafIconRenderDataProvider(RenderDataProvider delegate) {
                    this.delegate = delegate;
                }

                public String getDisplayName(Object o) {
                    return this.delegate.getDisplayName(o);
                }

                public boolean isHtmlDisplayName(Object o) {
                    return this.delegate.isHtmlDisplayName(o);
                }

                public Color getBackground(Object o) {
                    return this.delegate.getBackground(o);
                }

                public Color getForeground(Object o) {
                    return this.delegate.getForeground(o);
                }

                public String getTooltipText(Object o) {
                    return this.delegate.getTooltipText(o);
                }

                public Icon getIcon(Object o) {
                    if (BrowserTreeTableView.this.getOutline().getOutlineModel().isLeaf(o)) {
                        return NO_ICON;
                    }
                    return null;
                }
            }
        }
    }

    private class RefreshTable
    implements Runnable {
        private long toSelect;

        RefreshTable(long toSelect) {
            this.toSelect = toSelect;
        }

        @Override
        public void run() {
            Node root = LocalHistoryRootNode.createRootNode(LocalHistoryFileView.this.files);
            Node[] oldSelection = LocalHistoryFileView.this.getExplorerManager().getSelectedNodes();
            LocalHistoryFileView.this.tablePanel.getExplorerManager().setRootContext(root);
            if (root.getChildren().getNodesCount() > 0) {
                Node node;
                if (this.toSelect > -1L && (node = LocalHistoryFileView.this.getNode(this.toSelect)) != null) {
                    oldSelection = new Node[]{node};
                }
                if (oldSelection != null && oldSelection.length > 0) {
                    Node[] newSelection = this.getEqualNodes(root, oldSelection);
                    if (newSelection.length > 0) {
                        this.setNodes(root, newSelection);
                    } else {
                        Node[] newExploredContext = this.getEqualNodes(root, new Node[]{oldSelection[0].getParentNode()});
                        if (newExploredContext.length > 0) {
                            this.selectFirstNeighborNode(root, newExploredContext[0], oldSelection[0]);
                        }
                    }
                } else {
                    this.selectFirstNode(root);
                }
            } else {
                this.setNodes(root, new Node[0]);
            }
            LocalHistoryFileView.this.tablePanel.revalidate();
            LocalHistoryFileView.this.tablePanel.repaint();
        }

        private Node[] getEqualNodes(Node root, Node[] oldNodes) {
            ArrayList<Node> ret = new ArrayList<Node>();
            for (Node on : oldNodes) {
                Node node = this.findEqualInChildren(root, on);
                if (node != null) {
                    ret.add(node);
                }
                if (!root.getName().equals(on.getName())) continue;
                ret.add(root);
            }
            return ret.toArray(new Node[ret.size()]);
        }

        private Node findEqualInChildren(Node node, Node toFind) {
            Node[] children;
            for (Node child : children = node.getChildren().getNodes()) {
                if (toFind.getName().equals(child.getName())) {
                    return child;
                }
                Node n = this.findEqualInChildren(child, toFind);
                if (n == null) continue;
                return n;
            }
            return null;
        }

        private void selectFirstNode(Node root) {
            Node[] nodes;
            Node[] dateFolders = root.getChildren().getNodes();
            if (dateFolders != null && dateFolders.length > 0 && (nodes = dateFolders[0].getChildren().getNodes()) != null && nodes.length > 0) {
                this.setNodes(root, new Node[]{nodes[0]});
            }
        }

        private void selectFirstNeighborNode(Node root, Node context, Node oldSelection) {
            Node[] children = context.getChildren().getNodes();
            if (children.length > 0 && children[0] instanceof Comparable) {
                Node[] newSelection = new Node[]{children[0]};
                for (int i = 1; i < children.length; ++i) {
                    Comparable c = (Comparable)children[i];
                    if (c.compareTo(oldSelection) >= 0) continue;
                    newSelection[0] = children[i];
                }
                this.setNodes(root, newSelection);
                LocalHistoryFileView.this.tablePanel.getExplorerManager().setExploredContext(context);
            }
        }

        private void setNodes(final Node root, final Node[] nodes) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        LocalHistoryFileView.this.tablePanel.getExplorerManager().setRootContext(root);
                        LocalHistoryFileView.this.tablePanel.getExplorerManager().setSelectedNodes(nodes);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

