/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Action;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.CallModel;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphScene;

public class CallGraphState {
    private CallModel model;
    private CallGraphScene scene;
    private Action[] actions;
    private Map<Function, Boolean> calleesExpanded = new ConcurrentHashMap<Function, Boolean>();
    private Map<Function, Boolean> callersExpanded = new ConcurrentHashMap<Function, Boolean>();

    public CallGraphState(CallModel model, CallGraphScene scene, Action[] actions) {
        this.model = model;
        this.scene = scene;
        this.actions = actions;
    }

    public List<Call> getCallers(Function declaration) {
        return this.model.getCallers(declaration);
    }

    public List<Call> getCallees(Function definition) {
        return this.model.getCallees(definition);
    }

    public void doLayout() {
        if (this.scene != null) {
            this.scene.doLayout();
        }
    }

    public void addCallToScene(Call element) {
        if (this.scene != null) {
            this.scene.addCallToScene(element);
        }
    }

    public void addFunctionToScene(Function element) {
        if (this.scene != null) {
            this.scene.addFunctionToScene(element);
        }
    }

    public void setCalleesExpanded(Function element, boolean expanded) {
        this.calleesExpanded.put(element, expanded);
    }

    public boolean isCalleesExpanded(Function element) {
        Boolean expanded = this.calleesExpanded.get(element);
        if (expanded == null) {
            return false;
        }
        return expanded;
    }

    public void setCallersExpanded(Function element, boolean expanded) {
        this.callersExpanded.put(element, expanded);
    }

    public boolean isCallersExpanded(Function element) {
        Boolean expanded = this.callersExpanded.get(element);
        if (expanded == null) {
            return false;
        }
        return expanded;
    }

    public Action[] getActions() {
        return this.actions;
    }
}

