/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;

public class CodeCommentAction
extends ExtKit.CommentAction {
    public static final String COMMENT_LINE = "COMMENT_LINE";

    public CodeCommentAction() {
        super("");
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        if (target != null) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            final BaseDocument doc = (BaseDocument)target.getDocument();
            Caret caret = target.getCaret();
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            if (th == null) {
                return;
            }
            final TokenSequence ts = th.tokenSequence();
            try {
                if (caret.isSelectionVisible()) {
                    final int startPos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                    final int endPos = target.getSelectionEnd();
                    doc.runAtomicAsUser(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int end = endPos > 0 && Utilities.getRowStart((BaseDocument)doc, (int)endPos) == endPos ? endPos - 1 : endPos;
                                int lineCnt = Utilities.getRowCount((BaseDocument)doc, (int)startPos, (int)end);
                                ArrayList<String> mimeTypes = new ArrayList<String>(lineCnt);
                                int pos = startPos;
                                for (int x = lineCnt; x > 0; --x) {
                                    mimeTypes.add(CodeCommentAction.this.getRealMimeType(ts, pos));
                                    pos = Utilities.getRowStart((BaseDocument)doc, (int)pos, (int)1);
                                }
                                pos = startPos;
                                Iterator iter = mimeTypes.iterator();
                                while (iter.hasNext()) {
                                    CodeCommentAction.this.modifyLine(doc, (String)iter.next(), pos);
                                    pos = Utilities.getRowStart((BaseDocument)doc, (int)pos, (int)1);
                                }
                            }
                            catch (BadLocationException e) {
                                target.getToolkit().beep();
                            }
                        }
                    });
                } else {
                    final int pos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                    final String mt = this.getRealMimeType(ts, pos);
                    doc.runAtomicAsUser(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CodeCommentAction.this.modifyLine(doc, mt, pos);
                            }
                            catch (BadLocationException e) {
                                target.getToolkit().beep();
                            }
                        }
                    });
                }
            }
            catch (BadLocationException e) {
                target.getToolkit().beep();
            }
        }
    }

    private String getRealMimeType(TokenSequence ts, int offset) {
        while (true) {
            ts.move(offset);
            if (!ts.moveNext()) break;
            offset = ts.offset();
            TokenSequence ts2 = ts.embedded();
            if (ts2 == null) break;
            ts = ts2;
        }
        return ts.language().mimeType();
    }

    private void modifyLine(BaseDocument doc, String mimeType, int offset) throws BadLocationException {
        Feature feature = null;
        try {
            Language language = LanguagesManager.getDefault().getLanguage(mimeType);
            feature = language.getFeatureList().getFeature(COMMENT_LINE);
        }
        catch (LanguageDefinitionNotFoundException e) {
            // empty catch block
        }
        if (feature != null) {
            String prefix = (String)feature.getValue("prefix");
            if (prefix == null) {
                return;
            }
            String suffix = (String)feature.getValue("suffix");
            if (suffix != null) {
                int end = Utilities.getRowEnd((BaseDocument)doc, (int)offset);
                doc.insertString(end, suffix, null);
            }
            doc.insertString(offset, prefix, null);
        }
    }
}

