/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguageImpl;
import org.netbeans.modules.languages.NBSLanguageReader;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.features.ActionCreator;
import org.netbeans.modules.languages.features.ColorsManager;
import org.netbeans.modules.languages.features.LocalizationSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.RequestProcessor;

public class LanguagesManager
extends org.netbeans.api.languages.LanguagesManager {
    private static LanguagesManager languagesManager;
    private Language parsingLanguage = Language.create("parsing...");
    private Map<String, Language> mimeTypeToLanguage = new HashMap<String, Language>();
    private Set<FileObject> listeningOn = new HashSet<FileObject>();
    private Listener listener;

    public static LanguagesManager getDefault() {
        if (languagesManager == null) {
            languagesManager = new LanguagesManager();
        }
        return languagesManager;
    }

    public boolean isSupported(String mimeType) {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        return fs.findResource("Editors/" + mimeType + "/language.nbs") != null;
    }

    public boolean createDataObjectFor(String mimeType) {
        if (!this.isSupported(mimeType)) {
            return false;
        }
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource("Editors/" + mimeType);
        if (fo == null) {
            return false;
        }
        Boolean b = (Boolean)fo.getAttribute("createDataObject");
        if (b == null) {
            return true;
        }
        return b;
    }

    public static String normalizeMimeType(String mimeType) {
        if (mimeType.startsWith("test")) {
            int idx = mimeType.indexOf(95);
            if (idx < 0) {
                return mimeType;
            }
            mimeType = mimeType.substring(idx + 1);
        }
        return mimeType;
    }

    @Override
    public synchronized Language getLanguage(String mimeType) throws LanguageDefinitionNotFoundException {
        if (!this.mimeTypeToLanguage.containsKey(mimeType = LanguagesManager.normalizeMimeType(mimeType))) {
            this.mimeTypeToLanguage.put(mimeType, this.parsingLanguage);
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = fs.findResource("Editors/" + mimeType + "/language.nbs");
            if (fo == null) {
                this.mimeTypeToLanguage.remove(mimeType);
                throw new LanguageDefinitionNotFoundException("Language definition for " + mimeType + " not found.");
            }
            this.addListener(fo);
            try {
                NBSLanguageReader reader = NBSLanguageReader.create(fo, mimeType);
                final LanguageImpl language = new LanguageImpl(mimeType, reader);
                language.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        LanguagesManager.initLanguage(language);
                        language.removePropertyChangeListener(this);
                    }
                });
                final String mimeType2 = mimeType;
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            language.read();
                        }
                        catch (ParseException ex) {
                            Utils.message("Editors/" + mimeType2 + "/language.nbs: " + ex.getMessage());
                        }
                        catch (IOException ex) {
                            Utils.message("Editors/" + mimeType2 + "/language.nbs: " + ex.getMessage());
                        }
                    }
                }, 2000);
                this.mimeTypeToLanguage.put(mimeType, language);
            }
            catch (IOException ex) {
                this.mimeTypeToLanguage.put(mimeType, Language.create(mimeType));
                Utils.message("Editors/" + mimeType + "/language.nbs: " + ex.getMessage());
            }
        }
        if (this.parsingLanguage == this.mimeTypeToLanguage.get(mimeType)) {
            throw new IllegalArgumentException();
        }
        return this.mimeTypeToLanguage.get(mimeType);
    }

    public void addLanguage(Language l) {
        this.mimeTypeToLanguage.put(l.getMimeType(), l);
    }

    private void languageChanged(String mimeType) {
        Language language = this.mimeTypeToLanguage.get(mimeType);
        if (language != null && language instanceof LanguageImpl) {
            try {
                FileSystem fs = Repository.getDefault().getDefaultFileSystem();
                FileObject fo = fs.findResource("Editors/" + mimeType + "/language.nbs");
                if (fo == null) {
                    this.mimeTypeToLanguage.remove(mimeType);
                    throw new LanguageDefinitionNotFoundException("Language definition for " + mimeType + " not found.");
                }
                NBSLanguageReader reader = NBSLanguageReader.create(fo, mimeType);
                ((LanguageImpl)language).read(reader);
            }
            catch (ParseException ex) {
                Utils.message("Editors/" + mimeType + "/language.nbs: " + ex.getMessage());
            }
            catch (IOException ex) {
                Utils.message("Editors/" + mimeType + "/language.nbs: " + ex.getMessage());
            }
        }
        ParserManagerImpl.refreshHack();
    }

    private void addListener(FileObject fo) {
        if (!this.listeningOn.contains(fo)) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            fo.addFileChangeListener((FileChangeListener)this.listener);
            this.listeningOn.add(fo);
        }
    }

    private static void initLanguage(final Language l) {
        try {
            final FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            final FileObject root = fs.findResource("Editors/" + l.getMimeType());
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block11: {
                        try {
                            String foldFileName;
                            if (root.getFileObject("SideBar/org-netbeans-modules-languages-features-CodeFoldingSideBarFactory.instance") == null && l.getFeatureList().getFeatures("FOLD").size() > 0) {
                                FileUtil.createData((FileObject)root, (String)"FoldManager/org-netbeans-modules-languages-features-LanguagesFoldManager$Factory.instance");
                                FileUtil.createData((FileObject)root, (String)"SideBar/org-netbeans-modules-languages-features-CodeFoldingSideBarFactory.instance").setAttribute("position", (Object)1000);
                            }
                            if (root.getFileObject("UpToDateStatusProvider/org-netbeans-modules-languages-features-UpToDateStatusProviderFactoryImpl.instance") == null) {
                                FileUtil.createData((FileObject)root, (String)"UpToDateStatusProvider/org-netbeans-modules-languages-features-UpToDateStatusProviderFactoryImpl.instance");
                            }
                            LanguagesManager.initPopupMenu(root, l);
                            if (l.getFeatureList().getFeatures("NAVIGATOR").size() > 0 && fs.findResource(foldFileName = "Navigator/Panels/" + l.getMimeType() + "/org-netbeans-modules-languages-features-LanguagesNavigator.instance") == null) {
                                FileUtil.createData((FileObject)fs.getRoot(), (String)foldFileName);
                            }
                            FileUtil.createData((FileObject)root, (String)"ToolTips/org-netbeans-modules-languages-features-ToolTipAnnotation.instance");
                            if (l.getFeatureList().getFeature("COMMENT_LINE") == null) break block11;
                            FileObject toolbarDefault = FileUtil.createFolder((FileObject)root, (String)"Toolbars/Default");
                            LanguagesManager.createSeparator(toolbarDefault, "Separator-before-comment", 30000);
                            FileUtil.createData((FileObject)toolbarDefault, (String)"comment").setAttribute("position", (Object)31000);
                            FileUtil.createData((FileObject)toolbarDefault, (String)"uncomment").setAttribute("position", (Object)32000);
                            if (root.getFileObject("Keybindings/NetBeans/Defaults/keybindings.xml") != null) break block11;
                            InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/netbeans/modules/languages/resources/DefaultKeyBindings.xml");
                            try {
                                FileObject bindings = FileUtil.createData((FileObject)root, (String)"Keybindings/NetBeans/Defaults/keybindings.xml");
                                OutputStream os = bindings.getOutputStream();
                                try {
                                    FileUtil.copy((InputStream)is, (OutputStream)os);
                                }
                                finally {
                                    os.close();
                                }
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException ex) {
                            Utils.notify(ex);
                        }
                    }
                }
            });
        }
        catch (IOException ex) {
            Utils.notify(ex);
        }
        ColorsManager.initColorings(l);
    }

    private static void initPopupMenu(FileObject root, Language l) throws IOException {
        List<Feature> actions = l.getFeatureList().getFeatures("ACTION");
        int selectInPos = LanguagesManager.findPositionOfDefaultPopupAction("org-netbeans-modules-editor-NbSelectInPopupAction.instance", 1000);
        int increment = (LanguagesManager.findPositionOfDefaultPopupAction("org-openide-actions-CutAction.instance", 2000) - selectInPos) / (actions.size() + 3);
        FileObject popup = FileUtil.createFolder((FileObject)root, (String)"Popup");
        int pos = selectInPos + increment;
        LanguagesManager.createSeparator(popup, "SeparatorAfterSelectInPopupAction", pos);
        boolean actionAdded = false;
        actionAdded = true;
        FileUtil.createData((FileObject)popup, (String)"org-netbeans-modules-languages-features-GoToDeclarationAction.instance").setAttribute("position", (Object)(pos += increment));
        if (l.getFeatureList().getFeatures("INDENT").size() > 0) {
            actionAdded = true;
            FileUtil.createData((FileObject)popup, (String)"format").setAttribute("position", (Object)(pos += increment));
        }
        for (Feature action : actions) {
            if (action.getBoolean("explorer", false)) continue;
            actionAdded = true;
            pos += increment;
            String name = action.getSelector().getAsString();
            String displayName = LocalizationSupport.localize(l, (String)action.getValue("name"));
            String performer = action.getMethodName("performer");
            String enabler = action.getMethodName("enabled");
            boolean separatorBefore = action.getBoolean("separator_before", false);
            boolean separatorAfter = action.getBoolean("separator_after", false);
            FileObject fobj = FileUtil.createData((FileObject)popup, (String)(name + ".instance"));
            fobj.setAttribute("instanceCreate", (Object)new ActionCreator(new Object[]{displayName, performer, enabler}));
            fobj.setAttribute("instanceClass", (Object)"org.netbeans.modules.languages.features.GenericAction");
            fobj.setAttribute("position", (Object)pos);
            if (separatorBefore) {
                LanguagesManager.createSeparator(popup, name + "_separator_before", pos - increment / 3);
            }
            if (!separatorAfter) continue;
            LanguagesManager.createSeparator(popup, name + "_separator_after", pos + increment / 3);
        }
        if (actionAdded) {
            LanguagesManager.createSeparator(popup, "SeparatorBeforeCut", pos + increment);
        }
        if (l.getFeatureList().getFeatures("FOLD").size() > 0) {
            FileUtil.createData((FileObject)popup, (String)"generate-fold-popup").setAttribute("position", (Object)(LanguagesManager.findPositionOfDefaultPopupAction("org-openide-actions-PasteAction.instance", 3000) + 50));
        }
    }

    private static int findPositionOfDefaultPopupAction(String name, int fallback) {
        Object pos;
        FileObject f = Repository.getDefault().getDefaultFileSystem().findResource("Editors/Popup/" + name);
        if (f != null && (pos = f.getAttribute("position")) instanceof Integer) {
            return (Integer)pos;
        }
        return fallback;
    }

    private static void createSeparator(FileObject folder, String name, int position) throws IOException {
        FileObject separator = FileUtil.createData((FileObject)folder, (String)(name + ".instance"));
        separator.setAttribute("instanceClass", (Object)"javax.swing.JSeparator");
        separator.setAttribute("position", (Object)position);
    }

    private class Listener
    implements FileChangeListener {
        private Listener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            FileObject fo = fe.getFile();
            String mimeType = fo.getParent().getParent().getName() + '/' + fo.getParent().getName();
            LanguagesManager.this.languageChanged(mimeType);
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            FileObject fo = fe.getFile();
            String mimeType = fo.getParent().getName();
            LanguagesManager.this.languageChanged(mimeType);
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }
    }
}

