/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.toolsui;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.api.tool.impl.DLightConfigurationManagerAccessor;
import org.netbeans.modules.dlight.toolsui.DLightToolUIWrapper;

public class DLightConfigurationUIWrapper {
    private DLightConfiguration dlightConfiguration;
    private boolean custom;
    private String name;
    private String displayName;
    private List<DLightToolUIWrapper> tools;
    private boolean modified;
    private DLightConfiguration copyOf;

    public DLightConfigurationUIWrapper(DLightConfiguration dlightConfiguration, List<DLightTool> allDLightTools) {
        this.dlightConfiguration = dlightConfiguration;
        this.name = dlightConfiguration.getConfigurationName();
        this.displayName = dlightConfiguration.getDisplayedName();
        this.custom = DLightConfigurationManagerAccessor.getDefault().canRemoveConfiguration(dlightConfiguration.getConfigurationName());
        this.copyOf = null;
        this.initWrapper(allDLightTools);
    }

    public DLightConfigurationUIWrapper(String name, String displayName, List<DLightTool> allDLightTools) {
        DLightConfigurationManagerAccessor accessor = DLightConfigurationManagerAccessor.getDefault();
        this.dlightConfiguration = accessor.getDefaultConfiguration();
        this.name = name;
        this.displayName = displayName;
        this.custom = true;
        this.copyOf = null;
        this.initWrapper(allDLightTools);
    }

    private void initWrapper(List<DLightTool> allDLightTools) {
        this.tools = new ArrayList<DLightToolUIWrapper>();
        List confDlightTools = this.dlightConfiguration.getToolsSet();
        boolean i = false;
        for (DLightTool dlightTool : allDLightTools) {
            DLightTool toolToAdd = DLightConfigurationUIWrapper.findTool(confDlightTools, dlightTool.getID());
            toolToAdd = toolToAdd == null ? dlightTool : toolToAdd;
            if (toolToAdd == null || !toolToAdd.isVisible()) continue;
            boolean canEnable = this.dlightConfiguration.getToolByID(dlightTool.getID()) != null;
            boolean enabled = toolToAdd.isEnabled() ? DLightConfigurationUIWrapper.inList(dlightTool, confDlightTools) : false;
            this.tools.add(new DLightToolUIWrapper(toolToAdd, enabled, canEnable));
        }
    }

    private static DLightTool findTool(List<DLightTool> tools, String id) {
        for (DLightTool tool : tools) {
            if (!tool.getID().equals(id)) continue;
            return tool;
        }
        return null;
    }

    private static boolean inList(DLightTool dlightTool, List<DLightTool> list) {
        for (DLightTool dt : list) {
            if (!dt.getID().equals(dlightTool.getID())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public DLightConfiguration getDLightConfiguration() {
        return this.dlightConfiguration;
    }

    public void setDLightConfiguration(DLightConfiguration dLightConfiguration) {
        this.dlightConfiguration = dLightConfiguration;
    }

    public List<DLightToolUIWrapper> getTools() {
        return this.tools;
    }

    public DLightToolUIWrapper getToolUIWrapper(DLightTool dlightTool) {
        for (DLightToolUIWrapper dt : this.getTools()) {
            if (!dt.getDLightTool().getID().equals(dlightTool.getID())) continue;
            return dt;
        }
        return null;
    }

    public void setTools(List<DLightToolUIWrapper> tools) {
        this.tools = tools;
    }

    public void setToolEnabled(DLightToolUIWrapper toolWrapper, boolean isEnabled) {
        toolWrapper.setEnabled(isEnabled);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public DLightConfigurationUIWrapper copy() {
        ArrayList<DLightTool> toolsCopy = new ArrayList<DLightTool>(this.getTools().size());
        for (DLightToolUIWrapper dltuWrapper : this.getTools()) {
            toolsCopy.add(dltuWrapper.getDLightTool());
        }
        DLightConfigurationUIWrapper copy = new DLightConfigurationUIWrapper(this.getDLightConfiguration(), toolsCopy);
        copy.setModified(false);
        return copy;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DLightConfiguration getCopyOf() {
        return this.copyOf;
    }

    public void setCopyOf(DLightConfiguration copyOf) {
        this.copyOf = copyOf;
    }
}

