/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing.lexer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.util.Exceptions;

public class LexUtilities {
    private static final Set<TokenId> INDENT_WORDS = new HashSet<TokenId>();

    private LexUtilities() {
    }

    public static TokenSequence<? extends JsCommentTokenId> getCommentFor(Snapshot snapshot, int n) {
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(snapshot, n);
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        while (tokenSequence.movePrevious()) {
            TokenId tokenId = tokenSequence.token().id();
            if (tokenId == JsTokenId.BLOCK_COMMENT) {
                return tokenSequence.embedded(JsCommentTokenId.language());
            }
            if (tokenId == JsTokenId.WHITESPACE || tokenId == JsTokenId.EOL) continue;
            return null;
        }
        return null;
    }

    public static int getLexerOffset(JsParseResult jsParseResult, int n) {
        return jsParseResult.getSnapshot().getOriginalOffset(n);
    }

    public static OffsetRange getLexerOffsets(JsParseResult jsParseResult, OffsetRange offsetRange) {
        int n = offsetRange.getStart();
        int n2 = jsParseResult.getSnapshot().getOriginalOffset(n);
        if (n2 == n) {
            return offsetRange;
        }
        if (n2 == -1) {
            return OffsetRange.NONE;
        }
        return new OffsetRange(n2, n2 + offsetRange.getLength());
    }

    public static TokenSequence<? extends JsTokenId> getNextJsTokenSequence(Document document, int n, int n2) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        return LexUtilities.findNextJsTokenSequence(tokenSequence, n, n2);
    }

    private static TokenSequence<? extends JsTokenId> findNextJsTokenSequence(TokenSequence<?> tokenSequence, int n, int n2) {
        if (tokenSequence.language() == JsTokenId.language()) {
            if (!tokenSequence.moveNext()) {
                return null;
            }
            return tokenSequence;
        }
        while (tokenSequence.moveNext() && tokenSequence.offset() <= n2) {
            int n3 = tokenSequence.offset();
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 == null) continue;
            tokenSequence2.move(n3);
            TokenSequence<? extends JsTokenId> tokenSequence3 = LexUtilities.findNextJsTokenSequence(tokenSequence2, n, n2);
            if (tokenSequence3 == null) continue;
            return tokenSequence3;
        }
        return null;
    }

    public static TokenSequence<? extends JsTokenId> getJsTokenSequence(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        return LexUtilities.getJsTokenSequence(tokenHierarchy, n);
    }

    public static TokenSequence<? extends JsTokenId> getJsTokenSequence(Snapshot snapshot, int n) {
        TokenHierarchy tokenHierarchy = snapshot.getTokenHierarchy();
        return LexUtilities.getJsTokenSequence(tokenHierarchy, n);
    }

    public static TokenSequence<? extends JsTokenId> getJsTokenSequence(TokenHierarchy<?> tokenHierarchy, int n) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JsTokenId.language());
        if (tokenSequence == null) {
            tokenSequence = tokenHierarchy.tokenSequence(JsTokenId.jsonLanguage());
        }
        if (tokenSequence == null) {
            List list = tokenHierarchy.embeddedTokenSequences(n, true);
            for (TokenSequence tokenSequence2 : list) {
                if (tokenSequence2.language() != JsTokenId.language()) continue;
                tokenSequence = tokenSequence2;
                break;
            }
            if (tokenSequence == null) {
                list = tokenHierarchy.embeddedTokenSequences(n, false);
                for (TokenSequence tokenSequence2 : list) {
                    if (tokenSequence2.language() != JsTokenId.language()) continue;
                    tokenSequence = tokenSequence2;
                    break;
                }
            }
        }
        return tokenSequence;
    }

    public static TokenSequence<? extends JsTokenId> getPositionedSequence(Document document, int n) {
        return LexUtilities.getPositionedSequence(document, n, true);
    }

    public static TokenSequence<? extends JsTokenId> getPositionedSequence(Snapshot snapshot, int n) {
        return LexUtilities.getPositionedSequence(snapshot, n, true);
    }

    public static TokenSequence<? extends JsTokenId> getPositionedSequence(Document document, int n, boolean bl) {
        return LexUtilities._getPosSeq(LexUtilities.getJsTokenSequence(document, n), n, bl);
    }

    public static TokenSequence<? extends JsTokenId> getPositionedSequence(Snapshot snapshot, int n, boolean bl) {
        return LexUtilities._getPosSeq(LexUtilities.getJsTokenSequence(snapshot, n), n, bl);
    }

    private static TokenSequence<? extends JsTokenId> _getPosSeq(TokenSequence<? extends JsTokenId> tokenSequence, int n, boolean bl) {
        if (tokenSequence != null) {
            tokenSequence.move(n);
            if (!bl && !tokenSequence.moveNext()) {
                return null;
            }
            if (bl && !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return null;
            }
            return tokenSequence;
        }
        return null;
    }

    public static Token<? extends JsTokenId> getToken(Document document, int n) {
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(document, n);
        if (tokenSequence != null) {
            return tokenSequence.token();
        }
        return null;
    }

    public static Token<? extends JsTokenId> getToken(Snapshot snapshot, int n) {
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(snapshot, n);
        if (tokenSequence != null) {
            return tokenSequence.token();
        }
        return null;
    }

    public static char getTokenChar(Document document, int n) {
        String string;
        Token<? extends JsTokenId> token = LexUtilities.getToken(document, n);
        if (token != null && (string = ((Object)token.text()).toString()).length() > 0) {
            return string.charAt(0);
        }
        return '\u0000';
    }

    public static Token<? extends JsTokenId> findNextNonWsNonComment(TokenSequence<? extends JsTokenId> tokenSequence) {
        return LexUtilities.findNext(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT));
    }

    public static Token<? extends JsTokenId> findPreviousNonWsNonComment(TokenSequence<? extends JsTokenId> tokenSequence) {
        return LexUtilities.findPrevious(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT));
    }

    public static Token<? extends JsTokenId> findNext(TokenSequence<? extends JsTokenId> tokenSequence, List<JsTokenId> list) {
        if (list.contains(tokenSequence.token().id())) {
            while (tokenSequence.moveNext() && list.contains(tokenSequence.token().id())) {
            }
        }
        return tokenSequence.token();
    }

    public static Token<? extends JsTokenId> findNextIncluding(TokenSequence<? extends JsTokenId> tokenSequence, List<JsTokenId> list) {
        while (tokenSequence.moveNext() && !list.contains(tokenSequence.token().id())) {
        }
        return tokenSequence.token();
    }

    public static Token<? extends JsTokenId> findPreviousIncluding(TokenSequence<? extends JsTokenId> tokenSequence, List<JsTokenId> list) {
        while (tokenSequence.movePrevious() && !list.contains(tokenSequence.token().id())) {
        }
        return tokenSequence.token();
    }

    public static Token<? extends JsTokenId> findPrevious(TokenSequence<? extends JsTokenId> tokenSequence, List<JsTokenId> list) {
        if (list.contains(tokenSequence.token().id())) {
            while (tokenSequence.movePrevious() && list.contains(tokenSequence.token().id())) {
            }
        }
        return tokenSequence.token();
    }

    static boolean skipParenthesis(TokenSequence<? extends JsTokenId> tokenSequence) {
        return LexUtilities.skipParenthesis(tokenSequence, false);
    }

    public static boolean skipParenthesis(TokenSequence<? extends JsTokenId> tokenSequence, boolean bl) {
        int n = 0;
        Token token = tokenSequence.token();
        if (token == null) {
            return false;
        }
        TokenId tokenId = token.id();
        if (tokenId == JsTokenId.WHITESPACE || tokenId == JsTokenId.EOL) {
            while ((bl ? tokenSequence.movePrevious() : tokenSequence.moveNext()) && (tokenSequence.token().id() == JsTokenId.WHITESPACE || tokenSequence.token().id() == JsTokenId.EOL)) {
            }
        }
        if (tokenSequence.token().id() != (bl ? JsTokenId.RPAREN : JsTokenId.LPAREN)) {
            return false;
        }
        do {
            if ((tokenId = (token = tokenSequence.token()).id()) == (bl ? JsTokenId.RPAREN : JsTokenId.LPAREN)) {
                ++n;
                continue;
            }
            if (tokenId != (bl ? JsTokenId.LPAREN : JsTokenId.RPAREN)) continue;
            if (n == 0) {
                return false;
            }
            if (n == 1) {
                if (bl) {
                    tokenSequence.movePrevious();
                } else {
                    tokenSequence.moveNext();
                }
                return true;
            }
            --n;
        } while (!bl ? tokenSequence.moveNext() : tokenSequence.movePrevious());
        return false;
    }

    public static OffsetRange findFwd(Document document, TokenSequence<? extends JsTokenId> tokenSequence, TokenId tokenId, TokenId tokenId2) {
        int n = 0;
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            TokenId tokenId3 = token.id();
            if (tokenId3 == tokenId) {
                ++n;
                continue;
            }
            if (tokenId3 != tokenId2) continue;
            if (n == 0) {
                return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
            }
            --n;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBwd(Document document, TokenSequence<? extends JsTokenId> tokenSequence, TokenId tokenId, TokenId tokenId2) {
        int n = 0;
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            TokenId tokenId3 = token.id();
            if (tokenId3 == tokenId) {
                if (n == 0) {
                    return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
                }
                ++n;
                continue;
            }
            if (tokenId3 != tokenId2) continue;
            --n;
        }
        return OffsetRange.NONE;
    }

    private static OffsetRange findMultilineRange(TokenSequence<? extends JsTokenId> tokenSequence) {
        int n = tokenSequence.offset();
        JsTokenId jsTokenId = (JsTokenId)tokenSequence.token().id();
        switch (jsTokenId) {
            case ELSE: {
                tokenSequence.moveNext();
                jsTokenId = (JsTokenId)tokenSequence.token().id();
                break;
            }
            case IF: 
            case FOR: 
            case WHILE: {
                tokenSequence.moveNext();
                if (!LexUtilities.skipParenthesis(tokenSequence, false)) {
                    return OffsetRange.NONE;
                }
                jsTokenId = (JsTokenId)tokenSequence.token().id();
                break;
            }
            default: {
                return OffsetRange.NONE;
            }
        }
        boolean bl = false;
        int n2 = tokenSequence.offset();
        if (jsTokenId == JsTokenId.WHITESPACE || jsTokenId == JsTokenId.LINE_COMMENT || jsTokenId == JsTokenId.BLOCK_COMMENT || jsTokenId == JsTokenId.EOL) {
            if (tokenSequence.token().id() == JsTokenId.EOL) {
                n2 = tokenSequence.offset();
                bl = true;
            }
            while (tokenSequence.moveNext() && (tokenSequence.token().id() == JsTokenId.WHITESPACE || tokenSequence.token().id() == JsTokenId.LINE_COMMENT || tokenSequence.token().id() == JsTokenId.EOL || tokenSequence.token().id() == JsTokenId.BLOCK_COMMENT)) {
                if (tokenSequence.token().id() != JsTokenId.EOL) continue;
                n2 = tokenSequence.offset();
                bl = true;
            }
        }
        if (tokenSequence.token() == null || tokenSequence.token().id() != JsTokenId.LBRACE && bl) {
            return new OffsetRange(n, n2);
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange getMultilineRange(Document document, TokenSequence<? extends JsTokenId> tokenSequence) {
        int n = tokenSequence.index();
        OffsetRange offsetRange = LexUtilities.findMultilineRange(tokenSequence);
        tokenSequence.moveIndex(n);
        tokenSequence.moveNext();
        return offsetRange;
    }

    public static boolean isIndentToken(TokenId tokenId) {
        return INDENT_WORDS.contains(tokenId);
    }

    public static int getLineBalance(BaseDocument baseDocument, int n, TokenId tokenId, TokenId tokenId2) {
        try {
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
            TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence((Document)baseDocument, n2);
            if (tokenSequence == null) {
                return 0;
            }
            tokenSequence.move(n2);
            if (!tokenSequence.moveNext()) {
                return 0;
            }
            int n4 = 0;
            do {
                Token token;
                TokenId tokenId3;
                if ((tokenId3 = (token = tokenSequence.token()).id()) == tokenId) {
                    ++n4;
                    continue;
                }
                if (tokenId3 != tokenId2) continue;
                --n4;
            } while (tokenSequence.moveNext() && tokenSequence.offset() <= n3);
            return n4;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return 0;
        }
    }

    public static int getTokenBalance(Document document, TokenId tokenId, TokenId tokenId2, int n) throws BadLocationException {
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(document, 0);
        if (tokenSequence == null) {
            return 0;
        }
        tokenSequence.moveIndex(0);
        if (!tokenSequence.moveNext()) {
            return 0;
        }
        int n2 = 0;
        do {
            Token token;
            if ((token = tokenSequence.token()).id() == tokenId) {
                ++n2;
                continue;
            }
            if (token.id() != tokenId2) continue;
            --n2;
        } while (tokenSequence.moveNext());
        return n2;
    }

    public static boolean isCommentOnlyLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 == -1) {
            return false;
        }
        Token<? extends JsTokenId> token = LexUtilities.getToken((Document)baseDocument, n2);
        if (token != null) {
            return token.id() == JsTokenId.LINE_COMMENT;
        }
        return false;
    }

    public static boolean isCommentOnlyLine(Snapshot snapshot, int n) throws BadLocationException {
        int n2 = GsfUtilities.getRowFirstNonWhite((CharSequence)snapshot.getText(), (int)n);
        if (n2 == -1) {
            return false;
        }
        Token<? extends JsTokenId> token = LexUtilities.getToken(snapshot, n2);
        if (token != null) {
            return token.id() == JsTokenId.LINE_COMMENT;
        }
        return false;
    }

    public static OffsetRange getCommentBlock(Snapshot snapshot, int n, boolean bl) {
        block13: {
            try {
                TokenSequence tokenSequence = snapshot.getTokenHierarchy().tokenSequence(JsTokenId.language());
                if (tokenSequence == null) {
                    return OffsetRange.NONE;
                }
                tokenSequence.move(n);
                if (bl) {
                    while (tokenSequence.movePrevious()) {
                        TokenId tokenId = tokenSequence.token().id();
                        if (tokenId == JsTokenId.BLOCK_COMMENT || tokenId == JsTokenId.LINE_COMMENT) {
                            return LexUtilities.getCommentBlock(snapshot, tokenSequence.offset(), false);
                        }
                        if (tokenId == JsTokenId.WHITESPACE || tokenId == JsTokenId.EOL) continue;
                        return OffsetRange.NONE;
                    }
                    return OffsetRange.NONE;
                }
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return null;
                }
                Token token = tokenSequence.token();
                if (token != null && token.id() == JsTokenId.BLOCK_COMMENT) {
                    return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
                }
                if (token == null || token.id() != JsTokenId.LINE_COMMENT) break block13;
                CharSequence charSequence = snapshot.getText();
                int n2 = GsfUtilities.getRowStart((CharSequence)charSequence, (int)n);
                int n3 = GsfUtilities.getRowEnd((CharSequence)charSequence, (int)n);
                if (LexUtilities.isCommentOnlyLine(snapshot, n)) {
                    int n4;
                    while (n2 > 0) {
                        n4 = GsfUtilities.getRowStart((CharSequence)charSequence, (int)(n2 - 1));
                        if (n4 < 0 || !LexUtilities.isCommentOnlyLine(snapshot, n4)) {
                            n2 = GsfUtilities.getRowFirstNonWhite((CharSequence)charSequence, (int)n2);
                            break;
                        }
                        n2 = n4;
                    }
                    n4 = charSequence.length();
                    while (true) {
                        int n5;
                        if ((n5 = GsfUtilities.getRowEnd((CharSequence)charSequence, (int)(n3 + 1))) >= n4 || !LexUtilities.isCommentOnlyLine(snapshot, n5)) break;
                        n3 = n5;
                    }
                    n3 = GsfUtilities.getRowLastNonWhite((CharSequence)charSequence, (int)n3) + 1;
                    if (n2 < n3) {
                        return new OffsetRange(n2, n3);
                    }
                    break block13;
                }
                return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return OffsetRange.NONE;
    }

    public static int findSpaceBegin(BaseDocument baseDocument, int n) {
        int n2;
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence((Document)baseDocument, n);
        if (tokenSequence == null) {
            return n;
        }
        boolean bl = false;
        try {
            int n3;
            n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)Math.min(n, baseDocument.getLength()));
            int n4 = n2 - 1;
            if (n2 > 0 && (n4 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)(n2 - 1))) != -1 && (n3 = (int)baseDocument.getText(n4, 1).charAt(0)) == 44) {
                bl = true;
            }
            if (!bl) {
                n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                if (n <= n3 || n3 == -1) {
                    return n;
                }
            } else {
                n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                if (n4 >= 0 && (n <= n3 || n3 == -1)) {
                    return n4 + 1;
                }
                n2 = 0;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return n;
        }
        tokenSequence.move(n);
        if (tokenSequence.moveNext()) {
            if (n > tokenSequence.offset()) {
                return Math.max(tokenSequence.token().id() == JsTokenId.WHITESPACE ? tokenSequence.offset() : n, n2);
            }
            while (tokenSequence.movePrevious()) {
                Token token = tokenSequence.token();
                if (token.id() == JsTokenId.WHITESPACE) continue;
                return Math.max(tokenSequence.offset() + token.length(), n2);
            }
        }
        return n;
    }

    public static List<String> gatherDocumentation(JsParseResult jsParseResult, int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = n;
        try {
            int n3;
            int n4;
            String string;
            CharSequence charSequence = jsParseResult.getSnapshot().getText();
            if (n2 < 0 || n2 >= charSequence.length()) {
                return null;
            }
            int n5 = GsfUtilities.getRowStart((CharSequence)charSequence, (int)n2);
            --n5;
            while (n5 >= 0 && (GsfUtilities.isRowEmpty((CharSequence)charSequence, (int)(n5 = GsfUtilities.getRowStart((CharSequence)charSequence, (int)n5))) || GsfUtilities.isRowWhite((CharSequence)charSequence, (int)n5))) {
                --n5;
            }
            if (n5 < 0) {
                return null;
            }
            while (n5 >= 0 && !GsfUtilities.isRowEmpty((CharSequence)charSequence, (int)(n5 = GsfUtilities.getRowStart((CharSequence)charSequence, (int)n5))) && !GsfUtilities.isRowWhite((CharSequence)charSequence, (int)n5) && (string = ((Object)charSequence.subSequence(n4 = GsfUtilities.getRowFirstNonWhite((CharSequence)charSequence, (int)n5), n3 = GsfUtilities.getRowLastNonWhite((CharSequence)charSequence, (int)n5) + 1)).toString()).startsWith("*")) {
                if (string.length() == 1 || string.length() > 1 && string.charAt(1) != '/') {
                    linkedList.addFirst(string.substring(1).trim());
                }
                --n5;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return linkedList;
    }

    static {
        INDENT_WORDS.add(JsTokenId.FOR);
        INDENT_WORDS.add(JsTokenId.IF);
        INDENT_WORDS.add(JsTokenId.ELSE);
        INDENT_WORDS.add(JsTokenId.WHILE);
    }
}

