/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.palette;

import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.ComponentSerializationSupport;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.DefaultDataFlavor;
import org.netbeans.modules.vmd.api.palette.PaletteProvider;
import org.netbeans.modules.vmd.palette.PaletteItemDataNode;
import org.netbeans.modules.vmd.palette.PaletteItemDataObject;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.netbeans.spi.palette.PaletteFilter;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.ExTransferable;

public class PaletteKit
implements Runnable,
LookupListener {
    static final String CUSTOM_CATEGORY_NAME = "custom";
    private static final String PALETTE_FOLDER_NAME = "palette";
    private static final RequestProcessor RP = new RequestProcessor(PaletteKit.class);
    private WeakReference<DesignDocument> activeDocument;
    private PaletteController paletteController;
    private DNDHandler dndHandler;
    private Map<String, PaletteItemDataNode> nodesMap;
    private boolean isValidationRunning;
    private LinkedList<Lookup> validationQueue;
    private DataFolder rootFolder;
    private Lookup.Result<PaletteProvider> lookupResult;
    private final AtomicBoolean requiresPaletteInit = new AtomicBoolean(false);

    PaletteKit(String projectType) {
        this.validationQueue = new LinkedList();
        this.lookupResult = Lookup.getDefault().lookupResult(PaletteProvider.class);
        this.lookupResult.addLookupListener((LookupListener)this);
        String rootFolderPath = projectType + '/' + PALETTE_FOLDER_NAME;
        this.nodesMap = new HashMap<String, PaletteItemDataNode>();
        try {
            FileObject rootFolderFO = FileUtil.getConfigFile((String)rootFolderPath);
            if (rootFolderFO == null) {
                FileObject projectTypeFO = FileUtil.getConfigFile((String)projectType);
                if (projectTypeFO == null) {
                    projectTypeFO = FileUtil.getConfigRoot().createFolder(projectType);
                }
                rootFolderFO = FileUtil.createFolder((FileObject)projectTypeFO, (String)PALETTE_FOLDER_NAME);
            }
            this.rootFolder = DataFolder.findFolder((FileObject)rootFolderFO);
            this.rootFolder.getPrimaryFile().setAttribute("itemWidth", (Object)"120");
            this.dndHandler = new DNDHandler();
            this.paletteController = PaletteFactory.createPalette((String)rootFolderPath, (PaletteActions)new Actions(), (PaletteFilter)new Filter(), (DragAndDropHandler)this.dndHandler);
        }
        catch (IOException ex) {
            throw Debug.error((Object[])new Object[]{ex});
        }
    }

    synchronized void clean() {
        if (this.activeDocument == null || this.activeDocument.get() == null) {
            return;
        }
        String projectID = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectID();
        String projectType = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectType();
        final DescriptorRegistry registry = DescriptorRegistry.getDescriptorRegistry((String)projectType, (String)projectID);
        registry.readAccess(new Runnable(){

            @Override
            public void run() {
                List list = registry.getComponentProducers();
                HashMap<String, ComponentProducer> producers = new HashMap<String, ComponentProducer>(list.size());
                for (ComponentProducer producer : list) {
                    producers.put(producer.getProducerID(), producer);
                }
                PaletteKit.this.cleanCore(producers);
            }
        });
    }

    private void cleanCore(Map<String, ComponentProducer> producers) {
        try {
            for (FileObject catFolder : this.rootFolder.getPrimaryFile().getChildren()) {
                for (FileObject item : catFolder.getChildren()) {
                    item.delete();
                }
            }
        }
        catch (IOException ex) {
            Debug.warning((Object[])new Object[]{ex});
        }
    }

    synchronized void refresh() {
        this.refreshFO(this.rootFolder.getPrimaryFile());
    }

    private void refreshFO(FileObject fo) {
        if (fo.isFolder()) {
            for (FileObject fileObject : fo.getChildren()) {
                this.refreshFO(fileObject);
            }
        } else {
            fo.refresh();
        }
    }

    synchronized void refreshDescriptorRegistry() {
        if (this.activeDocument == null || this.activeDocument.get() == null) {
            return;
        }
        String projectType = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectType();
        ComponentSerializationSupport.refreshDescriptorRegistry((String)projectType);
    }

    public PaletteController getPaletteController() {
        return this.paletteController;
    }

    public DragAndDropHandler getDndHandler() {
        return this.dndHandler;
    }

    void refreshPaletteController() {
        if (this.paletteController == null) {
            return;
        }
        this.paletteController.refresh();
    }

    synchronized void init() {
        if (this.activeDocument == null || this.activeDocument.get() == null) {
            return;
        }
        if (this.requiresPaletteInit.getAndSet(true)) {
            return;
        }
        String projectID = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectID();
        final String projectType = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectType();
        final DescriptorRegistry registry = DescriptorRegistry.getDescriptorRegistry((String)projectType, (String)projectID);
        registry.readAccess(new Runnable(){

            @Override
            public void run() {
                while (PaletteKit.this.requiresPaletteInit.getAndSet(false)) {
                    Collection providers = PaletteKit.this.lookupResult.allInstances();
                    for (PaletteProvider provider : providers) {
                        if (provider == null) continue;
                        provider.initPaletteCategories(projectType);
                    }
                    PaletteKit.this.initCore(registry.getComponentProducers());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCore(List<ComponentProducer> producers) {
        FileObject[] children = this.rootFolder.getPrimaryFile().getChildren();
        HashMap<String, FileObject> categoryFolders = new HashMap<String, FileObject>(children.length);
        for (FileObject fo : children) {
            categoryFolders.put(fo.getName(), fo);
        }
        for (ComponentProducer producer : producers) {
            FileObject catFO;
            if (producer.getPaletteDescriptor() == null) continue;
            String producerID = producer.getProducerID();
            String catID = producer.getPaletteDescriptor().getCategoryID();
            if (catID != null) {
                catFO = (FileObject)categoryFolders.get(catID);
            } else {
                catFO = (FileObject)categoryFolders.get(CUSTOM_CATEGORY_NAME);
                if (catFO == null) continue;
            }
            if (catFO == null) {
                Debug.warning((Object[])new Object[]{catID + " should be initialized! See MidpPaletteProvider."});
                try {
                    catFO = DataFolder.create((DataFolder)this.rootFolder, (String)catID).getPrimaryFile();
                }
                catch (IOException ex) {
                    Debug.warning((Object[])new Object[]{"Can't create folder for palette category: " + ex});
                }
            }
            try {
                catFO.setAttribute("isReadonly", (Object)"true");
            }
            catch (IOException ex) {
                Debug.warning((Object[])new Object[]{"Can't set attributes for palette category folder", ex});
            }
            StringBuffer path = new StringBuffer();
            path.append(catFO.getPath());
            path.append('/');
            path.append(producerID);
            path.append('.');
            path.append("vmd_palette");
            if (FileUtil.getConfigFile((String)path.toString()) != null) continue;
            try {
                FileObject itemFO = catFO.createData(producerID, "vmd_palette");
                Properties props = new Properties();
                props.setProperty("producerID", producerID);
                String displayName = producer.getPaletteDescriptor().getDisplayName();
                props.setProperty("displayName", displayName != null ? displayName : "");
                String toolTip = producer.getPaletteDescriptor().getToolTip();
                props.setProperty("toolTip", toolTip != null ? toolTip : "");
                String icon = producer.getPaletteDescriptor().getSmallIcon();
                props.setProperty("icon", icon != null ? icon : "");
                String largeIcon = producer.getPaletteDescriptor().getLargeIcon();
                props.setProperty("bigIcon", largeIcon != null ? largeIcon : "");
                FileLock lock = itemFO.lock();
                OutputStream os = null;
                try {
                    os = itemFO.getOutputStream(lock);
                    props.store(os, "VMD Palette Item");
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                    lock.releaseLock();
                }
            }
            catch (IOException e) {
                StringBuffer str = new StringBuffer();
                str.append("Can't create file for palette item: ");
                str.append(path);
                str.append(", ");
                str.append(producerID);
                str.append(".");
                str.append("vmd_palette");
                str.append(": ");
                str.append(e);
                Debug.warning((Object[])new Object[]{str.toString()});
            }
        }
    }

    void checkValidity(Lookup lookup) {
        PaletteItemDataNode node = (PaletteItemDataNode)((Object)lookup.lookup(PaletteItemDataNode.class));
        assert (node != null);
        String producerID = node.getProducerID();
        if (producerID == null) {
            node.setNeedCheck(false);
            node.setValid(false);
            return;
        }
        if (!this.nodesMap.containsKey(producerID)) {
            this.nodesMap.put(producerID, node);
        }
        node.setNeedCheck(false);
        this.scheduleCheckValidityCore(lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCheckValidityCore(Lookup lookup) {
        LinkedList<Lookup> linkedList = this.validationQueue;
        synchronized (linkedList) {
            this.validationQueue.add(lookup);
            if (this.isValidationRunning) {
                return;
            }
            this.isValidationRunning = true;
        }
        RP.post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Lookup lookup;
            LinkedList<Lookup> linkedList = this.validationQueue;
            synchronized (linkedList) {
                if (this.validationQueue.isEmpty()) {
                    this.isValidationRunning = false;
                    break;
                }
                lookup = this.validationQueue.remove();
            }
            this.checkValidityCore(lookup);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PaletteKit.this.refreshPaletteController();
            }
        });
    }

    private void checkValidityCore(Lookup lookup) {
        if (this.activeDocument == null || this.activeDocument.get() == null) {
            return;
        }
        PaletteItemDataNode node = (PaletteItemDataNode)((Object)lookup.lookup(PaletteItemDataNode.class));
        if (node == null) {
            return;
        }
        final String producerID = node.getProducerID();
        String projectID = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectID();
        String projectType = ((DesignDocument)this.activeDocument.get()).getDocumentInterface().getProjectType();
        final ComponentProducer[] result = new ComponentProducer[1];
        final DescriptorRegistry registry = DescriptorRegistry.getDescriptorRegistry((String)projectType, (String)projectID);
        registry.readAccess(new Runnable(){

            @Override
            public void run() {
                List producers = registry.getComponentProducers();
                ComponentProducer producer = null;
                for (ComponentProducer p : producers) {
                    if (!p.getProducerID().equals(producerID)) continue;
                    producer = p;
                    break;
                }
                result[0] = producer;
            }
        });
        Boolean isValid = result[0] != null;
        if (isValid.booleanValue()) {
            isValid = result[0].checkValidity((DesignDocument)this.activeDocument.get(), false);
        }
        node.setValid(isValid == null || isValid != false);
    }

    void clearNodesStateCache() {
        for (PaletteItemDataNode node : this.nodesMap.values()) {
            node.setNeedCheck(true);
            node.setValid(true);
        }
    }

    void setActiveDocument(DesignDocument activeDocument) {
        this.activeDocument = new WeakReference<DesignDocument>(activeDocument);
    }

    public void resultChanged(LookupEvent ev) {
        this.init();
    }

    private class DNDHandler
    extends DragAndDropHandler {
        private DNDHandler() {
        }

        public void customize(final ExTransferable t, Lookup item) {
            if (PaletteKit.this.activeDocument == null || PaletteKit.this.activeDocument.get() == null) {
                return;
            }
            PaletteItemDataObject itemDataObject = (PaletteItemDataObject)((Object)item.lookup(PaletteItemDataObject.class));
            if (itemDataObject == null) {
                return;
            }
            final String producerID = itemDataObject.getProducerID();
            String projectID = ((DesignDocument)PaletteKit.this.activeDocument.get()).getDocumentInterface().getProjectID();
            String projectType = ((DesignDocument)PaletteKit.this.activeDocument.get()).getDocumentInterface().getProjectType();
            final DescriptorRegistry registry = DescriptorRegistry.getDescriptorRegistry((String)projectType, (String)projectID);
            registry.readAccess(new Runnable(){

                @Override
                public void run() {
                    List producers = registry.getComponentProducers();
                    final ComponentProducer[] producer = new ComponentProducer[1];
                    for (ComponentProducer p : producers) {
                        if (!p.getProducerID().equals(producerID)) continue;
                        producer[0] = p;
                        break;
                    }
                    if (producer[0] != null) {
                        DefaultDataFlavor dataFlavor = new DefaultDataFlavor(producer[0]);
                        t.put(new ExTransferable.Single((DataFlavor)dataFlavor){

                            protected Object getData() {
                                return producer[0].getProducerID();
                            }
                        });
                    }
                }
            });
        }
    }

    private class Filter
    extends PaletteFilter {
        private Filter() {
        }

        public boolean isValidCategory(Lookup lkp) {
            return true;
        }

        public boolean isValidItem(Lookup lkp) {
            PaletteItemDataNode node = (PaletteItemDataNode)((Object)lkp.lookup(PaletteItemDataNode.class));
            return node == null || node.isValid();
        }
    }

    private class Actions
    extends PaletteActions {
        private Actions() {
        }

        public Action[] getImportActions() {
            if (PaletteKit.this.activeDocument == null || PaletteKit.this.activeDocument.get() == null) {
                return null;
            }
            String projectType = ((DesignDocument)PaletteKit.this.activeDocument.get()).getDocumentInterface().getProjectType();
            Collection providers = Lookup.getDefault().lookupAll(PaletteProvider.class);
            ArrayList<? extends Action> actions = new ArrayList<Action>();
            for (PaletteProvider paletteProvider : providers) {
                List<? extends Action> list = paletteProvider.getActions(projectType);
                if (list == null) continue;
                actions.addAll(list);
            }
            return actions.toArray(new Action[actions.size()]);
        }

        public Action[] getCustomPaletteActions() {
            return new Action[0];
        }

        public Action[] getCustomCategoryActions(Lookup category) {
            return new Action[0];
        }

        public Action[] getCustomItemActions(Lookup item) {
            return new Action[0];
        }

        public Action getPreferredAction(Lookup item) {
            return null;
        }

        public Action getRefreshAction() {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PaletteKit.this.refreshDescriptorRegistry();
                    PaletteKit.this.refresh();
                }
            };
        }

        public Action getResetAction() {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PaletteKit.this.refreshDescriptorRegistry();
                    try {
                        FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                            public void run() {
                                PaletteKit.this.clean();
                                PaletteKit.this.init();
                            }
                        });
                    }
                    catch (IOException e) {
                        Debug.warning((Object[])new Object[]{e});
                    }
                }
            };
        }
    }
}

