/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.spi.project.support.GenericSources;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class TestDataDirsNodeFactory
implements NodeFactory {
    public NodeList<?> createNodes(Project p) {
        NbModuleProject prj = (NbModuleProject)p.getLookup().lookup(NbModuleProject.class);
        return new TestDataDirsNL(prj);
    }

    private static class TestDataDirsNL
    implements NodeList<SourceGroup> {
        private final NbModuleProject project;

        public TestDataDirsNL(NbModuleProject project) {
            this.project = project;
        }

        public List<SourceGroup> keys() {
            ArrayList<SourceGroup> keys = new ArrayList<SourceGroup>();
            for (String testType : this.project.supportedTestTypes()) {
                FileObject root;
                String dataDir = this.project.evaluator().getProperty("test." + testType + ".data.dir");
                if (dataDir == null || (root = this.project.getHelper().resolveFileObject(dataDir)) == null) continue;
                String displayName = NbBundle.getMessage(TestDataDirsNodeFactory.class, (String)("TestDataDirsNodeFactory." + testType + "_test_data"));
                keys.add(GenericSources.group((Project)this.project, (FileObject)root, (String)testType, (String)displayName, null, null));
            }
            return keys;
        }

        public Node node(final SourceGroup key) {
            try {
                return new FilterNode(DataObject.find((FileObject)key.getRootFolder()).getNodeDelegate()){

                    public String getName() {
                        return key.getName();
                    }

                    public String getDisplayName() {
                        return key.getDisplayName();
                    }
                };
            }
            catch (DataObjectNotFoundException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public void addNotify() {
        }

        public void removeNotify() {
        }
    }
}

