/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ModuleOperations;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public final class ModuleActions
implements ActionProvider {
    static final String TEST_USERDIR_LOCK_PROP_NAME = "run.args.ide";
    static final String TEST_USERDIR_LOCK_PROP_VALUE = "--test-userdir-lock-with-invalid-arg";
    static final Set<String> bkgActions = new HashSet<String>(Arrays.asList("run.single", "debug.single"));
    private final NbModuleProject project;
    private final Map<String, String[]> globalCommands = new HashMap<String, String[]>();
    private String[] supportedActions = null;
    private static final Pattern SRCDIRJAVA = Pattern.compile("\\.java$");
    private static final String SUBST = "Test.java";
    private static final String SYSTEM_PROPERTY_PREFIX = "test-unit-sys-prop.";

    static Action[] getProjectActions(NbModuleProject project) {
        boolean isNetBeansOrg;
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(CommonProjectActions.newFileAction());
        actions.add(null);
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_build"), null));
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_rebuild"), null));
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_clean"), null));
        actions.add(null);
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_run"), null));
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_debug"), null));
        actions.addAll(Utilities.actionsForPath((String)"Projects/Profiler_Actions_temporary"));
        if (project.supportedTestTypes().contains("unit")) {
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_test"), null));
        }
        actions.add(null);
        boolean bl = isNetBeansOrg = Util.getModuleType(project) == NbModuleProvider.NETBEANS_ORG;
        if (isNetBeansOrg) {
            actions.add(ModuleActions.createCheckBundleAction(project, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_unused_bundle_keys")));
            actions.add(null);
        }
        actions.add(ModuleActions.createReloadAction(project, new String[]{"reload"}, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_reload"), false));
        actions.add(ModuleActions.createReloadAction(project, new String[]{"reload-in-ide"}, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_reload_in_ide"), true));
        actions.add(ModuleActions.createSimpleAction(project, new String[]{"nbm"}, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_nbm")));
        actions.add(null);
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_javadoc"), null));
        actions.add(ModuleActions.createArchAction(project));
        actions.add(null);
        actions.add(CommonProjectActions.setAsMainProjectAction());
        actions.add(CommonProjectActions.openSubprojectsAction());
        actions.add(CommonProjectActions.closeProjectAction());
        actions.add(null);
        actions.add(CommonProjectActions.renameProjectAction());
        actions.add(CommonProjectActions.moveProjectAction());
        actions.add(CommonProjectActions.copyProjectAction());
        actions.add(CommonProjectActions.deleteProjectAction());
        actions.add(null);
        actions.add((Action)SystemAction.get(FindAction.class));
        actions.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
        actions.add(null);
        actions.add(CommonProjectActions.customizeProjectAction());
        return actions.toArray(new Action[actions.size()]);
    }

    public ModuleActions(NbModuleProject project) {
        this.project = project;
        this.refresh();
    }

    public void refresh() {
        HashSet<String> supportedActionsSet = new HashSet<String>();
        this.globalCommands.put("build", new String[]{"netbeans"});
        this.globalCommands.put("clean", new String[]{"clean"});
        if ("mkleint".equals(System.getProperty("user.name"))) {
            this.globalCommands.put("rebuild", new String[]{"clean", "netbeans", "do-test-build"});
        } else {
            this.globalCommands.put("rebuild", new String[]{"clean", "netbeans"});
        }
        this.globalCommands.put("run", new String[]{"run"});
        this.globalCommands.put("debug", new String[]{"debug"});
        this.globalCommands.put("profile", new String[]{"profile"});
        this.globalCommands.put("javadoc", new String[]{"javadoc-nb"});
        if (this.project.supportedTestTypes().contains("unit")) {
            this.globalCommands.put("test", new String[]{"test-unit"});
        }
        supportedActionsSet.addAll(this.globalCommands.keySet());
        supportedActionsSet.add("compile.single");
        supportedActionsSet.add("debug.fix");
        if (!this.project.supportedTestTypes().isEmpty()) {
            supportedActionsSet.add("test.single");
            supportedActionsSet.add("debug.test.single");
            supportedActionsSet.add("run.single");
            supportedActionsSet.add("debug.single");
            supportedActionsSet.add("run.single.method");
            supportedActionsSet.add("debug.single.method");
        }
        supportedActionsSet.add("rename");
        supportedActionsSet.add("move");
        supportedActionsSet.add("copy");
        supportedActionsSet.add("delete");
        this.supportedActions = supportedActionsSet.toArray(new String[supportedActionsSet.size()]);
    }

    public String[] getSupportedActions() {
        return this.supportedActions;
    }

    private static FileObject findBuildXml(NbModuleProject project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if ("delete".equals(command) || "rename".equals(command) || "move".equals(command) || "copy".equals(command)) {
            return true;
        }
        if (ModuleActions.findBuildXml(this.project) == null) {
            return false;
        }
        if (command.equals("compile.single")) {
            return this.findSources(context) != null || this.findTestSources(context, false) != null;
        }
        if (command.equals("test.single")) {
            return this.findTestSourcesForSources(context) != null || this.findTestSources(context, false) != null;
        }
        if (command.equals("debug.test.single")) {
            TestSources testSources = this.findTestSourcesForSources(context);
            if (testSources == null) {
                testSources = this.findTestSources(context, false);
            }
            return testSources != null && testSources.sources.length == 1;
        }
        if (command.equals("run.single")) {
            return this.findTestSources(context, false) != null;
        }
        if (command.equals("debug.single")) {
            TestSources testSources = this.findTestSources(context, false);
            return testSources != null && testSources.sources.length == 1;
        }
        if (command.equals("run.single.method") || command.equals("debug.single.method")) {
            NbPlatform plaf = this.project.getPlatform(false);
            if (plaf == null || plaf.getHarnessVersion().compareTo(HarnessVersion.V70) < 0) {
                return false;
            }
            return this.findTestMethodSources(context) != null;
        }
        if (command.equals("debug.fix")) {
            FileObject[] files = this.findSources(context);
            if (files != null && files.length == 1) {
                return true;
            }
            TestSources testSources = this.findTestSources(context, false);
            return testSources != null && testSources.sources.length == 1;
        }
        return true;
    }

    private FileObject[] findSources(Lookup context) {
        FileObject srcDir = this.project.getSourceDirectory();
        if (srcDir != null) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcDir, (String)".java", (boolean)true);
            return files;
        }
        return null;
    }

    private TestSources findTestSources(Lookup context, boolean checkInSrcDir) {
        for (String testType : this.project.supportedTestTypes()) {
            FileObject[] files;
            FileObject testSrcDir = this.project.getTestSourceDirectory(testType);
            if (testSrcDir == null || (files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)testSrcDir, (String)".java", (boolean)true)) == null) continue;
            return new TestSources(files, testType, testSrcDir);
        }
        if (checkInSrcDir) {
            FileObject[] files2;
            FileObject[] files;
            FileObject srcDir = this.project.getSourceDirectory();
            FileObject testSrcDir = this.project.getTestSourceDirectory("unit");
            if (srcDir != null && testSrcDir != null && (files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcDir, (String)".java", (boolean)true)) != null && (files2 = ActionUtils.regexpMapFiles((FileObject[])files, (FileObject)srcDir, (Pattern)SRCDIRJAVA, (FileObject)testSrcDir, (String)SUBST, (boolean)true)) != null) {
                return new TestSources(files2, "unit", testSrcDir);
            }
        }
        return null;
    }

    private TestSources findTestMethodSources(Lookup context) {
        SingleMethod meth = (SingleMethod)context.lookup(SingleMethod.class);
        if (meth != null) {
            FileObject file = meth.getFile();
            for (String testType : this.project.supportedTestTypes()) {
                FileObject testSrcDir = this.project.getTestSourceDirectory(testType);
                if (testSrcDir == null || !FileUtil.isParentOf((FileObject)testSrcDir, (FileObject)file)) continue;
                return new TestSources(new FileObject[]{file}, testType, testSrcDir, meth.getMethodName());
            }
        }
        return null;
    }

    private String getMainClass(Lookup context) {
        FileObject f;
        Collection mcs;
        FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, null, (String)".java", (boolean)true);
        if (files.length == 1 && (mcs = SourceUtils.getMainClasses((FileObject)(f = files[0]))).size() > 0) {
            ElementHandle h = (ElementHandle)mcs.iterator().next();
            String qname = h.getQualifiedName();
            return qname;
        }
        return null;
    }

    private TestSources findTestSourcesForSources(Lookup context) {
        String testType = "unit";
        FileObject[] sourceFiles = this.findSources(context);
        if (sourceFiles == null) {
            return null;
        }
        FileObject testSrcDir = this.project.getTestSourceDirectory(testType);
        if (testSrcDir == null) {
            return null;
        }
        FileObject srcDir = this.project.getSourceDirectory();
        FileObject[] matches = ActionUtils.regexpMapFiles((FileObject[])sourceFiles, (FileObject)srcDir, (Pattern)SRCDIRJAVA, (FileObject)testSrcDir, (String)SUBST, (boolean)true);
        if (matches != null) {
            return new TestSources(matches, testType, testSrcDir);
        }
        return null;
    }

    public void invokeAction(final String command, final Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            if (ModuleOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            }
            return;
        }
        if ("rename".equals(command)) {
            if (ModuleOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            }
            return;
        }
        if ("move".equals(command)) {
            if (ModuleOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            }
            return;
        }
        if ("copy".equals(command)) {
            if (ModuleOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            }
            return;
        }
        if (!ModuleActions.verifySufficientlyNewHarness(this.project)) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TestSources testSources;
                String[] targetNames;
                FileObject[] files;
                Properties p = new Properties();
                if (command.equals("compile.single")) {
                    files = ModuleActions.this.findSources(context);
                    if (files != null) {
                        p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)ModuleActions.this.project.getSourceDirectory()));
                        targetNames = new String[]{"compile-single"};
                    } else {
                        TestSources testSources2 = ModuleActions.this.findTestSources(context, false);
                        p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])testSources2.sources, (FileObject)testSources2.sourceDirectory));
                        p.setProperty("test.type", testSources2.testType);
                        targetNames = new String[]{"compile-test-single"};
                    }
                } else if (command.equals("test.single")) {
                    testSources = ModuleActions.this.findTestSourcesForSources(context);
                    if (testSources == null) {
                        testSources = ModuleActions.this.findTestSources(context, false);
                    }
                    targetNames = ModuleActions.this.setupTestSingle(p, testSources);
                } else if (command.equals("debug.test.single")) {
                    testSources = ModuleActions.this.findTestSourcesForSources(context);
                    if (testSources == null) {
                        testSources = ModuleActions.this.findTestSources(context, false);
                    }
                    targetNames = ModuleActions.this.setupDebugTestSingle(p, testSources);
                } else if (command.equals("run.single")) {
                    testSources = ModuleActions.this.findTestSources(context, false);
                    String clazz = ModuleActions.this.getMainClass(context);
                    targetNames = clazz != null ? ModuleActions.this.setupRunMain(p, testSources, context, clazz) : ModuleActions.this.setupTestSingle(p, testSources);
                } else if (command.equals("debug.single")) {
                    testSources = ModuleActions.this.findTestSources(context, false);
                    String clazz = ModuleActions.this.getMainClass(context);
                    targetNames = clazz != null ? ModuleActions.this.setupDebugMain(p, testSources, context, clazz) : ModuleActions.this.setupDebugTestSingle(p, testSources);
                } else if (command.equals("run.single.method")) {
                    testSources = ModuleActions.this.findTestMethodSources(context);
                    p.setProperty("test.class", ModuleActions.this.testClassName(testSources));
                    p.setProperty("test.type", testSources.testType);
                    p.setProperty("test.methods", testSources.method);
                    targetNames = new String[]{"test-method"};
                } else if (command.equals("debug.single.method")) {
                    testSources = ModuleActions.this.findTestMethodSources(context);
                    p.setProperty("test.class", ModuleActions.this.testClassName(testSources));
                    p.setProperty("test.type", testSources.testType);
                    p.setProperty("test.methods", testSources.method);
                    targetNames = new String[]{"debug-test-single-nb"};
                } else if (command.equals("debug.fix")) {
                    files = ModuleActions.this.findSources(context);
                    String path = null;
                    if (files != null) {
                        path = FileUtil.getRelativePath((FileObject)ModuleActions.this.project.getSourceDirectory(), (FileObject)files[0]);
                        assert (path != null);
                        assert (path.endsWith(".java"));
                        targetNames = new String[]{"debug-fix-nb"};
                    } else {
                        TestSources testSources3 = ModuleActions.this.findTestSources(context, false);
                        if (testSources3 == null) {
                            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ModuleActions.class, (String)"MSG_no_source"));
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                            return;
                        }
                        path = FileUtil.getRelativePath((FileObject)testSources3.sourceDirectory, (FileObject)testSources3.sources[0]);
                        p.setProperty("test.type", testSources3.testType);
                        assert (path != null);
                        assert (path.endsWith(".java"));
                        targetNames = new String[]{"debug-fix-test-nb"};
                    }
                    String clazzSlash = path.substring(0, path.length() - 5);
                    p.setProperty("fix.class", clazzSlash);
                } else {
                    if (command.equals("javadoc") && !ModuleActions.this.project.supportsJavadoc()) {
                        ModuleActions.this.promptForPublicPackagesToDocument();
                        return;
                    }
                    if ((command.equals("run") || command.equals("debug")) && ModuleActions.this.project.getTestUserDirLockFile().isFile()) {
                        p.setProperty(ModuleActions.TEST_USERDIR_LOCK_PROP_NAME, ModuleActions.TEST_USERDIR_LOCK_PROP_VALUE);
                    }
                    if ((targetNames = (String[])ModuleActions.this.globalCommands.get(command)) == null) {
                        throw new IllegalArgumentException(command);
                    }
                }
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(ModuleActions.this.project), (String[])targetNames, (Properties)p);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }
        };
        if (bkgActions.contains(command)) {
            RequestProcessor.getDefault().post(runnable);
        } else {
            runnable.run();
        }
    }

    private void promptForPublicPackagesToDocument() {
        if (UIUtil.showAcceptCancelDialog(NbBundle.getMessage(ModuleActions.class, (String)"TITLE_javadoc_disabled"), NbBundle.getMessage(ModuleActions.class, (String)"ERR_javadoc_disabled"), NbBundle.getMessage(ModuleActions.class, (String)"LBL_configure_pubpkg"), null, 2)) {
            CustomizerProviderImpl cpi = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            cpi.showCustomizer("Versioning", "publicPackages");
        }
    }

    private boolean hasTestUnitDataDir() {
        String dataDir = this.project.evaluator().getProperty("test.unit.data.dir");
        return dataDir != null && this.project.getHelper().resolveFileObject(dataDir) != null;
    }

    private void prepareSystemProperties(Map<String, Object> properties) {
        Map evaluated = this.project.evaluator().getProperties();
        if (evaluated == null) {
            return;
        }
        for (Map.Entry e : evaluated.entrySet()) {
            if (!((String)e.getKey()).startsWith(SYSTEM_PROPERTY_PREFIX) || e.getValue() == null) continue;
            LinkedList<String> systemProperties = (LinkedList<String>)properties.get("run.jvmargs");
            if (systemProperties == null) {
                systemProperties = new LinkedList<String>();
                properties.put("run.jvmargs", systemProperties);
            }
            systemProperties.add("-D" + ((String)e.getKey()).substring(SYSTEM_PROPERTY_PREFIX.length()) + "=" + (String)e.getValue());
        }
    }

    private static boolean verifySufficientlyNewHarness(NbModuleProject project) {
        NbPlatform plaf = project.getPlatform(false);
        if (plaf != null && plaf.getHarnessVersion() != HarnessVersion.UNKNOWN && plaf.getHarnessVersion().compareTo(project.getMinimumHarnessVersion()) < 0) {
            ModuleActions.promptForNewerHarness();
            return false;
        }
        return true;
    }

    static void promptForNewerHarness() {
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ModuleActions.class, (String)"ERR_harness_too_old"), 0);
        d.setTitle(NbBundle.getMessage(ModuleActions.class, (String)"TITLE_harness_too_old"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }

    private String[] setupTestSingle(Properties p, TestSources testSources) {
        p.setProperty("test.includes", ActionUtils.antIncludesList((FileObject[])testSources.sources, (FileObject)testSources.sourceDirectory));
        p.setProperty("test.type", testSources.testType);
        return new String[]{"test-single"};
    }

    private String[] setupRunMain(Properties p, TestSources testSources, Lookup context, String mainClass) {
        p.setProperty("main.class", mainClass);
        p.setProperty("test.type", testSources.testType);
        return new String[]{"run-test-main"};
    }

    private String[] setupDebugMain(Properties p, TestSources testSources, Lookup context, String mainClass) {
        p.setProperty("main.class", mainClass);
        p.setProperty("test.type", testSources.testType);
        return new String[]{"debug-test-main-nb"};
    }

    private String testClassName(TestSources testSources) {
        String path = FileUtil.getRelativePath((FileObject)testSources.sourceDirectory, (FileObject)testSources.sources[0]);
        assert (path != null && path.endsWith(".java")) : path;
        return path.substring(0, path.length() - 5).replace('/', '.');
    }

    private String[] setupDebugTestSingle(Properties p, TestSources testSources) {
        p.setProperty("test.class", this.testClassName(testSources));
        p.setProperty("test.type", testSources.testType);
        return new String[]{"debug-test-single-nb"};
    }

    private boolean bypassAntBuildScript(String command, FileObject[] files) throws IllegalArgumentException {
        FileObject toRun = null;
        if ("run.single".equals(command) || "debug.single".equals(command)) {
            toRun = files[0];
        }
        if (toRun != null) {
            String commandToExecute;
            String string = commandToExecute = "run.single".equals(command) ? "junit" : "junit-debug";
            if (!JavaRunner.isSupported((String)commandToExecute, Collections.singletonMap("execute.file", toRun))) {
                return false;
            }
            try {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                this.prepareSystemProperties(properties);
                properties.put("execute.file", toRun);
                JavaRunner.execute((String)commandToExecute, properties);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return true;
        }
        return false;
    }

    private static Action createSimpleAction(final NbModuleProject project, final String[] targetNames, String displayName) {
        return new AbstractAction(displayName){

            @Override
            public boolean isEnabled() {
                return ModuleActions.findBuildXml(project) != null;
            }

            @Override
            public void actionPerformed(ActionEvent ignore) {
                if (!ModuleActions.verifySufficientlyNewHarness(project)) {
                    return;
                }
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(project), (String[])targetNames, null);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }
        };
    }

    private static Action createCheckBundleAction(final NbModuleProject project, String displayName) {
        return new AbstractAction(displayName){

            @Override
            public boolean isEnabled() {
                return this.findMonitorXml() != null && project.getPathWithinNetBeansOrg() != null;
            }

            @Override
            public void actionPerformed(ActionEvent ignore) {
                Properties props = new Properties();
                props.put("modules", project.getPathWithinNetBeansOrg());
                props.put("fixedmodules", "");
                try {
                    ActionUtils.runTarget((FileObject)this.findMonitorXml(), (String[])new String[]{"check-bundle-usage"}, (Properties)props);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }

            private FileObject findMonitorXml() {
                return project.getNbrootFileObject("nbbuild/monitor.xml");
            }
        };
    }

    private static Action createReloadAction(final NbModuleProject project, final String[] targetNames, String displayName, final boolean inIDE) {
        return new AbstractAction(displayName){

            @Override
            public boolean isEnabled() {
                if (ModuleActions.findBuildXml(project) == null) {
                    return false;
                }
                if (Boolean.parseBoolean(project.evaluator().getProperty("is.autoload")) || Boolean.parseBoolean(project.evaluator().getProperty("is.eager"))) {
                    return false;
                }
                if (!inIDE) {
                    return project.getTestUserDirLockFile().isFile();
                }
                NbModuleProvider.NbModuleType type = Util.getModuleType(project);
                if (type == NbModuleProvider.NETBEANS_ORG) {
                    return true;
                }
                if (type == NbModuleProvider.STANDALONE) {
                    NbPlatform p = project.getPlatform(false);
                    return p != null && p.isDefault();
                }
                assert (type == NbModuleProvider.SUITE_COMPONENT) : type;
                try {
                    SuiteProject suite = SuiteUtils.findSuite(project);
                    if (suite == null) {
                        return false;
                    }
                    NbPlatform p = suite.getPlatform(false);
                    if (p == null || !p.isDefault()) {
                        return false;
                    }
                    return SuiteProperties.getArrayProperty(suite.getEvaluator(), "enabled.clusters").length == 0 && SuiteProperties.getArrayProperty(suite.getEvaluator(), "disabled.clusters").length == 0 && SuiteProperties.getArrayProperty(suite.getEvaluator(), "disabled.modules").length == 0;
                }
                catch (IOException e) {
                    Util.err.notify(1, (Throwable)e);
                    return false;
                }
            }

            @Override
            public void actionPerformed(ActionEvent ignore) {
                if (!ModuleActions.verifySufficientlyNewHarness(project)) {
                    return;
                }
                if (inIDE && ModuleUISettings.getDefault().getConfirmReloadInIDE()) {
                    NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ModuleActions.class, (String)"LBL_reload_in_ide_confirm"), NbBundle.getMessage(ModuleActions.class, (String)"LBL_reload_in_ide_confirm_title"), 2);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
                        return;
                    }
                    ModuleUISettings.getDefault().setConfirmReloadInIDE(false);
                }
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(project), (String[])targetNames, null);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }
        };
    }

    private static Action createArchAction(final NbModuleProject project) {
        return new AbstractAction(NbBundle.getMessage(ModuleActions.class, (String)"ACTION_arch")){

            @Override
            public boolean isEnabled() {
                return ModuleActions.findBuildXml(project) != null;
            }

            @Override
            public void actionPerformed(ActionEvent ignore) {
                if (!ModuleActions.verifySufficientlyNewHarness(project)) {
                    return;
                }
                ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                    public Void run() {
                        String prop = "javadoc.arch";
                        if (project.evaluator().getProperty(prop) == null) {
                            EditableProperties props = project.getHelper().getProperties("nbproject/project.properties");
                            props.setProperty(prop, "${basedir}/arch.xml");
                            project.getHelper().putProperties("nbproject/project.properties", props);
                            try {
                                ProjectManager.getDefault().saveProject((Project)project);
                            }
                            catch (IOException e) {
                                Util.err.notify((Throwable)e);
                            }
                        }
                        return null;
                    }
                });
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(project), (String[])new String[]{"arch-nb"}, null);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }
        };
    }

    static class TestSources {
        final FileObject[] sources;
        final String testType;
        final FileObject sourceDirectory;
        @NullAllowed
        final String method;

        public TestSources(FileObject[] sources, String testType, FileObject sourceDirectory) {
            this(sources, testType, sourceDirectory, null);
        }

        public TestSources(FileObject[] sources, String testType, FileObject sourceDirectory, String method) {
            assert (sources != null);
            assert (sourceDirectory != null);
            this.sources = sources;
            this.testType = testType;
            this.sourceDirectory = sourceDirectory;
            this.method = method;
        }
    }
}

