/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.layers.LayerNode;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.AnnotatedNode;
import org.netbeans.modules.apisupport.project.ui.ModuleLogicalView;
import org.netbeans.modules.apisupport.project.ui.SuiteLogicalView;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class ImportantFilesNodeFactory
implements NodeFactory {
    static final String IMPORTANT_FILES_NAME = "important.files";
    private static final RequestProcessor RP = new RequestProcessor(ImportantFilesNodeFactory.class.getName());

    public NodeList createNodes(Project p) {
        return new ImpFilesNL(p);
    }

    public static RequestProcessor getNodesSyncRP() {
        return RP;
    }

    public static Node createLayerNode(Project prj) {
        LayerHandle handle = LayerHandle.forProject(prj);
        if (handle != null && handle.getLayerFile() != null) {
            return new SpecialFileNode((Node)new LayerNode(handle), null);
        }
        return null;
    }

    private static String computeAnnotatedHtmlDisplayName(String htmlDisplayName, Set<? extends FileObject> files) {
        String result = null;
        if (files != null && files.iterator().hasNext()) {
            try {
                FileSystem.HtmlStatus hstat;
                String annotated;
                FileObject fo = files.iterator().next();
                FileSystem.Status stat = fo.getFileSystem().getStatus();
                if (stat instanceof FileSystem.HtmlStatus && !htmlDisplayName.equals(annotated = (hstat = (FileSystem.HtmlStatus)stat).annotateNameHtml(htmlDisplayName, files))) {
                    result = annotated;
                }
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return result;
    }

    private static final class SuiteImportantFilesChildren
    extends Children.Keys<String> {
        private List<String> visibleFiles = new ArrayList<String>();
        private FileChangeListener fcl;
        private static final Map<String, String> FILES = new LinkedHashMap<String, String>();
        private final SuiteProject project;

        public SuiteImportantFilesChildren(SuiteProject project) {
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.attachListeners();
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            this.removeListeners();
            super.removeNotify();
        }

        protected Node[] createNodes(String loc) {
            String locEval = this.project.getEvaluator().evaluate(loc);
            FileObject file = this.project.getHelper().resolveFileObject(locEval);
            try {
                Node orig = DataObject.find((FileObject)file).getNodeDelegate();
                return new Node[]{new SpecialFileNode(orig, FILES.get(loc))};
            }
            catch (DataObjectNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }

        private void refreshKeys() {
            ArrayList<String> newVisibleFiles = new ArrayList<String>();
            Iterator<String> it = FILES.keySet().iterator();
            HashSet<FileObject> files = new HashSet<FileObject>();
            while (it.hasNext()) {
                FileObject file;
                String loc = it.next();
                String locEval = this.project.getEvaluator().evaluate(loc);
                if (locEval == null || (file = this.project.getHelper().resolveFileObject(locEval)) == null) continue;
                newVisibleFiles.add(loc);
                files.add(file);
            }
            if (!this.isInitialized() || !((Object)newVisibleFiles).equals(this.visibleFiles)) {
                this.visibleFiles = newVisibleFiles;
                ImportantFilesNodeFactory.getNodesSyncRP().post(new Runnable(){

                    @Override
                    public void run() {
                        SuiteImportantFilesChildren.this.setKeys(SuiteImportantFilesChildren.this.visibleFiles);
                    }
                });
                ((ImportantFilesNode)this.getNode()).setFiles(files);
            }
        }

        private void attachListeners() {
            block3: {
                try {
                    if (this.fcl == null) {
                        this.fcl = new FileChangeAdapter(){

                            public void fileRenamed(FileRenameEvent fe) {
                                SuiteImportantFilesChildren.this.refreshKeys();
                            }

                            public void fileDataCreated(FileEvent fe) {
                                SuiteImportantFilesChildren.this.refreshKeys();
                            }

                            public void fileDeleted(FileEvent fe) {
                                SuiteImportantFilesChildren.this.refreshKeys();
                            }
                        };
                        this.project.getProjectDirectory().getFileSystem().addFileChangeListener(this.fcl);
                    }
                }
                catch (FileStateInvalidException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e);
                }
            }
        }

        private void removeListeners() {
            if (this.fcl != null) {
                block3: {
                    try {
                        this.project.getProjectDirectory().getFileSystem().removeFileChangeListener(this.fcl);
                    }
                    catch (FileStateInvalidException e) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError((Object)e);
                    }
                }
                this.fcl = null;
            }
        }

        static {
            FILES.put("master.jnlp", NbBundle.getMessage(SuiteLogicalView.class, (String)"LBL_jnlp_master"));
            FILES.put("build.xml", NbBundle.getMessage(SuiteLogicalView.class, (String)"LBL_build.xml"));
            FILES.put("nbproject/project.properties", NbBundle.getMessage(SuiteLogicalView.class, (String)"LBL_project.properties"));
            FILES.put("nbproject/private/private.properties", NbBundle.getMessage(SuiteLogicalView.class, (String)"LBL_private.properties"));
            FILES.put("nbproject/platform.properties", NbBundle.getMessage(SuiteLogicalView.class, (String)"LBL_platform.properties"));
            FILES.put("nbproject/private/platform-private.properties", NbBundle.getMessage(SuiteLogicalView.class, (String)"LBL_platform-private.properties"));
        }
    }

    static final class SpecialFileNode
    extends FilterNode {
        private final String displayName;

        public SpecialFileNode(Node orig, String displayName) {
            super(orig);
            this.displayName = displayName;
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return super.getDisplayName();
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public String getHtmlDisplayName() {
            String result = null;
            DataObject dob = (DataObject)this.getLookup().lookup(DataObject.class);
            if (dob != null) {
                Set files = dob.files();
                result = ImportantFilesNodeFactory.computeAnnotatedHtmlDisplayName(this.getDisplayName(), files);
            }
            return result;
        }
    }

    private static final class ImportantFilesChildren
    extends Children.Keys<Object> {
        private List<Object> visibleFiles = null;
        private final FileChangeListener fclStrong = new FileChangeAdapter(){

            public void fileRenamed(FileRenameEvent fe) {
                ImportantFilesChildren.this.refreshKeys();
            }

            public void fileDataCreated(FileEvent fe) {
                ImportantFilesChildren.this.refreshKeys();
            }

            public void fileDeleted(FileEvent fe) {
                ImportantFilesChildren.this.refreshKeys();
            }
        };
        private FileChangeListener fclWeak;
        private static final Map<String, String> FILES = new LinkedHashMap<String, String>();
        private final NbModuleProject project;

        public ImportantFilesChildren(NbModuleProject project) {
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.attachListeners();
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptyList());
            this.visibleFiles = null;
            this.removeListeners();
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof String) {
                String loc = (String)key;
                String locEval = this.project.evaluator().evaluate(loc);
                FileObject file = this.project.getHelper().resolveFileObject(locEval);
                try {
                    Node orig = DataObject.find((FileObject)file).getNodeDelegate();
                    return new Node[]{new SpecialFileNode(orig, FILES.get(loc))};
                }
                catch (DataObjectNotFoundException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (key instanceof LayerHandle) {
                return new Node[]{new SpecialFileNode((Node)new LayerNode((LayerHandle)key), null)};
            }
            throw new AssertionError(key);
        }

        private void refreshKeys() {
            HashSet<FileObject> files = new HashSet<FileObject>();
            ArrayList<Object> newVisibleFiles = new ArrayList<Object>();
            LayerHandle handle = LayerHandle.forProject(this.project);
            FileObject layerFile = handle.getLayerFile();
            if (layerFile != null) {
                newVisibleFiles.add(handle);
                files.add(layerFile);
            }
            for (String loc : FILES.keySet()) {
                String locEval = this.project.evaluator().evaluate(loc);
                if (locEval == null) {
                    newVisibleFiles.remove(loc);
                    continue;
                }
                FileObject file = this.project.getHelper().resolveFileObject(locEval);
                if (file == null) continue;
                newVisibleFiles.add(loc);
                files.add(file);
            }
            if (!((Object)newVisibleFiles).equals(this.visibleFiles)) {
                this.visibleFiles = newVisibleFiles;
                ImportantFilesNodeFactory.getNodesSyncRP().post(new Runnable(){

                    @Override
                    public void run() {
                        ImportantFilesChildren.this.setKeys(ImportantFilesChildren.this.visibleFiles);
                    }
                });
                ((ImportantFilesNode)this.getNode()).setFiles(files);
            }
        }

        private void attachListeners() {
            block3: {
                try {
                    if (this.fclWeak == null) {
                        FileSystem fs = this.project.getProjectDirectory().getFileSystem();
                        this.fclWeak = FileUtil.weakFileChangeListener((FileChangeListener)this.fclStrong, (Object)fs);
                        fs.addFileChangeListener(this.fclWeak);
                    }
                }
                catch (FileStateInvalidException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e);
                }
            }
        }

        private void removeListeners() {
            if (this.fclWeak != null) {
                block3: {
                    try {
                        this.project.getProjectDirectory().getFileSystem().removeFileChangeListener(this.fclWeak);
                    }
                    catch (FileStateInvalidException e) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError((Object)e);
                    }
                }
                this.fclWeak = null;
            }
        }

        static {
            FILES.put("${manifest.mf}", NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_module_manifest"));
            FILES.put("${javadoc.arch}", NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_arch_desc"));
            FILES.put("${javadoc.apichanges}", NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_api_changes"));
            FILES.put("${javadoc.overview}", NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_javadoc_overview"));
            FILES.put("build.xml", NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_build.xml"));
            FILES.put("nbproject/project.xml", NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_project.xml"));
            FILES.put("nbproject/project.properties", NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_project.properties"));
            FILES.put("nbproject/private/private.properties", NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_private.properties"));
            FILES.put("nbproject/suite.properties", NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_suite.properties"));
            FILES.put("nbproject/private/suite-private.properties", NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_suite-private.properties"));
            FILES.put("nbproject/platform.properties", NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_platform.properties"));
            FILES.put("nbproject/private/platform-private.properties", NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_platform-private.properties"));
        }
    }

    static final class ImportantFilesNode
    extends AnnotatedNode {
        private static final String DISPLAY_NAME = NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_important_files");

        public ImportantFilesNode(NbModuleProject project) {
            this(project, (Children)new ImportantFilesChildren(project));
        }

        ImportantFilesNode(Project project, Children ch) {
            super(ch, Lookups.singleton((Object)project));
        }

        public String getName() {
            return ImportantFilesNodeFactory.IMPORTANT_FILES_NAME;
        }

        private Image getIcon(boolean opened) {
            Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/apisupport/project/resources/config-badge.gif", (boolean)true);
            return ImageUtilities.mergeImages((Image)UIUtil.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
        }

        public String getDisplayName() {
            return this.annotateName(DISPLAY_NAME);
        }

        public String getHtmlDisplayName() {
            return ImportantFilesNodeFactory.computeAnnotatedHtmlDisplayName(ImportantFilesNode.DISPLAY_NAME, this.getFiles());
        }

        public Image getIcon(int type) {
            return this.annotateIcon(this.getIcon(false), type);
        }

        public Image getOpenedIcon(int type) {
            return this.annotateIcon(this.getIcon(true), type);
        }
    }

    private static class ImpFilesNL
    implements NodeList<String> {
        private Project project;

        public ImpFilesNL(Project p) {
            this.project = p;
        }

        public List<String> keys() {
            return Collections.singletonList(ImportantFilesNodeFactory.IMPORTANT_FILES_NAME);
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public Node node(String key) {
            assert (key.equals(ImportantFilesNodeFactory.IMPORTANT_FILES_NAME));
            if (this.project instanceof NbModuleProject) {
                return new ImportantFilesNode((NbModuleProject)this.project);
            }
            if (this.project instanceof SuiteProject) {
                return new ImportantFilesNode(this.project, (Children)new SuiteImportantFilesChildren((SuiteProject)this.project));
            }
            return null;
        }

        public void addNotify() {
        }

        public void removeNotify() {
        }
    }
}

