/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.layers.LayerFileSystem;
import org.netbeans.modules.apisupport.project.layers.PlatformLayersCacheManager;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tax.parser.XMLParsingSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.io.TreeStreamResult;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Task;
import org.xml.sax.InputSource;

public class LayerUtils {
    private static final Collection<FileSystem> EMPTY_FS_COL = new ArrayList<FileSystem>();
    private static final Logger LOG = Logger.getLogger(LayerUtils.class.getName());
    public static final String HIDDEN = "_hidden";
    private static final Set<String> XML_LIKE_TYPES = new HashSet<String>();

    private LayerUtils() {
    }

    public static ClassPath findResourceCP(Project project) {
        Sources s = ProjectUtils.getSources((Project)project);
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        for (String type : new String[]{"java", "resources"}) {
            for (SourceGroup group : s.getSourceGroups(type)) {
                roots.add(group.getRootFolder());
            }
        }
        if (roots.isEmpty()) {
            LOG.log(Level.WARNING, "no resource path for {0}", project);
        }
        return ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
    }

    static URL[] currentify(URL u, String suffix, ClassPath cp) {
        if (cp == null) {
            return new URL[]{u};
        }
        try {
            if (u.getProtocol().equals("nbres")) {
                FileObject fo;
                String path = u.getFile();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((fo = cp.findResource(path)) != null) {
                    return new URL[]{fo.getURL()};
                }
            } else if (u.getProtocol().equals("nbresloc")) {
                String ext;
                String name;
                String nameext;
                String folder;
                int idx;
                ArrayList<URL> urls = new ArrayList<URL>();
                String path = u.getFile();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((idx = path.lastIndexOf(47)) == -1) {
                    folder = "";
                    nameext = path;
                } else {
                    folder = path.substring(0, idx + 1);
                    nameext = path.substring(idx + 1);
                }
                idx = nameext.lastIndexOf(46);
                if (idx == -1) {
                    name = nameext;
                    ext = "";
                } else {
                    name = nameext.substring(0, idx);
                    ext = nameext.substring(idx);
                }
                ArrayList<String> suffixes = new ArrayList<String>(LayerUtils.computeSubVariants(suffix));
                suffixes.add(suffix);
                Collections.reverse(suffixes);
                for (String trysuffix : suffixes) {
                    String trypath = folder + name + trysuffix + ext;
                    FileObject fo = cp.findResource(trypath);
                    if (fo == null) continue;
                    urls.add(fo.getURL());
                }
                if (!urls.isEmpty()) {
                    return urls.toArray(new URL[urls.size()]);
                }
            }
        }
        catch (FileStateInvalidException fsie) {
            Util.err.notify(16, (Throwable)fsie);
        }
        return new URL[]{u};
    }

    static URL urlForBundle(String bundleName) throws MalformedURLException {
        return new URL("nbresloc:/" + bundleName.replace('.', '/') + ".properties");
    }

    public static String generateBundleKeyForFile(String filePath) {
        return filePath.replaceAll("[^-a-zA-Z0-9_./]", "");
    }

    private static List<String> computeSubVariants(String name) {
        int idx = name.indexOf(95);
        if (idx == -1) {
            return Collections.emptyList();
        }
        String base = name.substring(0, idx);
        String suffix = name.substring(idx);
        List<String> l = LayerUtils.computeSubVariants(base, suffix);
        return l.subList(0, l.size() - 1);
    }

    private static List<String> computeSubVariants(String base, String suffix) {
        int idx = suffix.indexOf(95, 1);
        if (idx == -1) {
            LinkedList<String> l = new LinkedList<String>();
            l.add(base);
            l.add(base + suffix);
            return l;
        }
        String remainder = suffix.substring(idx);
        List<String> l1 = LayerUtils.computeSubVariants(base, remainder);
        List<String> l2 = LayerUtils.computeSubVariants(base + suffix.substring(0, idx), remainder);
        LinkedList<String> l = new LinkedList<String>(l1);
        l.addAll(l2);
        return l;
    }

    public static String findGeneratedName(FileObject parent, String layerPath) {
        Matcher m = Pattern.compile("(.+/)?([^/.]+)(\\.[^/]+)?").matcher(layerPath);
        if (!m.matches()) {
            throw new IllegalArgumentException(layerPath);
        }
        String base = m.group(2);
        String ext = m.group(3);
        if (ext == null) {
            ext = "";
        } else if (ext.equals(".java")) {
            ext = "_java";
        } else if (XML_LIKE_TYPES.contains(ext)) {
            String upper = ext.substring(1, 2).toUpperCase(Locale.ENGLISH);
            base = base + upper + ext.substring(2);
            ext = ".xml";
        }
        String name = base + ext;
        if (parent == null || parent.getFileObject(name) == null) {
            return name;
        }
        int i = 1;
        while (parent.getFileObject(name = base + '_' + i + ext) != null) {
            ++i;
        }
        return name;
    }

    public static SavableTreeEditorCookie cookieForFile(FileObject f) {
        return new CookieImpl(f);
    }

    public static FileSystem getEffectiveSystemFilesystem(Project p) throws IOException {
        NbModuleProvider.NbModuleType type = Util.getModuleType(p);
        FileSystem projectLayer = LayerHandle.forProject(p).layer(false);
        if (type == NbModuleProvider.STANDALONE) {
            Set<File> jars = LayerUtils.getPlatformJarsForStandaloneProject(p);
            NbPlatform plaf = LayerUtils.getPlatformForProject(p);
            Collection<FileSystem> platformLayers = LayerUtils.getCachedLayers(plaf != null ? plaf.getDestDir() : null, jars);
            return LayerUtils.mergeFilesystems(projectLayer, platformLayers);
        }
        if (type == NbModuleProvider.SUITE_COMPONENT) {
            SuiteProject suite = SuiteUtils.findSuite(p);
            if (suite == null) {
                throw new IOException("Could not load suite for " + p);
            }
            ArrayList<FileSystem> readOnlyLayers = new ArrayList<FileSystem>();
            Set<NbModuleProject> modules = SuiteUtils.getSubProjects(suite);
            for (NbModuleProject sister : modules) {
                LayerHandle handle;
                FileSystem roLayer;
                if (sister == p || (roLayer = (handle = LayerHandle.forProject(sister)).layer(false)) == null) continue;
                readOnlyLayers.add(roLayer);
            }
            NbPlatform plaf = suite.getPlatform(true);
            Set<File> jars = LayerUtils.getPlatformJarsForSuiteComponentProject(suite);
            readOnlyLayers.addAll(LayerUtils.getCachedLayers(plaf != null ? plaf.getDestDir() : null, jars));
            return LayerUtils.mergeFilesystems(projectLayer, readOnlyLayers);
        }
        if (type == NbModuleProvider.NETBEANS_ORG) {
            XMLFileSystem xfs;
            block9: {
                NbModuleProject nbprj = (NbModuleProject)p.getLookup().lookup(NbModuleProject.class);
                Set<NbModuleProject> projects = LayerUtils.getProjectsForNetBeansOrgProject(nbprj);
                ArrayList<URL> otherLayerURLs = new ArrayList<URL>();
                for (NbModuleProject p2 : projects) {
                    File layerXml;
                    FileObject layerXml2;
                    FileObject src;
                    if (p2.getManifest() == null) continue;
                    ManifestManager mm = ManifestManager.getInstance(p2.getManifest(), false, true);
                    String layer = mm.getLayer();
                    if (layer != null && (src = p2.getSourceDirectory()) != null && (layerXml2 = src.getFileObject(layer)) != null) {
                        otherLayerURLs.add(layerXml2.getURL());
                    }
                    if ((layer = mm.getGeneratedLayer()) == null || !(layerXml = new File(nbprj.getClassesDirectory(), layer)).isFile()) continue;
                    otherLayerURLs.add(layerXml.toURI().toURL());
                }
                xfs = new XMLFileSystem();
                try {
                    xfs.setXmlUrls(otherLayerURLs.toArray(new URL[otherLayerURLs.size()]));
                }
                catch (PropertyVetoException ex) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError((Object)ex);
                }
            }
            return LayerUtils.mergeFilesystems(projectLayer, Collections.singletonList(xfs));
        }
        throw new AssertionError((Object)type);
    }

    public static NbPlatform getPlatformForProject(Project project) {
        NbModuleProvider mod = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        NbPlatform platform = null;
        File platformDir = mod.getActivePlatformLocation();
        if (platformDir != null) {
            platform = NbPlatform.getPlatformByDestDir(platformDir);
        }
        if (platform == null || !platform.isValid()) {
            platform = NbPlatform.getDefaultPlatform();
        }
        return platform;
    }

    public static Set<File> getPlatformJarsForSuiteComponentProject(SuiteProject suite) {
        try {
            HashSet<File> jars = new HashSet<File>();
            for (ModuleEntry entry : ModuleList.findOrCreateModuleListFromSuite(suite.getProjectDirectoryFile(), null).getAllEntries()) {
                jars.add(entry.getJarLocation());
            }
            return jars;
        }
        catch (IOException x) {
            LOG.log(Level.INFO, null, x);
            return Collections.emptySet();
        }
    }

    public static Set<NbModuleProject> getProjectsForNetBeansOrgProject(NbModuleProject project) throws IOException {
        ModuleList list = project.getModuleList();
        HashSet<NbModuleProject> projects = new HashSet<NbModuleProject>();
        projects.add(project);
        for (ModuleEntry other : list.getAllEntries()) {
            NbModuleProject p2;
            if (other.getClusterDirectory().getName().equals("extra")) continue;
            File root = other.getSourceLocation();
            assert (root != null) : other;
            FileObject fo = FileUtil.toFileObject((File)root);
            if (fo == null) continue;
            try {
                p2 = (NbModuleProject)ProjectManager.getDefault().findProject(fo);
            }
            catch (IOException x) {
                LOG.log(Level.INFO, "could not load " + fo, x);
                continue;
            }
            if (p2 == null) continue;
            projects.add(p2);
        }
        return projects;
    }

    public static Set<File> getPlatformJarsForStandaloneProject(Project project) {
        NbPlatform platform = LayerUtils.getPlatformForProject(project);
        if (platform == null) {
            return Collections.emptySet();
        }
        Set<ModuleEntry> entries = platform.getModules();
        HashSet<File> jars = new HashSet<File>(entries.size());
        for (ModuleEntry entry : entries) {
            jars.add(entry.getJarLocation());
        }
        return jars;
    }

    private static Collection<FileSystem> getCachedLayers(File rootDir, final Set<File> platformJars) throws IOException {
        if (rootDir == null) {
            return EMPTY_FS_COL;
        }
        File[] clusters = rootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return ClusterUtils.isValidCluster(pathname);
            }
        });
        Collection<FileSystem> cache = PlatformLayersCacheManager.getCache(clusters, new FileFilter(){

            @Override
            public boolean accept(File jar) {
                return platformJars.contains(jar);
            }
        });
        return cache;
    }

    private static FileSystem mergeFilesystems(FileSystem writableLayer, Collection<FileSystem> readOnlyLayers) {
        if (writableLayer == null) {
            writableLayer = new XMLFileSystem();
        }
        FileSystem[] layers = new FileSystem[readOnlyLayers.size() + 1];
        layers[0] = writableLayer;
        Iterator<FileSystem> it = readOnlyLayers.iterator();
        int i = 1;
        while (it.hasNext()) {
            layers[i] = it.next();
            ++i;
        }
        return new LayerFileSystem(layers);
    }

    static {
        XML_LIKE_TYPES.add(".settings");
        XML_LIKE_TYPES.add(".wstcref");
        XML_LIKE_TYPES.add(".wsmode");
        XML_LIKE_TYPES.add(".wsgrp");
        XML_LIKE_TYPES.add(".wsmgr");
    }

    private static final class CookieImpl
    implements SavableTreeEditorCookie,
    FileChangeListener,
    FileSystem.AtomicAction {
        private TreeDocumentRoot root;
        private boolean dirty;
        private Exception problem;
        private final FileObject f;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public CookieImpl(FileObject f) {
            this.f = f;
            f.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)f));
        }

        public TreeDocumentRoot getDocumentRoot() {
            return this.root;
        }

        public int getStatus() {
            if (this.problem != null) {
                return 3;
            }
            if (this.root != null) {
                return 1;
            }
            return 0;
        }

        public TreeDocumentRoot openDocumentRoot() throws IOException, TreeException {
            if (this.root == null && this.f.isValid()) {
                try {
                    boolean oldDirty = this.dirty;
                    int oldStatus = this.getStatus();
                    this.root = new XMLParsingSupport().parse(new InputSource(this.f.getURL().toExternalForm()));
                    this.problem = null;
                    this.dirty = false;
                    this.pcs.firePropertyChange("dirty", oldDirty, false);
                    this.pcs.firePropertyChange("status", oldStatus, 1);
                }
                catch (IOException e) {
                    this.problem = e;
                    throw e;
                }
                catch (TreeException e) {
                    this.problem = e;
                    throw e;
                }
                ((TreeObject)this.root).addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        CookieImpl.this.modified();
                    }
                });
            }
            return this.root;
        }

        public Task prepareDocumentRoot() {
            throw new UnsupportedOperationException();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        private void modified() {
            if (!this.dirty) {
                this.dirty = true;
                this.pcs.firePropertyChange("dirty", false, true);
            }
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        @Override
        public synchronized void save() throws IOException {
            if (this.root == null || !this.dirty) {
                return;
            }
            this.f.getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
            this.dirty = false;
            this.pcs.firePropertyChange("dirty", true, false);
        }

        public void run() throws IOException {
            OutputStream os = this.f.getOutputStream();
            try {
                new TreeStreamResult(os).getWriter(this.root).writeDocument();
            }
            catch (TreeException e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
            finally {
                os.close();
            }
        }

        public void fileChanged(FileEvent fe) {
            this.changed(fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.changed(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.changed((FileEvent)fe);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
            assert (false);
        }

        public void fileDataCreated(FileEvent fe) {
            assert (false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changed(FileEvent fe) {
            CookieImpl cookieImpl = this;
            synchronized (cookieImpl) {
                if (fe.firedFrom((FileSystem.AtomicAction)this)) {
                    return;
                }
                this.problem = null;
                this.dirty = false;
                this.root = null;
            }
            this.pcs.firePropertyChange("documentRoot", null, null);
        }
    }

    public static interface SavableTreeEditorCookie
    extends TreeEditorCookie {
        public static final String PROP_DIRTY = "dirty";

        public boolean isDirty();

        public void save() throws IOException;
    }
}

