/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.historystore;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import org.netbeans.modules.versioning.historystore.Entry;
import org.netbeans.modules.versioning.historystore.StorageManager;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbPreferences;

public class Storage {
    private final File storageFolder;
    private boolean storageExists;
    private boolean storageAccessible;
    private static final String DATA_FILE = "data";
    static final String PREF_KEY_TTL = "HistoryStorage.ttl";
    static final int INDEFINITE_TTL = Integer.MAX_VALUE;
    private static final FilenameFilter FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !Storage.DATA_FILE.equals(name);
        }
    };

    Storage(File storageFolder) {
        this.storageFolder = storageFolder;
        this.ensureAccessible();
        if (!this.storageAccessible) {
            StorageManager.LOG.log(Level.WARNING, "Cannot write or read from storage at {0}", storageFolder.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized File getContent(String repositoryPath, String filename, String revision) {
        File content = new File(Utils.getTempFolder(), "nb-vcs-" + filename);
        if (this.storageAccessible) {
            content.deleteOnExit();
            Entry entry = this.getEntry(repositoryPath, revision, false);
            InputStream is = null;
            try {
                is = entry.getStoreFileInputStream();
                Utils.copyStreamsCloseAll(new FileOutputStream(content), is);
                is = null;
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException ex) {
                StorageManager.LOG.log(Level.INFO, "getContent(): Cannot read file's content", ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return content;
    }

    public synchronized void setContent(String repositoryPath, String revision, File content) {
        if (this.ensureAccessible()) {
            Entry entry = this.getEntry(repositoryPath, revision, true);
            try {
                OutputStream os = entry.getStoreFileOutputStream();
                Utils.copyStreamsCloseAll(os, new FileInputStream(content));
            }
            catch (IOException ex) {
                StorageManager.LOG.log(Level.INFO, "setContent(): Cannot save file's content", ex);
            }
        }
    }

    private Entry getEntry(String repositoryPath, String revision, boolean write) {
        return new Entry(this.getStoreFile(repositoryPath, revision, write));
    }

    private File getStoreFile(String repositoryPath, String revision, boolean write) {
        File storeFolder = this.getStoreFolder(repositoryPath);
        if (write) {
            if (!storeFolder.exists()) {
                storeFolder.mkdirs();
            }
            StoreDataFile.write(new File(storeFolder, DATA_FILE), new StoreDataFile(repositoryPath));
        }
        return new File(storeFolder, revision);
    }

    private File getStoreFolder(String repositoryPath) {
        StoreDataFile data;
        File storeFolder = this.getStoreFolderName(repositoryPath);
        int i = 0;
        while (storeFolder.exists() && (data = StoreDataFile.read(new File(storeFolder, DATA_FILE))) != null && !data.getRelativePath().equals(repositoryPath)) {
            storeFolder = this.getStoreFolderName(repositoryPath + "." + i++);
        }
        return storeFolder;
    }

    private File getStoreFolderName(String filePath) {
        int fileHash = filePath.hashCode();
        String storeFileName = Storage.getMD5(filePath);
        File storeIndex = new File(this.storageFolder, Integer.toString(fileHash % 173 + 172));
        return new File(storeIndex, storeFileName);
    }

    synchronized void cleanUp() {
        StorageManager.LOG.log(Level.FINE, "Cleaning storage: {0}", this.storageFolder);
        long ts = System.currentTimeMillis();
        File[] contentFolders = this.storageFolder.listFiles();
        if (contentFolders != null) {
            for (File contentFolder : contentFolders) {
                File[] hashedFolders = contentFolder.listFiles();
                if (hashedFolders == null) continue;
                boolean empty = true;
                for (File hashedFolder : hashedFolders) {
                    if (this.cleanUp(hashedFolder)) {
                        Utils.deleteRecursively(hashedFolder);
                        continue;
                    }
                    empty = false;
                }
                if (!empty) continue;
                Utils.deleteRecursively(contentFolder);
            }
        }
        if ((contentFolders = this.storageFolder.listFiles()) == null || contentFolders.length == 0) {
            Utils.deleteRecursively(this.storageFolder);
            this.storageAccessible = false;
            this.storageExists = false;
            StorageManager.LOG.log(Level.FINE, "Empty storage deleted: {0}", new Object[]{this.storageFolder});
        }
        StorageManager.LOG.log(Level.FINE, "Storage cleaned: {0}, took {1} ms", new Object[]{this.storageFolder, System.currentTimeMillis() - ts});
    }

    private boolean cleanUp(File contentFolder) {
        boolean empty = true;
        File[] contentFiles = contentFolder.listFiles(FILE_FILTER);
        long currentTS = System.currentTimeMillis();
        if (contentFiles != null) {
            for (File contentFile : contentFiles) {
                if (contentFile.lastModified() < currentTS - this.getTTL()) {
                    Utils.deleteRecursively(contentFile);
                    continue;
                }
                empty = false;
            }
        }
        return empty;
    }

    private boolean ensureAccessible() {
        if (!this.storageAccessible && !this.storageExists) {
            this.storageFolder.mkdirs();
            this.storageAccessible = this.storageFolder.canWrite() && this.storageFolder.canRead();
            this.storageExists = this.storageAccessible || this.storageFolder.exists();
        }
        return this.storageAccessible;
    }

    private long getTTL() {
        return 86400000L * (long)NbPreferences.forModule(Storage.class).getInt(PREF_KEY_TTL, Integer.MAX_VALUE);
    }

    private static DataOutputStream getOutputStream(File file, boolean append) throws IOException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file, append)));
            }
            catch (IOException ioex) {
                if (++retry > 7) {
                    throw ioex;
                }
                Thread.sleep(retry * 30);
                continue;
            }
            break;
        }
    }

    private static DataInputStream getInputStream(File file) throws IOException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                return new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            }
            catch (IOException ioex) {
                if (++retry > 7) {
                    throw ioex;
                }
                Thread.sleep(retry * 30);
                continue;
            }
            break;
        }
    }

    static String getMD5(String name) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.update(name.getBytes());
        byte[] hash = digest.digest();
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i] & 0xFF);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            ret.append(hex);
        }
        return ret.toString();
    }

    private static class StoreDataFile {
        private final String relativePath;
        private static final int VERSION = 1;

        private StoreDataFile(String relativePath) {
            this.relativePath = relativePath;
        }

        String getRelativePath() {
            return this.relativePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static synchronized StoreDataFile read(File storeFile) {
            DataInputStream dis = null;
            try {
                if (storeFile.exists()) {
                    dis = Storage.getInputStream(storeFile);
                    long version = dis.readInt();
                    if (version == 1L) {
                        String fileName = dis.readUTF();
                        StoreDataFile storeDataFile = new StoreDataFile(fileName);
                        return storeDataFile;
                    }
                    Utils.deleteRecursively(storeFile.getParentFile());
                }
            }
            catch (FileNotFoundException e) {
                StorageManager.LOG.log(Level.FINEST, null, e);
            }
            catch (Exception e) {
                StorageManager.LOG.log(Level.FINE, null, e);
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException e) {}
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static synchronized void write(File storeFile, StoreDataFile value) {
            DataOutputStream dos = null;
            try {
                dos = Storage.getOutputStream(storeFile, false);
                StoreDataFile data = value;
                dos.writeInt(1);
                dos.writeUTF(data.getRelativePath());
                dos.flush();
            }
            catch (FileNotFoundException e) {
                StorageManager.LOG.log(Level.FINEST, null, e);
            }
            catch (Exception e) {
                StorageManager.LOG.log(Level.FINE, null, e);
            }
            finally {
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

