/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.Callable;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uihandler.Installer;
import org.netbeans.modules.uihandler.SlownessReporter;
import org.netbeans.modules.uihandler.TimeToFailure;
import org.netbeans.modules.uihandler.api.Controller;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class UIHandler
extends Handler
implements ActionListener,
Runnable,
Callable<JButton> {
    private final boolean exceptionOnly;
    public static final PropertyChangeSupport SUPPORT = new PropertyChangeSupport(Controller.getDefault());
    static final int MAX_LOGS = 1000;
    static final long MAX_LOGS_SIZE = 0x1400000L;
    private static Task lastRecord = Task.EMPTY;
    private static RequestProcessor FLUSH = new RequestProcessor("Flush UI Logs");
    private static boolean flushOnRecord;
    private final SlownessReporter reporter;
    private static boolean exceptionHandler;
    private JButton button;

    public static void registerExceptionHandler(boolean enable) {
        exceptionHandler = enable;
    }

    public UIHandler(boolean exceptionOnly) {
        this.setLevel(Level.FINEST);
        this.exceptionOnly = exceptionOnly;
        this.reporter = exceptionOnly ? null : new SlownessReporter();
    }

    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().equals(Level.CONFIG) && record.getMessage().startsWith("NotifyExcPanel: ")) {
            Installer.setSelectedExcParams(record.getParameters());
            return;
        }
        if (this.exceptionOnly) {
            if (record.getThrown() == null) {
                return;
            }
            if (!exceptionHandler) {
                return;
            }
        } else if (record.getLevel().equals(Level.CONFIG) && record.getMessage().equals("Slowness detected")) {
            String slownessType;
            Object[] params = record.getParameters();
            byte[] nps = (byte[])params[0];
            long time = (Long)params[1];
            String string = slownessType = params.length > 2 ? params[2].toString() : null;
            assert (nps != null) : "nps param should be not null";
            assert (nps.length > 0) : "nps param should not be empty";
            this.reporter.notifySlowness(nps, time, record.getMillis(), slownessType);
            return;
        }
        class WriteOut
        implements Runnable {
            public LogRecord r;

            WriteOut() {
            }

            @Override
            public void run() {
                Installer.writeOut(this.r);
                SUPPORT.firePropertyChange(null, null, null);
                this.r = null;
                TimeToFailure.logAction();
            }
        }
        WriteOut wo = new WriteOut();
        wo.r = record;
        lastRecord = FLUSH.post((Runnable)wo);
        if (flushOnRecord) {
            UIHandler.waitFlushed();
        }
    }

    @Override
    public void flush() {
        UIHandler.waitFlushed();
    }

    static final void flushImmediatelly() {
        flushOnRecord = true;
    }

    static final void waitFlushed() {
        try {
            lastRecord.waitFinished(1000L);
        }
        catch (InterruptedException ex) {
            Installer.LOG.log(Level.FINE, null, ex);
        }
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void run() {
        Installer.displaySummary("ERROR_URL", true, false, true);
        Installer.setSelectedExcParams(null);
    }

    @Override
    public JButton call() throws Exception {
        if (this.button == null) {
            this.button = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.button, (String)NbBundle.getMessage(UIHandler.class, (String)"MSG_SubmitButton"));
            this.button.addActionListener(this);
        }
        return this.button;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        JComponent c = (JComponent)ev.getSource();
        Window w = SwingUtilities.windowForComponent(c);
        if (w != null) {
            w.dispose();
        }
        Installer.RP.post((Runnable)this);
    }
}

