/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Logger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassPrepareEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassUnloadEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventQueueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventSetWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadDeathEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadStartEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

public class Operator {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    public static final String SILENT_EVENT_PROPERTY = "silent";
    private Thread thread;
    private final Set<ThreadReference> methodInvokingThreads = new HashSet<ThreadReference>();
    private boolean stop;
    private boolean canInterrupt;
    private JPDADebuggerImpl debugger;
    private RequestProcessor eventHandler;
    private Map<ThreadReference, HandlerTask> eventHandlers = new HashMap<ThreadReference, HandlerTask>();
    private final List<EventSet> parallelEvents = new LinkedList<EventSet>();

    public Operator(VirtualMachine virtualMachine, final JPDADebuggerImpl debugger, Executor starter, Runnable finalizer, ReadWriteLock resumeLock) {
        EventQueue eventQueue;
        try {
            eventQueue = VirtualMachineWrapper.eventQueue(virtualMachine);
        }
        catch (InternalExceptionWrapper ex) {
            eventQueue = null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            eventQueue = null;
        }
        if (eventQueue == null) {
            throw new NullPointerException();
        }
        this.debugger = debugger;
        final Object[] params = new Object[]{eventQueue, starter, finalizer};
        this.thread = new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[TRYBLOCK]], but top level block is 8[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, "Debugger operator thread");
    }

    private static final ThreadReference getEventThread(Event e) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        ThreadReference tref = null;
        if (e instanceof LocatableEvent) {
            tref = LocatableEventWrapper.thread((LocatableEvent)e);
        } else if (e instanceof ClassPrepareEvent) {
            tref = ClassPrepareEventWrapper.thread((ClassPrepareEvent)e);
        } else if (e instanceof ThreadStartEvent) {
            tref = ThreadStartEventWrapper.thread((ThreadStartEvent)e);
        } else if (e instanceof ThreadDeathEvent) {
            tref = ThreadDeathEventWrapper.thread((ThreadDeathEvent)e);
        }
        return tref;
    }

    public void start() {
        this.thread.start();
    }

    public synchronized void register(EventRequest req, Executor e) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        EventRequestWrapper.putProperty(req, "executor", e);
    }

    public synchronized void unregister(EventRequest req) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        Executor e = (Executor)EventRequestWrapper.getProperty(req, "executor");
        EventRequestWrapper.putProperty(req, "executor", null);
        if (e != null) {
            e.removed(req);
        }
        if (req instanceof StepRequest) {
            ThreadReference tr = StepRequestWrapper.thread((StepRequest)req);
            this.debugger.getThread(tr).setInStep(false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Operator operator = this;
        synchronized (operator) {
            if (this.stop) {
                return;
            }
            this.stop = true;
            if (this.canInterrupt) {
                this.thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startEventHandlerThreadFor(final ThreadReference tr) {
        RequestProcessor rp;
        Operator operator = this;
        synchronized (operator) {
            if (this.eventHandler == null) {
                this.eventHandler = new RequestProcessor("Debugger Event Handler", 10);
            }
            rp = this.eventHandler;
        }
        final Thread[] threadPtr = new Thread[]{null};
        RequestProcessor.Task task = rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread[] threadArray = threadPtr;
                synchronized (threadPtr) {
                    EventQueue eventQueue;
                    threadPtr[0] = Thread.currentThread();
                    threadPtr.notifyAll();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    try {
                        eventQueue = VirtualMachineWrapper.eventQueue(MirrorWrapper.virtualMachine(tr));
                    }
                    catch (InternalExceptionWrapper ex) {
                        return;
                    }
                    catch (VMDisconnectedExceptionWrapper ex) {
                        return;
                    }
                    while (true) {
                        block16: {
                            try {
                                EventSet eventSet = EventQueueWrapper.remove(eventQueue);
                                HashSet ignoredThreads = new HashSet();
                                if (Operator.this.testIgnoreEvent(eventSet, ignoredThreads)) {
                                    eventSet.resume();
                                    break block16;
                                }
                                List list = Operator.this.parallelEvents;
                                synchronized (list) {
                                    Operator.this.parallelEvents.add(eventSet);
                                }
                            }
                            catch (InterruptedException ex) {
                                return;
                            }
                            catch (InternalExceptionWrapper ex) {
                                continue;
                            }
                            catch (VMDisconnectedExceptionWrapper ex) {
                                return;
                            }
                            catch (Exception e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                            }
                        }
                        if (Thread.interrupted()) break;
                    }
                    return;
                }
            }
        }, 500);
        this.eventHandlers.put(tr, new HandlerTask(task, threadPtr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMethodInvoking(ThreadReference tr) {
        if (Thread.currentThread() == this.thread) {
            this.startEventHandlerThreadFor(tr);
        }
        Set<ThreadReference> set = this.methodInvokingThreads;
        synchronized (set) {
            this.methodInvokingThreads.add(tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMethodInvokeDone(ThreadReference tr) {
        HandlerTask task;
        if (Thread.currentThread() == this.thread && (task = this.eventHandlers.remove(tr)) != null) {
            task.cancel();
        }
        Set<ThreadReference> set = this.methodInvokingThreads;
        synchronized (set) {
            this.methodInvokingThreads.remove(tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testIgnoreEvent(EventSet eventSet, Set<ThreadReference> resumedThreads) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        int suspendPolicy;
        ThreadReference tref = null;
        for (Event e : eventSet) {
            if (!(e instanceof LocatableEvent)) continue;
            tref = LocatableEventWrapper.thread((LocatableEvent)e);
        }
        if (tref != null) {
            Set<ThreadReference> i$ = this.methodInvokingThreads;
            synchronized (i$) {
                if (this.methodInvokingThreads.contains(tref)) {
                    return true;
                }
            }
        }
        if ((suspendPolicy = EventSetWrapper.suspendPolicy(eventSet)) == 2) {
            Set<ThreadReference> set = this.methodInvokingThreads;
            synchronized (set) {
                for (ThreadReference tr : this.methodInvokingThreads) {
                    try {
                        ThreadReferenceWrapper.resume(tr);
                        resumedThreads.add(tr);
                    }
                    catch (ObjectCollectedExceptionWrapper ex) {
                    }
                    catch (IllegalThreadStateExceptionWrapper ex) {}
                }
            }
        }
        return false;
    }

    private void printEvent(Event e, Executor exec) {
        try {
            if (e instanceof ClassPrepareEvent) {
                logger.fine("JDI EVENT: ClassPrepareEvent " + ClassPrepareEventWrapper.referenceType((ClassPrepareEvent)e));
            } else if (e instanceof ClassUnloadEvent) {
                logger.fine("JDI EVENT: ClassUnloadEvent " + ClassUnloadEventWrapper.className((ClassUnloadEvent)e));
            } else if (e instanceof ThreadStartEvent) {
                try {
                    logger.fine("JDI EVENT: ThreadStartEvent " + ThreadStartEventWrapper.thread((ThreadStartEvent)e));
                }
                catch (Exception ex) {
                    logger.fine("JDI EVENT: ThreadStartEvent1 " + e);
                }
            } else if (e instanceof ThreadDeathEvent) {
                try {
                    logger.fine("JDI EVENT: ThreadDeathEvent " + ThreadDeathEventWrapper.thread((ThreadDeathEvent)e));
                }
                catch (Exception ex) {
                    logger.fine("JDI EVENT: ThreadDeathEvent1 " + e);
                }
            } else if (e instanceof MethodEntryEvent) {
                try {
                    logger.fine("JDI EVENT: MethodEntryEvent " + e);
                }
                catch (Exception ex) {
                    logger.fine("JDI EVENT: MethodEntryEvent " + e);
                }
            } else if (e instanceof BreakpointEvent) {
                logger.fine("JDI EVENT: BreakpointEvent " + LocatableEventWrapper.thread((BreakpointEvent)e) + " : " + LocatableWrapper.location((BreakpointEvent)e));
            } else if (e instanceof StepEvent) {
                logger.fine("JDI EVENT: StepEvent " + LocatableEventWrapper.thread((StepEvent)e) + " : " + LocatableWrapper.location((StepEvent)e));
            } else {
                logger.fine("JDI EVENT: " + e + " : " + exec);
            }
        }
        catch (Exception ex) {
            logger.fine(ex.getLocalizedMessage());
        }
    }

    static /* synthetic */ boolean access$100(Operator x0) {
        return x0.stop;
    }

    static /* synthetic */ boolean access$202(Operator x0, boolean x1) {
        x0.canInterrupt = x1;
        return x0.canInterrupt;
    }

    static /* synthetic */ Logger access$300() {
        return logger;
    }

    static /* synthetic */ ThreadReference access$400(Event x0) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        return Operator.getEventThread(x0);
    }

    static /* synthetic */ void access$600(Operator x0, Event x1, Executor x2) {
        x0.printEvent(x1, x2);
    }

    static /* synthetic */ boolean access$102(Operator x0, boolean x1) {
        x0.stop = x1;
        return x0.stop;
    }

    private static final class HandlerTask {
        private RequestProcessor.Task task;
        private Thread[] threadPtr;

        HandlerTask(RequestProcessor.Task task, Thread[] threadPtr) {
            this.task = task;
            this.threadPtr = threadPtr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void cancel() {
            if (this.task.cancel()) return;
            Thread[] threadArray = this.threadPtr;
            synchronized (this.threadPtr) {
                if (this.threadPtr[0] == null) {
                    try {
                        this.threadPtr.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                Thread t = this.threadPtr[0];
                if (t == null) return;
                t.interrupt();
                this.task.waitFinished();
                return;
            }
        }
    }
}

