/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.FieldWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;

public class FieldVariable
extends AbstractVariable
implements org.netbeans.api.debugger.jpda.Field,
Refreshable {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    protected Field field;
    private ObjectReference objectReference;
    private ReferenceType classType;
    private boolean valueSet = true;
    private final Object valueLock = new Object();
    private boolean valueRetrieved = false;
    private PrimitiveValue value;

    public FieldVariable(JPDADebuggerImpl debugger, PrimitiveValue value, Field field, String parentID, ObjectReference objectReference) {
        super(debugger, value, FieldVariable.getID(parentID, field));
        this.field = field;
        this.objectReference = objectReference;
    }

    public FieldVariable(JPDADebuggerImpl debugger, Field field, String parentID, ObjectReference objectReference) {
        this(debugger, null, field, parentID, objectReference);
        this.valueSet = false;
    }

    private static String getID(String parentID, Field field) {
        try {
            return parentID + '.' + TypeComponentWrapper.name(field);
        }
        catch (InternalExceptionWrapper ex) {
            return parentID + '.' + ex.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return parentID + ".0";
        }
    }

    public String getName() {
        try {
            return TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "";
        }
    }

    public String getClassName() {
        try {
            return ReferenceTypeWrapper.name(TypeComponentWrapper.declaringType(this.field));
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getCause().getLocalizedMessage();
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "";
        }
    }

    public JPDAClassType getDeclaringClass() {
        return new JPDAClassTypeImpl(this.getDebugger(), this.getTheDeclaringClassType());
    }

    private ReferenceType getTheDeclaringClassType() {
        ReferenceType type = this.classType;
        if (type == null) {
            this.classType = type = FieldVariable.getTheDeclaringClassType(this.objectReference, this.field);
        }
        return type;
    }

    static ReferenceType getTheDeclaringClassType(ObjectReference objectReference, Field field) {
        ReferenceType type;
        try {
            type = objectReference != null ? (ReferenceType)ValueWrapper.type(objectReference) : TypeComponentWrapper.declaringType(field);
        }
        catch (InternalExceptionWrapper ex) {
            throw ex.getCause();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            throw ex.getCause();
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            throw ex.getCause();
        }
        return type;
    }

    public String getDeclaredType() {
        try {
            return FieldWrapper.typeName(this.field);
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "";
        }
    }

    public boolean isStatic() {
        return TypeComponentWrapper.isStatic0(this.field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Value getInnerValue() {
        if (this.valueSet) {
            return super.getInnerValue();
        }
        Object object = this.valueLock;
        synchronized (object) {
            if (!this.valueRetrieved) {
                Value v;
                if (logger.isLoggable(Level.FINE)) {
                    if (this.objectReference == null) {
                        logger.fine("STARTED (FV): " + this.getTheDeclaringClassType() + ".getValue(" + this.field + ")");
                    } else {
                        logger.fine("STARTED (FV): " + this.objectReference + ".getValue(" + this.field + ")");
                    }
                }
                try {
                    v = this.objectReference == null ? ReferenceTypeWrapper.getValue(this.getTheDeclaringClassType(), this.field) : ObjectReferenceWrapper.getValue(this.objectReference, this.field);
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    v = null;
                }
                catch (InternalExceptionWrapper ocex) {
                    v = null;
                }
                catch (VMDisconnectedExceptionWrapper ocex) {
                    v = null;
                }
                if (logger.isLoggable(Level.FINE)) {
                    if (this.objectReference == null) {
                        logger.fine("FINISHED(FV): " + this.getTheDeclaringClassType() + ".getValue(" + this.field + ") = " + v);
                    } else {
                        logger.fine("FINISHED(FV): " + this.objectReference + ".getValue(" + this.field + ") = " + v);
                    }
                    logger.log(Level.FINE, "Called from ", new IllegalStateException("TEST"));
                }
                this.value = (PrimitiveValue)v;
                this.valueRetrieved = true;
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setValue(Value value) throws InvalidExpressionException {
        block15: {
            try {
                boolean set = false;
                if (this.objectReference != null) {
                    ObjectReferenceWrapper.setValue(this.objectReference, this.field, value);
                    set = true;
                } else {
                    ReferenceType rt = this.getTheDeclaringClassType();
                    if (rt instanceof ClassType) {
                        ClassType ct = (ClassType)rt;
                        ClassTypeWrapper.setValue(ct, this.field, value);
                        set = true;
                    }
                }
                if (!set) {
                    throw new InvalidExpressionException(this.field.toString());
                }
                if (this.valueSet) break block15;
                Object object = this.valueLock;
                synchronized (object) {
                    this.value = (PrimitiveValue)value;
                }
            }
            catch (IllegalArgumentExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex.getCause());
            }
            catch (InvalidTypeException ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (ClassNotLoadedException ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (InternalExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (ClassNotPreparedExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws RefreshFailedException {
        if (this.valueSet) {
            return;
        }
        Object object = this.valueLock;
        synchronized (object) {
            if (!this.valueRetrieved) {
                this.getInnerValue();
            }
        }
    }

    @Override
    public synchronized boolean isCurrent() {
        return this.valueSet || this.valueRetrieved;
    }

    @Override
    public FieldVariable clone() {
        String name;
        try {
            name = TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper ex) {
            name = ex.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            name = "0";
        }
        FieldVariable clon = new FieldVariable(this.getDebugger(), (PrimitiveValue)this.getJDIValue(), this.field, this.getID().substring(0, this.getID().length() - ("." + name + (this.getJDIValue() instanceof ObjectReference ? "^" : "")).length()), this.objectReference);
        clon.classType = this.classType;
        return clon;
    }

    @Override
    public String toString() {
        try {
            return "FieldVariable " + TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "Disconnected";
        }
    }
}

