/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.DeadlockDetectorImpl;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class CheckDeadlocksAction
extends AbstractAction
implements Runnable {
    private EnableListener listener = new EnableListener(this);

    public CheckDeadlocksAction() {
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this.listener);
        this.putValue("Name", CheckDeadlocksAction.getDisplayName());
        this.checkEnabled();
    }

    public static String getDisplayName() {
        return NbBundle.getMessage(CheckDeadlocksAction.class, (String)"CTL_CheckDeadlocks");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (de == null) {
            return;
        }
        final JPDADebuggerImpl debugger = (JPDADebuggerImpl)((Object)de.lookupFirst(null, JPDADebugger.class));
        if (debugger == null) {
            return;
        }
        debugger.getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                CheckDeadlocksAction.checkForDeadlock(debugger);
            }
        });
    }

    public static void checkForDeadlock(JPDADebuggerImpl debugger) {
        if (debugger.getState() == 4) {
            return;
        }
        VirtualMachine vm = debugger.getVirtualMachine();
        if (vm == null) {
            return;
        }
        try {
            VirtualMachineWrapper.suspend(vm);
            ArrayList<JPDAThreadImpl> threadsToNotify = new ArrayList<JPDAThreadImpl>();
            for (ThreadReference threadRef : VirtualMachineWrapper.allThreads(vm)) {
                try {
                    if (ThreadReferenceWrapper.suspendCount(threadRef) != 1) continue;
                    JPDAThreadImpl jpdaThread = debugger.getThread(threadRef);
                    jpdaThread.notifySuspended();
                    threadsToNotify.add(jpdaThread);
                }
                catch (ObjectCollectedExceptionWrapper e) {
                }
                catch (IllegalThreadStateExceptionWrapper e) {}
            }
            DeadlockDetector detector = debugger.getThreadsCollector().getDeadlockDetector();
            try {
                ((DeadlockDetectorImpl)detector).waitForUnfinishedTasks(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            Set dealocks = detector.getDeadlocks();
            if (dealocks == null || dealocks.size() == 0) {
                String msg = NbBundle.getMessage(CheckDeadlocksAction.class, (String)"CTL_No_Deadlock");
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                for (JPDAThreadImpl thread : threadsToNotify) {
                    thread.notifyToBeResumed();
                }
                VirtualMachineWrapper.resume(vm);
            }
        }
        catch (InternalExceptionWrapper e) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    private synchronized boolean canBeEnabled() {
        DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (de == null) {
            return false;
        }
        JPDADebugger debugger = (JPDADebugger)de.lookupFirst(null, JPDADebugger.class);
        return debugger != null;
    }

    private void checkEnabled() {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        this.setEnabled(this.canBeEnabled());
    }

    protected void finalize() throws Throwable {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this.listener);
    }

    private static class EnableListener
    extends DebuggerManagerAdapter {
        private Reference actionRef;

        public EnableListener(CheckDeadlocksAction action) {
            this.actionRef = new WeakReference<CheckDeadlocksAction>(action);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            CheckDeadlocksAction action = (CheckDeadlocksAction)this.actionRef.get();
            if (action != null) {
                action.checkEnabled();
            }
        }
    }
}

