/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.commands;

import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.commands.BugzillaCommand;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;

public class PerformQueryCommand
extends BugzillaCommand {
    private final BugzillaRepository repository;
    private final String queryUrl;
    private final TaskDataCollector collector;
    private IStatus status;

    public PerformQueryCommand(BugzillaRepository repository, String queryUrl, TaskDataCollector collector) {
        this.repository = repository;
        this.queryUrl = queryUrl;
        this.collector = collector;
    }

    @Override
    public void execute() throws CoreException {
        TaskRepository taskRepository = this.repository.getTaskRepository();
        RepositoryQuery query = new RepositoryQuery(taskRepository.getConnectorKind(), "");
        query.setUrl(this.queryUrl);
        BugzillaRepositoryConnector rc = Bugzilla.getInstance().getRepositoryConnector();
        Bugzilla.LOG.log(Level.FINE, "executing query on repository {0} with parameters \n\t{1}", new Object[]{this.repository.getUrl(), this.queryUrl});
        this.status = rc.performQuery(taskRepository, (IRepositoryQuery)query, this.collector, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public IStatus getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PerformQueryCommand [repository=");
        sb.append(this.repository.getUrl());
        sb.append(", queryUrl=");
        sb.append(this.queryUrl);
        sb.append("]");
        return super.toString();
    }
}

