/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.actions;

import java.net.URL;
import java.util.concurrent.Callable;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.GrailsServerState;
import org.netbeans.modules.groovy.grailsproject.actions.ConfigurationSupport;
import org.netbeans.modules.groovy.grailsproject.commands.GrailsCommandChooser;
import org.netbeans.modules.groovy.grailsproject.commands.GrailsCommandSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class GrailsCommandAction
extends CallableSystemAction {
    public void performAction() {
        ExecutionDescriptor descriptor;
        Callable callable;
        GrailsPlatform runtime = GrailsPlatform.getDefault();
        if (!runtime.isConfigured()) {
            ConfigurationSupport.showConfigurationWarning(runtime);
            return;
        }
        final GrailsProject project = GrailsProject.inferGrailsProject();
        if (project == null) {
            return;
        }
        GrailsCommandChooser.CommandDescriptor commandDescriptor = GrailsCommandChooser.select(project);
        if (commandDescriptor == null) {
            return;
        }
        ProjectInformation inf = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        String displayName = inf.getDisplayName() + " (" + commandDescriptor.getGrailsCommand().getCommand() + ")";
        final String[] params = commandDescriptor.getCommandParams() != null && !"".equals(commandDescriptor.getCommandParams().trim()) ? new String[]{commandDescriptor.getCommandParams()} : new String[]{};
        final boolean debug = commandDescriptor.isDebug();
        if ("run-app".equals(commandDescriptor.getGrailsCommand().getCommand())) {
            GrailsServerState serverState = (GrailsServerState)project.getLookup().lookup(GrailsServerState.class);
            Process process = null;
            if (serverState != null && serverState.isRunning()) {
                if (!debug) {
                    URL url = serverState.getRunningUrl();
                    if (url != null) {
                        GrailsCommandSupport.showURL(url, debug, project);
                    }
                    return;
                }
                process = serverState.getProcess();
                if (process != null) {
                    process.destroy();
                }
            }
            final Process oldProcess = process;
            callable = new Callable<Process>(){

                @Override
                public Process call() throws Exception {
                    if (oldProcess != null) {
                        oldProcess.waitFor();
                    }
                    Callable inner = ExecutionSupport.getInstance().createRunApp(GrailsProjectConfig.forProject((Project)project), debug, params);
                    Process process = (Process)inner.call();
                    GrailsServerState serverState = (GrailsServerState)project.getLookup().lookup(GrailsServerState.class);
                    if (serverState != null) {
                        serverState.setProcess(process);
                        serverState.setDebug(debug);
                    }
                    return process;
                }
            };
            descriptor = project.getCommandSupport().getRunDescriptor(debug);
        } else {
            callable = ExecutionSupport.getInstance().createSimpleCommand(commandDescriptor.getGrailsCommand().getCommand(), debug, GrailsProjectConfig.forProject((Project)project), params);
            descriptor = project.getCommandSupport().getDescriptor(commandDescriptor.getGrailsCommand().getCommand(), debug);
        }
        ExecutionService service = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)descriptor, (String)displayName);
        service.run();
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(GrailsCommandAction.class, (String)"CTL_GrailsCommandAction");
    }
}

