/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.spi;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.common.ui.BrokenServerLibrarySupport;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.model.api.RestApplicationModel;
import org.netbeans.modules.websvc.rest.model.api.RestApplications;
import org.netbeans.modules.websvc.rest.spi.ApplicationConfigPanel;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class WebRestSupport
extends RestSupport {
    private static final String JERSEY = "jersey";
    private static final String JSON = "json";
    private static final String JETTISON = "jettison";
    private static final String ROME = "rome";
    public static final String PROP_REST_RESOURCES_PATH = "rest.resources.path";
    public static final String PROP_REST_CONFIG_TYPE = "rest.config.type";
    public static final String CONFIG_TYPE_IDE = "ide";
    public static final String CONFIG_TYPE_USER = "user";
    public static final String CONFIG_TYPE_DD = "dd";
    public static final String REST_CONFIG_TARGET = "generate-rest-config";
    protected static final String JERSEY_SPRING_JAR_PATTERN = "jersey-spring.*\\.jar";
    protected static final String JERSEY_PROP_PACKAGES = "com.sun.jersey.config.property.packages";
    protected static final String JERSEY_PROP_PACKAGES_DESC = "Multiple packages, separated by semicolon(;), can be specified in param-value";

    public WebRestSupport(Project project) {
        super(project);
    }

    @Override
    public boolean isRestSupportOn() {
        if (this.getAntProjectHelper() == null) {
            return false;
        }
        return this.getProjectProperty(PROP_REST_CONFIG_TYPE) != null;
    }

    @Override
    public FileObject getPersistenceXml() {
        PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)this.getProject().getProjectDirectory());
        if (persistenceScope != null) {
            return persistenceScope.getPersistenceXml();
        }
        return null;
    }

    public WebApp getWebApp() throws IOException {
        FileObject fileObject = this.getWebXml();
        if (fileObject != null) {
            return DDProvider.getDefault().getDDRoot(fileObject);
        }
        return null;
    }

    protected WebApp findWebApp() throws IOException {
        FileObject fileObject;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null && (fileObject = webModule.getDeploymentDescriptor()) != null) {
            return DDProvider.getDefault().getDDRoot(fileObject);
        }
        return null;
    }

    public String getApplicationPathFromDD() throws IOException {
        ServletMapping servletMapping;
        WebApp webApp = this.findWebApp();
        if (webApp != null && (servletMapping = this.getRestServletMapping(webApp)) != null) {
            String string = null;
            if (servletMapping instanceof ServletMapping25) {
                String[] stringArray = ((ServletMapping25)servletMapping).getUrlPatterns();
                if (stringArray.length > 0) {
                    string = stringArray[0];
                }
            } else {
                string = servletMapping.getUrlPattern();
            }
            if (string != null) {
                if (string.endsWith("*")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                return string;
            }
        }
        return null;
    }

    public FileObject getDeploymentDescriptor() {
        WebModuleProvider webModuleProvider = (WebModuleProvider)this.project.getLookup().lookup(WebModuleProvider.class);
        if (webModuleProvider != null) {
            return webModuleProvider.findWebModule(this.project.getProjectDirectory()).getDeploymentDescriptor();
        }
        return null;
    }

    public FileObject getWebXml() throws IOException {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null) {
            FileObject fileObject = webModule.getDeploymentDescriptor();
            if (fileObject == null) {
                FileObject fileObject2;
                FileObject fileObject3 = webModule.getWebInf();
                if (fileObject3 == null && (fileObject2 = webModule.getDocumentBase()) != null) {
                    fileObject3 = fileObject2.createFolder("WEB-INF");
                }
                if (fileObject3 != null) {
                    fileObject = DDHelper.createWebXml((Profile)webModule.getJ2eeProfile(), (FileObject)fileObject3);
                }
            }
            return fileObject;
        }
        return null;
    }

    public ServletMapping getRestServletMapping(WebApp webApp) {
        String string = null;
        for (Servlet servlet : webApp.getServlet()) {
            String string2 = servlet.getServletClass();
            if (!"com.sun.jersey.spi.container.servlet.ServletContainer".equals(string2) && !"com.sun.jersey.spi.spring.container.servlet.SpringServlet".equals(string2)) continue;
            string = servlet.getServletName();
            break;
        }
        if (string != null) {
            for (Servlet servlet : webApp.getServletMapping()) {
                if (!string.equals(servlet.getServletName())) continue;
                return servlet;
            }
        }
        return null;
    }

    protected boolean hasRestServletAdaptor() {
        try {
            return this.getRestServletAdaptor(this.getWebApp()) != null;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    public boolean hasJerseyLibrary() {
        Collection<ServerLibrary> collection = this.getServerJerseyLibraries();
        for (ServerLibrary serverLibrary : collection) {
            String string = serverLibrary.getImplementationTitle();
            if (!(string = string.toLowerCase(Locale.ENGLISH)).contains(JERSEY)) continue;
            return true;
        }
        return false;
    }

    public Collection<ServerLibrary> getServerJerseyLibraries() {
        try {
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider == null) {
                return Collections.emptyList();
            }
            String string = j2eeModuleProvider.getServerInstanceID();
            if (string == null) {
                return Collections.emptyList();
            }
            ServerInstance serverInstance = Deployment.getDefault().getServerInstance(string);
            if (serverInstance == null) {
                return Collections.emptyList();
            }
            ServerInstance.LibraryManager libraryManager = serverInstance.getLibraryManager();
            if (libraryManager == null) {
                return Collections.emptyList();
            }
            LinkedList<ServerLibrary> linkedList = new LinkedList<ServerLibrary>();
            linkedList.addAll(this.findJerseyLibraries(libraryManager.getDeployableLibraries()));
            linkedList.addAll(this.findJerseyLibraries(libraryManager.getDeployedLibraries()));
            return linkedList;
        }
        catch (InstanceRemovedException instanceRemovedException) {
            Logger.getLogger(WebRestSupport.class.getName()).log(Level.INFO, null, instanceRemovedException);
            return Collections.emptyList();
        }
    }

    public boolean addDeployableServerJerseyLibraries() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        Collection<ServerLibrary> collection = this.getServerJerseyLibraries();
        if (j2eeModuleProvider != null && collection.size() > 0) {
            try {
                for (ServerLibrary serverLibrary : collection) {
                    j2eeModuleProvider.getConfigSupport().configureLibrary(ServerLibraryDependency.minimalVersion((String)serverLibrary.getName(), (Version)serverLibrary.getSpecificationVersion(), (Version)serverLibrary.getImplementationVersion()));
                }
                Preferences preferences = ProjectUtils.getPreferences((Project)this.project, ProjectUtils.class, (boolean)true);
                preferences.put(BrokenServerLibrarySupport.OFFER_LIBRARY_DEPLOYMENT, Boolean.TRUE.toString());
                return true;
            }
            catch (ConfigurationException configurationException) {
                Logger.getLogger(WebRestSupport.class.getName()).log(Level.WARNING, "Exception during extending an web project", configurationException);
                return false;
            }
        }
        return false;
    }

    protected Servlet getRestServletAdaptor(WebApp webApp) {
        if (webApp != null) {
            for (Servlet servlet : webApp.getServlet()) {
                String string = servlet.getServletClass();
                if (!"com.sun.jersey.spi.container.servlet.ServletContainer".equals(string) && !"com.sun.jersey.spi.spring.container.servlet.SpringServlet".equals(string) && !"com.sun.ws.rest.impl.container.servlet.ServletAdaptor".equals(string)) continue;
                return servlet;
            }
        }
        return null;
    }

    protected Servlet getRestServletAdaptorByName(WebApp webApp, String string) {
        if (webApp != null) {
            for (Servlet servlet : webApp.getServlet()) {
                if (!string.equals(servlet.getServletName())) continue;
                return servlet;
            }
        }
        return null;
    }

    public void addResourceConfigToWebApp(String string) throws IOException {
        FileObject fileObject = this.getWebXml();
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return;
        }
        if (webApp.getStatus() == 2) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebRestSupport.class, (String)"MSG_InvalidDD", (Object)webApp.getError()), 0));
            return;
        }
        boolean bl = false;
        try {
            ServletMapping servletMapping;
            Servlet servlet = this.getRestServletAdaptor(webApp);
            if (servlet == null) {
                servlet = (Servlet)webApp.createBean("Servlet");
                servlet.setServletName("ServletAdaptor");
                boolean bl2 = this.hasSpringSupport();
                if (bl2) {
                    servlet.setServletClass("com.sun.jersey.spi.spring.container.servlet.SpringServlet");
                    servletMapping = (InitParam)servlet.createBean("InitParam");
                    servletMapping.setParamName(JERSEY_PROP_PACKAGES);
                    servletMapping.setParamValue(".");
                    servletMapping.setDescription(JERSEY_PROP_PACKAGES_DESC);
                    servlet.addInitParam((InitParam)servletMapping);
                } else {
                    servlet.setServletClass("com.sun.jersey.spi.container.servlet.ServletContainer");
                }
                servlet.setLoadOnStartup(BigInteger.valueOf(1L));
                webApp.addServlet(servlet);
                bl = true;
            }
            String string2 = string;
            if (!string.startsWith("/")) {
                string2 = "/" + string;
            }
            if (string2.endsWith("/")) {
                string2 = string2 + "*";
            } else if (!string2.endsWith("*")) {
                string2 = string2 + "/*";
            }
            servletMapping = this.getRestServletMapping(webApp);
            if (servletMapping == null) {
                servletMapping = (ServletMapping)webApp.createBean("ServletMapping");
                servletMapping.setServletName(servlet.getServletName());
                if (servletMapping instanceof ServletMapping25) {
                    ((ServletMapping25)servletMapping).addUrlPattern(string2);
                } else {
                    servletMapping.setUrlPattern(string2);
                }
                webApp.addServletMapping(servletMapping);
                bl = true;
            } else {
                String[] stringArray;
                boolean bl3 = false;
                if (servletMapping instanceof ServletMapping25) {
                    stringArray = ((ServletMapping25)servletMapping).getUrlPatterns();
                    if (stringArray.length == 0 || !string2.equals(stringArray[0])) {
                        bl3 = true;
                    }
                } else if (!string2.equals(servletMapping.getUrlPattern())) {
                    bl3 = true;
                }
                if (bl3) {
                    if (servletMapping instanceof ServletMapping25) {
                        stringArray = ((ServletMapping25)servletMapping).getUrlPatterns();
                        if (stringArray.length > 0) {
                            ((ServletMapping25)servletMapping).setUrlPattern(0, string2);
                        } else {
                            ((ServletMapping25)servletMapping).addUrlPattern(string2);
                        }
                    } else {
                        servletMapping.setUrlPattern(string2);
                    }
                    bl = true;
                }
            }
            if (bl) {
                webApp.write(fileObject);
                this.logResourceCreation(this.project);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException);
        }
    }

    protected void removeResourceConfigFromWebApp() throws IOException {
        FileObject fileObject = this.getWebXml();
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return;
        }
        boolean bl = false;
        Servlet servlet = this.getRestServletAdaptorByName(webApp, "ServletAdaptor");
        if (servlet != null) {
            webApp.removeServlet(servlet);
            bl = true;
        }
        for (ServletMapping servletMapping : webApp.getServletMapping()) {
            if (!"ServletAdaptor".equals(servletMapping.getServletName())) continue;
            webApp.removeServletMapping(servletMapping);
            bl = true;
            break;
        }
        if (bl) {
            webApp.write(fileObject);
        }
    }

    protected void logResourceCreation(Project project) {
    }

    public List<RestApplication> getRestApplications() {
        RestApplicationModel restApplicationModel = this.getRestApplicationsModel();
        if (restApplicationModel != null) {
            try {
                return (List)restApplicationModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestApplications, List<RestApplication>>(){

                    public List<RestApplication> run(RestApplications restApplications) throws IOException {
                        return restApplications.getRestApplications();
                    }
                });
            }
            catch (IOException iOException) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    protected RestConfig setApplicationConfigProperty(boolean bl) {
        ApplicationConfigPanel applicationConfigPanel = new ApplicationConfigPanel(bl, this.hasJerseyLibrary());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)applicationConfigPanel, NbBundle.getMessage(WebRestSupport.class, (String)"TTL_ApplicationConfigPanel"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (NotifyDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            String string = applicationConfigPanel.getConfigType();
            this.setProjectProperty(PROP_REST_CONFIG_TYPE, string);
            if (CONFIG_TYPE_IDE.equals(string)) {
                String string2 = applicationConfigPanel.getApplicationPath();
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                this.setProjectProperty(PROP_REST_RESOURCES_PATH, string2);
                RestConfig restConfig = RestConfig.IDE;
                restConfig.setResourcePath(string2);
                restConfig.setJerseyLibSelected(applicationConfigPanel.isJerseyLibSelected());
                restConfig.setServerJerseyLibSelected(applicationConfigPanel.isServerJerseyLibSelected());
                return restConfig;
            }
            if (CONFIG_TYPE_DD.equals(string)) {
                RestConfig restConfig = RestConfig.DD;
                restConfig.setResourcePath(applicationConfigPanel.getApplicationPath());
                restConfig.setJerseyLibSelected(applicationConfigPanel.isJerseyLibSelected());
                restConfig.setServerJerseyLibSelected(applicationConfigPanel.isServerJerseyLibSelected());
                return restConfig;
            }
        } else {
            this.setProjectProperty(PROP_REST_CONFIG_TYPE, CONFIG_TYPE_USER);
            RestConfig restConfig = RestConfig.USER;
            restConfig.setJerseyLibSelected(applicationConfigPanel.isJerseyLibSelected());
            restConfig.setServerJerseyLibSelected(applicationConfigPanel.isServerJerseyLibSelected());
            return restConfig;
        }
        return RestConfig.USER;
    }

    protected void addJerseySpringJar() throws IOException {
        File[] fileArray;
        File file;
        ClassPath classPath;
        FileObject fileObject = this.findSourceRoot();
        if (fileObject != null && (classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile")).findResource("com/sun/jersey/api/spring/Autowire.class") == null && (file = InstalledFileLocator.getDefault().locate("modules/ext/rest", null, false)) != null && file.isDirectory() && (fileArray = file.listFiles(new RestSupport.JerseyFilter(JERSEY_SPRING_JAR_PATTERN))) != null && fileArray.length > 0) {
            URL uRL = FileUtil.getArchiveRoot((URL)fileArray[0].toURI().toURL());
            ProjectClassPathModifier.addRoots((URL[])new URL[]{uRL}, (FileObject)fileObject, (String)"classpath/compile");
        }
    }

    private Collection<ServerLibrary> findJerseyLibraries(Collection<ServerLibrary> collection) {
        ArrayList<ServerLibrary> arrayList = new ArrayList<ServerLibrary>(collection.size());
        for (ServerLibrary serverLibrary : collection) {
            String string = serverLibrary.getImplementationTitle();
            if (!(string = string.toLowerCase(Locale.ENGLISH)).contains(JERSEY) && !string.contains(JSON) && !string.contains(ROME) && !string.contains(JETTISON)) continue;
            arrayList.add(serverLibrary);
        }
        return arrayList;
    }

    @Override
    public int getProjectType() {
        return 1;
    }

    public static enum RestConfig {
        IDE,
        USER,
        DD;

        private String resourcePath;
        private boolean jerseyLibSelected;
        private boolean serverJerseyLibSelected;

        public boolean isJerseyLibSelected() {
            return this.jerseyLibSelected;
        }

        public void setJerseyLibSelected(boolean bl) {
            this.jerseyLibSelected = bl;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public void setResourcePath(String string) {
            this.resourcePath = string;
        }

        public void setServerJerseyLibSelected(boolean bl) {
            this.serverJerseyLibSelected = bl;
        }

        public boolean isServerJerseyLibSelected() {
            return this.serverJerseyLibSelected;
        }
    }
}

