/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.gotodeclaration.symbol.CppSymbolDescriptor;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.spi.jumpto.support.NameMatcher;
import org.netbeans.spi.jumpto.support.NameMatcherFactory;
import org.netbeans.spi.jumpto.symbol.SymbolProvider;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.util.NbBundle;

public class CppSymbolProvider
implements SymbolProvider {
    Cache cache;
    private boolean cancelled;
    private static final boolean TRACE = Boolean.getBoolean("cnd.gotosymbol.trace");
    private static final boolean USE_CACHE = CndUtils.getBoolean((String)"cnd.gotosymbol.cache", (boolean)true);

    public CppSymbolProvider() {
        if (TRACE) {
            this.trace("ctor", new Object[0]);
        }
    }

    public synchronized void cancel() {
        if (TRACE) {
            this.trace("cancel", new Object[0]);
        }
        this.cancelled = true;
        this.cache = null;
    }

    public synchronized void cleanup() {
        if (TRACE) {
            this.trace("cleanup", new Object[0]);
        }
        this.cancelled = false;
        this.cache = null;
    }

    public static CsmSelect.NameAcceptor createNameAcceptor(String text, SearchType searchType) {
        final NameMatcher nameMatcher = NameMatcherFactory.createNameMatcher((String)text, (SearchType)searchType);
        return new CsmSelect.NameAcceptor(){

            public boolean accept(CharSequence name) {
                return nameMatcher.accept(((Object)name).toString());
            }
        };
    }

    public synchronized void computeSymbolNames(SymbolProvider.Context context, SymbolProvider.Result result) {
        List cached;
        if (TRACE) {
            this.trace("computeSymbolNames %s", this.toString(context));
        }
        this.cancelled = false;
        CsmSelect.NameAcceptor nameAcceptor = CppSymbolProvider.createNameAcceptor(context.getText(), context.getSearchType());
        if (nameAcceptor == null) {
            if (CndUtils.isDebugMode()) {
                Logger log = Logger.getLogger("org.netbeans.modules.cnd.gotodeclaration");
                log.log(Level.SEVERE, "Can not create matcher for ''{0}'' search type {1}", new Object[]{context.getText(), context.getSearchType()});
            }
            return;
        }
        ArrayList<CppSymbolDescriptor> symbols = new ArrayList<CppSymbolDescriptor>();
        boolean filled = false;
        if (this.cache != null && context.getSearchType() == this.cache.searchType && context.getText().startsWith(this.cache.text) && (cached = (List)this.cache.data.get(context.getProject())) != null) {
            filled = true;
            long time = System.currentTimeMillis();
            for (CppSymbolDescriptor desc : cached) {
                if (!nameAcceptor.accept(desc.getRawName())) continue;
                symbols.add(desc);
            }
            if (TRACE) {
                this.trace("Narrowing %d symbols took %d ms", symbols.size(), System.currentTimeMillis() - time);
            }
        }
        if (!filled) {
            long time = System.currentTimeMillis();
            this.collect(context, nameAcceptor, symbols);
            if (TRACE) {
                this.trace("Collecting %d symbols took %d ms", symbols.size(), System.currentTimeMillis() - time);
            }
        }
        if (this.cancelled) {
            this.cache = null;
        } else {
            if (USE_CACHE) {
                this.cache = new Cache(context.getSearchType(), context.getText());
                this.cache.data.put(context.getProject(), symbols);
            }
            result.addResult(symbols);
        }
        this.cancelled = false;
    }

    private void collect(SymbolProvider.Context context, CsmSelect.NameAcceptor nameAcceptor, List<CppSymbolDescriptor> symbols) {
        if (context.getProject() == null) {
            HashSet<CsmProject> libs = new HashSet<CsmProject>();
            for (CsmProject csmProject : CsmModelAccessor.getModel().projects()) {
                if (this.cancelled) break;
                this.collectSymbols(csmProject, nameAcceptor, symbols);
                this.collectLibs(csmProject, libs);
            }
            for (CsmProject csmProject : libs) {
                if (!this.cancelled) {
                    this.collectSymbols(csmProject, nameAcceptor, symbols);
                    continue;
                }
                break;
            }
        } else {
            CsmProject csmProject;
            NativeProject nativeProject = (NativeProject)context.getProject().getLookup().lookup(NativeProject.class);
            if (nativeProject != null && (csmProject = CsmModelAccessor.getModel().getProject((Object)nativeProject)) != null) {
                this.collectSymbols(csmProject, nameAcceptor, symbols);
            }
        }
    }

    private void collectLibs(CsmProject project, Collection<CsmProject> libs) {
        for (CsmProject lib : project.getLibraries()) {
            if (libs.contains(lib)) continue;
            libs.add(lib);
            this.collectLibs(lib, libs);
        }
    }

    private void collectSymbols(CsmProject csmProject, CsmSelect.NameAcceptor nameAcceptor, List<CppSymbolDescriptor> symbols) {
        this.collectSymbols(csmProject.getGlobalNamespace(), nameAcceptor, symbols);
        CsmSelect.CsmFilter nameFilter = CsmSelect.getFilterBuilder().createNameFilter(nameAcceptor);
        for (CsmFile csmFile : csmProject.getAllFiles()) {
            Iterator macros = CsmSelect.getMacros((CsmFile)csmFile, (CsmSelect.CsmFilter)nameFilter);
            while (macros.hasNext() && !this.cancelled) {
                symbols.add(new CppSymbolDescriptor((CsmOffsetable)macros.next()));
            }
            if (this.cancelled) break;
            Iterator funcs = CsmSelect.getStaticFunctions((CsmFile)csmFile, (CsmSelect.CsmFilter)nameFilter);
            while (funcs.hasNext() && !this.cancelled) {
                CsmFunction func = (CsmFunction)funcs.next();
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)func)) {
                    symbols.add(new CppSymbolDescriptor((CsmOffsetable)func));
                    continue;
                }
                CsmFunctionDefinition definition = func.getDefinition();
                if (definition == null) continue;
                symbols.add(new CppSymbolDescriptor((CsmOffsetable)definition));
            }
            if (this.cancelled) break;
            CsmSelect.CsmFilter definitions = CsmSelect.getFilterBuilder().createCompoundFilter(nameFilter, CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION_DEFINITION}));
            Iterator declarations = CsmSelect.getDeclarations((CsmFile)csmFile, (CsmSelect.CsmFilter)definitions);
            while (declarations.hasNext() && !this.cancelled) {
                CsmFunction func;
                CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)declarations.next();
                if (!CsmKindUtilities.isFunctionDefinition((CsmObject)decl) || !((CsmFunction)decl).isStatic() || !(func = (CsmFunction)decl).equals(func.getDeclaration()) || !CsmKindUtilities.isFile((CsmObject)func.getScope())) continue;
                symbols.add(new CppSymbolDescriptor((CsmOffsetable)func));
            }
            if (this.cancelled) break;
            Iterator vars = CsmSelect.getStaticVariables((CsmFile)csmFile, (CsmSelect.CsmFilter)nameFilter);
            while (vars.hasNext() && !this.cancelled) {
                symbols.add(new CppSymbolDescriptor((CsmOffsetable)vars.next()));
            }
            if (!this.cancelled) continue;
            break;
        }
    }

    private void collectSymbols(CsmNamespace namespace, CsmSelect.NameAcceptor nameAcceptor, List<CppSymbolDescriptor> symbols) {
        CsmSelect.CsmFilter nameFilter = CsmSelect.getFilterBuilder().createNameFilter(nameAcceptor);
        CsmSelect.CsmFilter simpleKindFilter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION, CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.TYPEDEF});
        CsmSelect.CsmFilter simpleNameAndKindFilter = CsmSelect.getFilterBuilder().createCompoundFilter(nameFilter, simpleKindFilter);
        Iterator declarations = CsmSelect.getDeclarations((CsmNamespace)namespace, (CsmSelect.CsmFilter)simpleNameAndKindFilter);
        while (declarations.hasNext() && !this.cancelled) {
            CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)declarations.next();
            if (CsmKindUtilities.isFunction((CsmObject)decl)) {
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)decl)) {
                    symbols.add(new CppSymbolDescriptor((CsmOffsetable)decl));
                    continue;
                }
                CsmFunctionDefinition definition = ((CsmFunction)decl).getDefinition();
                if (definition != null && definition != decl) continue;
                symbols.add(new CppSymbolDescriptor((CsmOffsetable)decl));
                continue;
            }
            symbols.add(new CppSymbolDescriptor((CsmOffsetable)decl));
        }
        CsmSelect.CsmFilter compoundKindFilter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.STRUCT});
        declarations = CsmSelect.getDeclarations((CsmNamespace)namespace, (CsmSelect.CsmFilter)compoundKindFilter);
        while (declarations.hasNext() && !this.cancelled) {
            this.addDeclarationIfNeed((CsmOffsetableDeclaration)declarations.next(), nameAcceptor, symbols);
        }
        for (CsmNamespace child : namespace.getNestedNamespaces()) {
            if (this.cancelled) break;
            this.collectSymbols(child, nameAcceptor, symbols);
        }
    }

    private void addDeclarationIfNeed(CsmOffsetableDeclaration decl, CsmSelect.NameAcceptor nameAcceptor, List<CppSymbolDescriptor> symbols) {
        block4: {
            block3: {
                if (nameAcceptor.accept(decl.getName())) {
                    symbols.add(new CppSymbolDescriptor((CsmOffsetable)decl));
                }
                if (!CsmKindUtilities.isClass((CsmObject)decl)) break block3;
                for (CsmMember member : ((CsmClass)decl).getMembers()) {
                    this.addDeclarationIfNeed((CsmOffsetableDeclaration)member, nameAcceptor, symbols);
                }
                break block4;
            }
            if (!CsmKindUtilities.isEnum((CsmObject)decl)) break block4;
            for (CsmEnumerator enumerator : ((CsmEnum)decl).getEnumerators()) {
                if (!nameAcceptor.accept(enumerator.getName())) continue;
                symbols.add(new CppSymbolDescriptor((CsmOffsetable)enumerator));
            }
        }
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"CPP_Provider_Display_Name");
    }

    public String name() {
        return "C/C++";
    }

    private String toString(SymbolProvider.Context context) {
        return String.format("Context: prj=%s type=%s text=%s", context.getProject(), context.getSearchType(), context.getText());
    }

    private void trace(String format, Object ... args) {
        if (TRACE) {
            format = String.format("%s @%x %s\n", this.getClass().getSimpleName(), this.hashCode(), format);
            System.err.printf(format, args);
        }
    }

    private static class Cache {
        public final String text;
        public final SearchType searchType;
        private final Map<Project, List<CppSymbolDescriptor>> data;

        public Cache(SearchType searchType, String text) {
            this.text = text;
            this.searchType = searchType;
            this.data = new HashMap<Project, List<CppSymbolDescriptor>>();
        }
    }
}

