/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring.plugins;

import com.sun.source.tree.Tree;
import java.io.IOException;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.beans.refactoring.ModificationTransaction;
import org.netbeans.modules.spring.beans.refactoring.Modifications;
import org.netbeans.modules.spring.beans.refactoring.Occurrences;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactoringElement;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactorings;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class SpringRenamePlugin
implements RefactoringPlugin {
    private final RenameRefactoring refactoring;

    public SpringRenamePlugin(RenameRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        TreePathHandle treePathHandle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle != null && treePathHandle.getKind() == Tree.Kind.METHOD) {
            return this.prepareMethodRefactoring(refactoringElements, treePathHandle);
        }
        return this.prepareClassRefactoring(refactoringElements, treePathHandle);
    }

    private Problem prepareClassRefactoring(RefactoringElementsBag refactoringElements, TreePathHandle treePathHandle) {
        NonRecursiveFolder folder;
        FileObject fo = null;
        if (treePathHandle != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePathHandle.getKind())) {
            fo = treePathHandle.getFileObject();
        }
        if (fo == null) {
            fo = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
        }
        boolean recursive = true;
        if (fo == null && (folder = (NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)) != null) {
            recursive = false;
            fo = folder.getFolder();
        }
        if (fo == null) {
            return null;
        }
        SpringScope scope = SpringScope.getSpringScope(fo);
        if (scope == null) {
            return null;
        }
        try {
            if (treePathHandle != null) {
                SpringRefactorings.RenamedClassName clazz = null;
                JavaSource js = JavaSource.forFileObject((FileObject)fo);
                if (js != null) {
                    clazz = SpringRefactorings.getRenamedClassName(treePathHandle, js, this.refactoring.getNewName());
                }
                if (clazz != null) {
                    String oldBinaryName = clazz.getOldBinaryName();
                    String newBinaryName = clazz.getNewBinaryName();
                    if (oldBinaryName != null && newBinaryName != null) {
                        Modifications mods = new Modifications();
                        for (Occurrences.Occurrence occurrence : Occurrences.getJavaClassOccurrences(oldBinaryName, scope)) {
                            refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)SpringRefactoringElement.createJavaElementRefModification(occurrence, mods, clazz.getOldSimpleName(), newBinaryName));
                        }
                        refactoringElements.registerTransaction((Transaction)new ModificationTransaction(mods));
                    }
                }
            } else if (fo.isFolder()) {
                String newPackageName;
                String oldPackageName = SpringRefactorings.getPackageName(fo);
                String string = newPackageName = recursive ? SpringRefactorings.getRenamedPackageName(fo, this.refactoring.getNewName()) : this.refactoring.getNewName();
                if (oldPackageName != null && newPackageName != null) {
                    Modifications mods = new Modifications();
                    for (Occurrences.Occurrence occurrence : Occurrences.getJavaPackageOccurrences(oldPackageName, recursive, scope)) {
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)SpringRefactoringElement.createJavaElementRefModification(occurrence, mods, null, newPackageName));
                    }
                    refactoringElements.registerTransaction((Transaction)new ModificationTransaction(mods));
                }
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    private Problem prepareMethodRefactoring(RefactoringElementsBag refactoringElements, TreePathHandle treePathHandle) {
        FileObject fo = treePathHandle.getFileObject();
        try {
            SpringScope scope;
            SpringRefactorings.RenamedProperty prop = null;
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            if (js != null) {
                prop = SpringRefactorings.getRenamedProperty(treePathHandle, js, this.refactoring.getNewName());
            }
            if ((scope = SpringScope.getSpringScope(fo)) == null) {
                return null;
            }
            if (prop != null) {
                String newName = prop.getNewName();
                String oldName = prop.getOldName();
                if (newName != null && oldName != null) {
                    Modifications mods = new Modifications();
                    for (Occurrences.Occurrence occurrence : Occurrences.getPropertyOccurrences(prop, js, scope)) {
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)SpringRefactoringElement.createPropertyRefModification(occurrence, mods, prop.getOldName(), prop.getNewName()));
                    }
                    refactoringElements.registerTransaction((Transaction)new ModificationTransaction(mods));
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }
}

