/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.hyperlink.BeansRefHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.MatchType;
import org.netbeans.modules.spring.java.Property;
import org.netbeans.modules.spring.java.PropertyFinder;
import org.openide.util.Exceptions;

public class PHyperlinkProcessor
extends HyperlinkProcessor {
    private BeansRefHyperlinkProcessor beansRefHyperlinkProcessor = new BeansRefHyperlinkProcessor(true);

    @Override
    public void process(HyperlinkEnv env) {
        String attribName = env.getAttribName();
        if (env.getType().isValueHyperlink()) {
            if (attribName.endsWith("-ref")) {
                this.beansRefHyperlinkProcessor.process(env);
            }
        } else if (env.getType().isAttributeHyperlink()) {
            String className;
            String temp = ContextUtilities.getLocalNameFromTag(attribName);
            if (temp.endsWith("-ref")) {
                temp = temp.substring(0, temp.indexOf("-ref"));
            }
            if ((className = new BeanClassFinder(env.getBeanAttributes(), env.getFileObject()).findImplementationClass()) == null) {
                return;
            }
            JavaSource js = JavaUtils.getJavaSource(env.getFileObject());
            if (js == null) {
                return;
            }
            final String propName = temp;
            try {
                js.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        ElementUtilities eu = cc.getElementUtilities();
                        if (className == null) {
                            return;
                        }
                        TypeElement type = JavaUtils.findClassElementByBinaryName(className, cc);
                        Property[] props = new PropertyFinder(type.asType(), propName, eu, MatchType.PREFIX).findProperties();
                        if (props.length > 0 && props[0].getSetter() != null) {
                            ElementOpen.open((ClasspathInfo)cc.getClasspathInfo(), (Element)props[0].getSetter());
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    @Override
    public int[] getSpan(HyperlinkEnv env) {
        if (env.getType().isValueHyperlink()) {
            return super.getSpan(env);
        }
        if (env.getType().isAttributeHyperlink()) {
            return new int[]{env.getTokenStartOffset(), env.getTokenEndOffset()};
        }
        return null;
    }
}

