/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.settings;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.groovy.grails.RuntimeHelper;
import org.netbeans.modules.groovy.grails.settings.GrailsSettings;
import org.netbeans.modules.groovy.support.spi.GroovyOptionsSubpanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class GrailsRuntimePanel
extends JPanel
implements GroovyOptionsSubpanel {
    private final GrailsSettings settings = GrailsSettings.getInstance();
    private JButton chooseDir;
    private JTextField grailsHomeLocation;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel linkLabel;

    public GrailsRuntimePanel() {
        this.initComponents();
    }

    private void displayGrailsHomeWarning() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GrailsRuntimePanel.class, (String)"LBL_Not_grails_home"), 2));
    }

    private void initComponents() {
        this.grailsHomeLocation = new JTextField();
        this.chooseDir = new JButton();
        this.jLabel2 = new JLabel();
        this.linkLabel = new JLabel();
        this.jLabel5 = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.chooseDir, (String)NbBundle.getMessage(GrailsRuntimePanel.class, (String)"SupportPanel.chooseDir.text"));
        this.chooseDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrailsRuntimePanel.this.chooseDirActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GrailsRuntimePanel.class, (String)"SupportPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.linkLabel, (String)"<html><a href=\"http://www.grails.org\">http://www.grails.org</a></html>");
        this.linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GrailsRuntimePanel.this.linkLabelMousePressed(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GrailsRuntimePanel.this.linkLabelMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                GrailsRuntimePanel.this.linkLabelMouseEntered(evt);
            }
        });
        this.jLabel5.setLabelFor(this.grailsHomeLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(GrailsRuntimePanel.class, (String)"GrailsRuntimePanel.jLabel5.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel5).add((Component)this.grailsHomeLocation, -1, 426, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.chooseDir)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.linkLabel).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.chooseDir).add((Component)this.grailsHomeLocation, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.linkLabel))));
        this.grailsHomeLocation.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GrailsRuntimePanel.class, (String)"SupportPanel.grailsHomeLocation.accessibleName"));
        this.grailsHomeLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GrailsRuntimePanel.class, (String)"SupportPanel.grailsHomeLocation.accessibleDescription"));
        this.chooseDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GrailsRuntimePanel.class, (String)"SupportPanel.chooseDir.accessibleName"));
        this.chooseDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GrailsRuntimePanel.class, (String)"SupportPanel.chooseDir.accessibleDescription"));
    }

    private void chooseDirActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.grailsHomeLocation.getText());
        chooser.setFileSelectionMode(1);
        int r = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(GrailsRuntimePanel.class, (String)"LBL_Select_Directory"));
        if (r == 0) {
            File file = chooser.getSelectedFile();
            if (!RuntimeHelper.isValidRuntime(file)) {
                this.displayGrailsHomeWarning();
                return;
            }
            this.grailsHomeLocation.setText(file.getAbsolutePath());
        }
    }

    private void linkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void linkLabelMouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void linkLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://www.grails.org"));
        }
        catch (MalformedURLException murle) {
            Exceptions.printStackTrace((Throwable)murle);
        }
    }

    public Component getComponent() {
        return this;
    }

    public void load() {
        this.grailsHomeLocation.setText(this.settings.getGrailsBase());
    }

    public void store() {
        String location = this.grailsHomeLocation.getText();
        if ("".equals(location.trim())) {
            return;
        }
        if (!RuntimeHelper.isValidRuntime(new File(location))) {
            this.displayGrailsHomeWarning();
            return;
        }
        this.settings.setGrailsBase(location);
    }

    public boolean valid() {
        return true;
    }
}

