/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.doxygensupport;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.spi.editor.completion.CompletionDocumentation;

public class DoxygenDocumentation {
    private static final Pattern STRIP_STARS = Pattern.compile("^[ \t]*\\*[ \t]?", 8);
    private static final String[] formatItalic = new String[]{"<i>", "</i>"};
    private static final Map<String, CommandDescription> commands = new HashMap<String, CommandDescription>();

    static String doxygen2HTML(String doxygen, CppTokenId kind) {
        doxygen = doxygen.substring(3, doxygen.length() - 2);
        doxygen = STRIP_STARS.matcher(doxygen).replaceAll("");
        doxygen = doxygen.trim();
        if (kind == CppTokenId.BLOCK_COMMENT) {
            doxygen = "\\verbatim\n" + doxygen + "\n\\endverbatim";
        }
        StringBuilder output = new StringBuilder();
        LinkedList<String> wordEnd = new LinkedList<String>();
        LinkedList<String> lineEnd = new LinkedList<String>();
        LinkedList<String> parEnd = new LinkedList<String>();
        String[] nextWordFormat = null;
        for (Token t : DoxygenDocumentation.lex(doxygen)) {
            switch (t.id) {
                case WHITESPACE: {
                    output.append(t.image);
                    break;
                }
                case WORD: {
                    if (nextWordFormat != null) {
                        output.append((String)nextWordFormat[0]);
                    }
                    output.append(t.image);
                    for (String s : wordEnd) {
                        output.append(s);
                    }
                    wordEnd.clear();
                    if (nextWordFormat != null) {
                        output.append((String)nextWordFormat[1]);
                    }
                    nextWordFormat = null;
                    break;
                }
                case LINE_END: {
                    for (String s : wordEnd) {
                        output.append(s);
                    }
                    wordEnd.clear();
                    for (String s : lineEnd) {
                        output.append(s);
                    }
                    lineEnd.clear();
                    output.append(t.image);
                    output.append("</p><p>\n");
                    break;
                }
                case PAR_END: {
                    for (String s : wordEnd) {
                        output.append(s);
                    }
                    wordEnd.clear();
                    for (String s : lineEnd) {
                        output.append(s);
                    }
                    for (String s : parEnd) {
                        output.append(s);
                    }
                    lineEnd.clear();
                    parEnd.clear();
                    output.append("</p><p>\n");
                    break;
                }
                case COMMAND: {
                    CommandDescription cd = commands.get(t.image);
                    if (cd == null) {
                        cd = new CommandDescription(EndsOn.PAR, "<strong>" + t.image.substring(1) + ":</strong><br>&nbsp; ", "");
                    }
                    output.append(cd.htmlStart);
                    switch (cd.end) {
                        case WORD: {
                            wordEnd.add(cd.htmlEnd);
                            break;
                        }
                        case LINE: {
                            lineEnd.add(cd.htmlEnd);
                            break;
                        }
                        case PAR: {
                            parEnd.add(cd.htmlEnd);
                        }
                    }
                    if (!t.image.equals("\\param")) break;
                    nextWordFormat = formatItalic;
                }
            }
        }
        return "<html><body><p>" + output.toString() + "</p>";
    }

    public static CompletionDocumentationImpl create(CsmObject csmObject) {
        CsmFunction fun;
        CsmFunctionDefinition definition;
        if (!(csmObject instanceof CsmOffsetable)) {
            return null;
        }
        ArrayList<DocCandidate> list = new ArrayList<DocCandidate>();
        DoxygenDocumentation.getDocText(csmObject, list);
        if ((list.isEmpty() || DoxygenDocumentation.getBestDoc(list).kind != CppTokenId.DOXYGEN_COMMENT) && CsmKindUtilities.isFunctionDeclaration((CsmObject)csmObject) && (definition = (fun = (CsmFunction)csmObject).getDefinition()) != null && !definition.equals(fun)) {
            DoxygenDocumentation.getDocText((CsmObject)definition, list);
        }
        if (list.isEmpty()) {
            return null;
        }
        DocCandidate bestDoc = DoxygenDocumentation.getBestDoc(list);
        String htmlDocText = DoxygenDocumentation.doxygen2HTML(bestDoc.text, bestDoc.kind);
        return new CompletionDocumentationImpl(htmlDocText, bestDoc.kind);
    }

    private static DocCandidate getBestDoc(List<DocCandidate> list) {
        DocCandidate candidate = null;
        for (DocCandidate doc : list) {
            if (doc.kind == CppTokenId.DOXYGEN_COMMENT) {
                return doc;
            }
            if (doc.kind != CppTokenId.BLOCK_COMMENT || candidate != null && candidate.text.length() >= doc.text.length()) continue;
            candidate = doc;
        }
        return candidate;
    }

    private static void getDocText(CsmObject csmObject, List<DocCandidate> list) {
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        CsmFile containingFile = csmOffsetable.getContainingFile();
        if (containingFile == null) {
            return;
        }
        TokenHierarchy h = TokenHierarchy.create((CharSequence)containingFile.getText(), (Language)CppTokenId.languageHeader());
        TokenSequence ts = h.tokenSequence(CppTokenId.languageHeader());
        ts.move(csmOffsetable.getEndOffset());
        block17: while (ts.moveNext()) {
            switch ((CppTokenId)ts.token().id()) {
                case LINE_COMMENT: 
                case NEW_LINE: {
                    break block17;
                }
                case BLOCK_COMMENT: {
                    list.add(new DocCandidate(((Object)ts.token().text()).toString(), (CppTokenId)ts.token().id()));
                    continue block17;
                }
                case DOXYGEN_COMMENT: {
                    list.add(new DocCandidate(((Object)ts.token().text()).toString(), (CppTokenId)ts.token().id()));
                    break block17;
                }
                default: {
                    continue block17;
                }
            }
        }
        ts.move(csmOffsetable.getStartOffset());
        block18: while (ts.movePrevious()) {
            switch ((CppTokenId)ts.token().id()) {
                case LINE_COMMENT: 
                case NEW_LINE: 
                case WHITESPACE: {
                    continue block18;
                }
                case BLOCK_COMMENT: {
                    list.add(new DocCandidate(((Object)ts.token().text()).toString(), (CppTokenId)ts.token().id()));
                    continue block18;
                }
                case DOXYGEN_COMMENT: {
                    list.add(new DocCandidate(((Object)ts.token().text()).toString(), (CppTokenId)ts.token().id()));
                    break block18;
                }
                case SEMICOLON: 
                case RBRACE: 
                case LBRACE: 
                case PREPROCESSOR_DIRECTIVE: {
                    break block18;
                }
                default: {
                    continue block18;
                }
            }
        }
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
            ts.move(csmOffsetable.getStartOffset());
            block19: while (ts.moveNext()) {
                switch ((CppTokenId)ts.token().id()) {
                    case LINE_COMMENT: 
                    case NEW_LINE: 
                    case WHITESPACE: {
                        continue block19;
                    }
                    case BLOCK_COMMENT: {
                        list.add(new DocCandidate(((Object)ts.token().text()).toString(), (CppTokenId)ts.token().id()));
                        continue block19;
                    }
                    case DOXYGEN_COMMENT: {
                        list.add(new DocCandidate(((Object)ts.token().text()).toString(), (CppTokenId)ts.token().id()));
                        break block19;
                    }
                    case LBRACE: {
                        break block19;
                    }
                    default: {
                        continue block19;
                    }
                }
            }
        }
    }

    static Collection<Token> lex(String text) {
        LinkedList<Token> result = new LinkedList<Token>();
        StringBuilder img = new StringBuilder();
        int i = 0;
        boolean wasContent = true;
        boolean verbatimMode = false;
        boolean escapedCommand = false;
        block11: while (i < text.length()) {
            switch (text.charAt(i)) {
                case '\n': {
                    if (i < text.length() - 1) {
                        if (!verbatimMode) {
                            while (i < text.length() - 1 && (text.charAt(i + 1) == ' ' || text.charAt(i + 1) == '\t')) {
                                ++i;
                            }
                        }
                        if (text.charAt(i + 1) == '@' || text.charAt(i + 1) == '\\' || text.charAt(i + 1) == '\n') {
                            Token last = result.getLast();
                            if (last.id != TokenId.LINE_END && last.id != TokenId.PAR_END) {
                                result.add(new Token(wasContent ? TokenId.LINE_END : TokenId.PAR_END, "\n"));
                                wasContent = false;
                            }
                        } else if (!verbatimMode) {
                            result.add(new Token(TokenId.WHITESPACE, " "));
                            wasContent = false;
                        }
                    }
                    ++i;
                    continue block11;
                }
                case '\t': 
                case ' ': {
                    img.append(text.charAt(i++));
                    while (i < text.length() && (text.charAt(i) == ' ' || text.charAt(i) == '\t')) {
                        img.append(text.charAt(i++));
                    }
                    result.add(new Token(TokenId.WHITESPACE, img.toString()));
                    img = new StringBuilder();
                    continue block11;
                }
                case '@': 
                case '\\': {
                    if (escapedCommand) {
                        escapedCommand = false;
                        img.append(text.charAt(i));
                        ++i;
                        continue block11;
                    }
                    boolean escaped = false;
                    if (text.charAt(i) == '\\' && i + 1 < text.length()) {
                        switch (text.charAt(i + 1)) {
                            case '\\': {
                                escaped = true;
                                escapedCommand = true;
                                ++i;
                                break;
                            }
                            case '@': {
                                escaped = true;
                                escapedCommand = true;
                                ++i;
                                break;
                            }
                            case '\"': 
                            case '#': 
                            case '$': 
                            case '%': 
                            case '&': 
                            case '<': 
                            case '>': {
                                img.append(text.charAt(++i));
                                escaped = true;
                                break;
                            }
                            case ':': {
                                if (i + 2 >= text.length() || text.charAt(i + 2) != ':') break;
                                i += 3;
                                img.append("::");
                                escaped = true;
                            }
                        }
                        if (escaped) {
                            wasContent = true;
                            continue block11;
                        }
                    }
                    img.append('\\');
                    ++i;
                    while (i < text.length() && Character.isLetter(text.charAt(i))) {
                        img.append(text.charAt(i++));
                    }
                    result.add(new Token(TokenId.COMMAND, img.toString()));
                    if (img.toString().equals("\\verbatim")) {
                        verbatimMode = true;
                    }
                    if (verbatimMode && img.toString().equals("\\endverbatim")) {
                        verbatimMode = false;
                    }
                    img = new StringBuilder();
                    wasContent = true;
                    continue block11;
                }
            }
            img.append(text.charAt(i++));
            while (i < text.length() && (verbatimMode || text.charAt(i) != ' ' && text.charAt(i) != '\t' && text.charAt(i) != '\n') && text.charAt(i) != '\\' && text.charAt(i) != '@') {
                img.append(text.charAt(i++));
            }
            result.add(new Token(TokenId.WORD, img.toString()));
            img = new StringBuilder();
            wasContent = true;
        }
        return result;
    }

    static {
        commands.put("\\c", new CommandDescription(EndsOn.WORD, "<tt>", "</tt>"));
        commands.put("\\p", new CommandDescription(EndsOn.WORD, "<tt>", "</tt>"));
        commands.put("\\a", new CommandDescription(EndsOn.WORD, "<i>", "</i>"));
        commands.put("\\n", new CommandDescription(EndsOn.NONE, "<br/>", ""));
        commands.put("\\author", new CommandDescription(EndsOn.PAR, "<strong>Author:</strong><br>&nbsp; ", ""));
        commands.put("\\exception", new CommandDescription(EndsOn.PAR, "<strong>Exceptions:</strong><br>&nbsp; ", ""));
        commands.put("\\throw", new CommandDescription(EndsOn.PAR, "<strong>Throws:</strong><br>&nbsp; ", ""));
        commands.put("\\return", new CommandDescription(EndsOn.PAR, "<strong>Returns:</strong><br>&nbsp; ", ""));
        commands.put("\\param", new CommandDescription(EndsOn.PAR, "<strong>Parameter:</strong><br>&nbsp; ", ""));
        commands.put("\\sa", new CommandDescription(EndsOn.PAR, "<strong>See Also:</strong><br>&nbsp; ", ""));
        commands.put("\\verbatim", new CommandDescription(EndsOn.NONE, "<pre>", ""));
        commands.put("\\endverbatim", new CommandDescription(EndsOn.NONE, "</pre>", ""));
        commands.put("\\brief", new CommandDescription(EndsOn.PAR, "", ""));
        commands.put("\\date", new CommandDescription(EndsOn.PAR, "<strong>Date:</strong><br>&nbsp; ", ""));
        commands.put("\\bug", new CommandDescription(EndsOn.PAR, "<strong>Bug:</strong><br>&nbsp; ", ""));
        commands.put("\\warning", new CommandDescription(EndsOn.PAR, "<strong>Warning:</strong><br>&nbsp; ", ""));
        commands.put("\\version", new CommandDescription(EndsOn.PAR, "<strong>Version:</strong><br>&nbsp; ", ""));
    }

    private static final class DocCandidate {
        private final String text;
        private final CppTokenId kind;

        public DocCandidate(String text, CppTokenId kind) {
            this.text = text;
            this.kind = kind;
        }
    }

    public static final class CompletionDocumentationImpl
    implements CompletionDocumentation {
        private final String text;
        private final CppTokenId kind;

        public CompletionDocumentationImpl(String text, CppTokenId kind) {
            this.kind = kind;
            this.text = text;
        }

        public CppTokenId getKind() {
            return this.kind;
        }

        public String getText() {
            return this.text;
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    static enum TokenId {
        COMMAND,
        WHITESPACE,
        PAR_END,
        LINE_END,
        WORD;

    }

    static class Token {
        final TokenId id;
        final String image;

        public Token(TokenId id, String image) {
            this.id = id;
            this.image = image;
        }

        public String toString() {
            return (Object)((Object)this.id) + ":" + this.image;
        }
    }

    static enum EndsOn {
        WORD,
        LINE,
        PAR,
        NONE;

    }

    static final class CommandDescription {
        final EndsOn end;
        final String htmlStart;
        final String htmlEnd;

        public CommandDescription(EndsOn end, String htmlStart, String htmlEnd) {
            this.end = end;
            this.htmlStart = htmlStart;
            this.htmlEnd = htmlEnd;
        }
    }
}

