/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.debugger;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.model.services.AutosProvider;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class CsmAutosProviderImpl
implements AutosProvider {
    public static final boolean AUTOS_INCLUDE_MACROS = Boolean.getBoolean("debugger.autos.macros");

    public Set<String> getAutos(final StyledDocument document, int line) {
        Element lineElem;
        if (line < 0 || document == null) {
            return Collections.emptySet();
        }
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)false, (boolean)false);
        if (csmFile == null || !csmFile.isParsed()) {
            return Collections.emptySet();
        }
        Element lineRootElement = NbDocument.findLineRootElement((StyledDocument)document);
        HashSet<String> autos = new HashSet<String>();
        int startOffset = CsmAutosProviderImpl.addAutos(csmFile, lineRootElement, line, document, autos);
        if (line > 0 && (lineElem = lineRootElement.getElement(line - 1)) != null) {
            final AtomicInteger prevOffset = new AtomicInteger(lineElem.getEndOffset());
            document.render(new Runnable(){

                @Override
                public void run() {
                    TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)document, (int)prevOffset.get(), (boolean)false, (boolean)true);
                    if (ts == null) {
                        return;
                    }
                    if (CndTokenUtilities.shiftToNonWhite((TokenSequence)ts, (boolean)true)) {
                        prevOffset.set(ts.offset());
                    }
                }
            });
            int prevLine = NbDocument.findLineNumber((StyledDocument)document, (int)prevOffset.get());
            CsmAutosProviderImpl.addAutos(csmFile, lineRootElement, prevLine, document, autos);
        }
        return autos;
    }

    private static int addAutos(CsmFile csmFile, Element lineRootElement, int line, final StyledDocument document, final Set<String> autos) {
        int lineEndOffset;
        CsmOffsetable statementEnd;
        Element lineElem = lineRootElement.getElement(line);
        if (lineElem == null) {
            return -1;
        }
        int lineStartOffset = lineElem.getStartOffset();
        CsmOffsetable statementStart = CsmAutosProviderImpl.getStatement(csmFile, lineStartOffset);
        if (statementStart != null) {
            lineStartOffset = statementStart.getStartOffset();
        }
        if ((statementEnd = CsmAutosProviderImpl.getStatement(csmFile, lineEndOffset = lineElem.getEndOffset())) != null) {
            lineEndOffset = statementEnd.getEndOffset();
        }
        final int startOffset = lineStartOffset;
        final int endOffset = lineEndOffset;
        CsmFileReferences.getDefault().accept((CsmScope)csmFile, new CsmFileReferences.Visitor(){

            public void visit(CsmReferenceContext context) {
                CsmReference reference = context.getReference();
                if (startOffset <= reference.getStartOffset() && reference.getEndOffset() <= endOffset) {
                    CsmObject referencedObject = reference.getReferencedObject();
                    if (CsmKindUtilities.isVariable((CsmObject)referencedObject) && !CsmAutosProviderImpl.filterAuto((CsmScopeElement)((CsmVariable)referencedObject))) {
                        StringBuilder sb = new StringBuilder(reference.getText());
                        if (context.size() > 1) {
                            block5: for (int i = context.size() - 1; i >= 0; --i) {
                                CppTokenId token = context.getToken(i);
                                switch (token) {
                                    case DOT: 
                                    case ARROW: 
                                    case SCOPE: {
                                        break;
                                    }
                                    default: {
                                        break block5;
                                    }
                                }
                                if (i <= 0) continue;
                                sb.insert(0, token.fixedText());
                                CsmReference prevReference = context.getReference(i - 1);
                                if (prevReference == null) break;
                                sb.insert(0, prevReference.getText());
                            }
                        }
                        autos.add(sb.toString());
                    } else if (AUTOS_INCLUDE_MACROS && CsmKindUtilities.isMacro((CsmObject)referencedObject)) {
                        String txt = ((Object)reference.getText()).toString();
                        int[] macroExpansionSpan = CsmMacroExpansion.getMacroExpansionSpan((Document)document, (int)reference.getStartOffset(), (boolean)false);
                        if (macroExpansionSpan != null && macroExpansionSpan[0] != macroExpansionSpan[1]) {
                            try {
                                txt = document.getText(macroExpansionSpan[0], macroExpansionSpan[1] - macroExpansionSpan[0]);
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        autos.add(txt);
                    }
                }
            }
        });
        return lineStartOffset;
    }

    private static CsmOffsetable getStatement(CsmFile csmFile, int offset) {
        CsmContext context = CsmOffsetResolver.findContext(csmFile, offset, null);
        CsmScope scope = context.getLastScope();
        for (CsmScopeElement csmScopeElement : scope.getScopeElements()) {
            CsmOffsetable offs;
            if (!CsmKindUtilities.isOffsetable((Object)csmScopeElement) || (offs = (CsmOffsetable)csmScopeElement).getEndOffset() < offset) continue;
            if (offs.getStartOffset() > offset || CsmKindUtilities.isCompoundStatement((CsmObject)offs)) {
                return null;
            }
            return offs;
        }
        return null;
    }

    private static boolean filterAuto(CsmScopeElement object) {
        CsmScope scope = object.getScope();
        return CsmKindUtilities.isNamespace((Object)scope) && "std".equals(((Object)((CsmNamespace)scope).getQualifiedName()).toString());
    }

    private static int[] getInterestedStatementOffsets(CsmOffsetable offs) {
        if (CsmKindUtilities.isStatement((CsmObject)offs)) {
            switch (((CsmStatement)offs).getKind()) {
                case IF: {
                    offs = ((CsmIfStatement)offs).getCondition();
                    break;
                }
                case SWITCH: {
                    offs = ((CsmSwitchStatement)offs).getCondition();
                    break;
                }
                case WHILE: 
                case DO_WHILE: {
                    offs = ((CsmLoopStatement)offs).getCondition();
                    break;
                }
                case FOR: {
                    offs = ((CsmForStatement)offs).getCondition();
                }
            }
        }
        return new int[]{offs.getStartOffset(), offs.getEndOffset()};
    }
}

