/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc.editor;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import javax.lang.model.element.Name;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.openide.util.Exceptions;

public class AddBeanPanel {
    private Document document;
    private String className;
    private String id;

    AddBeanPanel(Document document) {
        this.document = document;
    }

    Document getDocument() {
        return this.document;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getClassName() {
        if (this.className == null) {
            this.className = this.findClassName();
        }
        return this.className;
    }

    void setClassName(String className) {
        this.className = className;
    }

    public String getId() {
        if (this.id == null) {
            String name = this.getClassName();
            if (name == null) {
                return null;
            }
            name = name.substring(name.lastIndexOf(".") + 1);
            this.id = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return this.id;
    }

    private String findClassName() {
        final String[] className = new String[1];
        JavaSource js = JavaSource.forDocument((Document)this.document);
        if (js == null) {
            return null;
        }
        try {
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    Document doc = cc.getDocument();
                    if (doc != null) {
                        ExpressionTree packageTree = cc.getCompilationUnit().getPackageName();
                        if (packageTree != null) {
                            TreePath path = cc.getTrees().getPath(cc.getCompilationUnit(), packageTree);
                            Name qualifiedName = cc.getElements().getPackageOf(cc.getTrees().getElement(path)).getQualifiedName();
                            className[0] = qualifiedName.toString() + ".";
                        }
                        String cls = (String)new ClassScanner().scan(cc.getCompilationUnit(), null);
                        className[0] = className[0] == null ? cls : className[0] + cls;
                    }
                }
            }, true);
            return className[0];
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private class ClassScanner
    extends TreePathScanner<String, Void> {
        private ClassScanner() {
        }

        @Override
        public String visitClass(ClassTree tree, Void p) {
            return tree.getSimpleName().toString();
        }
    }
}

