/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.modules.hibernate.wizards.HibernateCodeGenWizard;
import org.netbeans.modules.hibernate.wizards.HibernateCodeGenWizardHelper;
import org.netbeans.modules.hibernate.wizards.HibernateCodeGenerationPanel;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class HibernateCodeGenWizardDescriptor
implements WizardDescriptor.Panel,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private HibernateCodeGenerationPanel component;
    private boolean componentInitialized;
    private WizardDescriptor wizardDescriptor;
    private Project project;
    private String title;

    public HibernateCodeGenWizardDescriptor(Project project, String string) {
        this.project = project;
        this.title = string;
    }

    public HibernateCodeGenerationPanel getComponent() {
        if (this.component == null) {
            this.component = new HibernateCodeGenerationPanel();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public HelpCtx getHelp() {
        return new HelpCtx(HibernateCodeGenWizardDescriptor.class);
    }

    public void readSettings(Object object) {
        this.wizardDescriptor = (WizardDescriptor)object;
        this.wizardDescriptor.putProperty("NewFileWizard_Title", (Object)this.title);
        HibernateCodeGenWizardHelper hibernateCodeGenWizardHelper = HibernateCodeGenWizard.getHelper(this.wizardDescriptor);
        if (!this.componentInitialized) {
            this.componentInitialized = true;
            this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
            FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
            this.getComponent().initialize(this.project, fileObject);
        }
    }

    public boolean isValid() {
        Object object;
        SourceGroup sourceGroup = this.getComponent().getLocationValue();
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)this.getComponent().getConfigurationFile());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        if (dataObject != null) {
            object = (HibernateCfgDataObject)dataObject;
            HibernateConfiguration hibernateConfiguration = object.getHibernateConfiguration();
            String string = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.driver_class");
            if (string == null || "".equals(string)) {
                string = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.driver_class");
            }
            if (string == null || "".equals(string)) {
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_No_DB_ConnectionDriver_Exists"));
                return false;
            }
        }
        if (this.getComponent().getConfigurationFile() == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_ConfFileChooser"));
            return false;
        }
        if (this.getComponent().getRevengFile() == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_RevengFileChooser"));
            return false;
        }
        object = this.getComponent().getPackageName();
        if (sourceGroup == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_JavaTargetChooser_SelectSourceGroup"));
            return false;
        }
        if (((String)object).trim().equals("")) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_JavaTargetChooser_CantUseDefaultPackage"));
            return false;
        }
        if (!JavaIdentifiers.isValidPackageName((String)object)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_JavaTargetChooser_InvalidPackage"));
            return false;
        }
        if (!SourceGroups.isFolderWritable((SourceGroup)sourceGroup, (String)object)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HibernateCodeGenWizardDescriptor.class, (String)"ERR_JavaTargetChooser_UnwritablePackage"));
            return false;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    public void storeSettings(Object object) {
        Object object2 = ((WizardDescriptor)object).getValue();
        if (object2.equals(WizardDescriptor.NEXT_OPTION) || object2.equals(WizardDescriptor.FINISH_OPTION)) {
            HibernateCodeGenWizardHelper hibernateCodeGenWizardHelper = HibernateCodeGenWizard.getHelper(this.wizardDescriptor);
            hibernateCodeGenWizardHelper.setConfigurationFile(this.getComponent().getConfigurationFile());
            hibernateCodeGenWizardHelper.setRevengFile(this.getComponent().getRevengFile());
            hibernateCodeGenWizardHelper.setLocation(this.getComponent().getLocationValue());
            hibernateCodeGenWizardHelper.setPackageName(this.getComponent().getPackageName());
            hibernateCodeGenWizardHelper.setDomainGen(this.getComponent().getChkDomain());
            hibernateCodeGenWizardHelper.setHbmGen(this.getComponent().getChkHbm());
            hibernateCodeGenWizardHelper.setJavaSyntax(this.getComponent().getChkJava());
            hibernateCodeGenWizardHelper.setEjbAnnotation(this.getComponent().getChkEjb());
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.changeSupport.fireChange();
    }

    private void setErrorMessage(String string) {
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
    }
}

