/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.BrowseFolders;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.EventListenerPanel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.EventTableModel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.SecurityTablePanel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.Util;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class EventTablePanel
extends DefaultTablePanel {
    private EventTableModel model;
    private HibernateCfgDataObject configDataObject;

    public EventTablePanel(HibernateCfgDataObject dObj, final EventTableModel model) {
        super((AbstractTableModel)model);
        this.model = model;
        this.configDataObject = dObj;
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTablePanel.this.configDataObject.modelUpdatedFromUI();
                int row = EventTablePanel.this.getTable().getSelectedRow();
                model.removeRow(row);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean add) {
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int row = this.add ? -1 : EventTablePanel.this.getTable().getSelectedRow();
            final EventListenerPanel dialogPanel = new EventListenerPanel();
            if (!this.add) {
                String listenerClass = (String)EventTablePanel.this.model.getValueAt(row, 0);
                dialogPanel.initValues(listenerClass);
            }
            dialogPanel.addBrowseClassActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        SourceGroup[] groups = Util.getJavaSourceGroups(EventTablePanel.this.configDataObject);
                        FileObject fo = BrowseFolders.showDialog(groups);
                        if (fo != null) {
                            String className = Util.getResourcePath(groups, fo);
                            dialogPanel.getListenerClassTextField().setText(className);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            EditDialog dialog = new EditDialog(dialogPanel, NbBundle.getMessage(SecurityTablePanel.class, (String)"LBL_Event_Listener"), this.add){

                protected String validate() {
                    String listenerClass = dialogPanel.getListenerClass();
                    if (listenerClass.length() == 0) {
                        return NbBundle.getMessage(SecurityTablePanel.class, (String)"TXT_Listener_Class_Empty");
                    }
                    return null;
                }
            };
            if (this.add) {
                dialog.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getListenerClassTextField().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getListenerClassTextField().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                EventTablePanel.this.configDataObject.modelUpdatedFromUI();
                String listenerClass = dialogPanel.getListenerClass();
                if (this.add) {
                    EventTablePanel.this.model.addRow(listenerClass);
                } else {
                    EventTablePanel.this.model.editRow(row, listenerClass);
                }
            }
        }
    }
}

