/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class XRefResultSet<T> {
    private final Map<ContextScope, Collection<ContextEntry>> scopeEntries;
    private final Map<ContextScope, AtomicInteger> scopes;
    private final ConcurrentMap<CharSequence, T> unresolved;
    private final AtomicInteger lineCounter = new AtomicInteger(0);
    private long time = 0L;

    public static Collection<ContextScope> sortedContextScopes(XRefResultSet bag, boolean byEntries) {
        ArrayList<ContextScope> out = new ArrayList<ContextScope>(ContextScope.values().length);
        for (ContextScope scope : ContextScope.values()) {
            boolean added = false;
            int scopeNum = byEntries ? bag.getEntries(scope).size() : bag.getNumberOfContexts(scope, false);
            for (int i = 0; i < out.size(); ++i) {
                ContextScope curScope = (ContextScope)((Object)out.get(i));
                int curScopeNum = byEntries ? bag.getEntries(curScope).size() : bag.getNumberOfContexts(curScope, false);
                if (curScopeNum > scopeNum) continue;
                out.add(i, scope);
                added = true;
                break;
            }
            if (added) continue;
            out.add(scope);
        }
        return out;
    }

    public XRefResultSet() {
        this.scopeEntries = new HashMap<ContextScope, Collection<ContextEntry>>(ContextScope.values().length);
        this.scopes = new HashMap<ContextScope, AtomicInteger>(ContextScope.values().length);
        this.unresolved = new ConcurrentHashMap<CharSequence, T>(100);
        for (ContextScope scopeContext : ContextScope.values()) {
            this.scopeEntries.put(scopeContext, Collections.synchronizedList(new ArrayList(1024)));
            this.scopes.put(scopeContext, new AtomicInteger(0));
        }
    }

    public final void addEntry(ContextScope contextScope, ContextEntry entry) {
        this.scopeEntries.get((Object)contextScope).add(entry);
    }

    public final Collection<ContextEntry> getEntries(ContextScope contextScope) {
        return this.scopeEntries.get((Object)contextScope);
    }

    public final void incrementScopeCounter(ContextScope contextScope) {
        this.scopes.get((Object)contextScope).incrementAndGet();
    }

    public final void incrementLineCounter(int fileLinesNum) {
        this.lineCounter.addAndGet(fileLinesNum);
    }

    public final int getLineCount() {
        return this.lineCounter.get();
    }

    public final int getNumberOfAllContexts() {
        int out = 0;
        for (AtomicInteger val : this.scopes.values()) {
            out += val.get();
        }
        return out;
    }

    public final int getNumberOfContexts(ContextScope contextScope, boolean relative) {
        int num = this.scopes.get((Object)contextScope).get();
        if (relative && num != 0) {
            assert (num > 0);
            num = num * 100 / this.getNumberOfAllContexts();
        }
        return num;
    }

    public T getUnresolvedEntry(CharSequence name) {
        return (T)this.unresolved.get(name);
    }

    public T addUnresolvedEntry(CharSequence name, T value) {
        T prev = this.unresolved.putIfAbsent(name, value);
        return prev == null ? value : prev;
    }

    public Collection<T> getUnresolvedEntries(Comparator<? super T> comparator) {
        ArrayList out = new ArrayList(this.unresolved.values());
        Collections.sort(out, comparator);
        return out;
    }

    public final void setTime(long nanoTime) {
        this.time = nanoTime;
    }

    public final long getTime() {
        return this.time;
    }

    public final double getTimeMs() {
        return (double)this.time / 1000000.0;
    }

    public final double getTimeSec() {
        return (double)this.time / 1.0E9;
    }

    public final double getLinesPerSec() {
        return this.time == 0L ? 0.0 : (double)this.getLineCount() / this.getTimeSec();
    }

    public static final class ContextEntry {
        public final DeclarationKind declaration;
        public final DeclarationScope declarationScope;
        public final IncludeLevel declarationIncludeLevel;
        public final UsageStatistics usageStatistics;
        public static final ContextEntry UNRESOLVED = new ContextEntry(DeclarationKind.UNRESOLVED, DeclarationScope.UNRESOLVED, IncludeLevel.UNRESOLVED, UsageStatistics.UNKNOWN);
        public static final ContextEntry UNRESOLVED_AFTER_UNRESOLVED = new ContextEntry(DeclarationKind.UNRESOLVED, DeclarationScope.UNRESOLVED, IncludeLevel.UNRESOLVED, UsageStatistics.UNKNOWN);
        public static final ContextEntry UNRESOLVED_TEMPLATE_BASED = new ContextEntry(DeclarationKind.UNRESOLVED, DeclarationScope.UNRESOLVED, IncludeLevel.UNRESOLVED, UsageStatistics.UNKNOWN);
        public static final ContextEntry UNRESOLVED_MACRO_BASED = new ContextEntry(DeclarationKind.UNRESOLVED, DeclarationScope.UNRESOLVED, IncludeLevel.UNRESOLVED, UsageStatistics.UNKNOWN);
        public static final ContextEntry UNRESOLVED_BUILTIN_BASED = new ContextEntry(DeclarationKind.UNRESOLVED, DeclarationScope.UNRESOLVED, IncludeLevel.UNRESOLVED, UsageStatistics.UNKNOWN);
        public static final ContextEntry RESOLVED = new ContextEntry(DeclarationKind.UNRESOLVED, DeclarationScope.UNRESOLVED, IncludeLevel.UNRESOLVED, UsageStatistics.UNKNOWN);

        public ContextEntry(DeclarationKind declaration, DeclarationScope declarationScope, IncludeLevel declarationIncludeLevel, UsageStatistics usageStatistics) {
            this.declaration = declaration;
            this.declarationScope = declarationScope;
            this.declarationIncludeLevel = declarationIncludeLevel;
            this.usageStatistics = usageStatistics;
        }
    }

    public static enum UsageStatistics {
        FIRST_USAGE,
        SECOND_USAGE,
        NEXT_USAGE,
        UNKNOWN;

    }

    public static enum IncludeLevel {
        THIS_FILE,
        PROJECT_DIRECT,
        LIBRARY_DIRECT,
        PROJECT_DEEP,
        LIBRARY_DEEP,
        UNRESOLVED;

    }

    public static enum DeclarationScope {
        FUNCTION_THIS,
        CLASSIFIER_THIS,
        CLASSIFIER_PARENT,
        PROJECT_CLASSIFIER,
        LIBRARY_CLASSIFIER,
        NAMESPACE_THIS,
        NAMESPACE_PARENT,
        PROJECT_NAMESPACE,
        LIBRARY_NAMESPACE,
        FILE_THIS,
        PROJECT_FILE,
        LIBRARY_FILE,
        PROJECT_GLOBAL,
        LIBRARY_GLOBAL,
        UNRESOLVED;

    }

    public static enum DeclarationKind {
        CLASSIFIER,
        ENUMERATOR,
        VARIABLE,
        PARAMETER,
        FUNCTION,
        NAMESPACE,
        CLASS_FORWARD,
        MACRO,
        UNRESOLVED;

    }

    public static enum ContextScope {
        GLOBAL_FUNCTION,
        NAMESPACE_FUNCTION,
        FILE_LOCAL_FUNCTION,
        METHOD,
        CONSTRUCTOR,
        INLINED_METHOD,
        INLINED_CONSTRUCTOR,
        UNRESOLVED;

    }
}

